/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.ICubeRecoverRecord;
import kd.bos.olapServer.replication.IDDLRecord;
import kd.bos.olapServer.replication.IRedoRecord;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.ReadedRedoFile;
import kd.bos.olapServer.replication.ReadedRedoPage;
import kd.bos.olapServer.replication.RedoReplayer;
import kd.bos.olapServer.replication.RedoType;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.replication.SlaveLSNContext;
import kd.bos.olapServer.replication.TimeStatQueue;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 32\u00020\u0001:\u0003345B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010$\u001a\u00020!J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010&\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020!H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0010H\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010&\u001a\u00020)H\u0002J\b\u0010-\u001a\u00020!H\u0016J\b\u0010.\u001a\u00020!H\u0016J \u0010/\u001a\b\u0012\u0004\u0012\u0002H00 \"\u0004\b\u0000\u001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H002R2\u0010\f\u001a&\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\u00100\rj\u0012\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0016\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\b\u0012\u00060\u0013j\u0002`\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001eR>\u0010\u001f\u001a2\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\rj\u0018\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 `\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lkd/bos/olapServer/replication/ReplayCoordinator;", "Ljava/lang/Thread;", "olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "LSNContext", "Lkd/bos/olapServer/replication/SlaveLSNContext;", "path", "", "Lkd/bos/olapServer/common/string;", "delayTimeStat", "Lkd/bos/olapServer/replication/TimeStatQueue;", "(Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/replication/SlaveLSNContext;Ljava/lang/String;Lkd/bos/olapServer/replication/TimeStatQueue;)V", "UnCompleteDdlRecords", "Ljava/util/HashMap;", "", "Lkd/bos/olapServer/common/int;", "Lkd/bos/olapServer/replication/IRedoRecord;", "Lkotlin/collections/HashMap;", "_isError", "", "enable", "especial", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkd/bos/olapServer/common/bool;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "isError", "()Z", "isFinished", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "joinJobs", "Ljava/util/concurrent/Future;", "", "redoFile", "Lkd/bos/olapServer/replication/ReadedRedoFile;", "close", "dealCubeRecoverRecord", "record", "Lkd/bos/olapServer/replication/ICubeRecoverRecord;", "dealDDLRecord", "Lkd/bos/olapServer/replication/IDDLRecord;", "dealEspecial", "dispatch", "execDDL", "run", "start", "submit", "T", "task", "Lkotlin/Function0;", "Companion", "DefaultThreadFactory", "ReplayCallable", "bos-olap-core"})
public final class ReplayCoordinator
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OlapWorkspace olap;
    @Nullable
    private final TimeStatQueue delayTimeStat;
    @NotNull
    private final ReadedRedoFile redoFile;
    private volatile boolean enable;
    private boolean _isError;
    @NotNull
    private HashMap<Integer, IRedoRecord> UnCompleteDdlRecords;
    @NotNull
    private final ConcurrentHashMap<Integer, Boolean> especial;
    @NotNull
    private final HashMap<Integer, Future<Unit>> joinJobs;
    @NotNull
    private final AtomicBoolean isFinished;
    @NotNull
    private final ThreadPoolExecutor executor;
    private static final int dealEspecialInterval = 0x6400000;
    private static final int maxRedoQueueSize = 4096;

    /*
     * WARNING - void declaration
     */
    public ReplayCoordinator(@NotNull OlapWorkspace olap, @NotNull SlaveLSNContext LSNContext2, @NotNull String path, @Nullable TimeStatQueue delayTimeStat) {
        void $this$executor_u24lambda_u2d3;
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)LSNContext2, (String)"LSNContext");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(ReplayCoordinator.class.getName());
        this.olap = olap;
        this.delayTimeStat = delayTimeStat;
        this.redoFile = new ReadedRedoFile(path, LSNContext2);
        this.enable = true;
        this.UnCompleteDdlRecords = new HashMap();
        this.especial = new ConcurrentHashMap();
        this.joinJobs = new HashMap();
        this.isFinished = new AtomicBoolean();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(CommonTypesKt.getAvailableProcessors() * 4, CommonTypesKt.getAvailableProcessors() * 4, 5L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new DefaultThreadFactory());
        boolean bl = false;
        boolean bl2 = false;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
        ReplayCoordinator replayCoordinator = this;
        boolean bl3 = false;
        $this$executor_u24lambda_u2d3.allowCoreThreadTimeOut(true);
        Unit unit = Unit.INSTANCE;
        replayCoordinator.executor = threadPoolExecutor;
    }

    public final boolean isError() {
        return this._isError;
    }

    @NotNull
    public final AtomicBoolean isFinished() {
        return this.isFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int count = 0;
        this.isFinished.set(false);
        try {
            while ((this.enable || this.UnCompleteDdlRecords.size() > 0) && !this._isError) {
                if (this.olap.checkExecuteByFreeSpace() <= 5120L) {
                    this._isError = true;
                    break;
                }
                if (this.redoFile.hasNext()) {
                    this.isFinished.set(false);
                    ReadedRedoPage page = this.redoFile.next();
                    TimeStatQueue timeStatQueue = this.delayTimeStat;
                    if (timeStatQueue != null) {
                        timeStatQueue.setEnd(page.getPageLSN());
                    }
                    while (page.hasNext()) {
                        int n;
                        IRedoRecord record2 = page.next();
                        RedoType redoType = record2.getRedoType();
                        int n2 = WhenMappings.$EnumSwitchMapping$0[redoType.ordinal()];
                        switch (n2) {
                            case 1: {
                                this.dealDDLRecord((IDDLRecord)record2);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.dispatch(record2);
                                break;
                            }
                            case 4: {
                                this.dealCubeRecoverRecord((ICubeRecoverRecord)record2);
                            }
                        }
                        if ((count = (n = count) + 1) != 0x6400000) continue;
                        this.dealEspecial();
                        count = 0;
                    }
                    continue;
                }
                this.dealEspecial();
                count = 0;
                this.isFinished.set(true);
                Thread.sleep(10L);
            }
            this.dealEspecial();
        }
        catch (Throwable e) {
            this._isError = true;
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = "\u91cd\u505a\u7ebf\u7a0b \u5f02\u5e38\u9000\u51fa\u3002";
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if (e == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv, e);
                }
            }
            throw e;
        }
        finally {
            this.executor.shutdown();
            this.executor.awaitTermination(60L, TimeUnit.DAYS);
            this.redoFile.close();
            this.isFinished.set(true);
        }
    }

    private final void dealCubeRecoverRecord(ICubeRecoverRecord record2) {
        try {
            record2.replayCubeRecover(this.olap);
        }
        catch (Exception e) {
            this._isError = true;
        }
    }

    private final void dealDDLRecord(IDDLRecord record2) {
        IRedoRecord ddlRecord = this.UnCompleteDdlRecords.get(record2.getCubeId());
        if (ddlRecord == null) {
            if (record2.isEofDDL()) {
                if (record2.getCubeId() == 0) {
                    this.execDDL(record2);
                    return;
                }
                this.dispatch(record2);
                return;
            }
            Map map = this.UnCompleteDdlRecords;
            Integer n = record2.getCubeId();
            boolean bl = false;
            map.put(n, record2);
        } else {
            IDDLRecord conRecord = record2.consolidate(ddlRecord);
            Map map = this.UnCompleteDdlRecords;
            Integer n = record2.getCubeId();
            boolean bl = false;
            map.put(n, conRecord);
            if (!record2.isEofDDL()) {
                return;
            }
            if (record2.getCubeId() == 0) {
                this.execDDL(conRecord);
            } else {
                this.dispatch(conRecord);
            }
            this.UnCompleteDdlRecords.remove(record2.getCubeId());
        }
    }

    private final void dispatch(IRedoRecord record2) {
        CubeWorkspace cubeWorkspace = this.olap.getCubeWorkspaceByCubeId(record2.getCubeId());
        while (cubeWorkspace.getReplayRedo().getRecordQueue().size() > 4096) {
            this.dealEspecial();
        }
        cubeWorkspace.getReplayRedo().getRecordQueue().add(record2);
        if (cubeWorkspace.getReplayRedo().tryLatch()) {
            Future job2 = this.submit((Function0)new Function0<Unit>(cubeWorkspace, this, record2){
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                final /* synthetic */ ReplayCoordinator this$0;
                final /* synthetic */ IRedoRecord $record;
                {
                    this.$cubeWorkspace = $cubeWorkspace;
                    this.this$0 = $receiver;
                    this.$record = $record;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    try {
                        RedoReplayer replayer = new RedoReplayer(this.$cubeWorkspace, ReplayCoordinator.access$getOlap$p(this.this$0));
                        this.$cubeWorkspace.getMetadataLock().enterRead((Function0)new Function0<Unit>(replayer){
                            final /* synthetic */ RedoReplayer $replayer;
                            {
                                this.$replayer = $replayer;
                                super(0);
                            }

                            public final void invoke() {
                                this.$replayer.executeJob(true);
                            }
                        });
                    }
                    catch (Exception e) {
                        void this_$iv;
                        ReplayCoordinator.access$set_isError$p(this.this$0, true);
                        OlapLogger olapLogger = ReplicationManager.INSTANCE.getLogger();
                        CubeWorkspace cubeWorkspace = this.$cubeWorkspace;
                        boolean $i$f$error = false;
                        if (this_$iv.isErrorEnabled()) {
                            boolean bl = false;
                            String message$iv = "\u91cd\u505a\u5b50\u7ebf\u7a0b\uff0ccube: " + cubeWorkspace.getMetadata().getName() + '(' + cubeWorkspace.getCubeId() + ")\uff0c \u5f02\u5e38\u9000\u51fa\u3002";
                            OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                            if (olap$iv != null) {
                                String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                                HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                                olap$iv.getHealthReports().commit(report$iv);
                            }
                            if ((Throwable)e == null) {
                                OlapLogger.access$getLogger$p((OlapLogger)this_$iv).error(message$iv);
                            } else {
                                OlapLogger.access$getLogger$p((OlapLogger)this_$iv).error(message$iv, (Throwable)e);
                            }
                        }
                        throw e;
                    }
                    finally {
                        ConcurrentHashMap concurrentHashMap = ReplayCoordinator.access$getEspecial$p(this.this$0);
                        ReplayCoordinator replayCoordinator = this.this$0;
                        IRedoRecord iRedoRecord = this.$record;
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (concurrentHashMap) {
                            boolean bl3 = false;
                            Map map = ReplayCoordinator.access$getEspecial$p(replayCoordinator);
                            Integer n = iRedoRecord.getCubeId();
                            Boolean bl4 = true;
                            boolean bl5 = false;
                            map.put(n, bl4);
                            Unit unit = Unit.INSTANCE;
                        }
                        this.$cubeWorkspace.getReplayRedo().unLatch();
                    }
                }
            });
            Map map = this.joinJobs;
            Integer n = record2.getCubeId();
            boolean bl = false;
            map.put(n, job2);
        }
    }

    private final void execDDL(IDDLRecord record2) {
        Collection<Future<Unit>> collection = this.joinJobs.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"joinJobs.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Future it = (Future)element$iv;
            boolean bl = false;
            it.get();
        }
        this.joinJobs.clear();
        record2.replayDDL(this.olap);
    }

    private final void dealEspecial() {
        Object object = this.especial;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            int cubeId = ((Number)object2.getKey()).intValue();
            CubeWorkspace cubeWorkspace = this.olap.tryGetByCubeId(cubeId);
            if (cubeWorkspace == null) {
                this.especial.remove(cubeId);
                continue;
            }
            if (!cubeWorkspace.getReplayRedo().tryLatch()) continue;
            if (cubeWorkspace.getReplayRedo().getRecordQueue().size() > 0) {
                OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    Logger logger = OlapLogger.access$getLogger$p(this_$iv);
                    boolean bl3 = false;
                    String string = "dealspecial cubeid " + cubeId + " redoqueue size:" + cubeWorkspace.getReplayRedo().getRecordQueue().size();
                    logger.info(string);
                }
                RedoReplayer replayer = new RedoReplayer(cubeWorkspace, this.olap);
                replayer.executeJob(false);
                this.especial.remove(cubeId);
            }
            cubeWorkspace.getReplayRedo().unLatch();
        }
    }

    @Override
    public void start() {
        this.enable = true;
        super.start();
    }

    public final void close() {
        this.enable = false;
        this.join();
        this.executor.shutdown();
        this.redoFile.close();
    }

    @NotNull
    public final <T> Future<T> submit(@NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Future future = this.executor.submit((Callable)new ReplayCallable<T>(task));
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit(ReplayCallable(task))");
        return future;
    }

    public static final /* synthetic */ OlapWorkspace access$getOlap$p(ReplayCoordinator $this) {
        return $this.olap;
    }

    public static final /* synthetic */ void access$set_isError$p(ReplayCoordinator $this, boolean bl) {
        $this._isError = bl;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getEspecial$p(ReplayCoordinator $this) {
        return $this.especial;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer/replication/ReplayCoordinator$Companion;", "", "()V", "dealEspecialInterval", "", "maxRedoQueueSize", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0006\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/replication/ReplayCoordinator$ReplayCallable;", "V", "Ljava/util/concurrent/Callable;", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "call", "()Ljava/lang/Object;", "bos-olap-core"})
    private static final class ReplayCallable<V>
    implements Callable<V> {
        @NotNull
        private final Function0<V> task;

        public ReplayCallable(@NotNull Function0<? extends V> task) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            this.task = task;
        }

        @Override
        public V call() {
            return (V)this.task.invoke();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer/replication/ReplayCoordinator$DefaultThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "group", "Ljava/lang/ThreadGroup;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "bos-olap-core"})
    private static final class DefaultThreadFactory
    implements ThreadFactory {
        @NotNull
        private final ThreadGroup group;
        @NotNull
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public DefaultThreadFactory() {
            ThreadGroup threadGroup;
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                ThreadGroup threadGroup2 = s.getThreadGroup();
                Intrinsics.checkNotNullExpressionValue((Object)threadGroup2, (String)"s.threadGroup");
                threadGroup = threadGroup2;
            } else {
                ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
                Intrinsics.checkNotNullExpressionValue((Object)threadGroup3, (String)"currentThread().threadGroup");
                threadGroup = threadGroup3;
            }
            this.group = threadGroup;
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Thread t2 = new Thread(this.group, r, Intrinsics.stringPlus((String)"replayRedoThread-", (Object)this.threadNumber.getAndIncrement()), 0L);
            if (t2.isDaemon()) {
                t2.setDaemon(false);
            }
            if (t2.getPriority() != 5) {
                t2.setPriority(5);
            }
            return t2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedoType.values().length];
            nArray[RedoType.METADATA.ordinal()] = 1;
            nArray[RedoType.INSERT.ordinal()] = 2;
            nArray[RedoType.UPDATE.ordinal()] = 3;
            nArray[RedoType.CubeRecover.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

