/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.util.HashSet;
import java.util.Set;
import kd.bos.olapServer.dataEntities.InputRow;
import kd.bos.olapServer.replication.IDDLRecord;
import kd.bos.olapServer.replication.IDMLRecord;
import kd.bos.olapServer.replication.IRedoRecord;
import kd.bos.olapServer.replication.ReadedRedoFile;
import kd.bos.olapServer.replication.ReadedRedoPage;
import kd.bos.olapServer.replication.SlaveLSNContext;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\n\u0010\f\u001a\u00060\nj\u0002`\u000b\u0012\f\b\u0002\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u0012\u0012\b\u0002\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\u0011\u0012\f\b\u0002\u0010\u0012\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\n\u0010\u001f\u001a\u00060\u000ej\u0002`\u000fH\u0002J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lkd/bos/olapServer/replication/ReplayOneCube;", "", "olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "LSNContext", "Lkd/bos/olapServer/replication/SlaveLSNContext;", "path", "", "Lkd/bos/olapServer/common/string;", "redoCubeId", "", "Lkd/bos/olapServer/common/int;", "cubeId", "maxTime", "", "Lkd/bos/olapServer/common/long;", "ignoreTid", "", "maxTid", "(Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/replication/SlaveLSNContext;Ljava/lang/String;IIJLjava/util/Set;J)V", "cube", "Lkd/bos/olapServer/storages/CubeWorkspace;", "redoFile", "Lkd/bos/olapServer/replication/ReadedRedoFile;", "row", "Lkd/bos/olapServer/dataEntities/InputRow;", "writer", "Lkd/bos/olapServer/storages/IInputRowWriter;", "isInvalid", "", "Lkd/bos/olapServer/common/bool;", "tid", "replay", "", "replayRecord", "record", "Lkd/bos/olapServer/replication/IRedoRecord;", "bos-olap-core"})
public final class ReplayOneCube {
    @NotNull
    private final OlapWorkspace olap;
    private final int redoCubeId;
    private final long maxTime;
    @NotNull
    private final Set<Long> ignoreTid;
    private final long maxTid;
    @NotNull
    private final CubeWorkspace cube;
    @NotNull
    private InputRow row;
    @NotNull
    private IInputRowWriter writer;
    @NotNull
    private final ReadedRedoFile redoFile;

    public ReplayOneCube(@NotNull OlapWorkspace olap, @NotNull SlaveLSNContext LSNContext2, @NotNull String path, int redoCubeId, int cubeId, long maxTime, @NotNull Set<Long> ignoreTid, long maxTid) {
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)LSNContext2, (String)"LSNContext");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(ignoreTid, (String)"ignoreTid");
        this.olap = olap;
        this.redoCubeId = redoCubeId;
        this.maxTime = maxTime;
        this.ignoreTid = ignoreTid;
        this.maxTid = maxTid;
        this.cube = this.olap.getCubeWorkspaceByCubeId(cubeId);
        this.row = this.cube.getMetadata().getEnabledPartition() ? new InputRow(this.cube.getMetadata().getPartitionCubeMetadata(this.cube.getMetadata().getPartition().getAllPartitionItems().get(0))) : new InputRow(this.cube.getMetadata());
        this.writer = CubeWorkspace.createWriter$default(this.cube, null, 1, null);
        this.redoFile = new ReadedRedoFile(path, LSNContext2);
    }

    public /* synthetic */ ReplayOneCube(OlapWorkspace olapWorkspace, SlaveLSNContext slaveLSNContext, String string, int n, int n2, long l, Set set, long l2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            l = Long.MAX_VALUE;
        }
        if ((n3 & 0x40) != 0) {
            set = new HashSet();
        }
        if ((n3 & 0x80) != 0) {
            l2 = Long.MAX_VALUE;
        }
        this(olapWorkspace, slaveLSNContext, string, n, n2, l, set, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void replay() {
        try {
            while (this.redoFile.hasNext()) {
                ReadedRedoPage page = this.redoFile.next();
                if (page.getTimestamp() > this.maxTime) {
                    break;
                }
                while (page.hasNext()) {
                    IRedoRecord record2 = page.next();
                    if (record2.getCubeId() != this.redoCubeId || this.isInvalid(record2.getTid())) continue;
                    this.replayRecord(record2);
                }
            }
        }
        finally {
            this.writer.force();
            this.writer.close();
            this.redoFile.close();
        }
    }

    private final boolean isInvalid(long tid) {
        if (tid > this.maxTid) {
            return true;
        }
        return this.ignoreTid.contains(tid);
    }

    private final void replayRecord(IRedoRecord record2) {
        IRedoRecord iRedoRecord = record2;
        if (iRedoRecord instanceof IDDLRecord) {
            this.writer.force();
            this.writer.close();
            ((IDDLRecord)record2).replayDDL(this.olap);
            this.row = this.cube.getMetadata().getEnabledPartition() ? new InputRow(this.cube.getMetadata().getPartitionCubeMetadata(this.cube.getMetadata().getPartition().getAllPartitionItems().get(0))) : new InputRow(this.cube.getMetadata());
            this.writer = CubeWorkspace.createWriter$default(this.cube, null, 1, null);
        } else if (iRedoRecord instanceof IDMLRecord) {
            ((IDMLRecord)record2).replayDML(this.cube, this.writer, this.row);
        } else {
            throw Res.INSTANCE.getNotSupportedException("impossible Redo Type " + (Object)((Object)record2.getRedoType()) + " for cube:" + this.redoCubeId, new Object[0]);
        }
    }
}

