/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.io.File;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.BackupType;
import kd.bos.olapServer.replication.ControlConfig;
import kd.bos.olapServer.replication.IReplicationMaster;
import kd.bos.olapServer.replication.IReplicationSlave;
import kd.bos.olapServer.replication.OlapBackupRecover;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.ReplayCoordinator;
import kd.bos.olapServer.replication.ReplicationConf;
import kd.bos.olapServer.replication.ReplicationContext;
import kd.bos.olapServer.replication.ReplicationMaster;
import kd.bos.olapServer.replication.ReplicationSlave;
import kd.bos.olapServer.replication.ReplicationStatus;
import kd.bos.olapServer.replication.SlaveLSNContext;
import kd.bos.olapServer.security.IAccessStrategy;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.security.StatusAccessStrategy;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\n\u00108\u001a\u00060*j\u0002`+J\u0006\u00109\u001a\u000205J\u001a\u0010:\u001a\u00060*j\u0002`+2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020\fJ\u0012\u0010=\u001a\u0002052\n\u0010>\u001a\u00060'j\u0002`(J\u0012\u0010?\u001a\u0002052\n\u0010>\u001a\u00060'j\u0002`(J\n\u0010@\u001a\u00060Aj\u0002`BJ\"\u0010C\u001a\u0002052\u0006\u0010D\u001a\u00020\u001e2\n\u0010E\u001a\u00060Aj\u0002`B2\u0006\u0010F\u001a\u00020\u001bJ\u0016\u0010G\u001a\u00060*j\u0002`+2\n\u0010>\u001a\u00060'j\u0002`(J\n\u0010H\u001a\u00060*j\u0002`+J\u0006\u0010I\u001a\u000205J\u0012\u0010J\u001a\u0002052\n\u0010K\u001a\u00060Aj\u0002`BJ\u001a\u0010L\u001a\u0002052\u0006\u0010M\u001a\u00020N2\n\u0010O\u001a\u00060Aj\u0002`BJ\u0006\u0010P\u001a\u000205J\u0010\u0010Q\u001a\u0002052\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010\f0\f0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010%\u001a\f\u0012\b\u0012\u00060'j\u0002`(0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010)\u001a\u00060*j\u0002`+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0015\u0010.\u001a\u00060*j\u0002`+8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006R"}, d2={"Lkd/bos/olapServer/replication/ReplicationManager;", "", "()V", "Master", "Lkd/bos/olapServer/replication/IReplicationMaster;", "getMaster", "()Lkd/bos/olapServer/replication/IReplicationMaster;", "Slave", "Lkd/bos/olapServer/replication/IReplicationSlave;", "getSlave", "()Lkd/bos/olapServer/replication/IReplicationSlave;", "value", "Lkd/bos/olapServer/replication/ReplicationStatus;", "Status", "getStatus", "()Lkd/bos/olapServer/replication/ReplicationStatus;", "setStatus", "(Lkd/bos/olapServer/replication/ReplicationStatus;)V", "SwitchThread", "Ljava/lang/Thread;", "getSwitchThread", "()Ljava/lang/Thread;", "setSwitchThread", "(Ljava/lang/Thread;)V", "_conf", "Lkd/bos/olapServer/replication/ReplicationConf;", "_context", "Lkd/bos/olapServer/replication/ReplicationContext;", "_master", "_olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "_slave", "_status", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "_statusStrategy", "Lkd/bos/olapServer/security/IAccessStrategy;", "disableCubes", "Ljava/util/concurrent/CopyOnWriteArraySet;", "", "Lkd/bos/olapServer/common/int;", "enableMaster", "", "Lkd/bos/olapServer/common/bool;", "getEnableMaster", "()Z", "enableSlave", "getEnableSlave", "logger", "Lkd/bos/olapServer/replication/OlapLogger;", "getLogger", "()Lkd/bos/olapServer/replication/OlapLogger;", "backupOlap", "", "type", "Lkd/bos/olapServer/replication/BackupType;", "canSwitch", "close", "compareAndSetStatus", "expect", "update", "disableCube", "cubeId", "enableCube", "getBackupPath", "", "Lkd/bos/olapServer/common/string;", "init", "olap", "confPath", "context", "isDisable", "isVipHost", "masterToSlave", "recoveryOlap", "backupPath", "replayRedo", "controlConfig", "Lkd/bos/olapServer/replication/ControlConfig;", "redoPath", "slaveToMaster", "updateAccessStrategies", "bos-olap-core"})
public final class ReplicationManager {
    @NotNull
    public static final ReplicationManager INSTANCE = new ReplicationManager();
    @Nullable
    private static IReplicationMaster _master;
    @Nullable
    private static IReplicationSlave _slave;
    @NotNull
    private static final CopyOnWriteArraySet<Integer> disableCubes;
    @Nullable
    private static ReplicationConf _conf;
    @Nullable
    private static OlapWorkspace _olap;
    @NotNull
    private static AtomicReference<ReplicationStatus> _status;
    @Nullable
    private static IAccessStrategy _statusStrategy;
    @NotNull
    private static final OlapLogger logger;
    @Nullable
    private static Thread SwitchThread;
    @Nullable
    private static ReplicationContext _context;

    private ReplicationManager() {
    }

    @NotNull
    public final IReplicationMaster getMaster() {
        IReplicationMaster iReplicationMaster = _master;
        Intrinsics.checkNotNull((Object)iReplicationMaster);
        return iReplicationMaster;
    }

    public final boolean getEnableMaster() {
        return _master != null;
    }

    @NotNull
    public final IReplicationSlave getSlave() {
        IReplicationSlave iReplicationSlave = _slave;
        Intrinsics.checkNotNull((Object)iReplicationSlave);
        return iReplicationSlave;
    }

    public final boolean getEnableSlave() {
        return _slave != null;
    }

    @NotNull
    public final ReplicationStatus getStatus() {
        ReplicationStatus replicationStatus = _status.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)replicationStatus), (String)"_status.get()");
        return replicationStatus;
    }

    public final void setStatus(@NotNull ReplicationStatus value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        _status.set(value2);
        this.updateAccessStrategies(value2);
    }

    private final synchronized void updateAccessStrategies(ReplicationStatus value2) {
        logger.setStatus(value2);
        IAccessStrategy currentStatusStrategy = _statusStrategy;
        if (currentStatusStrategy != null) {
            OlapWorkspace olapWorkspace = _olap;
            Intrinsics.checkNotNull((Object)olapWorkspace);
            olapWorkspace.getAccessStrategies().remove(currentStatusStrategy);
        }
        StatusAccessStrategy newStatusStrategy = new StatusAccessStrategy(value2);
        _statusStrategy = newStatusStrategy;
        OlapWorkspace olapWorkspace = _olap;
        Intrinsics.checkNotNull((Object)olapWorkspace);
        olapWorkspace.getAccessStrategies().add(newStatusStrategy);
        OlapLogger this_$iv = logger;
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"set new status:", (Object)((Object)value2));
            logger.info(string);
        }
    }

    @NotNull
    public final OlapLogger getLogger() {
        return logger;
    }

    public final boolean compareAndSetStatus(@NotNull ReplicationStatus expect, @NotNull ReplicationStatus update) {
        Intrinsics.checkNotNullParameter((Object)((Object)expect), (String)"expect");
        Intrinsics.checkNotNullParameter((Object)((Object)update), (String)"update");
        boolean ret = _status.compareAndSet(expect, update);
        if (ret) {
            this.updateAccessStrategies(update);
        }
        return ret;
    }

    @Nullable
    public final Thread getSwitchThread() {
        return SwitchThread;
    }

    public final void setSwitchThread(@Nullable Thread thread) {
        SwitchThread = thread;
    }

    public final void init(@NotNull OlapWorkspace olap, @NotNull String confPath, @NotNull ReplicationContext context) {
        Object it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)confPath, (String)"confPath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        _olap = olap;
        logger.setOlapWorkspace(olap);
        _context = context;
        Object object = new String[]{"replication.xml"};
        File configFile = Paths.INSTANCE.get(confPath, (String[])object).toFile();
        if (!configFile.exists()) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)configFile, (String)"configFile");
        ReplicationConf replicationConf = _conf = ReplicationConf.Companion.read(configFile);
        Intrinsics.checkNotNull((Object)replicationConf);
        if (replicationConf.get_master().getMasterReplication()) {
            ReplicationConf replicationConf2 = _conf;
            Intrinsics.checkNotNull((Object)replicationConf2);
            if (replicationConf2.get_slave().getSlaveReplication()) {
                ReplicationConf replicationConf3 = _conf;
                Intrinsics.checkNotNull((Object)replicationConf3);
                replicationConf3.checkValid();
                object = Res.INSTANCE.getReplicationManagerException_2();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Res.ReplicationManagerException_2");
                throw Res.INSTANCE.getRuntimeException((String)object, new Object[0]);
            }
        }
        ReplicationConf replicationConf4 = _conf;
        Intrinsics.checkNotNull((Object)replicationConf4);
        if (replicationConf4.get_master().getMasterReplication()) {
            ReplicationConf replicationConf5 = _conf;
            Intrinsics.checkNotNull((Object)replicationConf5);
            replicationConf5.checkValid();
            ReplicationConf replicationConf6 = _conf;
            Intrinsics.checkNotNull((Object)replicationConf6);
            object = new ReplicationMaster(replicationConf6, olap, context);
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            ((ReplicationMaster)it).start();
            _master = (IReplicationMaster)object;
        }
        ReplicationConf replicationConf7 = _conf;
        Intrinsics.checkNotNull((Object)replicationConf7);
        if (replicationConf7.get_slave().getSlaveReplication()) {
            ReplicationConf replicationConf8 = _conf;
            Intrinsics.checkNotNull((Object)replicationConf8);
            object = new ReplicationSlave(replicationConf8, olap, context);
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            ((ReplicationSlave)it).start();
            _slave = (IReplicationSlave)object;
        }
    }

    @NotNull
    public final String getBackupPath() {
        if (_conf == null) {
            return "";
        }
        ReplicationConf replicationConf = _conf;
        Intrinsics.checkNotNull((Object)replicationConf);
        return replicationConf.get_node().getBackupPath();
    }

    public final void disableCube(int cubeId) {
        disableCubes.add(cubeId);
    }

    public final void enableCube(int cubeId) {
        disableCubes.remove(cubeId);
    }

    public final boolean isDisable(int cubeId) {
        return disableCubes.contains(cubeId) | disableCubes.contains(0) | cubeId == -1;
    }

    public final void slaveToMaster() {
        AutoCloseable autoCloseable = _slave;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        _slave = null;
        ReplicationConf replicationConf = _conf;
        Intrinsics.checkNotNull((Object)replicationConf);
        OlapWorkspace olapWorkspace = _olap;
        Intrinsics.checkNotNull((Object)olapWorkspace);
        ReplicationContext replicationContext = _context;
        Intrinsics.checkNotNull((Object)replicationContext);
        autoCloseable = new ReplicationMaster(replicationConf, olapWorkspace, replicationContext);
        boolean bl = false;
        boolean bl2 = false;
        AutoCloseable it = autoCloseable;
        boolean bl3 = false;
        ((ReplicationMaster)it).start();
        _master = (IReplicationMaster)autoCloseable;
    }

    public final void masterToSlave() {
        IReplicationMaster iReplicationMaster = _master;
        if (iReplicationMaster != null) {
            iReplicationMaster.close();
        }
        _master = null;
        ReplicationConf replicationConf = _conf;
        Intrinsics.checkNotNull((Object)replicationConf);
        OlapWorkspace olapWorkspace = _olap;
        Intrinsics.checkNotNull((Object)olapWorkspace);
        ReplicationContext replicationContext = _context;
        Intrinsics.checkNotNull((Object)replicationContext);
        ReplicationSlave tempSalve = new ReplicationSlave(replicationConf, olapWorkspace, replicationContext);
        int n = 1;
        while (true) {
            String string;
            Logger logger;
            int i = n++;
            try {
                tempSalve.start();
                OlapLogger this_$iv = ReplicationManager.logger;
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    logger = OlapLogger.access$getLogger$p(this_$iv);
                    boolean bl = false;
                    string = "start\u6210\u529f";
                    logger.info(string);
                }
                _slave = tempSalve;
            }
            catch (Exception ex) {
                HealthReport report$iv;
                String reportId$iv;
                Thread.sleep(1000L);
                OlapLogger this_$iv = ReplicationManager.logger;
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    boolean bl = false;
                    String message$iv = "" + '\u7b2c' + i + "\u6b21\u5c1d\u8bd5\u8fde\u63a5\u65b0MASTER\uff0c\u5931\u8d25";
                    OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                    if (olap$iv != null) {
                        reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                        report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                        olap$iv.getHealthReports().commit(report$iv);
                    }
                    logger = OlapLogger.access$getLogger$p(this_$iv);
                    $i$a$-warn-ReplicationManager$masterToSlave$2 = false;
                    string = "" + '\u7b2c' + i + "\u6b21\u5c1d\u8bd5\u8fde\u63a5\u65b0MASTER\uff0c\u5931\u8d25";
                    logger.warn(string);
                }
                if (i != 10) continue;
                this_$iv = ReplicationManager.logger;
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv = "\u4e3b\u81ea\u52a8\u5207\u6362\u4e3a\u4ece\uff0c\u5931\u8d25";
                    OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                    if (olap$iv != null) {
                        reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                        report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        olap$iv.getHealthReports().commit(report$iv);
                    }
                    if ((Throwable)ex == null) {
                        OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                    } else {
                        OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)ex);
                    }
                }
                tempSalve.close();
                if (n <= 10) continue;
            }
            break;
        }
    }

    public final boolean isVipHost() {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface item = e.nextElement();
            for (InterfaceAddress address : item.getInterfaceAddresses()) {
                String string = address.getAddress().getHostAddress();
                ReplicationConf replicationConf = _conf;
                Intrinsics.checkNotNull((Object)replicationConf);
                if (!Intrinsics.areEqual((Object)string, (Object)replicationConf.get_node().getVip())) continue;
                if (_status.get() == ReplicationStatus.Slave) {
                    OlapLogger this_$iv = logger;
                    boolean $i$f$info = false;
                    if (this_$iv.isInfoEnabled()) {
                        Logger logger = OlapLogger.access$getLogger$p(this_$iv);
                        boolean bl = false;
                        String string2 = "VIP: " + address.getAddress().getHostAddress() + ", \u72b6\u6001\uff1a" + (Object)((Object)INSTANCE.getStatus());
                        logger.info(string2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public final boolean canSwitch() {
        if (this.getEnableMaster()) {
            OlapWorkspace olapWorkspace = _olap;
            Intrinsics.checkNotNull((Object)olapWorkspace);
            return olapWorkspace.isFree();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void backupOlap(@NotNull BackupType type) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.compareAndSetStatus(ReplicationStatus.Slave, ReplicationStatus.Backup)) {
            try {
                BackupType backupType = type;
                int n = WhenMappings.$EnumSwitchMapping$0[backupType.ordinal()];
                switch (n) {
                    case 1: {
                        IReplicationSlave iReplicationSlave = _slave;
                        if (iReplicationSlave == null) {
                            return;
                        }
                        iReplicationSlave.totalBackup();
                        return;
                    }
                    case 2: {
                        IReplicationSlave iReplicationSlave = _slave;
                        if (iReplicationSlave == null) {
                            return;
                        }
                        iReplicationSlave.incrementBackup();
                        return;
                    }
                }
                return;
            }
            finally {
                this.compareAndSetStatus(ReplicationStatus.Backup, ReplicationStatus.Slave);
            }
        }
        if (_status.get() == ReplicationStatus.Master && (object = _master) != null) {
            object.checkCanTotalBackup();
        }
        if (!this.compareAndSetStatus(ReplicationStatus.Master, ReplicationStatus.Backup)) {
            object = Res.INSTANCE.getReplicationManagerException_3();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Res.ReplicationManagerException_3");
            Object object2 = object;
            object = new Object[]{_status.get()};
            throw Res.INSTANCE.getRuntimeException((String)object2, (Object[])object);
        }
        try {
            object = type;
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: {
                    IReplicationMaster iReplicationMaster = _master;
                    if (iReplicationMaster == null) {
                        return;
                    }
                    iReplicationMaster.totalBackup();
                    return;
                }
                case 2: {
                    IReplicationMaster iReplicationMaster = _master;
                    if (iReplicationMaster == null) {
                        return;
                    }
                    iReplicationMaster.incrementBackup();
                    return;
                }
            }
            return;
        }
        finally {
            this.compareAndSetStatus(ReplicationStatus.Backup, ReplicationStatus.Master);
        }
    }

    public final void replayRedo(@NotNull ControlConfig controlConfig, @NotNull String redoPath) {
        Intrinsics.checkNotNullParameter((Object)controlConfig, (String)"controlConfig");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        SlaveLSNContext slaveContext = new SlaveLSNContext(controlConfig.getRecoveryStartLSN(), controlConfig.getRecoveryEndLSN());
        if (controlConfig.getRecoveryStartLSN() == controlConfig.getRecoveryEndLSN()) {
            return;
        }
        OlapWorkspace olapWorkspace = _olap;
        Intrinsics.checkNotNull((Object)olapWorkspace);
        ReplayCoordinator coordinator = new ReplayCoordinator(olapWorkspace, slaveContext, redoPath, null);
        coordinator.start();
        while (true) {
            if (coordinator.isError()) {
                String string = Res.INSTANCE.getReplicationManagerException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ReplicationManagerException_1");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            if (slaveContext.getNextReadPage() == controlConfig.getRecoveryEndLSN()) break;
            Thread.sleep(10L);
        }
        coordinator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recoveryOlap(@NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        if (!this.compareAndSetStatus(ReplicationStatus.None, ReplicationStatus.Recover)) {
            Object[] objectArray = Res.INSTANCE.getReplicationManagerException_4();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ReplicationManagerException_4");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{_status.get()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
        try {
            OlapWorkspace olapWorkspace = _olap;
            Intrinsics.checkNotNull((Object)olapWorkspace);
            ReplicationConf replicationConf = _conf;
            Intrinsics.checkNotNull((Object)replicationConf);
            OlapBackupRecover recoverMgr = new OlapBackupRecover(olapWorkspace, replicationConf);
            recoverMgr.recovery(backupPath);
        }
        catch (Exception e) {
            OlapLogger this_$iv = logger;
            Object t$iv = null;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("\u6570\u636e\u6062\u590d\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f ").append(e).append('\uff1a');
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
                String message$iv = stringBuilder.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null)).toString();
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
            }
            throw e;
        }
        finally {
            this.compareAndSetStatus(ReplicationStatus.Recover, ReplicationStatus.None);
        }
    }

    public final void close() {
        Object object = SwitchThread;
        if (object != null) {
            ((Thread)object).join();
        }
        OlapLogger this_$iv = logger;
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)this.getClass().getSimpleName(), (Object)" close()");
            logger.info(string);
        }
        if (this.getEnableMaster()) {
            object = _master;
            if (object != null) {
                object.close();
            }
            _master = null;
        }
        if (this.getEnableSlave()) {
            object = _slave;
            if (object != null) {
                object.close();
            }
            _slave = null;
        }
        disableCubes.clear();
        _status.set(ReplicationStatus.None);
    }

    static {
        disableCubes = new CopyOnWriteArraySet();
        _status = new AtomicReference<ReplicationStatus>(ReplicationStatus.None);
        Logger logger = LoggerFactory.getLogger((String)"ReplicationLog");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"ReplicationLog\")");
        ReplicationManager.logger = new OlapLogger(logger, _olap, INSTANCE.getStatus());
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackupType.values().length];
            nArray[BackupType.Total.ordinal()] = 1;
            nArray[BackupType.Increment.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

