/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.ControlConfig;
import kd.bos.olapServer.replication.IReplicationMaster;
import kd.bos.olapServer.replication.LSNUtil;
import kd.bos.olapServer.replication.MasterLSNContext;
import kd.bos.olapServer.replication.OlapBackupRecover;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.OlapReplicationMasterPlugin;
import kd.bos.olapServer.replication.RedoBuffer;
import kd.bos.olapServer.replication.RedoPage;
import kd.bos.olapServer.replication.RedoSender;
import kd.bos.olapServer.replication.ReplicationConf;
import kd.bos.olapServer.replication.ReplicationContext;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.replication.ReplicationStatus;
import kd.bos.olapServer.replication.TimeStatQueue;
import kd.bos.olapServer.replication.WritedRedoFile;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J$\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001d0\u001cj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001d`\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\u0014\u0010!\u001a\u00020\u00192\n\u0010\"\u001a\u00060#j\u0002`$H\u0016J\b\u0010%\u001a\u00020\u0019H\u0016J\u0014\u0010&\u001a\u00060#j\u0002`$2\u0006\u0010'\u001a\u00020(H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkd/bos/olapServer/replication/ReplicationMaster;", "Lkd/bos/olapServer/replication/IReplicationMaster;", "conf", "Lkd/bos/olapServer/replication/ReplicationConf;", "olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "context", "Lkd/bos/olapServer/replication/ReplicationContext;", "(Lkd/bos/olapServer/replication/ReplicationConf;Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/replication/ReplicationContext;)V", "ackTimeStat", "Lkd/bos/olapServer/replication/TimeStatQueue;", "controlConfig", "Lkd/bos/olapServer/replication/ControlConfig;", "controlFileName", "", "Lkd/bos/olapServer/common/string;", "file", "Lkd/bos/olapServer/replication/WritedRedoFile;", "masterLSNContext", "Lkd/bos/olapServer/replication/MasterLSNContext;", "redoBuffer", "Lkd/bos/olapServer/replication/RedoBuffer;", "redoSender", "Lkd/bos/olapServer/replication/RedoSender;", "checkCanTotalBackup", "", "close", "getDisplayInfo", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "incrementBackup", "start", "syncSlaves", "syncPoint", "", "Lkd/bos/olapServer/common/LSN;", "totalBackup", "tryMerge", "local", "Ljava/nio/ByteBuffer;", "bos-olap-core"})
public final class ReplicationMaster
implements IReplicationMaster {
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final OlapWorkspace olap;
    @NotNull
    private final String controlFileName;
    @NotNull
    private ControlConfig controlConfig;
    @NotNull
    private final MasterLSNContext masterLSNContext;
    @Nullable
    private final TimeStatQueue ackTimeStat;
    @NotNull
    private final RedoSender redoSender;
    @NotNull
    private final RedoBuffer redoBuffer;
    @Nullable
    private WritedRedoFile file;

    public ReplicationMaster(@NotNull ReplicationConf conf, @NotNull OlapWorkspace olap, @NotNull ReplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.conf = conf;
        this.olap = olap;
        String[] stringArray = new String[]{"lsn.control"};
        this.controlFileName = ((Object)Paths.INSTANCE.get(this.olap.getRootPath(), stringArray)).toString();
        this.controlConfig = new File(this.controlFileName).exists() ? ControlConfig.Companion.readControlConfig(this.controlFileName) : new ControlConfig(0L, 0L);
        this.masterLSNContext = new MasterLSNContext(this.controlConfig.getRecoveryEndLSN());
        this.ackTimeStat = this.conf.get_node().getEnableStat() ? new TimeStatQueue(this.masterLSNContext.getCurrentPage()) : null;
        this.redoSender = new RedoSender(this.conf, this.masterLSNContext, context, this.ackTimeStat);
        this.redoBuffer = new RedoBuffer(this.masterLSNContext, (Function1<? super RedoPage, Unit>)((Function1)new Function1<RedoPage, Unit>(this){
            final /* synthetic */ ReplicationMaster this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RedoPage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ReplicationMaster.access$getRedoSender$p(this.this$0).sync(it);
                if (ReplicationMaster.access$getConf$p(this.this$0).get_master().getEnableWriteDisk()) {
                    WritedRedoFile writedRedoFile = ReplicationMaster.access$getFile$p(this.this$0);
                    Intrinsics.checkNotNull((Object)writedRedoFile);
                    writedRedoFile.writePage(it);
                    ReplicationMaster.access$getMasterLSNContext$p(this.this$0).setNextWritePage(LSNUtil.INSTANCE.nextPageLSN(ReplicationMaster.access$getMasterLSNContext$p(this.this$0).getNextWritePage()));
                }
            }
        }));
        this.olap.getPlugins().getOrCreate(OlapReplicationMasterPlugin.Companion.getOlapReplicationPluginKey(), 1.INSTANCE);
    }

    @Override
    public long tryMerge(@NotNull ByteBuffer local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        return this.redoBuffer.tryMerge$bos_olap_core(local);
    }

    @Override
    public void syncSlaves(long syncPoint) {
        this.redoBuffer.forceSync$bos_olap_core(syncPoint);
        int count = 0;
        int maxCount = 1000;
        while (this.masterLSNContext.getLastACKLSN() < syncPoint) {
            Thread.sleep(10L);
            int n = count;
            if ((count = n + 1) <= maxCount) continue;
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                boolean bl = false;
                String message$iv = "slave ACK\u8fd4\u56de\u8d85\u65f6,masterLSNContext.lastACKLSN=" + this.masterLSNContext.getLastACKLSN() + ", syncPoint= " + syncPoint;
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                Logger logger = OlapLogger.access$getLogger$p(this_$iv);
                $i$a$-warn-ReplicationMaster$syncSlaves$1 = false;
                String string = "slave ACK\u8fd4\u56de\u8d85\u65f6,masterLSNContext.lastACKLSN=" + this.masterLSNContext.getLastACKLSN() + ", syncPoint= " + syncPoint;
                logger.warn(string);
            }
            String string = Res.INSTANCE.getReplicationMasterException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ReplicationMasterException_1");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
    }

    @Override
    public void start() {
        try {
            this.file = this.conf.get_master().getEnableWriteDisk() ? new WritedRedoFile(this.conf.get_node().getRedoPath(), this.masterLSNContext, this.conf.get_node().getRedoKeepSegments()) : null;
            ReplicationManager.INSTANCE.replayRedo(this.controlConfig, this.conf.get_node().getRedoPath());
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        ReplicationManager.INSTANCE.setStatus(ReplicationStatus.Master);
        this.redoSender.start();
    }

    @Override
    public void checkCanTotalBackup() {
        int tryTime = 300;
        while (tryTime > 0) {
            if (!this.olap.isFree()) {
                String string = Res.INSTANCE.getReplicationMasterException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ReplicationMasterException_2");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            int n = tryTime;
            tryTime = n + -1;
            Thread.sleep(10L);
        }
    }

    @Override
    public void totalBackup() {
        this.checkCanTotalBackup();
        OlapBackupRecover olapBackupRecover = new OlapBackupRecover(this.olap, this.conf);
        olapBackupRecover.totalBackup(this.masterLSNContext.getCurrentPage());
    }

    @Override
    public void incrementBackup() {
        OlapBackupRecover olapBackupRecover = new OlapBackupRecover(this.olap, this.conf);
        olapBackupRecover.incrementBackup(this.masterLSNContext.getCurrentPage());
    }

    @Override
    public void close() {
        this.redoBuffer.close();
        this.redoSender.close();
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = "\u5173\u95ed" + this.redoSender.getClass().getSimpleName() + "\u6210\u529f";
            logger.info(string);
        }
        WritedRedoFile writedRedoFile = this.file;
        if (writedRedoFile != null) {
            writedRedoFile.close();
        }
        new ControlConfig(this.masterLSNContext.getNextWritePage(), this.masterLSNContext.getNextWritePage()).save(this.controlFileName);
    }

    @Override
    @NotNull
    public HashMap<String, Object> getDisplayInfo() {
        long editPage = this.masterLSNContext.getCurrentPage();
        long writedLsn = LSNUtil.INSTANCE.prePageLSN(this.masterLSNContext.getNextWritePage());
        long ackedLsn = this.masterLSNContext.getLastACKLSN();
        TimeStatQueue timeStatQueue = this.ackTimeStat;
        ArrayList<Pair<Long, Long>> timeStat = timeStatQueue == null ? null : timeStatQueue.getTimeStat();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Map map = data;
        String string = "editPage";
        Pair pair = new Pair((Object)"\u5f53\u524d\u7f16\u8f91\u9875LSN", (Object)editPage);
        boolean bl = false;
        map.put(string, pair);
        map = data;
        string = "writedLsn";
        pair = new Pair((Object)"\u5df2\u5199\u76d8\u9875LSN", (Object)writedLsn);
        bl = false;
        map.put(string, pair);
        map = data;
        string = "ackedLsn";
        pair = new Pair((Object)"Slave\u5df2\u786e\u8ba4\u63a5\u6536LSN", (Object)ackedLsn);
        bl = false;
        map.put(string, pair);
        map = data;
        string = "slaveNum";
        pair = new Pair((Object)"\u5df2\u63a5\u5165Slave\u7ed3\u70b9", this.redoSender.getReadySlaves());
        bl = false;
        map.put(string, pair);
        map = data;
        string = "timeStat";
        pair = new Pair((Object)"RTT\u4f20\u8f93\u5ef6\u8fdf\u8ddf\u8e2a\u66f2\u7ebf", timeStat);
        bl = false;
        map.put(string, pair);
        return data;
    }

    public static final /* synthetic */ RedoSender access$getRedoSender$p(ReplicationMaster $this) {
        return $this.redoSender;
    }

    public static final /* synthetic */ ReplicationConf access$getConf$p(ReplicationMaster $this) {
        return $this.conf;
    }

    public static final /* synthetic */ WritedRedoFile access$getFile$p(ReplicationMaster $this) {
        return $this.file;
    }

    public static final /* synthetic */ MasterLSNContext access$getMasterLSNContext$p(ReplicationMaster $this) {
        return $this.masterLSNContext;
    }
}

