/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.replication.ControlConfig;
import kd.bos.olapServer.replication.IReplicationSlave;
import kd.bos.olapServer.replication.LSNUtil;
import kd.bos.olapServer.replication.OlapBackupRecover;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.OlapReplicationMasterPlugin;
import kd.bos.olapServer.replication.RedoReceiver;
import kd.bos.olapServer.replication.ReplayCoordinator;
import kd.bos.olapServer.replication.ReplicationConf;
import kd.bos.olapServer.replication.ReplicationContext;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.replication.SlaveLSNContext;
import kd.bos.olapServer.replication.TimeStatQueue;
import kd.bos.olapServer.storages.OlapWorkspace;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001a`\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkd/bos/olapServer/replication/ReplicationSlave;", "Lkd/bos/olapServer/replication/IReplicationSlave;", "conf", "Lkd/bos/olapServer/replication/ReplicationConf;", "olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "context", "Lkd/bos/olapServer/replication/ReplicationContext;", "(Lkd/bos/olapServer/replication/ReplicationConf;Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/replication/ReplicationContext;)V", "controlConfig", "Lkd/bos/olapServer/replication/ControlConfig;", "controlFileName", "", "Lkd/bos/olapServer/common/string;", "coordinator", "Lkd/bos/olapServer/replication/ReplayCoordinator;", "delayTimeStat", "Lkd/bos/olapServer/replication/TimeStatQueue;", "receiver", "Lkd/bos/olapServer/replication/RedoReceiver;", "slaveContext", "Lkd/bos/olapServer/replication/SlaveLSNContext;", "close", "", "getDisplayInfo", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "incrementBackup", "start", "startReplay", "stopReplay", "totalBackup", "bos-olap-core"})
public final class ReplicationSlave
implements IReplicationSlave {
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final OlapWorkspace olap;
    @NotNull
    private final String controlFileName;
    @NotNull
    private ControlConfig controlConfig;
    @NotNull
    private final SlaveLSNContext slaveContext;
    @Nullable
    private final TimeStatQueue delayTimeStat;
    @NotNull
    private final RedoReceiver receiver;
    @Nullable
    private ReplayCoordinator coordinator;

    public ReplicationSlave(@NotNull ReplicationConf conf, @NotNull OlapWorkspace olap, @NotNull ReplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.conf = conf;
        this.olap = olap;
        String[] stringArray = new String[]{"lsn.control"};
        this.controlFileName = ((Object)Paths.INSTANCE.get(this.olap.getRootPath(), stringArray)).toString();
        this.controlConfig = new File(this.controlFileName).exists() ? ControlConfig.Companion.readControlConfig(this.controlFileName) : new ControlConfig(0L, 0L);
        this.slaveContext = new SlaveLSNContext(this.controlConfig.getRecoveryStartLSN(), this.controlConfig.getRecoveryEndLSN());
        this.delayTimeStat = this.conf.get_node().getEnableStat() ? new TimeStatQueue(this.slaveContext.getNextWritePage()) : null;
        this.receiver = new RedoReceiver(this.conf, this.slaveContext, context, this.delayTimeStat);
        this.olap.getPlugins().getOrCreate(OlapReplicationMasterPlugin.Companion.getOlapReplicationPluginKey(), 1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void totalBackup() {
        this.stopReplay();
        try {
            OlapBackupRecover olapBackupRecover = new OlapBackupRecover(this.olap, this.conf);
            olapBackupRecover.totalBackup(this.slaveContext.getNextReadPage());
        }
        finally {
            this.startReplay();
        }
    }

    @Override
    public void incrementBackup() {
        OlapBackupRecover olapBackupRecover = new OlapBackupRecover(this.olap, this.conf);
        olapBackupRecover.incrementBackup(this.slaveContext.getNextWritePage());
    }

    private final void startReplay() {
        this.coordinator = new ReplayCoordinator(this.olap, this.slaveContext, this.conf.get_node().getRedoPath(), this.delayTimeStat);
        ReplayCoordinator replayCoordinator = this.coordinator;
        if (replayCoordinator != null) {
            replayCoordinator.start();
        }
    }

    private final void stopReplay() {
        ReplayCoordinator replayCoordinator = this.coordinator;
        if (replayCoordinator != null) {
            replayCoordinator.close();
        }
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Class<?> clazz;
            ReplayCoordinator replayCoordinator2;
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = "\u5173\u95ed" + ((replayCoordinator2 = this.coordinator) == null ? null : ((clazz = replayCoordinator2.getClass()) == null ? null : clazz.getSimpleName())) + "\u6210\u529f";
            logger.info(string);
        }
    }

    @Override
    public void start() {
        try {
            this.receiver.start();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        if (!this.receiver.isAlive()) {
            return;
        }
        this.startReplay();
    }

    @Override
    public void close() {
        this.stopReplay();
        this.receiver.close();
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = "\u5173\u95ed" + this.receiver.getClass().getSimpleName() + "\u6210\u529f";
            logger.info(string);
        }
        new ControlConfig(this.slaveContext.getNextReadPage(), this.slaveContext.getNextWritePage()).save(this.controlFileName);
    }

    @Override
    @NotNull
    public HashMap<String, Object> getDisplayInfo() {
        long recvedLsn = LSNUtil.INSTANCE.prePageLSN(this.slaveContext.getNextWritePage());
        long replyPage = LSNUtil.INSTANCE.prePageLSN(this.slaveContext.getNextReadPage());
        TimeStatQueue timeStatQueue = this.delayTimeStat;
        ArrayList<Pair<Long, Long>> timeStat = timeStatQueue == null ? null : timeStatQueue.getTimeStat();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Map map = data;
        String string = "recvedLsn";
        Pair pair = new Pair((Object)"\u5df2\u63a5\u6536\u9875LSN", (Object)recvedLsn);
        boolean bl = false;
        map.put(string, pair);
        map = data;
        string = "replyPage";
        pair = new Pair((Object)"\u5f53\u524d\u91cd\u505a\u9875LSN", (Object)replyPage);
        bl = false;
        map.put(string, pair);
        map = data;
        string = "timeStat";
        pair = new Pair((Object)"Redo\u91cd\u505a\u5ef6\u8fdf\u8ddf\u8e2a\u66f2\u7ebf", timeStat);
        bl = false;
        map.put(string, pair);
        return data;
    }
}

