/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.replication.LSNContext;
import kd.bos.olapServer.replication.LSNUtil;
import kd.bos.olapServer.replication.RedoFile;
import kd.bos.olapServer.replication.RedoPage;
import kd.bos.olapServer.replication.WritedRedoFile;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/replication/WritedRedoFile;", "Lkd/bos/olapServer/replication/RedoFile;", "path", "", "Lkd/bos/olapServer/common/string;", "context", "Lkd/bos/olapServer/replication/LSNContext;", "keepSegments", "", "Lkd/bos/olapServer/common/int;", "(Ljava/lang/String;Lkd/bos/olapServer/replication/LSNContext;I)V", "checkInitLSN", "", "clearPast", "deleteLast", "writePage", "", "Lkd/bos/olapServer/common/bool;", "page", "Lkd/bos/olapServer/replication/RedoPage;", "bos-olap-core"})
public final class WritedRedoFile
extends RedoFile {
    @NotNull
    private final String path;
    @NotNull
    private final LSNContext context;
    private final int keepSegments;

    public WritedRedoFile(@NotNull String path, @NotNull LSNContext context, int keepSegments) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        super(context.getNextWritePage(), path, openOptionArray);
        this.path = path;
        this.context = context;
        this.keepSegments = keepSegments;
        this.checkInitLSN();
        this.clearPast();
    }

    public final boolean writePage(@NotNull RedoPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        int dataSize = page.getBuffer().position();
        page.getBuffer().flip();
        if (this.context.getNextWritePage() == this.getNextFileLsn()) {
            this.switchFile();
            this.deleteLast();
        }
        while (this.getFd().size() < LSNUtil.INSTANCE.getPageStartPosition(this.context.getNextWritePage())) {
            ByteBuffer tmpBuffer = page.getBuffer().duplicate();
            this.getFd().write(tmpBuffer, this.getFd().size());
        }
        int writeSize = this.getFd().write(page.getBuffer(), LSNUtil.INSTANCE.getPageStartPosition(this.context.getNextWritePage()));
        boolean bl = writeSize == dataSize;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return true;
    }

    private final void deleteLast() {
        if (this.keepSegments <= 0) {
            return;
        }
        long deleteFileLsn = LSNUtil.INSTANCE.prevFileLSN(this.context.getNextWritePage(), this.keepSegments);
        if (deleteFileLsn == -1L) {
            return;
        }
        String[] stringArray = new String[]{LSNUtil.INSTANCE.getFileName(deleteFileLsn)};
        File deleteFile = Paths.INSTANCE.get(this.path, stringArray).toFile();
        if (deleteFile.exists()) {
            deleteFile.delete();
        }
    }

    private final void clearPast() {
        if (this.keepSegments <= 0) {
            return;
        }
        long lastDeleteLsn = LSNUtil.INSTANCE.prevFileLSN(this.context.getNextWritePage(), this.keepSegments);
        if (lastDeleteLsn == -1L) {
            return;
        }
        boolean bl = lastDeleteLsn != LSNUtil.INSTANCE.fileLSN(this.context.getNextWritePage());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        int n = 0;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String lastDeleteFile = LSNUtil.INSTANCE.getFileName(lastDeleteLsn);
        File[] redoFiles = new File(this.path).listFiles();
        if (redoFiles != null) {
            for (File file : redoFiles) {
                if (file.getName().compareTo(lastDeleteFile) > 0) continue;
                file.delete();
            }
        }
    }

    public final void checkInitLSN() {
        Object element$iv2;
        String maxFileName = null;
        maxFileName = "00_0000_0000.redo";
        FileTreeWalk redoPathWalk = FilesKt.walk$default((File)new File(this.path), null, (int)1, null);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)redoPathWalk.maxDepth(1)), (Function1)checkInitLSN.1.INSTANCE), (Function1)checkInitLSN.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            File it = (File)element$iv2;
            boolean bl = false;
            if (it.getName().compareTo(maxFileName) <= 0) continue;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            maxFileName = string;
        }
        String lastFileName = StringsKt.substringBefore$default((String)maxFileName, (char)'.', null, (int)2, null);
        element$iv2 = new String[]{maxFileName};
        long lastFileSize = Paths.INSTANCE.get(this.path, (String)element$iv2).toFile().length();
        long lastLSN = LSNUtil.INSTANCE.getLsnByFileName(lastFileName, lastFileSize);
        if (lastLSN > this.context.getNextWritePage()) {
            Object[] objectArray = Res.INSTANCE.getWritedRedoFileException_1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.WritedRedoFileException_1");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{lastLSN, this.context.getNextWritePage()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
    }
}

