/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.selects;

import kd.bos.olapServer.query.IRowIndexIterator;
import kd.bos.olapServer.selects.ConcurrentQueryJob;
import kd.bos.olapServer.selects.IQueryReader;
import kd.bos.olapServer.selects.ISelectFieldCollection;
import kd.bos.olapServer.selects.PartitionConcurrentQueryTask;
import kd.bos.olapServer.selects.PartitionQuerySession;
import kd.bos.olapServer.selects.PartitionSelectFieldCollection;
import kd.bos.olapServer.selects.SelectFieldCollectionBuilder;
import kd.bos.olapServer.storages.PartitionCubeWorkspace;
import kd.bos.olapServer.storages.pools.TaskResourceContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00060\fj\u0002`\u0016H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/selects/PartitionQueryReader;", "Lkd/bos/olapServer/selects/IQueryReader;", "session", "Lkd/bos/olapServer/selects/PartitionQuerySession;", "(Lkd/bos/olapServer/selects/PartitionQuerySession;)V", "_currentPartitionJob", "Lkd/bos/olapServer/selects/ConcurrentQueryJob;", "Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "Lkd/bos/olapServer/selects/PartitionConcurrentQueryTask;", "_currentQueryIterator", "Lkd/bos/olapServer/query/IRowIndexIterator;", "_isFirstLoopPartition", "", "_selectFields", "Lkd/bos/olapServer/selects/PartitionSelectFieldCollection;", "selectFields", "Lkd/bos/olapServer/selects/ISelectFieldCollection;", "getSelectFields", "()Lkd/bos/olapServer/selects/ISelectFieldCollection;", "close", "", "next", "Lkd/bos/olapServer/common/bool;", "nextPartitionCubeWorkspace", "bos-olap-core"})
public final class PartitionQueryReader
implements IQueryReader {
    @NotNull
    private final PartitionQuerySession session;
    @Nullable
    private ConcurrentQueryJob<PartitionCubeWorkspace, PartitionConcurrentQueryTask> _currentPartitionJob;
    @NotNull
    private IRowIndexIterator _currentQueryIterator;
    @NotNull
    private final PartitionSelectFieldCollection _selectFields;
    private boolean _isFirstLoopPartition;

    public PartitionQueryReader(@NotNull PartitionQuerySession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this._currentQueryIterator = IRowIndexIterator.Empty.INSTANCE;
        this._selectFields = new PartitionSelectFieldCollection(this.session.getQuery());
        this._isFirstLoopPartition = true;
    }

    @Override
    @NotNull
    public ISelectFieldCollection getSelectFields() {
        return this._selectFields;
    }

    @Override
    public boolean next() {
        return this._currentQueryIterator.next() || this.nextPartitionCubeWorkspace();
    }

    private final boolean nextPartitionCubeWorkspace() {
        TaskResourceContainer res;
        ConcurrentQueryJob nextJob;
        PartitionConcurrentQueryTask nextCubePartition;
        IRowIndexIterator currentItr;
        do {
            int n;
            ConcurrentQueryJob<PartitionCubeWorkspace, PartitionConcurrentQueryTask> currentJob;
            if ((currentJob = this._currentPartitionJob) != null) {
                currentJob.exit();
                n = currentJob.getTask().getIndex();
            } else {
                n = -1;
            }
            int currentPartitionIndex = n;
            nextCubePartition = null;
            if (this._isFirstLoopPartition && (nextCubePartition = this.session.getNextCubeQueryPartitionOnFirstLoop$bos_olap_core(currentPartitionIndex)) == null) {
                this._isFirstLoopPartition = false;
                this._currentPartitionJob = null;
                currentPartitionIndex = -1;
            }
            if (nextCubePartition == null) {
                PartitionConcurrentQueryTask partitionConcurrentQueryTask = this.session.getNextCubeQueryPartition$bos_olap_core(currentPartitionIndex);
                if (partitionConcurrentQueryTask == null) {
                    return false;
                }
                nextCubePartition = partitionConcurrentQueryTask;
            }
            nextJob = new ConcurrentQueryJob(nextCubePartition);
            this._currentPartitionJob = nextJob;
            currentItr = null;
            res = nextJob.getCurrentThreadResourceContainer();
        } while (!(currentItr = this.session.isParallel() ? nextCubePartition.getQuerySession().buildForParallel(nextJob) : nextCubePartition.getQuerySession().build(res)).next());
        SelectFieldCollectionBuilder fieldsBuilder = new SelectFieldCollectionBuilder(res, nextCubePartition.getQuerySession().getWorkspace().getRowCount(), currentItr);
        this._selectFields.updateProxyField((PartitionCubeWorkspace)nextCubePartition.getCubeWorkspace(), fieldsBuilder, nextCubePartition.getQuerySession());
        this._currentQueryIterator = currentItr;
        return true;
    }

    @Override
    public void close() {
        ConcurrentQueryJob<PartitionCubeWorkspace, PartitionConcurrentQueryTask> concurrentQueryJob = this._currentPartitionJob;
        if (concurrentQueryJob != null) {
            concurrentQueryJob.close();
        }
    }
}

