/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.selects;

import java.util.Collection;
import kd.bos.olapServer.collections.IImmutableListBoolean;
import kd.bos.olapServer.collections.ImmutableListBooleanByBitmap;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.IRowIndexIterator;
import kd.bos.olapServer.query.QuerySession;
import kd.bos.olapServer.selects.DimensionSelectField;
import kd.bos.olapServer.selects.DimensionSelectFieldMore;
import kd.bos.olapServer.selects.DimensionSelectFieldOne;
import kd.bos.olapServer.selects.EmptyDimensionSelectField;
import kd.bos.olapServer.selects.IDimensionSelectField;
import kd.bos.olapServer.selects.IMeasureSelectField;
import kd.bos.olapServer.selects.MeasureSelectField;
import kd.bos.olapServer.selects.RowIndexSelectField;
import kd.bos.olapServer.storages.pools.TaskResourceContainer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002J\u000e\u0010\f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer/selects/SelectFieldCollectionBuilder;", "", "resourceContainer", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "rowCount", "", "Lkd/bos/olapServer/common/int;", "rowIndexItr", "Lkd/bos/olapServer/query/IRowIndexIterator;", "(Lkd/bos/olapServer/storages/pools/TaskResourceContainer;ILkd/bos/olapServer/query/IRowIndexIterator;)V", "buildRowIndexSelectField", "Lkd/bos/olapServer/selects/RowIndexSelectField;", "buildSelectField", "Lkd/bos/olapServer/selects/IDimensionSelectField;", "selectDim", "Lkd/bos/olapServer/metadata/Dimension;", "querySession", "Lkd/bos/olapServer/query/QuerySession;", "members", "", "Lkd/bos/olapServer/metadata/Member;", "Lkd/bos/olapServer/selects/IMeasureSelectField;", "selectMeasure", "Lkd/bos/olapServer/metadata/Measure;", "createSelectDimension", "bos-olap-core"})
public final class SelectFieldCollectionBuilder {
    @NotNull
    private final TaskResourceContainer resourceContainer;
    private final int rowCount;
    @NotNull
    private final IRowIndexIterator rowIndexItr;

    public SelectFieldCollectionBuilder(@NotNull TaskResourceContainer resourceContainer, int rowCount, @NotNull IRowIndexIterator rowIndexItr) {
        Intrinsics.checkNotNullParameter((Object)resourceContainer, (String)"resourceContainer");
        Intrinsics.checkNotNullParameter((Object)rowIndexItr, (String)"rowIndexItr");
        this.resourceContainer = resourceContainer;
        this.rowCount = rowCount;
        this.rowIndexItr = rowIndexItr;
    }

    @NotNull
    public final IDimensionSelectField buildSelectField(@NotNull Dimension selectDim, @NotNull QuerySession querySession) {
        Intrinsics.checkNotNullParameter((Object)selectDim, (String)"selectDim");
        Intrinsics.checkNotNullParameter((Object)querySession, (String)"querySession");
        return this.buildSelectField(selectDim, querySession.getDimensionFilterMembers(selectDim));
    }

    private final IDimensionSelectField buildSelectField(Dimension selectDim, Collection<? extends Member> members2) {
        IDimensionSelectField iDimensionSelectField;
        if (members2 != null) {
            int n = members2.size();
            if (n == 0) {
                iDimensionSelectField = new EmptyDimensionSelectField(selectDim);
            } else if (n == 1) {
                iDimensionSelectField = new DimensionSelectFieldOne(selectDim, (Member)CollectionsKt.first((Iterable)members2));
            } else {
                boolean bl = 2 <= n ? n <= 5 : false;
                if (bl) {
                    Collection<? extends Member> $this$toTypedArray$iv = members2;
                    boolean $i$f$toTypedArray = false;
                    Collection<? extends Member> thisCollection$iv = $this$toTypedArray$iv;
                    Member[] memberArray = thisCollection$iv.toArray(new Member[0]);
                    if (memberArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Member[] memberArray2 = memberArray;
                    int n2 = 0;
                    int n3 = members2.size();
                    IImmutableListBoolean[] iImmutableListBooleanArray = new IImmutableListBoolean[n3];
                    Dimension dimension = selectDim;
                    while (n2 < n3) {
                        int n4 = n2++;
                        iImmutableListBooleanArray[n4] = new ImmutableListBooleanByBitmap(this.resourceContainer.getQueryBitmap(selectDim, memberArray2[n4]), this.rowCount);
                    }
                    IRowIndexIterator iRowIndexIterator = this.rowIndexItr;
                    Member[] memberArray3 = memberArray2;
                    IImmutableListBoolean[] iImmutableListBooleanArray2 = iImmutableListBooleanArray;
                    Dimension dimension2 = dimension;
                    iDimensionSelectField = new DimensionSelectFieldMore(dimension2, iImmutableListBooleanArray2, memberArray3, iRowIndexIterator);
                } else {
                    iDimensionSelectField = this.createSelectDimension(selectDim);
                }
            }
        } else if (selectDim.getMembers().getCount() == 1) {
            int n = 0;
            int n5 = selectDim.getMembers().getCount();
            Member[] memberArray = new Member[n5];
            while (n < n5) {
                int n6 = n++;
                memberArray[n6] = (Member)selectDim.getMembers().get(n6);
            }
            Member[] allMembers = memberArray;
            iDimensionSelectField = new DimensionSelectFieldOne(selectDim, allMembers[0]);
        } else {
            iDimensionSelectField = this.createSelectDimension(selectDim);
        }
        return iDimensionSelectField;
    }

    private final IDimensionSelectField createSelectDimension(Dimension selectDim) {
        return new DimensionSelectField(selectDim.getName(), selectDim, this.resourceContainer.getDimensionList(selectDim), this.rowIndexItr);
    }

    @NotNull
    public final IMeasureSelectField buildSelectField(@NotNull Measure selectMeasure) {
        Intrinsics.checkNotNullParameter((Object)selectMeasure, (String)"selectMeasure");
        return new MeasureSelectField(selectMeasure.getName(), this.resourceContainer.getMeasureList(selectMeasure), this.rowIndexItr);
    }

    @NotNull
    public final RowIndexSelectField buildRowIndexSelectField() {
        return new RowIndexSelectField(this.rowIndexItr);
    }
}

