/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer.backup.BackupCommandExecutor;
import kd.bos.olapServer.backup.RecoveryCommandExecutor;
import kd.bos.olapServer.common.ImmutablePropertyBag;
import kd.bos.olapServer.common.OlapContext;
import kd.bos.olapServer.computingEngine.ComputingCommandExecutor;
import kd.bos.olapServer.dataSources.BackupCommandInfo;
import kd.bos.olapServer.dataSources.ComputingCommandInfo;
import kd.bos.olapServer.dataSources.FunctionCommandInfo;
import kd.bos.olapServer.dataSources.MetadataCommandInfo;
import kd.bos.olapServer.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer.dataSources.SaveCommandInfo;
import kd.bos.olapServer.dataSources.SelectCommandInfo;
import kd.bos.olapServer.function.FunctionCommandExecutor;
import kd.bos.olapServer.function.FunctionDefine;
import kd.bos.olapServer.function.FunctionInfo;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.metadata.MetadataCommandExecutor;
import kd.bos.olapServer.metadata.OlapMetadata;
import kd.bos.olapServer.metadata.builds.CubeEntry;
import kd.bos.olapServer.monitorReports.OlapHealthReportContainer;
import kd.bos.olapServer.performanceStatistics.CommandContext;
import kd.bos.olapServer.performanceStatistics.CommandExecuteState;
import kd.bos.olapServer.query.SelectCommandExecutor;
import kd.bos.olapServer.replication.BackupType;
import kd.bos.olapServer.replication.BackupUtil;
import kd.bos.olapServer.replication.ReplicationContext;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.replication.ReplicationStatus;
import kd.bos.olapServer.security.AccessStrategyCollection;
import kd.bos.olapServer.security.OlapActions;
import kd.bos.olapServer.server.OlapServer;
import kd.bos.olapServer.server.OlapSession;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.storages.SaveCommandExecutor;
import kd.bos.olapServer.storages.plugins.OlapWorkspacePlugin;
import kd.bos.olapServer.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer.storages.plugins.PluginCollection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u001aJ\b\u0010%\u001a\u00020\u001aH\u0016J\u0016\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001eJ>\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002H*0.H\u0082\b\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307J\u0016\u00108\u001a\u00060\u0003j\u0002`92\n\u0010:\u001a\u00060\u0003j\u0002`9J&\u0010;\u001a\u0016\u0012\b\u0012\u00060\u0003j\u0002`9\u0012\b\u0012\u00060\u0003j\u0002`90<2\n\u0010:\u001a\u00060\u0003j\u0002`9J\u0010\u0010=\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`907J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?J\u0012\u0010A\u001a\u00020B2\n\u0010C\u001a\u00060\u0003j\u0002`9J8\u0010D\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0003j\u0002`9\u0012\b\u0012\u00060\u0003j\u0002`90<0E2\n\u0010:\u001a\u00060\u0003j\u0002`92\n\u0010F\u001a\u00060\u0003j\u0002`9J\"\u0010G\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020I0Hj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020I`JJ\u0006\u0010K\u001a\u00020LJ\u0016\u0010M\u001a\u00060\bj\u0002`\t2\n\u0010:\u001a\u00060\u0003j\u0002`9J\u0016\u0010N\u001a\u00060\bj\u0002`\t2\n\u0010:\u001a\u00060\u0003j\u0002`9J\u0016\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020RJ\u0016\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020U2\u0006\u0010\u001d\u001a\u00020\u001eJ2\u0010S\u001a\u00020\u001a2\u0006\u0010T\u001a\u00020U2\u0006\u0010\u001d\u001a\u00020\u001e2\u001a\u0010V\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010I0X\u0012\u0004\u0012\u00020\u001a0WJ\u001e\u0010Y\u001a\u00020\u001a2\u0006\u0010T\u001a\u00020U2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010Z\u001a\u00020 J\u001e\u0010[\u001a\u00020\u001a2\u0006\u0010\\\u001a\u00020]2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010^\u001a\u00020_J\u0012\u0010`\u001a\u00020\u001a2\n\u0010a\u001a\u00060\u0003j\u0002`9J\u0006\u0010b\u001a\u00020\u001aJ\u0016\u0010c\u001a\u00020\u001a2\u0006\u0010d\u001a\u00020e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010f\u001a\u00020\u001a2\b\u0010g\u001a\u0004\u0018\u00010/2\u0006\u0010-\u001a\u00020,H\u0002J\u001e\u0010h\u001a\u00020\u001a2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\u0006\u0010\u001d\u001a\u00020\u001eJ,\u0010h\u001a\u00020\u001a2\u0006\u0010i\u001a\u00020j2\u0014\u0010m\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010I0X0n2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lkd/bos/olapServer/server/OlapServer;", "Ljava/io/Closeable;", "rootPath", "", "startGC", "", "Lkd/bos/olapServer/common/bool;", "gcTimePeriod", "", "Lkd/bos/olapServer/common/long;", "(Ljava/lang/String;ZJ)V", "healthReports", "Lkd/bos/olapServer/monitorReports/OlapHealthReportContainer;", "getHealthReports", "()Lkd/bos/olapServer/monitorReports/OlapHealthReportContainer;", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "getOlapWorkspace$bos_olap_core", "()Lkd/bos/olapServer/storages/OlapWorkspace;", "plugins", "Lkd/bos/olapServer/storages/plugins/PluginCollection;", "Lkd/bos/olapServer/storages/plugins/OlapWorkspacePlugin;", "Lkd/bos/olapServer/storages/plugins/OlapWorkspacePluginContext;", "getPlugins", "()Lkd/bos/olapServer/storages/plugins/PluginCollection;", "backup", "", "backupCommandInfo", "Lkd/bos/olapServer/dataSources/BackupCommandInfo;", "session", "Lkd/bos/olapServer/server/OlapSession;", "outputStream", "Ljava/io/OutputStream;", "backupOlap", "type", "Lkd/bos/olapServer/replication/BackupType;", "checkExecuteByFreeSpace", "close", "computing", "computingCommand", "Lkd/bos/olapServer/dataSources/ComputingCommandInfo;", "executeCommand", "R", "actionCode", "Lkd/bos/olapServer/security/OlapActions;", "action", "Lkotlin/Function2;", "Lkd/bos/olapServer/storages/CubeWorkspace;", "Lkd/bos/olapServer/performanceStatistics/CommandContext;", "(Lkd/bos/olapServer/server/OlapSession;Lkd/bos/olapServer/security/OlapActions;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "executeFunction", "Lkd/bos/olapServer/common/ImmutablePropertyBag;", "functionCommandInfo", "Lkd/bos/olapServer/dataSources/FunctionCommandInfo;", "getBackupRecords", "", "getCubeMetadata", "Lkd/bos/olapServer/common/string;", "cubeName", "getCubeProperties", "", "getCubes", "getFunctionDefines", "", "Lkd/bos/olapServer/function/FunctionDefine;", "getFunctionInfo", "Lkd/bos/olapServer/function/FunctionInfo;", "name", "getMembers", "Lkotlin/sequences/Sequence;", "dimName", "getReplicationDisplayInfo", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getReplicationStatus", "Lkd/bos/olapServer/replication/ReplicationStatus;", "getRowCount", "getTransactionVersion", "initReplication", "confPath", "context", "Lkd/bos/olapServer/replication/ReplicationContext;", "query", "selectCommand", "Lkd/bos/olapServer/dataSources/SelectCommandInfo;", "consumer", "Lkotlin/Function1;", "", "queryStream", "outStream", "recovery", "command", "Lkd/bos/olapServer/dataSources/RecoveryCommandInfo;", "webInputStream", "Ljava/io/InputStream;", "recoveryOlap", "backupPath", "switchToMaster", "updateMetadata", "metadataCommand", "Lkd/bos/olapServer/dataSources/MetadataCommandInfo;", "verify", "cubeWorkspace", "write", "saveInfo", "Lkd/bos/olapServer/dataSources/SaveCommandInfo;", "reader", "Ljava/io/BufferedReader;", "dataValuesList", "", "bos-olap-core"})
public final class OlapServer
implements Closeable {
    @NotNull
    private final String rootPath;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final OlapHealthReportContainer healthReports;

    /*
     * WARNING - void declaration
     */
    public OlapServer(@NotNull String rootPath, boolean startGC, long gcTimePeriod) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.rootPath = rootPath;
        OlapWorkspace olapWorkspace = new OlapWorkspace(OlapMetadata.Companion.ReadFrom(this.rootPath), this.rootPath);
        boolean bl = false;
        boolean bl2 = false;
        OlapWorkspace olapWorkspace2 = olapWorkspace;
        OlapServer olapServer = this;
        boolean bl3 = false;
        if (startGC) {
            void $this$olapWorkspace_u24lambda_u2d0;
            $this$olapWorkspace_u24lambda_u2d0.startGC(gcTimePeriod);
        }
        Unit unit = Unit.INSTANCE;
        olapServer.olapWorkspace = olapWorkspace;
        this.healthReports = new OlapHealthReportContainer(this.olapWorkspace);
    }

    public /* synthetic */ OlapServer(String string, boolean bl, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        this(string, bl, l);
    }

    @NotNull
    public final OlapWorkspace getOlapWorkspace$bos_olap_core() {
        return this.olapWorkspace;
    }

    @NotNull
    public final OlapHealthReportContainer getHealthReports() {
        return this.healthReports;
    }

    private final void verify(CubeWorkspace cubeWorkspace, OlapActions action) {
        AccessStrategyCollection accessStrategyCollection;
        this.olapWorkspace.getAccessStrategies().verify(action);
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        if (cubeWorkspace2 != null && (accessStrategyCollection = cubeWorkspace2.getAccessStrategies()) != null) {
            accessStrategyCollection.verify(action);
        }
    }

    public final void initReplication(@NotNull String confPath, @NotNull ReplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)confPath, (String)"confPath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReplicationManager.INSTANCE.init(this.olapWorkspace, confPath, context);
    }

    public final void backup(@NotNull BackupCommandInfo backupCommandInfo, @NotNull OlapSession session, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)backupCommandInfo, (String)"backupCommandInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        String cubeName = session.getCubeName();
        CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(cubeName);
        this.verify(cubeWorkspace, OlapActions.ActionCubeBackup);
        BackupCommandExecutor executor = new BackupCommandExecutor(backupCommandInfo, cubeWorkspace, outputStream, this.rootPath);
        executor.run();
    }

    public final void recovery(@NotNull RecoveryCommandInfo command, @NotNull OlapSession session, @NotNull InputStream webInputStream) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)webInputStream, (String)"webInputStream");
        String cubeName = command.getCubeName();
        this.verify(null, OlapActions.ActionCubeRecovery);
        RecoveryCommandExecutor executor = new RecoveryCommandExecutor(this.olapWorkspace, command, cubeName, this.rootPath, webInputStream);
        executor.run();
    }

    public final void backupOlap(@NotNull BackupType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.verify(null, OlapActions.ActionTotalBackup);
        ReplicationManager.INSTANCE.backupOlap(type);
    }

    public final void recoveryOlap(@NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        this.verify(null, OlapActions.ActionTotalRecovery);
        ReplicationManager.INSTANCE.recoveryOlap(backupPath);
    }

    @NotNull
    public final List<String> getBackupRecords() {
        String backupPath = ReplicationManager.INSTANCE.getBackupPath();
        CharSequence charSequence = backupPath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        BackupUtil backupUtil = new BackupUtil(backupPath, false);
        return BackupUtil.getBackupRecords$default(backupUtil, 0, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String query(@NotNull SelectCommandInfo selectCommand, @NotNull OlapSession session) {
        String string;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)selectCommand, (String)"selectCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        OlapServer olapServer = this;
        OlapActions actionCode$iv = OlapActions.ActionQuery;
        boolean $i$f$executeCommand = false;
        String cubeName$iv = session.getCubeName();
        CubeWorkspace cubeWorkspace$iv = this_$iv.getOlapWorkspace$bos_olap_core().getCubeWorkspace(cubeName$iv);
        ((OlapServer)this_$iv).verify(cubeWorkspace$iv, actionCode$iv);
        CommandContext context$iv = new CommandContext();
        session.setContext(context$iv);
        OlapContext.Companion this_$iv$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            this_$iv$iv.push(context$iv);
            boolean bl = false;
            CommandContext commandContext = context$iv;
            CubeWorkspace cubeWorkspace = cubeWorkspace$iv;
            boolean bl2 = false;
            string = (String)cubeWorkspace.getMetadataLock().enterRead((Function0)new Function0<String>(selectCommand, this, cubeWorkspace){
                final /* synthetic */ SelectCommandInfo $selectCommand;
                final /* synthetic */ OlapServer this$0;
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                {
                    this.$selectCommand = $selectCommand;
                    this.this$0 = $receiver;
                    this.$cubeWorkspace = $cubeWorkspace;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final String invoke() {
                    String string;
                    SelectCommandExecutor executor = new SelectCommandExecutor(this.$selectCommand, this.this$0.getOlapWorkspace$bos_olap_core(), this.$cubeWorkspace);
                    ByteArrayOutputStream outputSteam = new ByteArrayOutputStream();
                    Closeable closeable = outputSteam;
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                        boolean bl3 = false;
                        executor.buildResult(outputSteam);
                        String string2 = outputSteam.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputSteam.toString()");
                        string = string2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return string;
                }
            });
        }
        finally {
            boolean bl = false;
            context$iv.setEndState();
            this_$iv$iv.pop(context$iv);
        }
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"executeCommand(session, OlapActions.ActionQuery) { cubeWorkspace, _ ->\n            cubeWorkspace.metadataLock.enterRead {\n                val executor = SelectCommandExecutor(selectCommand, olapWorkspace, cubeWorkspace)\n                val outputSteam = ByteArrayOutputStream()\n                outputSteam.use {\n                    executor.buildResult(outputSteam)\n                    outputSteam.toString()\n                }\n            }\n        }");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void queryStream(@NotNull SelectCommandInfo selectCommand, @NotNull OlapSession session, @NotNull OutputStream outStream) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)selectCommand, (String)"selectCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outStream, (String)"outStream");
        OlapServer olapServer = this;
        OlapActions actionCode$iv = OlapActions.ActionQuery;
        boolean $i$f$executeCommand = false;
        String cubeName$iv = session.getCubeName();
        CubeWorkspace cubeWorkspace$iv = this_$iv.getOlapWorkspace$bos_olap_core().getCubeWorkspace(cubeName$iv);
        ((OlapServer)this_$iv).verify(cubeWorkspace$iv, actionCode$iv);
        CommandContext context$iv = new CommandContext();
        session.setContext(context$iv);
        OlapContext.Companion this_$iv$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            this_$iv$iv.push(context$iv);
            boolean bl = false;
            CommandContext commandContext = context$iv;
            CubeWorkspace cubeWorkspace = cubeWorkspace$iv;
            boolean bl2 = false;
            cubeWorkspace.getMetadataLock().enterRead((Function0)new Function0<Unit>(selectCommand, this, cubeWorkspace, outStream){
                final /* synthetic */ SelectCommandInfo $selectCommand;
                final /* synthetic */ OlapServer this$0;
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                final /* synthetic */ OutputStream $outStream;
                {
                    this.$selectCommand = $selectCommand;
                    this.this$0 = $receiver;
                    this.$cubeWorkspace = $cubeWorkspace;
                    this.$outStream = $outStream;
                    super(0);
                }

                public final void invoke() {
                    SelectCommandExecutor executor = new SelectCommandExecutor(this.$selectCommand, this.this$0.getOlapWorkspace$bos_olap_core(), this.$cubeWorkspace);
                    executor.buildResult(this.$outStream);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean bl = false;
            context$iv.setEndState();
            this_$iv$iv.pop(context$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void query(@NotNull SelectCommandInfo selectCommand, @NotNull OlapSession session, @NotNull Function1<? super Object[], Unit> consumer) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)selectCommand, (String)"selectCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        OlapServer olapServer = this;
        OlapActions actionCode$iv = OlapActions.ActionQuery;
        boolean $i$f$executeCommand = false;
        String cubeName$iv = session.getCubeName();
        CubeWorkspace cubeWorkspace$iv = this_$iv.getOlapWorkspace$bos_olap_core().getCubeWorkspace(cubeName$iv);
        ((OlapServer)this_$iv).verify(cubeWorkspace$iv, actionCode$iv);
        CommandContext context$iv = new CommandContext();
        session.setContext(context$iv);
        OlapContext.Companion this_$iv$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            this_$iv$iv.push(context$iv);
            boolean bl = false;
            CommandContext commandContext = context$iv;
            CubeWorkspace cubeWorkspace = cubeWorkspace$iv;
            boolean bl2 = false;
            cubeWorkspace.getMetadataLock().enterRead((Function0)new Function0<Unit>(selectCommand, this, cubeWorkspace, consumer){
                final /* synthetic */ SelectCommandInfo $selectCommand;
                final /* synthetic */ OlapServer this$0;
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                final /* synthetic */ Function1<Object[], Unit> $consumer;
                {
                    this.$selectCommand = $selectCommand;
                    this.this$0 = $receiver;
                    this.$cubeWorkspace = $cubeWorkspace;
                    this.$consumer = $consumer;
                    super(0);
                }

                public final void invoke() {
                    SelectCommandExecutor executor = new SelectCommandExecutor(this.$selectCommand, this.this$0.getOlapWorkspace$bos_olap_core(), this.$cubeWorkspace);
                    executor.buildResult(this.$consumer);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean bl = false;
            context$iv.setEndState();
            this_$iv$iv.pop(context$iv);
        }
    }

    @NotNull
    public final ImmutablePropertyBag executeFunction(@NotNull FunctionCommandInfo functionCommandInfo, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)functionCommandInfo, (String)"functionCommandInfo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String cubeName = session.getCubeName();
        CubeWorkspace cubeWorkspace = null;
        CharSequence charSequence = cubeName;
        boolean bl = false;
        if (charSequence.length() > 0) {
            cubeWorkspace = this.olapWorkspace.getCubeWorkspace(cubeName);
        }
        FunctionCommandExecutor executor = new FunctionCommandExecutor(functionCommandInfo, this.olapWorkspace, cubeWorkspace);
        return executor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull SaveCommandInfo saveInfo, @NotNull BufferedReader reader, @NotNull OlapSession session) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)saveInfo, (String)"saveInfo");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        OlapServer olapServer = this;
        OlapActions actionCode$iv = OlapActions.ActionWrite;
        boolean $i$f$executeCommand = false;
        String cubeName$iv = session.getCubeName();
        CubeWorkspace cubeWorkspace$iv = this_$iv.getOlapWorkspace$bos_olap_core().getCubeWorkspace(cubeName$iv);
        ((OlapServer)this_$iv).verify(cubeWorkspace$iv, actionCode$iv);
        CommandContext context$iv = new CommandContext();
        session.setContext(context$iv);
        OlapContext.Companion this_$iv$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            void context;
            this_$iv$iv.push(context$iv);
            boolean bl = false;
            CommandContext commandContext = context$iv;
            CubeWorkspace cubeWorkspace = cubeWorkspace$iv;
            boolean bl2 = false;
            context.setTimeState(CommandExecuteState.Companion.getWaitingQueryLock());
            cubeWorkspace.getMetadataLock().enterRead((Function0)new Function0<Unit>((CommandContext)context, cubeWorkspace, saveInfo, reader){
                final /* synthetic */ CommandContext $context;
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                final /* synthetic */ SaveCommandInfo $saveInfo;
                final /* synthetic */ BufferedReader $reader;
                {
                    this.$context = $context;
                    this.$cubeWorkspace = $cubeWorkspace;
                    this.$saveInfo = $saveInfo;
                    this.$reader = $reader;
                    super(0);
                }

                public final void invoke() {
                    this.$context.setTimeState(CommandExecuteState.Companion.getEnterQueryLock());
                    SaveCommandExecutor executor = new SaveCommandExecutor(this.$cubeWorkspace, this.$saveInfo, this.$reader);
                    executor.write();
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean bl = false;
            context$iv.setEndState();
            this_$iv$iv.pop(context$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull SaveCommandInfo saveInfo, @NotNull Iterator<Object[]> dataValuesList, @NotNull OlapSession session) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)saveInfo, (String)"saveInfo");
        Intrinsics.checkNotNullParameter(dataValuesList, (String)"dataValuesList");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        OlapServer olapServer = this;
        OlapActions actionCode$iv = OlapActions.ActionWrite;
        boolean $i$f$executeCommand = false;
        String cubeName$iv = session.getCubeName();
        CubeWorkspace cubeWorkspace$iv = this_$iv.getOlapWorkspace$bos_olap_core().getCubeWorkspace(cubeName$iv);
        ((OlapServer)this_$iv).verify(cubeWorkspace$iv, actionCode$iv);
        CommandContext context$iv = new CommandContext();
        session.setContext(context$iv);
        OlapContext.Companion this_$iv$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            void context;
            this_$iv$iv.push(context$iv);
            boolean bl = false;
            CommandContext commandContext = context$iv;
            CubeWorkspace cubeWorkspace = cubeWorkspace$iv;
            boolean bl2 = false;
            context.setTimeState(CommandExecuteState.Companion.getWaitingQueryLock());
            cubeWorkspace.getMetadataLock().enterRead((Function0)new Function0<Unit>((CommandContext)context, cubeWorkspace, saveInfo, dataValuesList){
                final /* synthetic */ CommandContext $context;
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                final /* synthetic */ SaveCommandInfo $saveInfo;
                final /* synthetic */ Iterator<Object[]> $dataValuesList;
                {
                    this.$context = $context;
                    this.$cubeWorkspace = $cubeWorkspace;
                    this.$saveInfo = $saveInfo;
                    this.$dataValuesList = $dataValuesList;
                    super(0);
                }

                public final void invoke() {
                    this.$context.setTimeState(CommandExecuteState.Companion.getEnterQueryLock());
                    SaveCommandExecutor executor = new SaveCommandExecutor(this.$cubeWorkspace, this.$saveInfo, this.$dataValuesList);
                    executor.write();
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean bl = false;
            context$iv.setEndState();
            this_$iv$iv.pop(context$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void computing(@NotNull ComputingCommandInfo computingCommand, @NotNull OlapSession session) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)computingCommand, (String)"computingCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        OlapServer olapServer = this;
        OlapActions actionCode$iv = OlapActions.ActionCompute;
        boolean $i$f$executeCommand = false;
        String cubeName$iv = session.getCubeName();
        CubeWorkspace cubeWorkspace$iv = this_$iv.getOlapWorkspace$bos_olap_core().getCubeWorkspace(cubeName$iv);
        ((OlapServer)this_$iv).verify(cubeWorkspace$iv, actionCode$iv);
        CommandContext context$iv = new CommandContext();
        session.setContext(context$iv);
        OlapContext.Companion this_$iv$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            this_$iv$iv.push(context$iv);
            boolean bl = false;
            CommandContext commandContext = context$iv;
            CubeWorkspace cubeWorkspace = cubeWorkspace$iv;
            boolean bl2 = false;
            cubeWorkspace.getMetadataLock().enterRead((Function0)new Function0<Unit>(computingCommand, this, cubeWorkspace){
                final /* synthetic */ ComputingCommandInfo $computingCommand;
                final /* synthetic */ OlapServer this$0;
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                {
                    this.$computingCommand = $computingCommand;
                    this.this$0 = $receiver;
                    this.$cubeWorkspace = $cubeWorkspace;
                    super(0);
                }

                public final void invoke() {
                    ComputingCommandExecutor executor = new ComputingCommandExecutor(this.$computingCommand, this.this$0.getOlapWorkspace$bos_olap_core(), this.$cubeWorkspace);
                    executor.run();
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean bl = false;
            context$iv.setEndState();
            this_$iv$iv.pop(context$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R executeCommand(OlapSession session, OlapActions actionCode, Function2<? super CubeWorkspace, ? super CommandContext, ? extends R> action) {
        Object object;
        boolean $i$f$executeCommand = false;
        String cubeName = session.getCubeName();
        CubeWorkspace cubeWorkspace = this.getOlapWorkspace$bos_olap_core().getCubeWorkspace(cubeName);
        this.verify(cubeWorkspace, actionCode);
        CommandContext context = new CommandContext();
        session.setContext(context);
        OlapContext.Companion this_$iv = OlapContext.Companion;
        boolean $i$f$withContext = false;
        try {
            this_$iv.push(context);
            boolean bl = false;
            object = action.invoke((Object)cubeWorkspace, (Object)context);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            boolean bl = false;
            context.setEndState();
            this_$iv.pop(context);
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    public final void updateMetadata(@NotNull MetadataCommandInfo metadataCommand, @NotNull OlapSession session) {
        Intrinsics.checkNotNullParameter((Object)metadataCommand, (String)"metadataCommand");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String cubeName = session.getCubeName();
        this.verify(this.olapWorkspace.tryGet(cubeName), OlapActions.ActionMetadataUpdate);
        CommandContext context = new CommandContext();
        session.setContext(context);
        MetadataCommandExecutor executor = new MetadataCommandExecutor(metadataCommand, this.olapWorkspace, cubeName, context);
        executor.run();
        context.setEndState();
    }

    @NotNull
    public final PluginCollection<OlapWorkspacePlugin, OlapWorkspacePluginContext> getPlugins() {
        return this.olapWorkspace.getPlugins();
    }

    @Override
    public void close() {
        ReplicationManager.INSTANCE.close();
        this.olapWorkspace.close();
    }

    public final void switchToMaster() {
    }

    @NotNull
    public final ReplicationStatus getReplicationStatus() {
        return ReplicationManager.INSTANCE.getStatus();
    }

    @NotNull
    public final HashMap<String, Object> getReplicationDisplayInfo() {
        if (ReplicationManager.INSTANCE.getEnableMaster()) {
            return ReplicationManager.INSTANCE.getMaster().getDisplayInfo();
        }
        if (ReplicationManager.INSTANCE.getEnableSlave()) {
            return ReplicationManager.INSTANCE.getSlave().getDisplayInfo();
        }
        return new HashMap<String, Object>();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCubes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.olapWorkspace.getMetadata().getCubes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CubeEntry cubeEntry = (CubeEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getCubeMetadata(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        CubeWorkspace cubeWorkspace = this.olapWorkspace.tryGet(cubeName);
        if (cubeWorkspace == null) {
            return "";
        }
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        return cubeWorkspace2.getMetadata().toJsonV1();
    }

    @NotNull
    public final Sequence<Map<String, String>> getMembers(@NotNull String cubeName, @NotNull String dimName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)dimName, (String)"dimName");
        CubeWorkspace cubeWorkspace = this.olapWorkspace.tryGet(cubeName);
        if (cubeWorkspace == null) {
            return SequencesKt.sequenceOf((Object[])new Map[0]);
        }
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        MemberCollection members2 = ((Dimension)cubeWorkspace2.getMetadata().getDimensions().get(dimName)).getMembers();
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)members2), (Function1)getMembers.1.INSTANCE);
    }

    public final long getRowCount(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return this.olapWorkspace.getCubeWorkspace(cubeName).getRowCount();
    }

    public final long getTransactionVersion(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return this.olapWorkspace.getTransactionVersion(cubeName);
    }

    @NotNull
    public final Map<String, String> getCubeProperties(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        HashMap map = new HashMap();
        Map map2 = map;
        Object object = "name";
        boolean bl = false;
        map2.put(object, cubeName);
        CubeEntry cubeEntry = (CubeEntry)this.olapWorkspace.getMetadata().getCubes().tryGet(cubeName);
        if (cubeEntry != null) {
            Object object2 = cubeEntry.getProperties();
            boolean bl2 = false;
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                Object object3 = object2 = (Map.Entry)object.next();
                boolean bl3 = false;
                String property = (String)object3.getKey();
                Object object4 = object2;
                boolean bl4 = false;
                String value2 = (String)object4.getValue();
                object4 = map;
                bl4 = false;
                object4.put(property, value2);
            }
        }
        return map;
    }

    @NotNull
    public final FunctionInfo getFunctionInfo(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.olapWorkspace.getFunctions().getFunctionInfo(name2);
    }

    @NotNull
    public final Iterable<FunctionDefine> getFunctionDefines() {
        return this.olapWorkspace.getFunctions().getFunctionDefines();
    }

    public final void checkExecuteByFreeSpace() {
        this.olapWorkspace.checkExecuteByFreeSpace();
    }
}

