/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.Closeable;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.DefaultByteBufferProvider;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.storages.ChangeVersionManager;
import kd.bos.olapServer.storages.CubeDataLock;
import kd.bos.olapServer.storages.CubeDataStorage;
import kd.bos.olapServer.storages.CubeMetadataStorage;
import kd.bos.olapServer.storages.CubeResourcePool;
import kd.bos.olapServer.storages.ICubeMetadataLock;
import kd.bos.olapServer.storages.InputRowList;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\n\u0010)\u001a\u00060*j\u0002`+J\u000e\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "", "_metadata", "Lkd/bos/olapServer/metadata/Cube;", "path", "", "Lkd/bos/olapServer/common/string;", "(Lkd/bos/olapServer/metadata/Cube;Ljava/lang/String;)V", "Metadata", "getMetadata", "()Lkd/bos/olapServer/metadata/Cube;", "_changeVersionManager", "Lkd/bos/olapServer/storages/ChangeVersionManager;", "_dataStorage", "Lkd/bos/olapServer/storages/CubeDataStorage;", "_metadataStorage", "Lkd/bos/olapServer/storages/CubeMetadataStorage;", "_resourcePool", "Lkd/bos/olapServer/storages/CubeResourcePool;", "dataLock", "Lkd/bos/olapServer/storages/CubeDataLock;", "getDataLock", "()Lkd/bos/olapServer/storages/CubeDataLock;", "dataStorage", "getDataStorage", "()Lkd/bos/olapServer/storages/CubeDataStorage;", "metadataStorage", "getMetadataStorage", "()Lkd/bos/olapServer/storages/CubeMetadataStorage;", "resourcePool", "getResourcePool", "()Lkd/bos/olapServer/storages/CubeResourcePool;", "close", "", "createSelectorContext", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "gc", "metadataLock", "Lkd/bos/olapServer/storages/ICubeMetadataLock;", "getInputRowList", "Lkd/bos/olapServer/storages/InputRowList;", "getRowCount", "", "Lkd/bos/olapServer/common/int;", "onMetadataUpdated", "newMetadata", "bos-olap-core"})
public abstract class AbstractCubeWorkspace {
    @NotNull
    private volatile Cube _metadata;
    @NotNull
    private final String path;
    @NotNull
    private volatile CubeDataStorage _dataStorage;
    @NotNull
    private final CubeDataLock dataLock;
    @NotNull
    private final ChangeVersionManager _changeVersionManager;
    @NotNull
    private volatile CubeResourcePool _resourcePool;
    @NotNull
    private volatile CubeMetadataStorage _metadataStorage;

    public AbstractCubeWorkspace(@NotNull Cube _metadata, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)_metadata, (String)"_metadata");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this._metadata = _metadata;
        this.path = path;
        this._dataStorage = new CubeDataStorage(this._metadata, new DefaultByteBufferProvider(this.path), false);
        this.dataLock = new CubeDataLock();
        this._changeVersionManager = new ChangeVersionManager(0L, 1, null);
        this._resourcePool = new CubeResourcePool(this._dataStorage, this._changeVersionManager);
        this._metadataStorage = new CubeMetadataStorage(this.getResourcePool(), this.path, this._dataStorage);
    }

    @NotNull
    public final CubeDataStorage getDataStorage() {
        return this._dataStorage;
    }

    @NotNull
    public final CubeDataLock getDataLock() {
        return this.dataLock;
    }

    @NotNull
    public final CubeResourcePool getResourcePool() {
        return this._resourcePool;
    }

    @NotNull
    public final CubeMetadataStorage getMetadataStorage() {
        return this._metadataStorage;
    }

    @NotNull
    public final Cube getMetadata() {
        return this._metadata;
    }

    @NotNull
    public final InputRowList getInputRowList() {
        return this.getResourcePool().getInputRowList();
    }

    public final int getRowCount() {
        return this.getResourcePool().getRowCount();
    }

    public final void onMetadataUpdated(@NotNull Cube newMetadata) {
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        boolean bl = Intrinsics.areEqual((Object)newMetadata.getName(), (Object)this._metadata.getName());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._metadata = newMetadata;
        CubeDataStorage dataStorage = new CubeDataStorage(newMetadata, new DefaultByteBufferProvider(this.path), false);
        CubeResourcePool resourcePool = new CubeResourcePool(dataStorage, this._changeVersionManager);
        CubeMetadataStorage metadataStorage = new CubeMetadataStorage(resourcePool, this.path, dataStorage);
        this._resourcePool.close();
        this._changeVersionManager.updateChangeVersion();
        this._dataStorage = dataStorage;
        this._resourcePool = resourcePool;
        this._metadataStorage = metadataStorage;
    }

    public final void gc(@NotNull ICubeMetadataLock metadataLock) {
        Intrinsics.checkNotNullParameter((Object)metadataLock, (String)"metadataLock");
        this.getResourcePool().gc(metadataLock, this.dataLock);
    }

    @NotNull
    public final SelectorContext createSelectorContext() {
        return new SelectorContext(this.getResourcePool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Closeable closeable = this.dataLock.getWriteLock();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl3 = false;
            this.getResourcePool().close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

