/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.Closeable;
import kd.bos.olapServer.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer.collections.IMutableDictionaryObserver;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataEntities.IInputRow;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.dataEntities.IMeasureValuesKt;
import kd.bos.olapServer.storages.BasicCubeWorkspace;
import kd.bos.olapServer.storages.CubeDataLock;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.EmptyDimensionKeys;
import kd.bos.olapServer.storages.ICubeDataObserver;
import kd.bos.olapServer.storages.ICubeDataObserverContext;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.InputRowList;
import kd.bos.olapServer.storages.plugins.InputRowWriterCreatingEventArgs;
import kd.bos.olapServer.transactions.ITransaction;
import kd.bos.olapServer.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B5\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J$\u00106\u001a\u0002072\n\u00108\u001a\u00060\u0013j\u0002`\u00142\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u0005H\u0016J\u0018\u00106\u001a\u0002072\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u0005H\u0016J\u001c\u0010;\u001a\u00060<j\u0002`=2\u0006\u00109\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0005H\u0016J\b\u0010?\u001a\u000207H\u0016J\b\u0010@\u001a\u000207H\u0016J$\u0010A\u001a\u0002072\n\u0010B\u001a\u00060\u0013j\u0002`C2\u0006\u00109\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0005H\u0016J$\u0010D\u001a\u0002072\n\u0010E\u001a\u00060\u0013j\u0002`C2\u0006\u00109\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0005H\u0016J(\u0010F\u001a\u0002072\n\u00108\u001a\u00060\u0013j\u0002`\u00142\n\u0010G\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010:\u001a\u00020\u0005H\u0016J\u001c\u0010F\u001a\u0002072\n\u0010G\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010:\u001a\u00020\u0005H\u0016R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00060\u0013j\u0002`\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u00060\u0016j\u0002`\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\u00060\u0013j\u0002`\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010 R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0018\u0010+\u001a\u00060\u0013j\u0002`\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010 R\u001c\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\u00060\u0016j\u0002`\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010#R\u0018\u00101\u001a\u00060\u0016j\u0002`\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010#R\u000e\u00103\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00104\u001a\u00060\u0016j\u0002`\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010#\u00a8\u0006H"}, d2={"Lkd/bos/olapServer/storages/BasicInputRowWriter;", "Lkd/bos/olapServer/storages/IInputRowWriter;", "Lkd/bos/olapServer/storages/ICubeDataObserverContext;", "Lkd/bos/olapServer/collections/IMutableDictionaryObserver;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "realWorkspace", "Lkd/bos/olapServer/storages/BasicCubeWorkspace;", "_tran", "Lkd/bos/olapServer/transactions/ITransaction;", "strategy", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "dataLock", "Lkd/bos/olapServer/storages/CubeDataLock;", "(Lkd/bos/olapServer/storages/CubeWorkspace;Lkd/bos/olapServer/storages/BasicCubeWorkspace;Lkd/bos/olapServer/transactions/ITransaction;Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;Lkd/bos/olapServer/storages/CubeDataLock;)V", "_currentKey", "_index", "", "Lkd/bos/olapServer/common/int;", "_lockTime", "", "Lkd/bos/olapServer/common/long;", "_observer", "Lkd/bos/olapServer/storages/ICubeDataObserver;", "_writeLock", "Ljava/io/Closeable;", "creatingEventArgs", "Lkd/bos/olapServer/storages/plugins/InputRowWriterCreatingEventArgs;", "cubeId", "getCubeId", "()I", "globalIndex", "getGlobalIndex", "()J", "index", "getIndex", "inputRowList", "Lkd/bos/olapServer/storages/InputRowList;", "keyInPartition", "getKeyInPartition", "()Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "partitionId", "getPartitionId", "getStrategy", "()Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "tid", "getTid", "transactionId", "getTransactionId", "writeCount", "writeLockTime", "getWriteLockTime", "add", "", "partionId", "key", "values", "addOrUpdate", "", "Lkd/bos/olapServer/common/bool;", "value", "close", "force", "onAdded", "addIndex", "Lkd/bos/olapServer/common/idx;", "onUpdated", "updateIndex", "update", "rowIndex", "bos-olap-core"})
public final class BasicInputRowWriter
implements IInputRowWriter,
ICubeDataObserverContext,
IMutableDictionaryObserver<IDimensionKeys, IMeasureValues> {
    @NotNull
    private final ITransaction _tran;
    @Nullable
    private final IAddOrUpdateStrategy<IMeasureValues> strategy;
    private final long _lockTime;
    @Nullable
    private Closeable _writeLock;
    @NotNull
    private final InputRowList inputRowList;
    private long writeCount;
    @NotNull
    private final InputRowWriterCreatingEventArgs creatingEventArgs;
    @Nullable
    private final ICubeDataObserver _observer;
    private int _index;
    @NotNull
    private IDimensionKeys _currentKey;
    private final int cubeId;

    public BasicInputRowWriter(@NotNull CubeWorkspace cubeWorkspace, @NotNull BasicCubeWorkspace realWorkspace, @NotNull ITransaction _tran, @Nullable IAddOrUpdateStrategy<IMeasureValues> strategy, @NotNull CubeDataLock dataLock) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)realWorkspace, (String)"realWorkspace");
        Intrinsics.checkNotNullParameter((Object)_tran, (String)"_tran");
        Intrinsics.checkNotNullParameter((Object)dataLock, (String)"dataLock");
        this._tran = _tran;
        this.strategy = strategy;
        this.creatingEventArgs = new InputRowWriterCreatingEventArgs(this);
        boolean $i$f$measureNanoTime = false;
        boolean bl = false;
        long start$iv = System.nanoTime();
        BasicInputRowWriter basicInputRowWriter = this;
        boolean bl2 = false;
        this._writeLock = dataLock.getWriteLock();
        Unit unit = Unit.INSTANCE;
        basicInputRowWriter._lockTime = System.nanoTime() - start$iv;
        try {
            this.inputRowList = realWorkspace.getInputRowList();
            cubeWorkspace.getInputRowWriterCreating().invoke(cubeWorkspace.getPlugins().getContext(), this.creatingEventArgs);
            this._observer = this.creatingEventArgs.createCubeDataObserver$bos_olap_core();
        }
        catch (Throwable ex) {
            Closeable closeable = this._writeLock;
            if (closeable != null) {
                closeable.close();
            }
            throw ex;
        }
        this._index = -1;
        this._currentKey = EmptyDimensionKeys.INSTANCE;
        this.cubeId = cubeWorkspace.getCubeId();
    }

    @Override
    @Nullable
    public IAddOrUpdateStrategy<IMeasureValues> getStrategy() {
        return this.strategy;
    }

    @Override
    public boolean addOrUpdate(@NotNull IDimensionKeys key, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        BasicInputRowWriter observer = this._observer == null ? null : this;
        return this.inputRowList.addOrUpdate(key, value2, this.getStrategy(), (IMutableDictionaryObserver<IDimensionKeys, IMeasureValues>)observer) < 0;
    }

    @Override
    public void add(@NotNull IDimensionKeys key, @NotNull IMeasureValues values) {
        boolean bl;
        boolean canAdd;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Object object = this.getStrategy();
        boolean bl2 = canAdd = object == null ? true : (bl = object.canAdd());
        if (canAdd) {
            this._index = this.inputRowList.add$bos_olap_core(key, values);
            this._currentKey = key;
            object = this;
            long l = ((BasicInputRowWriter)object).writeCount;
            ((BasicInputRowWriter)object).writeCount = l + 1L;
            object = this._observer;
            if (object != null) {
                object.onAdded(key, values);
            }
        }
    }

    @Override
    public void update(long rowIndex, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        boolean bl = 0L <= rowIndex ? rowIndex < Integer.MAX_VALUE : false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int index2 = (int)rowIndex;
        IMeasureValues newValues = this.getStrategy() != null && this.getStrategy().getSupportModifiedValue() ? this.getStrategy().modifiedValue(this.inputRowList.getMeasureValues(index2), values) : values;
        IDimensionKeys key = this.inputRowList.update$bos_olap_core(index2, newValues);
        ICubeDataObserver iCubeDataObserver = this._observer;
        if (iCubeDataObserver != null) {
            ICubeDataObserver iCubeDataObserver2 = iCubeDataObserver;
            boolean bl6 = false;
            boolean bl7 = false;
            ICubeDataObserver $this$update_u24lambda_u2d1 = iCubeDataObserver2;
            boolean bl8 = false;
            if (!IMeasureValuesKt.allValuesIsUndefined(newValues)) {
                this._index = index2;
                this._currentKey = key;
                BasicInputRowWriter basicInputRowWriter = this;
                long l = basicInputRowWriter.writeCount;
                basicInputRowWriter.writeCount = l + 1L;
                $this$update_u24lambda_u2d1.onUpdated(key, newValues);
            }
        }
    }

    @Override
    public void add(int partionId, @NotNull IDimensionKeys key, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.inputRowList.add$bos_olap_core(key, values);
    }

    @Override
    public void update(int partionId, int rowIndex, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.inputRowList.update$bos_olap_core(rowIndex, values);
    }

    @Override
    public void onAdded(int addIndex, @NotNull IDimensionKeys key, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ICubeDataObserver iCubeDataObserver = this._observer;
        if (iCubeDataObserver != null) {
            ICubeDataObserver iCubeDataObserver2 = iCubeDataObserver;
            boolean bl = false;
            boolean bl2 = false;
            ICubeDataObserver $this$onAdded_u24lambda_u2d2 = iCubeDataObserver2;
            boolean bl3 = false;
            this._index = addIndex;
            this._currentKey = key;
            BasicInputRowWriter basicInputRowWriter = this;
            long l = basicInputRowWriter.writeCount;
            basicInputRowWriter.writeCount = l + 1L;
            $this$onAdded_u24lambda_u2d2.onAdded(key, value2);
        }
    }

    @Override
    public void onUpdated(int updateIndex, @NotNull IDimensionKeys key, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ICubeDataObserver iCubeDataObserver = this._observer;
        if (iCubeDataObserver != null) {
            ICubeDataObserver iCubeDataObserver2 = iCubeDataObserver;
            boolean bl = false;
            boolean bl2 = false;
            ICubeDataObserver $this$onUpdated_u24lambda_u2d3 = iCubeDataObserver2;
            boolean bl3 = false;
            if (!IMeasureValuesKt.allValuesIsUndefined(value2)) {
                this._index = updateIndex;
                this._currentKey = key;
                BasicInputRowWriter basicInputRowWriter = this;
                long l = basicInputRowWriter.writeCount;
                basicInputRowWriter.writeCount = l + 1L;
                $this$onUpdated_u24lambda_u2d3.onUpdated(key, value2);
            }
        }
    }

    @Override
    public int getCubeId() {
        return this.cubeId;
    }

    @Override
    public long getTid() {
        return this._tran.getVersion().getId();
    }

    @Override
    public int getPartitionId() {
        return -1;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public long getGlobalIndex() {
        return this._index;
    }

    @Override
    @NotNull
    public IDimensionKeys getKeyInPartition() {
        return this._currentKey;
    }

    @Override
    public void force() {
        this.inputRowList.force();
        if (this.writeCount > 0L) {
            ICubeDataObserver iCubeDataObserver = this._observer;
            if (iCubeDataObserver != null) {
                iCubeDataObserver.onForcePartition();
            }
            iCubeDataObserver = this._observer;
            if (iCubeDataObserver != null) {
                iCubeDataObserver.onForce();
            }
        }
        this._tran.commit();
    }

    @Override
    public void close() {
        Closeable closeable = this._writeLock;
        if (closeable != null) {
            closeable.close();
        }
        if (this._tran.getState() == TransactionStatus.Active) {
            this._tran.rollback();
        }
    }

    @Override
    public long getWriteLockTime() {
        return this._lockTime;
    }

    @Override
    public long getTransactionId() {
        return this._tran.getVersion().getId();
    }

    @Override
    public boolean addOrUpdate(@NotNull IInputRow row) {
        return IInputRowWriter.DefaultImpls.addOrUpdate(this, row);
    }
}

