/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.File;
import java.util.List;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.metadata.OlapDataTypes;
import kd.bos.olapServer.metadata.builds.DimensionBuilder;
import kd.bos.olapServer.metadata.builds.MemberBuilder;
import kd.bos.olapServer.metadata.events.AlterMeasureEvent;
import kd.bos.olapServer.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer.metadata.events.DropDimensionEvent;
import kd.bos.olapServer.metadata.events.DropMemberEvent;
import kd.bos.olapServer.metadata.events.MetadataEvent;
import kd.bos.olapServer.storages.CommonCubeMetadataStorage;
import kd.bos.olapServer.storages.CubeDataStorage;
import kd.bos.olapServer.storages.CubeResourcePool;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer/storages/CubeMetadataStorage;", "", "resourcePool", "Lkd/bos/olapServer/storages/CubeResourcePool;", "path", "", "Lkd/bos/olapServer/common/string;", "dataStorage", "Lkd/bos/olapServer/storages/CubeDataStorage;", "(Lkd/bos/olapServer/storages/CubeResourcePool;Ljava/lang/String;Lkd/bos/olapServer/storages/CubeDataStorage;)V", "bind", "Lkd/bos/olapServer/metadata/events/MetadataEvent;", "event", "bindAlterMeasure", "", "Lkd/bos/olapServer/metadata/events/AlterMeasureEvent;", "bindCreateDimension", "Lkd/bos/olapServer/metadata/events/CreateDimensionEvent;", "bindDropDimension", "Lkd/bos/olapServer/metadata/events/DropDimensionEvent;", "bindDropMember", "Lkd/bos/olapServer/metadata/events/DropMemberEvent;", "invokeEvent", "bos-olap-core"})
public final class CubeMetadataStorage {
    @NotNull
    private final CubeResourcePool resourcePool;
    @NotNull
    private final String path;
    @NotNull
    private final CubeDataStorage dataStorage;

    public CubeMetadataStorage(@NotNull CubeResourcePool resourcePool, @NotNull String path, @NotNull CubeDataStorage dataStorage) {
        Intrinsics.checkNotNullParameter((Object)resourcePool, (String)"resourcePool");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)dataStorage, (String)"dataStorage");
        this.resourcePool = resourcePool;
        this.path = path;
        this.dataStorage = dataStorage;
    }

    public final void invokeEvent(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommonCubeMetadataStorage.INSTANCE.bind(event);
        this.bind(event).invoke();
    }

    private final void bindCreateDimension(CreateDimensionEvent event) {
        Cube cube = this.dataStorage.getCube();
        DimensionBuilder dimBuilder = event.getDimBuilder();
        long rowCount = event.getRowCount();
        event.before((Function0<Unit>)((Function0)new Function0<Unit>(dimBuilder, rowCount, cube, event){
            final /* synthetic */ DimensionBuilder $dimBuilder;
            final /* synthetic */ long $rowCount;
            final /* synthetic */ Cube $cube;
            final /* synthetic */ CreateDimensionEvent $event;
            {
                this.$dimBuilder = $dimBuilder;
                this.$rowCount = $rowCount;
                this.$cube = $cube;
                this.$event = $event;
                super(0);
            }

            public final void invoke() {
                String dimName = this.$dimBuilder.getName();
                Object[] objectArray = (Object[])this.$dimBuilder.getDefaultMemberName();
                boolean bl = false;
                String realDefaultMemberName = objectArray.length() == 0 ? (this.$dimBuilder.getAllowNull() ? Member.Companion.getNull() : "") : this.$dimBuilder.getDefaultMemberName();
                objectArray = realDefaultMemberName;
                bl = false;
                if (objectArray.length() == 0 && this.$rowCount > 0L) {
                    objectArray = Res.INSTANCE.getCubeStorageBasicException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CubeStorageBasicException_2");
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{this.$cube.getName(), this.$rowCount, dimName};
                    throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                }
                objectArray = realDefaultMemberName;
                bl = false;
                this.$event.setDefaultMemberBuilder(objectArray.length() > 0 ? (MemberBuilder)this.$dimBuilder.getMembers().get(realDefaultMemberName) : null);
            }
        }));
    }

    @NotNull
    public final MetadataEvent bind(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof CreateDimensionEvent) {
            this.bindCreateDimension((CreateDimensionEvent)event);
        } else if (metadataEvent instanceof DropDimensionEvent) {
            this.bindDropDimension((DropDimensionEvent)event);
        } else if (metadataEvent instanceof DropMemberEvent) {
            this.bindDropMember((DropMemberEvent)event);
        } else if (metadataEvent instanceof AlterMeasureEvent) {
            this.bindAlterMeasure((AlterMeasureEvent)event);
        }
        this.dataStorage.bind(event, new SelectorContext(this.resourcePool));
        return event;
    }

    private final void bindDropMember(DropMemberEvent event) {
        if (event.isPartitionDimension()) {
            event.before((Function0<Unit>)((Function0)new Function0<Unit>(this, event){
                final /* synthetic */ CubeMetadataStorage this$0;
                final /* synthetic */ DropMemberEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    File partitionDir = new File(CubeMetadataStorage.access$getPath$p(this.this$0));
                    if (partitionDir.exists()) {
                        if (CubeMetadataStorage.access$getResourcePool$p(this.this$0).getRowCount() == 0) {
                            this.$event.addDeleteDir(partitionDir);
                        } else {
                            void $this$forEach$iv;
                            String[] stringArray = partitionDir.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"partitionDir.name");
                            CharSequence charSequence = (CharSequence)stringArray;
                            stringArray = new String[]{"&"};
                            List partitionMembers = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                            MemberCollection allMembers = this.$event.getDimension().getMembers();
                            Iterable iterable = partitionMembers;
                            DropMemberEvent dropMemberEvent = this.$event;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                String memberName = (String)element$iv;
                                boolean bl = false;
                                Member member = (Member)allMembers.tryGet(memberName);
                                if (member == null || !ArraysKt.contains((Object[])dropMemberEvent.getDropMembers(), (Object)member)) continue;
                                if (!dropMemberEvent.getAllowDropMemberWhenRowReferenced()) {
                                    Object[] objectArray = Res.INSTANCE.getMemberMetadataCommandException_3();
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MemberMetadataCommandException_3");
                                    Object[] objectArray2 = objectArray;
                                    objectArray = new Object[]{dropMemberEvent.getDimension().getName(), member.getName()};
                                    throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                                }
                                dropMemberEvent.addDeleteDir(partitionDir);
                                dropMemberEvent.markHasReference();
                            }
                        }
                    }
                }
            }));
        }
    }

    private final void bindAlterMeasure(AlterMeasureEvent event) {
        Measure[] $this$forEach$iv = event.getMeasures();
        boolean $i$f$forEach = false;
        Measure[] measureArray = $this$forEach$iv;
        int n = measureArray.length;
        for (int i = 0; i < n; ++i) {
            Measure element$iv;
            Measure measure = element$iv = measureArray[i];
            boolean bl = false;
            if (measure.getDataType() != OlapDataTypes.decimal || event.getNewDataType() != OlapDataTypes.object) continue;
            event.after((Function0<Unit>)((Function0)new Function0<Unit>(this, measure, event){
                final /* synthetic */ CubeMetadataStorage this$0;
                final /* synthetic */ Measure $measure;
                final /* synthetic */ AlterMeasureEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$measure = $measure;
                    this.$event = $event;
                    super(0);
                }

                public final void invoke() {
                    String[] stringArray = new String[]{Intrinsics.stringPlus((String)this.$measure.getName(), (Object)"/flags.dat")};
                    String flagPath = ((Object)Paths.INSTANCE.get(CubeMetadataStorage.access$getPath$p(this.this$0), stringArray)).toString();
                    Object[] objectArray = new String[]{Intrinsics.stringPlus((String)this.$measure.getName(), (Object)"/main.dat")};
                    String mainPath = ((Object)Paths.INSTANCE.get(CubeMetadataStorage.access$getPath$p(this.this$0), (String[])objectArray)).toString();
                    if (!new File(flagPath).delete() || !new File(mainPath).delete()) {
                        objectArray = Res.INSTANCE.getMeasureMetadataCommandException_3();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MeasureMetadataCommandException_3");
                        Object object = objectArray;
                        objectArray = new Object[]{this.$measure.getName(), this.$event.getCubeName()};
                        throw Res.INSTANCE.getRuntimeException((String)object, objectArray);
                    }
                }
            }));
        }
    }

    private final void bindDropDimension(DropDimensionEvent event) {
        event.core((Function0<Unit>)((Function0)new Function0<Unit>(event, this){
            final /* synthetic */ DropDimensionEvent $event;
            final /* synthetic */ CubeMetadataStorage this$0;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!this.$event.isRebuild()) {
                    String dimensionName = this.$event.getDimension().getName();
                    String[] stringArray = new String[]{dimensionName};
                    String dimDirectionPath = ((Object)Paths.INSTANCE.get(CubeMetadataStorage.access$getPath$p(this.this$0), stringArray)).toString();
                    File file = new File(dimDirectionPath);
                    if (file.exists()) {
                        FileTools.INSTANCE.deleteDir(file);
                    }
                }
            }
        }));
    }

    public static final /* synthetic */ String access$getPath$p(CubeMetadataStorage $this) {
        return $this.path;
    }

    public static final /* synthetic */ CubeResourcePool access$getResourcePool$p(CubeMetadataStorage $this) {
        return $this.resourcePool;
    }
}

