/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Iterator;
import kd.bos.olapServer.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer.common.EventArgs;
import kd.bos.olapServer.common.EventHandlerList;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.monitorReports.HealthReportContainer;
import kd.bos.olapServer.replication.CubeRedoQueue;
import kd.bos.olapServer.security.AccessStrategyCollection;
import kd.bos.olapServer.selects.IQuerySession;
import kd.bos.olapServer.selects.Query;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.BasicCubeWorkspaceProxy;
import kd.bos.olapServer.storages.ICubeMetadataLock;
import kd.bos.olapServer.storages.ICubeMetadataStorage;
import kd.bos.olapServer.storages.ICubeWorkspaceProxy;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.IMetadataDatabase;
import kd.bos.olapServer.storages.PartitionCubeWorkspaceProxy;
import kd.bos.olapServer.storages.plugins.CubeWorkspacePlugin;
import kd.bos.olapServer.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer.storages.plugins.InputRowWriterCreatingEventArgs;
import kd.bos.olapServer.storages.plugins.PluginCollection;
import kd.bos.olapServer.transactions.TransactionManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010D\u001a\u00020EJ\b\u0010F\u001a\u00020\u000eH\u0002J\u001a\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\n\u0010K\u001a\u00060\u0010j\u0002`\u0011J\u0018\u0010L\u001a\u00020M2\u0010\b\u0002\u0010N\u001a\n\u0012\u0004\u0012\u00020P\u0018\u00010OJ\u0006\u0010Q\u001a\u00020EJ\n\u0010R\u001a\u00060Sj\u0002`TJ\f\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VJ\u0006\u0010X\u001a\u00020ER\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020&0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001eR\u0015\u0010(\u001a\u00060\u0010j\u0002`\u00118F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001b08\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006Y"}, d2={"Lkd/bos/olapServer/storages/CubeWorkspace;", "", "path", "", "Lkd/bos/olapServer/common/string;", "cubeId", "", "Lkd/bos/olapServer/common/int;", "(Ljava/lang/String;I)V", "Metadata", "Lkd/bos/olapServer/metadata/Cube;", "getMetadata", "()Lkd/bos/olapServer/metadata/Cube;", "_cubeWorkspaceProxy", "Lkd/bos/olapServer/storages/ICubeWorkspaceProxy;", "_isClosed", "", "Lkd/bos/olapServer/common/bool;", "_metadata", "_metadataBase", "Lkd/bos/olapServer/storages/IMetadataDatabase;", "accessStrategies", "Lkd/bos/olapServer/security/AccessStrategyCollection;", "getAccessStrategies", "()Lkd/bos/olapServer/security/AccessStrategyCollection;", "collecting", "Lkd/bos/olapServer/common/EventHandlerList;", "Lkd/bos/olapServer/storages/plugins/CubeWorkspacePluginContext;", "Lkd/bos/olapServer/common/EventArgs;", "getCollecting", "()Lkd/bos/olapServer/common/EventHandlerList;", "getCubeId", "()I", "healthReports", "Lkd/bos/olapServer/monitorReports/HealthReportContainer;", "getHealthReports", "()Lkd/bos/olapServer/monitorReports/HealthReportContainer;", "inputRowWriterCreating", "Lkd/bos/olapServer/storages/plugins/InputRowWriterCreatingEventArgs;", "getInputRowWriterCreating", "isClosed", "()Z", "md5", "", "getMd5", "()[B", "metadataLock", "Lkd/bos/olapServer/storages/ICubeMetadataLock;", "getMetadataLock", "()Lkd/bos/olapServer/storages/ICubeMetadataLock;", "metadataStorage", "Lkd/bos/olapServer/storages/ICubeMetadataStorage;", "getMetadataStorage", "()Lkd/bos/olapServer/storages/ICubeMetadataStorage;", "pluginContext", "plugins", "Lkd/bos/olapServer/storages/plugins/PluginCollection;", "Lkd/bos/olapServer/storages/plugins/CubeWorkspacePlugin;", "getPlugins", "()Lkd/bos/olapServer/storages/plugins/PluginCollection;", "replayRedo", "Lkd/bos/olapServer/replication/CubeRedoQueue;", "getReplayRedo", "()Lkd/bos/olapServer/replication/CubeRedoQueue;", "transactionManager", "Lkd/bos/olapServer/transactions/TransactionManager;", "getTransactionManager", "()Lkd/bos/olapServer/transactions/TransactionManager;", "close", "", "createProxy", "createQuerySession", "Lkd/bos/olapServer/selects/IQuerySession;", "query", "Lkd/bos/olapServer/selects/Query;", "isParallel", "createWriter", "Lkd/bos/olapServer/storages/IInputRowWriter;", "strategy", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "gc", "getRowCount", "", "Lkd/bos/olapServer/common/long;", "getSubWorkspaces", "", "Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "onMetadataUpdated", "bos-olap-core"})
public final class CubeWorkspace {
    @NotNull
    private final String path;
    private final int cubeId;
    @NotNull
    private final IMetadataDatabase _metadataBase;
    @NotNull
    private volatile Cube _metadata;
    @NotNull
    private final CubeWorkspacePluginContext pluginContext;
    @NotNull
    private final PluginCollection<CubeWorkspacePlugin, CubeWorkspacePluginContext> plugins;
    @NotNull
    private final AccessStrategyCollection accessStrategies;
    @NotNull
    private final HealthReportContainer healthReports;
    @NotNull
    private ICubeWorkspaceProxy _cubeWorkspaceProxy;
    @NotNull
    private final ICubeMetadataLock metadataLock;
    @NotNull
    private final CubeRedoQueue replayRedo;
    @NotNull
    private final EventHandlerList<CubeWorkspacePluginContext, InputRowWriterCreatingEventArgs> inputRowWriterCreating;
    @NotNull
    private final EventHandlerList<CubeWorkspacePluginContext, EventArgs> collecting;
    private volatile boolean _isClosed;

    public CubeWorkspace(@NotNull String path, int cubeId) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.cubeId = cubeId;
        this._metadataBase = IMetadataDatabase.Companion.readFrom(this.path);
        this.pluginContext = new CubeWorkspacePluginContext(this);
        this.plugins = new PluginCollection(this.pluginContext);
        this._metadata = this._metadataBase.build();
        this.accessStrategies = new AccessStrategyCollection();
        this.healthReports = new HealthReportContainer(this.accessStrategies);
        this._cubeWorkspaceProxy = this.createProxy();
        this.metadataLock = this._cubeWorkspaceProxy.createMetadataLock();
        this.replayRedo = new CubeRedoQueue();
        this.inputRowWriterCreating = new EventHandlerList();
        this.collecting = new EventHandlerList();
    }

    public /* synthetic */ CubeWorkspace(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        this(string, n);
    }

    public final int getCubeId() {
        return this.cubeId;
    }

    @NotNull
    public final PluginCollection<CubeWorkspacePlugin, CubeWorkspacePluginContext> getPlugins() {
        return this.plugins;
    }

    @NotNull
    public final Cube getMetadata() {
        return this._metadata;
    }

    @NotNull
    public final AccessStrategyCollection getAccessStrategies() {
        return this.accessStrategies;
    }

    @NotNull
    public final HealthReportContainer getHealthReports() {
        return this.healthReports;
    }

    private final ICubeWorkspaceProxy createProxy() {
        return this._metadata.getEnabledPartition() ? (ICubeWorkspaceProxy)new PartitionCubeWorkspaceProxy(this, this._metadataBase, this.path) : (ICubeWorkspaceProxy)new BasicCubeWorkspaceProxy(this, this._metadataBase, this.path);
    }

    @NotNull
    public final Iterator<AbstractCubeWorkspace> getSubWorkspaces() {
        return this._cubeWorkspaceProxy.getSubWorkspaces();
    }

    @NotNull
    public final ICubeMetadataStorage getMetadataStorage() {
        return this._cubeWorkspaceProxy.getMetadataStorage();
    }

    @NotNull
    public final ICubeMetadataLock getMetadataLock() {
        return this.metadataLock;
    }

    @NotNull
    public final CubeRedoQueue getReplayRedo() {
        return this.replayRedo;
    }

    @NotNull
    public final IInputRowWriter createWriter(@Nullable IAddOrUpdateStrategy<IMeasureValues> strategy) {
        return this._cubeWorkspaceProxy.createWriter(strategy);
    }

    public static /* synthetic */ IInputRowWriter createWriter$default(CubeWorkspace cubeWorkspace, IAddOrUpdateStrategy iAddOrUpdateStrategy, int n, Object object) {
        if ((n & 1) != 0) {
            iAddOrUpdateStrategy = null;
        }
        return cubeWorkspace.createWriter(iAddOrUpdateStrategy);
    }

    @NotNull
    public final EventHandlerList<CubeWorkspacePluginContext, InputRowWriterCreatingEventArgs> getInputRowWriterCreating() {
        return this.inputRowWriterCreating;
    }

    @NotNull
    public final IQuerySession createQuerySession(@NotNull Query query2, boolean isParallel) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        return this._cubeWorkspaceProxy.createQuerySession(query2, isParallel);
    }

    public final long getRowCount() {
        return this._cubeWorkspaceProxy.getRowCount();
    }

    @NotNull
    public final TransactionManager getTransactionManager() {
        return this._cubeWorkspaceProxy.getTransactionManager();
    }

    @NotNull
    public final byte[] getMd5() {
        MessageDigest md = MessageDigest.getInstance("MD5");
        Object object = String.valueOf(this.cubeId);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray);
        object = this._metadata.getName();
        charset = Charsets.UTF_8;
        bl = false;
        String string2 = object;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray2);
        object = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"md.digest()");
        return object;
    }

    public final void onMetadataUpdated() {
        ICubeWorkspaceProxy iCubeWorkspaceProxy;
        Cube newMetadata = this._metadataBase.build();
        boolean bl = Intrinsics.areEqual((Object)newMetadata.getName(), (Object)this._metadata.getName());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean oldEnabledPartition = this._metadata.getEnabledPartition();
        boolean newEnabledPartition = newMetadata.getEnabledPartition();
        this._metadata = newMetadata;
        if (oldEnabledPartition == newEnabledPartition) {
            iCubeWorkspaceProxy = this._cubeWorkspaceProxy.onMetadataUpdated(newMetadata);
        } else {
            ICubeWorkspaceProxy proxy = this.createProxy();
            this._cubeWorkspaceProxy.close();
            iCubeWorkspaceProxy = proxy;
        }
        this._cubeWorkspaceProxy = iCubeWorkspaceProxy;
    }

    @NotNull
    public final EventHandlerList<CubeWorkspacePluginContext, EventArgs> getCollecting() {
        return this.collecting;
    }

    public final void gc() {
        this._cubeWorkspaceProxy.gc(this.metadataLock);
        this.collecting.invoke(this.pluginContext, EventArgs.Default.INSTANCE);
    }

    public final boolean isClosed() {
        return this._isClosed;
    }

    public final void close() {
        if (this._isClosed) {
            return;
        }
        this.metadataLock.enterWrite((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeWorkspace this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!CubeWorkspace.access$get_isClosed$p(this.this$0)) {
                    CubeWorkspace.access$get_cubeWorkspaceProxy$p(this.this$0).close();
                    CubeWorkspace.access$get_metadataBase$p(this.this$0).close();
                    this.this$0.getPlugins().close$bos_olap_core();
                    CubeWorkspace.access$set_isClosed$p(this.this$0, true);
                }
            }
        });
    }

    public static final /* synthetic */ boolean access$get_isClosed$p(CubeWorkspace $this) {
        return $this._isClosed;
    }

    public static final /* synthetic */ ICubeWorkspaceProxy access$get_cubeWorkspaceProxy$p(CubeWorkspace $this) {
        return $this._cubeWorkspaceProxy;
    }

    public static final /* synthetic */ IMetadataDatabase access$get_metadataBase$p(CubeWorkspace $this) {
        return $this._metadataBase;
    }

    public static final /* synthetic */ void access$set_isClosed$p(CubeWorkspace $this, boolean bl) {
        $this._isClosed = bl;
    }
}

