/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.Closeable;
import java.util.Arrays;
import java.util.UUID;
import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.collections.IImmutableList;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.storages.IImmutableFixedNumberMap;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\u00020\u0003B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0018\u0010\u0018\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u0019\u001a\u00060\u000ej\u0002`\u000fH\u0016R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer/storages/ImmutablePosition2NumberMap;", "Ljava/io/Closeable;", "Lkd/bos/olapServer/collections/ICloneable;", "Lkd/bos/olapServer/storages/IImmutableFixedNumberMap;", "uuidSeq", "Lkd/bos/olapServer/collections/IImmutableList;", "Ljava/util/UUID;", "members", "Lkd/bos/olapServer/metadata/MemberCollection;", "oldNumber2PosMap", "", "oldPos2NumberMap", "(Lkd/bos/olapServer/collections/IImmutableList;Lkd/bos/olapServer/metadata/MemberCollection;[I[I)V", "fixedNumber", "", "Lkd/bos/olapServer/common/int;", "number2PosMap", "pos2NumberMap", "add", "", "id", "clone", "close", "getPositionByFixedNumber", "tryGetFixedNumberByPosition", "position", "bos-olap-core"})
public final class ImmutablePosition2NumberMap
implements Closeable,
ICloneable<ImmutablePosition2NumberMap>,
IImmutableFixedNumberMap {
    @NotNull
    private final IImmutableList<UUID> uuidSeq;
    @NotNull
    private final MemberCollection members;
    @NotNull
    private final int[] number2PosMap;
    @NotNull
    private final int[] pos2NumberMap;
    private int fixedNumber;

    public ImmutablePosition2NumberMap(@NotNull IImmutableList<UUID> uuidSeq, @NotNull MemberCollection members2, @Nullable int[] oldNumber2PosMap, @Nullable int[] oldPos2NumberMap) {
        int n;
        Intrinsics.checkNotNullParameter(uuidSeq, (String)"uuidSeq");
        Intrinsics.checkNotNullParameter((Object)members2, (String)"members");
        this.uuidSeq = uuidSeq;
        this.members = members2;
        int startIndex = 0;
        if (oldNumber2PosMap != null) {
            int[] nArray = oldNumber2PosMap;
            n = this.uuidSeq.getCount() + 1;
            boolean bl = false;
            int[] nArray2 = Arrays.copyOf(nArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            this.number2PosMap = nArray2;
            startIndex = oldNumber2PosMap.length - 1;
            this.fixedNumber = oldNumber2PosMap.length;
            Intrinsics.checkNotNull((Object)oldPos2NumberMap);
            this.pos2NumberMap = oldPos2NumberMap;
        } else {
            int n2;
            this.fixedNumber = 0;
            int n3 = 0;
            n = this.uuidSeq.getCount() + 1;
            int[] nArray = new int[n];
            ImmutablePosition2NumberMap immutablePosition2NumberMap = this;
            while (n3 < n) {
                n2 = n3++;
                nArray[n2] = -1;
            }
            immutablePosition2NumberMap.number2PosMap = nArray;
            n3 = 0;
            n = this.members.getCount();
            nArray = new int[n];
            immutablePosition2NumberMap = this;
            while (n3 < n) {
                n2 = n3++;
                nArray[n2] = -1;
            }
            immutablePosition2NumberMap.pos2NumberMap = nArray;
            this.add(Member.Companion.getNull_ID());
            startIndex = 0;
        }
        int n4 = startIndex;
        n = this.uuidSeq.getCount();
        if (n4 < n) {
            do {
                int i = n4++;
                UUID id = this.uuidSeq.get(i);
                if (Intrinsics.areEqual((Object)Member.Companion.getNull_ID(), (Object)id)) continue;
                this.add(id);
            } while (n4 < n);
        }
    }

    public /* synthetic */ ImmutablePosition2NumberMap(IImmutableList iImmutableList, MemberCollection memberCollection, int[] nArray, int[] nArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            nArray = null;
        }
        if ((n & 8) != 0) {
            nArray2 = null;
        }
        this(iImmutableList, memberCollection, nArray, nArray2);
    }

    private final void add(UUID id) {
        Member member = this.members.tryGet(id);
        if (member != null) {
            if (this.pos2NumberMap[member.getPosition$bos_olap_core()] == -1) {
                this.pos2NumberMap[member.getPosition$bos_olap_core()] = this.fixedNumber;
            } else {
                Object[] objectArray = Res.INSTANCE.getPosition2NumberMapException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.Position2NumberMapException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{id};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
        }
        Object object = this;
        int n = ((ImmutablePosition2NumberMap)object).fixedNumber;
        ((ImmutablePosition2NumberMap)object).fixedNumber = n + 1;
        object = member;
        int n2 = object == null ? -1 : (n = ((Member)object).getPosition$bos_olap_core());
        this.number2PosMap[n] = n2;
    }

    @Override
    public int getPositionByFixedNumber(int fixedNumber) {
        try {
            return this.number2PosMap[fixedNumber];
        }
        catch (IndexOutOfBoundsException _) {
            throw new IndexOutOfBoundsException("fixedNumber=" + fixedNumber + ",number2PosMap.size=" + this.number2PosMap.length);
        }
    }

    @Override
    public int tryGetFixedNumberByPosition(int position) {
        return (0 <= position ? position < this.pos2NumberMap.length : false) ? this.pos2NumberMap[position] : -1;
    }

    @Override
    public void close() {
        Closeable closeable;
        IImmutableList<UUID> iImmutableList = this.uuidSeq;
        Closeable closeable2 = closeable = iImmutableList instanceof Closeable ? (Closeable)((Object)iImmutableList) : null;
        if (closeable != null) {
            closeable.close();
        }
    }

    @Override
    @NotNull
    public ImmutablePosition2NumberMap clone() {
        ImmutablePosition2NumberMap immutablePosition2NumberMap;
        Object object;
        int oldCount = this.uuidSeq.getCount();
        IImmutableList<UUID> $this$clone$iv = this.uuidSeq;
        boolean $i$f$clone = false;
        Object object2 = object = $this$clone$iv instanceof ICloneable ? (ICloneable)((Object)$this$clone$iv) : null;
        if (object == null) {
            throw new NotSupportedException($this$clone$iv + " not support ICloneable.");
        }
        Object instance$iv = object;
        Object t2 = instance$iv.clone();
        if (!(t2 instanceof IImmutableList)) {
            t2 = null;
        }
        if ((object = (IImmutableList)t2) == null) {
            throw new NotSupportedException($this$clone$iv + " clone() not override.");
        }
        Object newUUIDSeq = object;
        if (newUUIDSeq == this.uuidSeq) {
            boolean bl = newUUIDSeq.getCount() == oldCount;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            immutablePosition2NumberMap = this;
        } else {
            immutablePosition2NumberMap = new ImmutablePosition2NumberMap((IImmutableList<UUID>)newUUIDSeq, this.members, this.number2PosMap, this.pos2NumberMap);
        }
        return immutablePosition2NumberMap;
    }
}

