/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.common.Version;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.builds.CubeBuilder;
import kd.bos.olapServer.metadata.builds.FileFormatChecker;
import kd.bos.olapServer.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer.metadata.xObjectStorages.XObject;
import kd.bos.olapServer.metadata.xObjectStorages.XObjectSession;
import kd.bos.olapServer.metadata.xObjectStorages.XObjectStorage;
import kd.bos.olapServer.storages.IMetadataDatabase;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.JsonHelper;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b \u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002)*B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u00060\u0004j\u0002`\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\u0012\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\rH$J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00060\bj\u0002`\u001dH$J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020 2\n\u0010\"\u001a\u00060\bj\u0002`\u001dH\u0002J\b\u0010#\u001a\u00020\u0014H\u0002J \u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0014\u0010'\u001a\u00020 2\n\u0010\"\u001a\u00060\bj\u0002`\u001dH$J\u0012\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lkd/bos/olapServer/storages/MetadataDatabase;", "Ljava/io/Closeable;", "Lkd/bos/olapServer/storages/IMetadataDatabase;", "path", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "_isClosed", "", "_isInitialized", "_lastCube", "Lkd/bos/olapServer/metadata/Cube;", "_lastCubeBuilder", "Lkd/bos/olapServer/metadata/builds/CubeBuilder;", "_lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getPath", "()Ljava/lang/String;", "build", "close", "", "copyTo", "targetPath", "createDatabase", "createDatabaseCore", "existCubeBuilder", "createWriterContext", "Lkd/bos/olapServer/metadata/builds/IMetadataWriterContext;", "existDatabase", "Lkd/bos/olapServer/common/bool;", "getCubeBuilderFromDB", "storage", "Lkd/bos/olapServer/metadata/xObjectStorages/XObjectStorage;", "getStorage", "isReadonly", "init", "onSaved", "ctx", "builder", "open", "tryGetCubeBuilderFromLastBuild", "Companion", "MetadataWriterContext", "bos-olap-core"})
public abstract class MetadataDatabase
implements Closeable,
IMetadataDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private volatile boolean _isInitialized;
    @NotNull
    private final ReentrantReadWriteLock _lock;
    @Nullable
    private CubeBuilder _lastCubeBuilder;
    @Nullable
    private Cube _lastCube;
    private volatile boolean _isClosed;

    public MetadataDatabase(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this._lock = new ReentrantReadWriteLock();
    }

    @NotNull
    protected final String getPath() {
        return this.path;
    }

    @NotNull
    protected abstract XObjectStorage open(boolean var1);

    protected abstract void createDatabaseCore(@Nullable CubeBuilder var1);

    protected abstract boolean existDatabase();

    private final XObjectStorage getStorage(boolean isReadonly) {
        boolean bl = !this._isClosed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (!this._isInitialized) {
            this.init();
        }
        return this.open(isReadonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init() {
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            if (!this._isInitialized) {
                if (!this.existDatabase()) {
                    this.createDatabase();
                }
                this._isInitialized = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    protected void createDatabase() {
        CubeBuilder cubeBuilder;
        FileTools.INSTANCE.autoMakeDir(this.path);
        String[] stringArray = new String[]{"cube.json"};
        File jsonFile = Paths.INSTANCE.get(this.path, stringArray).toFile();
        if (jsonFile.exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)jsonFile, (String)"jsonFile");
            Companion.checkMetadataVersionFromCubeJson(jsonFile);
            ObjectMapper mapper = JsonHelper.INSTANCE.getMapper();
            Object object = mapper.reader(CubeBuilder.class).readValue(jsonFile);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.reader(CubeBuilder::class.java).readValue(jsonFile)");
            CubeBuilder result = (CubeBuilder)object;
            object = jsonFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonFile.parent");
            new FileFormatChecker((String)object, result).repair();
            cubeBuilder = result;
        } else {
            cubeBuilder = null;
        }
        CubeBuilder existCubeBuilder = cubeBuilder;
        this.createDatabaseCore(existCubeBuilder);
        if (existCubeBuilder != null) {
            int n;
            File oldFile;
            int oldId = 0;
            while (((oldFile = new File(jsonFile.getParent(), Intrinsics.stringPlus((String)"cube.json.old", (Object)(oldId == 0 ? "" : String.valueOf(oldId))))).exists() || !jsonFile.renameTo(oldFile)) && (oldId = (n = oldId) + 1) < 100) {
            }
            if (oldId >= 100) {
                throw new RuntimeException("too much cube.json.old !");
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)jsonFile, (String)"jsonFile");
        FilesKt.writeText((File)jsonFile, (String)("{\"metadataVersion\": \"" + Cube.Companion.getMetadataRequireServerMinVersion() + "\"}"), (Charset)Charsets.UTF_8);
    }

    @Override
    @NotNull
    public IMetadataWriterContext createWriterContext() {
        IMetadataWriterContext iMetadataWriterContext;
        ReentrantReadWriteLock.WriteLock writeLock = this._lock.writeLock();
        writeLock.lock();
        XObjectStorage storage = null;
        try {
            storage = this.getStorage(false);
            CubeBuilder cubeBuilder = this.tryGetCubeBuilderFromLastBuild(storage);
            if (cubeBuilder == null) {
                cubeBuilder = this.getCubeBuilderFromDB(storage);
            }
            XObjectSession xObjectSession = cubeBuilder.getX().getSession();
            Intrinsics.checkNotNull((Object)xObjectSession);
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock");
            iMetadataWriterContext = new MetadataWriterContext(cubeBuilder, xObjectSession, storage, writeLock, this);
        }
        catch (Exception ex) {
            XObjectStorage xObjectStorage = storage;
            if (xObjectStorage != null) {
                xObjectStorage.close();
            }
            writeLock.unlock();
            throw ex;
        }
        return iMetadataWriterContext;
    }

    protected void onSaved(@NotNull IMetadataWriterContext ctx, @NotNull CubeBuilder builder, @NotNull XObjectStorage storage) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this._lastCubeBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Cube build() {
        Cube cube;
        Object object;
        ReentrantReadWriteLock.ReadLock readLock = this._lock.readLock();
        readLock.lock();
        Closeable storage = null;
        try {
            CubeBuilder cubeBuilder = this._lastCubeBuilder;
            if (cubeBuilder == null) {
                storage = this.getStorage(true);
                cubeBuilder = this.getCubeBuilderFromDB((XObjectStorage)storage);
            } else {
                this._lastCubeBuilder = null;
            }
            object = cubeBuilder.build();
            boolean bl = false;
            boolean bl2 = false;
            Cube it = object;
            boolean bl3 = false;
            this._lastCube = it;
            cube = object;
        }
        finally {
            object = storage;
            if (object != null) {
                object.close();
            }
            readLock.unlock();
        }
        return cube;
    }

    private final CubeBuilder getCubeBuilderFromDB(XObjectStorage storage) {
        XObjectSession session = XObjectSession.Companion.loadAll(storage);
        XObject xCube = session.getOrCreateObject("__root__");
        return new CubeBuilder(xCube);
    }

    private final CubeBuilder tryGetCubeBuilderFromLastBuild(XObjectStorage storage) {
        CubeBuilder cubeBuilder;
        Cube lastCube = this._lastCube;
        if (lastCube != null) {
            XObjectSession session = storage.createSession();
            CubeBuilder newBuilder = new CubeBuilder(lastCube);
            session.addObjectOnOpen(newBuilder.getX());
            cubeBuilder = newBuilder;
        } else {
            cubeBuilder = null;
        }
        return cubeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        ReentrantReadWriteLock.WriteLock writeLock = this._lock.writeLock();
        writeLock.lock();
        try {
            for (String file : this.getFileNames()) {
                String[] stringArray = new String[]{file};
                File source2 = Paths.INSTANCE.get(this.path, stringArray).toFile();
                String[] stringArray2 = new String[]{file};
                File target = Paths.INSTANCE.get(targetPath, stringArray2).toFile();
                Intrinsics.checkNotNullExpressionValue((Object)source2, (String)"source");
                Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
                FilesKt.copyTo$default((File)source2, (File)target, (boolean)false, (int)0, (int)6, null);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this._isClosed) {
            ReentrantReadWriteLock.WriteLock writeLock = this._lock.writeLock();
            writeLock.lock();
            try {
                this._isClosed = true;
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00060\u000fj\u0002`\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/storages/MetadataDatabase$MetadataWriterContext;", "Ljava/io/Closeable;", "Lkd/bos/olapServer/metadata/builds/IMetadataWriterContext;", "cubeBuilder", "Lkd/bos/olapServer/metadata/builds/CubeBuilder;", "session", "Lkd/bos/olapServer/metadata/xObjectStorages/XObjectSession;", "storage", "Lkd/bos/olapServer/metadata/xObjectStorages/XObjectStorage;", "writeLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "db", "Lkd/bos/olapServer/storages/MetadataDatabase;", "(Lkd/bos/olapServer/metadata/builds/CubeBuilder;Lkd/bos/olapServer/metadata/xObjectStorages/XObjectSession;Lkd/bos/olapServer/metadata/xObjectStorages/XObjectStorage;Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;Lkd/bos/olapServer/storages/MetadataDatabase;)V", "_isClosed", "", "getCubeBuilder", "()Lkd/bos/olapServer/metadata/builds/CubeBuilder;", "isClosed", "Lkd/bos/olapServer/common/bool;", "()Z", "close", "", "save", "bos-olap-core"})
    private static final class MetadataWriterContext
    implements Closeable,
    IMetadataWriterContext {
        @NotNull
        private final CubeBuilder cubeBuilder;
        @NotNull
        private final XObjectSession session;
        @NotNull
        private final XObjectStorage storage;
        @NotNull
        private final ReentrantReadWriteLock.WriteLock writeLock;
        @NotNull
        private final MetadataDatabase db;
        private boolean _isClosed;

        public MetadataWriterContext(@NotNull CubeBuilder cubeBuilder, @NotNull XObjectSession session, @NotNull XObjectStorage storage, @NotNull ReentrantReadWriteLock.WriteLock writeLock, @NotNull MetadataDatabase db) {
            Intrinsics.checkNotNullParameter((Object)cubeBuilder, (String)"cubeBuilder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)writeLock, (String)"writeLock");
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this.cubeBuilder = cubeBuilder;
            this.session = session;
            this.storage = storage;
            this.writeLock = writeLock;
            this.db = db;
        }

        @Override
        @NotNull
        public CubeBuilder getCubeBuilder() {
            return this.cubeBuilder;
        }

        @Override
        public boolean isClosed() {
            return this._isClosed;
        }

        @Override
        public void close() {
            if (!this._isClosed) {
                this.storage.close();
                this.writeLock.unlock();
                this._isClosed = true;
            }
        }

        @Override
        public void save() {
            this.session.save();
            this.db.onSaved(this, this.getCubeBuilder(), this.storage);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/storages/MetadataDatabase$Companion;", "", "()V", "checkMetadataVersionFromCubeJson", "", "jsonFile", "Ljava/io/File;", "TempCubeJson", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkMetadataVersionFromCubeJson(@NotNull File jsonFile) {
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Version version = Version.Companion.getCurrentVersion();
            Version currentServerVersion = version == null ? new Version(5, 3) : version;
            Version version2 = null;
            try {
                String txt;
                long fileSize = jsonFile.length();
                boolean bl = 28L <= fileSize ? fileSize < 35L : false;
                if (bl && StringsKt.contains$default((CharSequence)(txt = FilesKt.readText((File)jsonFile, (Charset)Charsets.UTF_8)), (CharSequence)"metadataVersion", (boolean)false, (int)2, null)) {
                    TempCubeJson obj = (TempCubeJson)JsonHelper.INSTANCE.getMapper().readValue(txt, TempCubeJson.class);
                    version2 = Version.Companion.createVersion(obj.getMetadataVersion());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (version2 != null && version2.compareTo(currentServerVersion) > 0) {
                Object[] objectArray = Res.INSTANCE.getMetadataXFileDatabaseException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MetadataXFileDatabaseException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{currentServerVersion, version2};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer/storages/MetadataDatabase$Companion$TempCubeJson;", "", "()V", "metadataVersion", "", "Lkd/bos/olapServer/common/string;", "getMetadataVersion", "()Ljava/lang/String;", "setMetadataVersion", "(Ljava/lang/String;)V", "bos-olap-core"})
        private static final class TempCubeJson {
            @NotNull
            private String metadataVersion = "";

            @NotNull
            public final String getMetadataVersion() {
                return this.metadataVersion;
            }

            public final void setMetadataVersion(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.metadataVersion = string;
            }
        }
    }
}

