/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.ClosedFileSystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.olapServer.backup.CubeBackup;
import kd.bos.olapServer.backup.CubeRecovery;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.CommandTypes;
import kd.bos.olapServer.common.EventArgs;
import kd.bos.olapServer.common.EventHandlerList;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.function.FunctionManager;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kd.bos.olapServer.metadata.CubeEntryCollection;
import kd.bos.olapServer.metadata.IdGenerator;
import kd.bos.olapServer.metadata.OlapMetadata;
import kd.bos.olapServer.metadata.builds.CubeEntry;
import kd.bos.olapServer.metadata.builds.OlapMetadataBuilder;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportContainer;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.security.AccessStrategyCollection;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapLockManager;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.storages.plugins.CubeWorkspaceEventArgs;
import kd.bos.olapServer.storages.plugins.OlapWorkspacePlugin;
import kd.bos.olapServer.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer.storages.plugins.PluginCollection;
import kd.bos.olapServer.storages.pools.ObjectPool;
import kd.bos.olapServer.tools.Res;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 n2\u00020\u0001:\u0001nB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010J\u001a\u00060\u0017j\u0002`\u0018J\u0012\u0010K\u001a\u00020L2\n\u0010M\u001a\u00060\u0005j\u0002`\u0006J\u0010\u0010N\u001a\u00020L2\u0006\u0010O\u001a\u00020\u0003H\u0002J\n\u0010P\u001a\u00060\u0014j\u0002`\u0015J\b\u0010Q\u001a\u00020LH\u0002J\u0006\u0010R\u001a\u00020LJ\u0012\u0010S\u001a\u00020T2\n\u0010U\u001a\u00060\u0005j\u0002`\u0006J\b\u0010V\u001a\u00020LH\u0002J\u0012\u0010W\u001a\u00020 2\n\u0010U\u001a\u00060\u0005j\u0002`\u0006J\u0012\u0010X\u001a\u00020 2\n\u0010Y\u001a\u00060\u0017j\u0002`\u0018J\u0013\u0010Z\u001a\b\u0012\u0004\u0012\u00020 0[H\u0000\u00a2\u0006\u0002\b\\J\u0012\u0010]\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010U\u001a\u00020\u0005J\n\u0010^\u001a\u00060Tj\u0002`_J\u0010\u0010`\u001a\u00020L2\u0006\u0010a\u001a\u00020,H\u0002J \u0010b\u001a\u00020L2\n\u0010Y\u001a\u00060\u0017j\u0002`\u00182\n\u0010U\u001a\u00060\u0005j\u0002`\u0006H\u0002J\b\u0010c\u001a\u00020\u0003H\u0002J\u0012\u0010d\u001a\u00020L2\n\u0010M\u001a\u00060\u0005j\u0002`\u0006J\u0006\u0010e\u001a\u00020LJ\u0018\u0010f\u001a\u00060Tj\u0002`_2\f\b\u0002\u0010g\u001a\u00060\u0014j\u0002`\u0015J\u0010\u0010h\u001a\u0004\u0018\u00010 2\u0006\u0010U\u001a\u00020\u0005J\u0014\u0010i\u001a\u0004\u0018\u00010 2\n\u0010Y\u001a\u00060\u0017j\u0002`\u0018J\u001e\u0010j\u001a\u00020L2\u0006\u0010k\u001a\u00020l2\u000e\u0010m\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u0018\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001c0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001d\u0010+\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020,0&\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010*R\u001b\u0010.\u001a\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b0\u00101R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0016\u00108\u001a\n :*\u0004\u0018\u00010909X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001c\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010B\u001a\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020'0C\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010I\u00a8\u0006o"}, d2={"Lkd/bos/olapServer/storages/OlapWorkspace;", "", "olapMetadata", "Lkd/bos/olapServer/metadata/OlapMetadata;", "RootPath", "", "Lkd/bos/olapServer/common/string;", "(Lkd/bos/olapServer/metadata/OlapMetadata;Ljava/lang/String;)V", "LockManager", "Lkd/bos/olapServer/storages/OlapLockManager;", "getLockManager", "()Lkd/bos/olapServer/storages/OlapLockManager;", "Metadata", "getMetadata", "()Lkd/bos/olapServer/metadata/OlapMetadata;", "getRootPath", "()Ljava/lang/String;", "_idGenerator", "Lkd/bos/olapServer/metadata/IdGenerator;", "_lastGcNanoTime", "", "Lkd/bos/olapServer/common/long;", "_state", "", "Lkd/bos/olapServer/common/int;", "_stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_tempPool", "Lkotlin/Lazy;", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "_workspaces", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkd/bos/olapServer/storages/CubeWorkspace;", "accessStrategies", "Lkd/bos/olapServer/security/AccessStrategyCollection;", "getAccessStrategies", "()Lkd/bos/olapServer/security/AccessStrategyCollection;", "collecting", "Lkd/bos/olapServer/common/EventHandlerList;", "Lkd/bos/olapServer/storages/plugins/OlapWorkspacePluginContext;", "Lkd/bos/olapServer/common/EventArgs;", "getCollecting", "()Lkd/bos/olapServer/common/EventHandlerList;", "cubeWorkspaceLoading", "Lkd/bos/olapServer/storages/plugins/CubeWorkspaceEventArgs;", "getCubeWorkspaceLoading", "freeSpaceFile", "Ljava/io/File;", "getFreeSpaceFile", "()Ljava/io/File;", "freeSpaceFile$delegate", "Lkotlin/Lazy;", "functions", "Lkd/bos/olapServer/function/FunctionManager;", "getFunctions", "()Lkd/bos/olapServer/function/FunctionManager;", "gcPool", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "healthReports", "Lkd/bos/olapServer/monitorReports/HealthReportContainer;", "getHealthReports", "()Lkd/bos/olapServer/monitorReports/HealthReportContainer;", "lastGetSpacePair", "Lkotlin/Pair;", "pluginContext", "plugins", "Lkd/bos/olapServer/storages/plugins/PluginCollection;", "Lkd/bos/olapServer/storages/plugins/OlapWorkspacePlugin;", "getPlugins", "()Lkd/bos/olapServer/storages/plugins/PluginCollection;", "tempPool", "getTempPool", "()Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "assignNextId", "backupOlap", "", "backupPath", "buildOlapWorkspaces", "newMetadata", "checkExecuteByFreeSpace", "checkState", "close", "contains", "", "cubeName", "gc", "getCubeWorkspace", "getCubeWorkspaceByCubeId", "cubeId", "getLoadedWorkspaces", "", "getLoadedWorkspaces$bos_olap_core", "getTransactionVersion", "isFree", "Lkd/bos/olapServer/common/bool;", "onCubeWorkspaceLoading", "e", "putWorkspace", "reBuildMetadata", "recoveryOlap", "reloadOlapMetadata", "startGC", "gcTimePeriod", "tryGet", "tryGetByCubeId", "updateMetadata", "action", "Lkd/bos/olapServer/common/CommandTypes;", "updateCubeName", "Companion", "bos-olap-core"})
public final class OlapWorkspace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile OlapMetadata olapMetadata;
    @NotNull
    private final String RootPath;
    @NotNull
    private final ConcurrentHashMap<String, Lazy<CubeWorkspace>> _workspaces;
    @NotNull
    private final IdGenerator _idGenerator;
    @NotNull
    private final AccessStrategyCollection accessStrategies;
    @NotNull
    private final HealthReportContainer healthReports;
    @NotNull
    private final OlapLockManager LockManager;
    private volatile int _state;
    @NotNull
    private final OlapWorkspacePluginContext pluginContext;
    @NotNull
    private final PluginCollection<OlapWorkspacePlugin, OlapWorkspacePluginContext> plugins;
    @NotNull
    private final FunctionManager functions;
    @NotNull
    private final EventHandlerList<OlapWorkspacePluginContext, CubeWorkspaceEventArgs> cubeWorkspaceLoading;
    @NotNull
    private final Lazy<ByteBufferResourcePool> _tempPool;
    private final ScheduledExecutorService gcPool;
    private long _lastGcNanoTime;
    @NotNull
    private final EventHandlerList<OlapWorkspacePluginContext, EventArgs> collecting;
    @NotNull
    private final ReentrantReadWriteLock _stateLock;
    @NotNull
    private final Lazy freeSpaceFile$delegate;
    @Nullable
    private Pair<Long, Long> lastGetSpacePair;
    private static long GcTimePeriod = ObjectPool.Companion.getResourceTimeout() + 10;

    public OlapWorkspace(@NotNull OlapMetadata olapMetadata, @NotNull String RootPath) {
        Intrinsics.checkNotNullParameter((Object)olapMetadata, (String)"olapMetadata");
        Intrinsics.checkNotNullParameter((Object)RootPath, (String)"RootPath");
        this.olapMetadata = olapMetadata;
        this.RootPath = RootPath;
        this._workspaces = new ConcurrentHashMap(this.olapMetadata.getCubes().getCount());
        this._idGenerator = new IdGenerator(this.RootPath);
        this.accessStrategies = new AccessStrategyCollection();
        this.healthReports = new HealthReportContainer(this.accessStrategies);
        this.LockManager = new OlapLockManager();
        this._state = 0;
        this.buildOlapWorkspaces(this.olapMetadata);
        this.LockManager.markIsFormal(this.olapMetadata.getCubes());
        this._state = 1;
        this.pluginContext = new OlapWorkspacePluginContext(this);
        this.plugins = new PluginCollection(this.pluginContext);
        this.functions = FunctionManager.Companion.createDefault$bos_olap_core();
        this.cubeWorkspaceLoading = new EventHandlerList();
        this._tempPool = LazyKt.lazy((Function0)_tempPool.1.INSTANCE);
        this.gcPool = Executors.newScheduledThreadPool(1);
        this.collecting = new EventHandlerList();
        this._stateLock = new ReentrantReadWriteLock();
        this.freeSpaceFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ OlapWorkspace this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return new File(this.this$0.getRootPath());
            }
        }));
    }

    @NotNull
    public final String getRootPath() {
        return this.RootPath;
    }

    @NotNull
    public final OlapMetadata getMetadata() {
        return this.olapMetadata;
    }

    @NotNull
    public final AccessStrategyCollection getAccessStrategies() {
        return this.accessStrategies;
    }

    @NotNull
    public final HealthReportContainer getHealthReports() {
        return this.healthReports;
    }

    @NotNull
    public final OlapLockManager getLockManager() {
        return this.LockManager;
    }

    @NotNull
    public final PluginCollection<OlapWorkspacePlugin, OlapWorkspacePluginContext> getPlugins() {
        return this.plugins;
    }

    @NotNull
    public final FunctionManager getFunctions() {
        return this.functions;
    }

    public final int assignNextId() {
        return this._idGenerator.assignNextId();
    }

    private final void buildOlapWorkspaces(OlapMetadata newMetadata) {
        for (CubeEntry cube22 : newMetadata.getCubes()) {
            String name2;
            int cubeId = cube22.getId();
            String string = cube22.getName();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string3.toUpperCase(locale), (String)"(this as java.lang.String).toUpperCase(locale)");
            if (this._workspaces.containsKey(name2)) continue;
            this.putWorkspace(cubeId, cube22.getName());
        }
        boolean cube22 = false;
        List removedCubes = new ArrayList();
        Enumeration<String> cubeId = this._workspaces.keys();
        Intrinsics.checkNotNullExpressionValue(cubeId, (String)"_workspaces.keys()");
        Iterator cube22 = CollectionsKt.iterator(cubeId);
        while (cube22.hasNext()) {
            String cubeName = (String)cube22.next();
            CubeEntryCollection cubeEntryCollection = newMetadata.getCubes();
            Intrinsics.checkNotNullExpressionValue((Object)cubeName, (String)"cubeName");
            if (cubeEntryCollection.contains(cubeName)) continue;
            removedCubes.add(cubeName);
        }
        Iterable $this$forEach$iv = removedCubes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this._workspaces.remove(it);
        }
    }

    private final void putWorkspace(int cubeId, String cubeName) {
        String string = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
        String name2 = string4;
        this._workspaces.putIfAbsent(name2, (Lazy<CubeWorkspace>)LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<CubeWorkspace>(this, cubeName, cubeId){
            final /* synthetic */ OlapWorkspace this$0;
            final /* synthetic */ String $cubeName;
            final /* synthetic */ int $cubeId;
            {
                this.this$0 = $receiver;
                this.$cubeName = $cubeName;
                this.$cubeId = $cubeId;
                super(0);
            }

            @NotNull
            public final CubeWorkspace invoke() {
                Object object = new String[]{this.$cubeName};
                String cubeDataPath = ((Object)Paths.INSTANCE.get(this.this$0.getRootPath(), (String[])object)).toString();
                object = new CubeWorkspace(cubeDataPath, this.$cubeId);
                String string = this.$cubeName;
                OlapWorkspace olapWorkspace = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$invoke_u24lambda_u2d1 = object;
                boolean bl3 = false;
                boolean bl4 = Intrinsics.areEqual((Object)string, (Object)((CubeWorkspace)$this$invoke_u24lambda_u2d1).getMetadata().getName());
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string2 = "cubeName:" + string + ", but metadata.Name:" + ((CubeWorkspace)$this$invoke_u24lambda_u2d1).getMetadata().getName();
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                OlapWorkspace.access$onCubeWorkspaceLoading(olapWorkspace, new CubeWorkspaceEventArgs(((CubeWorkspace)$this$invoke_u24lambda_u2d1).getPlugins().getContext()));
                return object;
            }
        })));
    }

    @NotNull
    public final EventHandlerList<OlapWorkspacePluginContext, CubeWorkspaceEventArgs> getCubeWorkspaceLoading() {
        return this.cubeWorkspaceLoading;
    }

    private final void onCubeWorkspaceLoading(CubeWorkspaceEventArgs e) {
        this.cubeWorkspaceLoading.invoke(this.pluginContext, e);
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspace(@NotNull String cubeName) {
        Lazy<CubeWorkspace> lazy;
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.checkState();
        Object[] objectArray = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        String string = objectArray2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
        Lazy<CubeWorkspace> lazy2 = this._workspaces.get(string);
        if (lazy2 == null) {
            objectArray = Res.INSTANCE.getOlapWorkspaceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.OlapWorkspaceException_1");
            Object[] objectArray3 = objectArray;
            objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException((String)objectArray3, objectArray);
        }
        Lazy<CubeWorkspace> lazyObj = lazy = lazy2;
        return (CubeWorkspace)lazyObj.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CubeWorkspace> getLoadedWorkspaces$bos_olap_core() {
        void $this$mapNotNullTo$iv$iv;
        void $this$toTypedArray$iv;
        Collection<Lazy<CubeWorkspace>> collection = this._workspaces.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_workspaces.values");
        boolean $i$f$toTypedArray = false;
        Lazy[] thisCollection$iv = $this$toTypedArray$iv;
        Lazy[] lazyArray = thisCollection$iv.toArray(new Lazy[0]);
        if (lazyArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Lazy[] $this$mapNotNull$iv = lazyArray;
        boolean $i$f$mapNotNull = false;
        thisCollection$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var8_8 = $this$forEach$iv$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            CubeWorkspace cubeWorkspace;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var8_8[i];
            boolean bl = false;
            Lazy it = (Lazy)element$iv$iv;
            boolean bl2 = false;
            if ((it.isInitialized() ? (CubeWorkspace)it.getValue() : null) == null) continue;
            cubeWorkspace = cubeWorkspace;
            boolean bl3 = false;
            boolean bl4 = false;
            CubeWorkspace it$iv$iv = cubeWorkspace;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final CubeWorkspace tryGet(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.checkState();
        String string = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        Lazy<CubeWorkspace> lazy = this._workspaces.get(string3);
        return lazy == null ? null : (CubeWorkspace)lazy.getValue();
    }

    @Nullable
    public final CubeWorkspace tryGetByCubeId(int cubeId) {
        CubeWorkspace cubeWorkspace;
        String string = this.getMetadata().getCubes().tryGetCubeNameById(cubeId);
        if (string == null) {
            cubeWorkspace = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            cubeWorkspace = this.tryGet(it);
        }
        return cubeWorkspace;
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspaceByCubeId(int cubeId) {
        return this.getCubeWorkspace(this.getMetadata().getCubes().getCubeNameById(cubeId));
    }

    public final boolean isFree() {
        Object object = this._workspaces;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            Lazy v = (Lazy)object2.getValue();
            if (!v.isInitialized() || !((CubeWorkspace)v.getValue()).getMetadataLock().hasHolder()) continue;
            return false;
        }
        return true;
    }

    public final long getTransactionVersion(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        String string = cubeName;
        boolean bl = false;
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        Lazy<CubeWorkspace> lazyWorkspace = this._workspaces.get(string2);
        return lazyWorkspace == null || !lazyWorkspace.isInitialized() ? 0L : ((CubeWorkspace)lazyWorkspace.getValue()).getTransactionManager().getLastCommittedTransactionId();
    }

    public final boolean contains(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        String string = cubeName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        return this._workspaces.containsKey(string3);
    }

    @NotNull
    public final ByteBufferResourcePool getTempPool() {
        return (ByteBufferResourcePool)this._tempPool.getValue();
    }

    private final void checkState() {
        if (this._state != 1) {
            throw new ClosedFileSystemException();
        }
    }

    public final void updateMetadata(@NotNull CommandTypes action, @Nullable String updateCubeName) {
        Lazy<CubeWorkspace> lazyObj;
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        this.checkState();
        ConcurrentHashMap<String, Lazy<CubeWorkspace>> currentWorkspaces = this._workspaces;
        CubeWorkspace workspace = null;
        Object object = updateCubeName;
        if (object == null) {
            string = null;
        } else {
            String string2 = object;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            bl = false;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3.toUpperCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
        }
        String cubeNameUpperCase = string;
        if (cubeNameUpperCase != null && (lazyObj = currentWorkspaces.get(cubeNameUpperCase)) != null && lazyObj.isInitialized()) {
            workspace = (CubeWorkspace)lazyObj.getValue();
        }
        object = action;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                if (updateCubeName == null) break;
                this.reBuildMetadata();
                int cubeId = ((CubeEntry)this.olapMetadata.getCubes().get(updateCubeName)).getId();
                this.putWorkspace(cubeId, updateCubeName);
                break;
            }
            case 2: {
                if (workspace == null || cubeNameUpperCase == null) break;
                workspace.onMetadataUpdated();
                break;
            }
            case 3: {
                Object cubeId = workspace;
                if (cubeId != null) {
                    ((CubeWorkspace)cubeId).close();
                }
                this.reBuildMetadata();
                cubeId = this._workspaces;
                bl = false;
                Object object2 = cubeId;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                TypeIntrinsics.asMutableMap((Object)object2).remove(cubeNameUpperCase);
                break;
            }
            case 4: {
                OlapMetadata newMetadata = this.reBuildMetadata();
                this.buildOlapWorkspaces(newMetadata);
            }
        }
    }

    public final void reloadOlapMetadata() {
        this.checkState();
        this.reBuildMetadata();
    }

    private final OlapMetadata reBuildMetadata() {
        return (OlapMetadata)this.LockManager.enterWrite((Function0)new Function0<OlapMetadata>(this){
            final /* synthetic */ OlapWorkspace this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OlapMetadata invoke() {
                OlapMetadata newMetadata = OlapMetadataBuilder.Companion.readFrom(this.this$0.getRootPath()).build();
                this.this$0.getLockManager().markIsFormal(newMetadata.getCubes());
                OlapWorkspace.access$setOlapMetadata$p(this.this$0, newMetadata);
                return newMetadata;
            }
        });
    }

    public final boolean startGC(long gcTimePeriod) {
        long currentGcTimePeriod;
        long l = currentGcTimePeriod = gcTimePeriod < 0L ? GcTimePeriod : gcTimePeriod;
        if (this._state == 1 && currentGcTimePeriod > 0L) {
            this.gcPool.scheduleAtFixedRate(this::gc, currentGcTimePeriod, currentGcTimePeriod, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean startGC$default(OlapWorkspace olapWorkspace, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = -1L;
        }
        return olapWorkspace.startGC(l);
    }

    @NotNull
    public final EventHandlerList<OlapWorkspacePluginContext, EventArgs> getCollecting() {
        return this.collecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void gc() {
        if (this._state != 1) {
            return;
        }
        if (System.nanoTime() - this._lastGcNanoTime < GcTimePeriod * 1000000000L / (long)2) {
            return;
        }
        try {
            ConcurrentHashMap<String, Lazy<CubeWorkspace>> workspaces = this._workspaces;
            Object object = workspaces;
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                Lazy v = (Lazy)object2.getValue();
                if (!v.isInitialized()) continue;
                CubeWorkspace workspace = (CubeWorkspace)v.getValue();
                workspace.gc();
            }
            if (this._tempPool.isInitialized()) {
                ((ByteBufferResourcePool)this._tempPool.getValue()).gc();
            }
            this.collecting.invoke(this.pluginContext, EventArgs.Default.INSTANCE);
        }
        catch (Exception ex) {
            boolean bl = false;
            System.out.println(ex);
        }
        finally {
            this._lastGcNanoTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void backupOlap(@NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
        Map $this$forEach$iv = this._workspaces;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$cubeName$cubeWorkSpace = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$cubeName$cubeWorkSpace;
            boolean bl3 = false;
            String cubeName = (String)entry.getKey();
            Map.Entry entry2 = $dstr$cubeName$cubeWorkSpace;
            boolean bl4 = false;
            Lazy cubeWorkSpace = (Lazy)entry2.getValue();
            if (!continueToken.canContinue()) continue;
            try {
                String metaCubeName = ((CubeWorkspace)cubeWorkSpace.getValue()).getMetadata().getName();
                Object object = new String[]{Intrinsics.stringPlus((String)metaCubeName, (Object)".backup")};
                File backupFile = new File(((Object)Paths.INSTANCE.get(backupPath, (String)object)).toString());
                object = new FileOutputStream(backupFile);
                boolean bl5 = false;
                boolean bl6 = false;
                Throwable throwable = null;
                try {
                    FileOutputStream outputStream = (FileOutputStream)object;
                    boolean bl7 = false;
                    Closeable closeable = new CubeBackup((CubeWorkspace)cubeWorkSpace.getValue(), outputStream, this.getRootPath());
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Throwable throwable2 = null;
                    try {
                        CubeBackup it = (CubeBackup)closeable;
                        boolean bl10 = false;
                        it.backup();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(cubeName + ' ' + ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recoveryOlap(@NotNull String backupPath) {
        File[] children;
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        if (this._workspaces.size() != 0) {
            String string = Res.INSTANCE.getOlapWorkspaceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.OlapWorkspaceException_2");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        File[] fileArray = new File(backupPath).listFiles(OlapWorkspace::recoveryOlap$lambda-6);
        if (fileArray == null) {
            return;
        }
        fileArray = children = fileArray;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File child = fileArray[n];
            ++n;
            Closeable closeable = new DataInputStream(new FileInputStream(child));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                String cubeName;
                DataInputStream it = (DataInputStream)closeable;
                boolean bl3 = false;
                String filename = child.getName();
                Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
                String string = filename;
                int n3 = 0;
                int n4 = filename.length() - ".backup".length();
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n3, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                new CubeRecovery(this, cubeName, this.getRootPath(), it).recovery();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        OlapMetadataBuilder newBuilder = OlapMetadataBuilder.Companion.readFrom(backupPath);
        OlapMetadataBuilder builder = OlapMetadataBuilder.Companion.readFrom(this.RootPath);
        builder.getCubes().clear();
        builder.getCubes().addAll((Collection<CubeEntry>)newBuilder.getCubes());
        builder.save();
        OlapMetadata newOlapMetadata = builder.build();
        this._workspaces.clear();
        this.buildOlapWorkspaces(newOlapMetadata);
        this.olapMetadata = newOlapMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        int n;
        int n2;
        int n3;
        if (this._state != 1) {
            return;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this._stateLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            n = 0;
            if (this._state != 1) {
                return;
            }
            this._state = 4;
            this.gcPool.shutdown();
            Ref.ObjectRef ex = new Ref.ObjectRef();
            ConcurrentHashMap<String, Lazy<CubeWorkspace>> workspaces = this._workspaces;
            boolean bl4 = false;
            List threads = new ArrayList();
            Object object = workspaces;
            boolean bl5 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl6 = false;
                Lazy v = (Lazy)object2.getValue();
                if (!v.isInitialized()) continue;
                threads.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((Lazy<CubeWorkspace>)v, (Ref.ObjectRef<Exception>)ex){
                    final /* synthetic */ Lazy<CubeWorkspace> $v;
                    final /* synthetic */ Ref.ObjectRef<Exception> $ex;
                    {
                        this.$v = $v;
                        this.$ex = $ex;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            ((CubeWorkspace)this.$v.getValue()).close();
                        }
                        catch (Exception vex) {
                            this.$ex.element = vex;
                        }
                    }
                }), (int)31, null));
            }
            for (Thread t2 : threads) {
                t2.join();
            }
            if (this._tempPool.isInitialized()) {
                ((ByteBufferResourcePool)this._tempPool.getValue()).close();
            }
            this.getPlugins().close$bos_olap_core();
            this._state = 5;
            Exception ex2 = (Exception)ex.element;
            if (ex2 != null) {
                throw ex2;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n6 = 0;
            n3 = 0;
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                n = n3++;
                boolean bl7 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final File getFreeSpaceFile() {
        Lazy lazy = this.freeSpaceFile$delegate;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    public final long checkExecuteByFreeSpace() {
        Pair last = this.lastGetSpacePair;
        long currentTime = System.currentTimeMillis();
        if (last == null || ((Number)last.getSecond()).longValue() < 51200L && currentTime - ((Number)last.getFirst()).longValue() > 120000L || ((Number)last.getSecond()).longValue() >= 51200L && currentTime - ((Number)last.getFirst()).longValue() > 1200000L) {
            long freeSpace = this.getFreeSpaceFile().getFreeSpace() / (long)0x100000;
            String reportId = "Out-Of-Disk-Space";
            long l = freeSpace;
            boolean bl = 0L <= l ? l <= 2048L : false;
            if (bl) {
                Object[] objectArray = Res.INSTANCE.getOlapWorkspaceException_3();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.OlapWorkspaceException_3");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{freeSpace / (long)1024};
                HealthReport report = new HealthReport(reportId, null, Res.INSTANCE.format((String)objectArray2, objectArray), HealthReportLevel.Error, ~(PrivilegeType.Read.getCode() | PrivilegeType.SingleCubeBackup.getCode()));
                this.healthReports.commit(report);
            } else {
                boolean bl2 = 2049L <= l ? l <= 5120L : false;
                if (bl2) {
                    Object[] objectArray = Res.INSTANCE.getOlapWorkspaceException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.OlapWorkspaceException_3");
                    Object[] objectArray3 = objectArray;
                    objectArray = new Object[]{freeSpace / (long)1024};
                    HealthReport report = new HealthReport(reportId, null, Res.INSTANCE.format((String)objectArray3, objectArray), HealthReportLevel.Error, PrivilegeType.Compute.getCode() | PrivilegeType.TotalRecovery.getCode() | PrivilegeType.TotalBackup.getCode() | PrivilegeType.SingleCubeRecovery.getCode());
                    this.healthReports.commit(report);
                } else {
                    Pair<Long, Long> lastPair = this.lastGetSpacePair;
                    if (lastPair != null && ((Number)lastPair.getSecond()).longValue() <= 5120L) {
                        this.healthReports.solveById(reportId);
                    }
                }
            }
            this.lastGetSpacePair = last = new Pair((Object)currentTime, (Object)freeSpace);
        }
        return ((Number)last.getSecond()).longValue();
    }

    private static final boolean recoveryOlap$lambda-6(File $noName_0, String fileName) {
        Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
        return StringsKt.endsWith$default((String)fileName, (String)".backup", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ void access$onCubeWorkspaceLoading(OlapWorkspace $this, CubeWorkspaceEventArgs e) {
        $this.onCubeWorkspaceLoading(e);
    }

    public static final /* synthetic */ void access$setOlapMetadata$p(OlapWorkspace $this, OlapMetadata olapMetadata) {
        $this.olapMetadata = olapMetadata;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer/storages/OlapWorkspace$Companion;", "", "()V", "GcTimePeriod", "", "getGcTimePeriod", "()J", "setGcTimePeriod", "(J)V", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public final long getGcTimePeriod() {
            return GcTimePeriod;
        }

        public final void setGcTimePeriod(long l) {
            GcTimePeriod = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandTypes.values().length];
            nArray[CommandTypes.create.ordinal()] = 1;
            nArray[CommandTypes.alter.ordinal()] = 2;
            nArray[CommandTypes.drop.ordinal()] = 3;
            nArray[CommandTypes.repair.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

