/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer.metadata.events.CreateMemberEvent;
import kd.bos.olapServer.metadata.events.MetadataEvent;
import kd.bos.olapServer.storages.CommonCubeMetadataStorage;
import kd.bos.olapServer.storages.ICubeMetadataStorage;
import kd.bos.olapServer.storages.IMetadataDatabase;
import kd.bos.olapServer.storages.PartitionCubeWorkspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\fH\u0096\u0001J\t\u0010\r\u001a\u00020\u000eH\u0096\u0001J\u0015\u0010\u000f\u001a\u00020\u000e2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0096\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u0005H\u0096\u0001\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer/storages/PartitionCubeMetadataStorage;", "Lkd/bos/olapServer/storages/ICubeMetadataStorage;", "Lkd/bos/olapServer/storages/IMetadataDatabase;", "metadataBase", "subCubeWorkspaces", "", "Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "(Lkd/bos/olapServer/storages/IMetadataDatabase;[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;)V", "getMetadataBase", "()Lkd/bos/olapServer/storages/IMetadataDatabase;", "[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "build", "Lkd/bos/olapServer/metadata/Cube;", "close", "", "copyTo", "targetPath", "", "Lkd/bos/olapServer/common/string;", "createWriterContext", "Lkd/bos/olapServer/metadata/builds/IMetadataWriterContext;", "getFileNames", "()[Ljava/lang/String;", "invokeAll", "event", "Lkd/bos/olapServer/metadata/events/MetadataEvent;", "invokeEvent", "bos-olap-core"})
public final class PartitionCubeMetadataStorage
implements ICubeMetadataStorage,
IMetadataDatabase {
    @NotNull
    private final IMetadataDatabase metadataBase;
    @NotNull
    private final PartitionCubeWorkspace[] subCubeWorkspaces;

    public PartitionCubeMetadataStorage(@NotNull IMetadataDatabase metadataBase, @NotNull PartitionCubeWorkspace[] subCubeWorkspaces) {
        Intrinsics.checkNotNullParameter((Object)metadataBase, (String)"metadataBase");
        Intrinsics.checkNotNullParameter((Object)subCubeWorkspaces, (String)"subCubeWorkspaces");
        this.metadataBase = metadataBase;
        this.subCubeWorkspaces = subCubeWorkspaces;
    }

    @NotNull
    public final IMetadataDatabase getMetadataBase() {
        return this.metadataBase;
    }

    @Override
    @NotNull
    public Cube build() {
        return this.metadataBase.build();
    }

    @Override
    public void close() {
        this.metadataBase.close();
    }

    @Override
    public void copyTo(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        this.metadataBase.copyTo(targetPath);
    }

    @Override
    @NotNull
    public IMetadataWriterContext createWriterContext() {
        return this.metadataBase.createWriterContext();
    }

    @Override
    @NotNull
    public String[] getFileNames() {
        return this.metadataBase.getFileNames();
    }

    @Override
    public void invokeEvent(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommonCubeMetadataStorage.INSTANCE.bind(event);
        this.invokeAll(event);
    }

    private final void invokeAll(MetadataEvent event) {
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof CreateMemberEvent) {
            for (PartitionCubeWorkspace subWorkspace : this.subCubeWorkspaces) {
                if (!subWorkspace.getMetadata().getDimensions().contains(((CreateMemberEvent)event).getDimBuilder().getName())) continue;
                subWorkspace.getMetadataStorage().bind(event);
            }
        } else if (metadataEvent instanceof CreateDimensionEvent) {
            for (PartitionCubeWorkspace subWorkspace : this.subCubeWorkspaces) {
                int subRowCount = subWorkspace.getRowCount();
                if (subRowCount <= 0) continue;
                ((CreateDimensionEvent)event).setRowCount(subRowCount);
                subWorkspace.getMetadataStorage().bind(event);
            }
        } else {
            for (PartitionCubeWorkspace subWorkspace : this.subCubeWorkspaces) {
                subWorkspace.getMetadataStorage().bind(event);
            }
        }
        event.invoke();
    }
}

