/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.ICubePartitionMetadata;
import kd.bos.olapServer.metadata.IPartitionItem;
import kd.bos.olapServer.selects.IQuerySession;
import kd.bos.olapServer.selects.PartitionQuerySession;
import kd.bos.olapServer.selects.Query;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.CubeMetadataLock;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.ICubeMetadataLock;
import kd.bos.olapServer.storages.ICubeMetadataStorage;
import kd.bos.olapServer.storages.ICubeWorkspaceProxy;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.IMetadataDatabase;
import kd.bos.olapServer.storages.PartitionCubeMetadataStorage;
import kd.bos.olapServer.storages.PartitionCubeWorkspace;
import kd.bos.olapServer.storages.PartitionInputRowWriter;
import kd.bos.olapServer.transactions.TransactionManager;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tB1\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\n\u0010)\u001a\u00060*j\u0002`+H\u0016J\u0018\u0010,\u001a\u00020-2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/H\u0016J\u0010\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001fH\u0016J\f\u00103\u001a\u000604j\u0002`5H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0016J\u0013\u00109\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\"H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006="}, d2={"Lkd/bos/olapServer/storages/PartitionCubeWorkspaceProxy;", "Lkd/bos/olapServer/storages/ICubeWorkspaceProxy;", "owner", "Lkd/bos/olapServer/storages/CubeWorkspace;", "metadataBase", "Lkd/bos/olapServer/storages/IMetadataDatabase;", "path", "", "Lkd/bos/olapServer/common/string;", "(Lkd/bos/olapServer/storages/CubeWorkspace;Lkd/bos/olapServer/storages/IMetadataDatabase;Ljava/lang/String;)V", "newSubCubeWorkspaces", "", "Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "(Lkd/bos/olapServer/storages/CubeWorkspace;Lkd/bos/olapServer/storages/IMetadataDatabase;Ljava/lang/String;[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;)V", "_metadataStorage", "Lkd/bos/olapServer/storages/PartitionCubeMetadataStorage;", "_owner", "_subCubeWorkspaces", "[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "_tranManager", "Lkd/bos/olapServer/transactions/TransactionManager;", "metadataStorage", "Lkd/bos/olapServer/storages/ICubeMetadataStorage;", "getMetadataStorage", "()Lkd/bos/olapServer/storages/ICubeMetadataStorage;", "transactionManager", "getTransactionManager", "()Lkd/bos/olapServer/transactions/TransactionManager;", "close", "", "createMetadataLock", "Lkd/bos/olapServer/storages/ICubeMetadataLock;", "createPartitionCubeWorkspace", "subMetadata", "Lkd/bos/olapServer/metadata/Cube;", "partitionItem", "Lkd/bos/olapServer/metadata/IPartitionItem;", "createQuerySession", "Lkd/bos/olapServer/selects/IQuerySession;", "query", "Lkd/bos/olapServer/selects/Query;", "isParallel", "", "Lkd/bos/olapServer/common/bool;", "createWriter", "Lkd/bos/olapServer/storages/IInputRowWriter;", "strategy", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "gc", "metadataLock", "getRowCount", "", "Lkd/bos/olapServer/common/long;", "getSubWorkspaces", "", "Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "loadPartitionCubeWorkspace", "()[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "onMetadataUpdated", "newMetadata", "bos-olap-core"})
public final class PartitionCubeWorkspaceProxy
implements ICubeWorkspaceProxy {
    @NotNull
    private final CubeWorkspace _owner;
    @NotNull
    private final String path;
    @NotNull
    private final PartitionCubeWorkspace[] _subCubeWorkspaces;
    @NotNull
    private final PartitionCubeMetadataStorage _metadataStorage;
    @NotNull
    private final TransactionManager _tranManager;

    public PartitionCubeWorkspaceProxy(@NotNull CubeWorkspace owner, @NotNull IMetadataDatabase metadataBase, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)metadataBase, (String)"metadataBase");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this._owner = owner;
        this.path = path;
        this._subCubeWorkspaces = this.loadPartitionCubeWorkspace();
        this._metadataStorage = new PartitionCubeMetadataStorage(metadataBase, this._subCubeWorkspaces);
        this._tranManager = TransactionManager.Companion.createTransactionManager(path);
    }

    private PartitionCubeWorkspaceProxy(CubeWorkspace owner, IMetadataDatabase metadataBase, String path, PartitionCubeWorkspace[] newSubCubeWorkspaces) {
        this._owner = owner;
        this.path = path;
        this._subCubeWorkspaces = newSubCubeWorkspaces;
        this._metadataStorage = new PartitionCubeMetadataStorage(metadataBase, this._subCubeWorkspaces);
        this._tranManager = TransactionManager.Companion.createTransactionManager(path);
    }

    private final PartitionCubeWorkspace[] loadPartitionCubeWorkspace() {
        Cube metadata = this._owner.getMetadata();
        ICubePartitionMetadata partition = metadata.getPartition();
        List<IPartitionItem> partitionItemList = partition.getAllPartitionItems();
        int n = 0;
        int n2 = partitionItemList.size();
        PartitionCubeWorkspace[] partitionCubeWorkspaceArray = new PartitionCubeWorkspace[n2];
        while (n < n2) {
            int n3 = n++;
            IPartitionItem partitionItem = partitionItemList.get(n3);
            partitionCubeWorkspaceArray[n3] = this.createPartitionCubeWorkspace(metadata.getPartitionCubeMetadata(partitionItem), partitionItem);
        }
        return partitionCubeWorkspaceArray;
    }

    private final PartitionCubeWorkspace createPartitionCubeWorkspace(Cube subMetadata, IPartitionItem partitionItem) {
        String[] stringArray = new String[]{partitionItem.getKey()};
        String subPath = ((Object)Paths.INSTANCE.get(this.path, stringArray)).toString();
        return new PartitionCubeWorkspace(subMetadata, subPath, partitionItem);
    }

    @Override
    @NotNull
    public ICubeMetadataLock createMetadataLock() {
        return new CubeMetadataLock();
    }

    @Override
    @NotNull
    public ICubeMetadataStorage getMetadataStorage() {
        return this._metadataStorage;
    }

    @Override
    @NotNull
    public TransactionManager getTransactionManager() {
        return this._tranManager;
    }

    @Override
    @NotNull
    public IInputRowWriter createWriter(@Nullable IAddOrUpdateStrategy<IMeasureValues> strategy) {
        return new PartitionInputRowWriter(this._owner, this._tranManager.beginTransaction(), strategy, this._subCubeWorkspaces);
    }

    @Override
    @NotNull
    public IQuerySession createQuerySession(@NotNull Query query2, boolean isParallel) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        return new PartitionQuerySession(this._owner.getMetadata(), query2, this._subCubeWorkspaces, isParallel);
    }

    @Override
    public long getRowCount() {
        long count = 0L;
        PartitionCubeWorkspace[] $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        PartitionCubeWorkspace[] partitionCubeWorkspaceArray = $this$forEach$iv;
        int n = partitionCubeWorkspaceArray.length;
        for (int i = 0; i < n; ++i) {
            PartitionCubeWorkspace element$iv;
            PartitionCubeWorkspace it = element$iv = partitionCubeWorkspaceArray[i];
            boolean bl = false;
            count += (long)it.getRowCount();
        }
        return count;
    }

    @Override
    public void gc(@NotNull ICubeMetadataLock metadataLock) {
        Intrinsics.checkNotNullParameter((Object)metadataLock, (String)"metadataLock");
        PartitionCubeWorkspace[] $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        PartitionCubeWorkspace[] partitionCubeWorkspaceArray = $this$forEach$iv;
        int n = partitionCubeWorkspaceArray.length;
        for (int i = 0; i < n; ++i) {
            PartitionCubeWorkspace element$iv;
            PartitionCubeWorkspace it = element$iv = partitionCubeWorkspaceArray[i];
            boolean bl = false;
            it.gc(metadataLock);
        }
    }

    @Override
    @NotNull
    public ICubeWorkspaceProxy onMetadataUpdated(@NotNull Cube newMetadata) {
        PartitionCubeWorkspace it;
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        boolean bl = false;
        HashMap currentWorkspaceDict = new HashMap();
        PartitionCubeWorkspace[] $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        PartitionCubeWorkspace[] partitionCubeWorkspaceArray = $this$forEach$iv;
        int n = partitionCubeWorkspaceArray.length;
        for (int i = 0; i < n; ++i) {
            PartitionCubeWorkspace element$iv;
            it = element$iv = partitionCubeWorkspaceArray[i];
            boolean bl2 = false;
            Map map = currentWorkspaceDict;
            String string = it.getPartitionItem().getKey();
            boolean bl3 = false;
            map.put(string, it);
        }
        List<IPartitionItem> newPartitionItems = newMetadata.getPartition().getAllPartitionItems();
        n = newPartitionItems.size();
        PartitionCubeWorkspace[] partitionCubeWorkspaceArray2 = new PartitionCubeWorkspace[n];
        for (int i = 0; i < n; ++i) {
            PartitionCubeWorkspace partitionCubeWorkspace;
            int element$iv = i;
            IPartitionItem partitionItem = newPartitionItems.get(element$iv);
            PartitionCubeWorkspace workspace = (PartitionCubeWorkspace)currentWorkspaceDict.remove(partitionItem.getKey());
            if (workspace == null) {
                partitionCubeWorkspace = this.createPartitionCubeWorkspace(newMetadata.getPartitionCubeMetadata(partitionItem), partitionItem);
            } else {
                workspace.onMetadataUpdated(newMetadata.getPartitionCubeMetadata(partitionItem), partitionItem);
                partitionCubeWorkspace = workspace;
            }
            partitionCubeWorkspaceArray2[element$iv] = partitionCubeWorkspace;
        }
        PartitionCubeWorkspace[] newSubCubeWorkspaces = partitionCubeWorkspaceArray2;
        Collection collection = currentWorkspaceDict.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"currentWorkspaceDict.values");
        Iterable $this$forEach$iv2 = collection;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (PartitionCubeWorkspace)element$iv;
            boolean bl4 = false;
            it.close();
        }
        return new PartitionCubeWorkspaceProxy(this._owner, this._metadataStorage.getMetadataBase(), this.path, newSubCubeWorkspaces);
    }

    @Override
    @NotNull
    public Iterator<AbstractCubeWorkspace> getSubWorkspaces() {
        return ArrayIteratorKt.iterator((Object[])this._subCubeWorkspaces);
    }

    @Override
    public void close() {
        PartitionCubeWorkspace[] $this$forEach$iv = this._subCubeWorkspaces;
        boolean $i$f$forEach = false;
        PartitionCubeWorkspace[] partitionCubeWorkspaceArray = $this$forEach$iv;
        int n = partitionCubeWorkspaceArray.length;
        for (int i = 0; i < n; ++i) {
            PartitionCubeWorkspace element$iv;
            PartitionCubeWorkspace it = element$iv = partitionCubeWorkspaceArray[i];
            boolean bl = false;
            it.close();
        }
    }
}

