/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.Closeable;
import kd.bos.olapServer.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer.collections.IMutableDictionaryObserver;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataEntities.IInputRow;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.dataEntities.IMeasureValuesKt;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.EmptyPartitionItem;
import kd.bos.olapServer.metadata.IPartitionItem;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.EmptyDimensionKeys;
import kd.bos.olapServer.storages.ICubeDataObserver;
import kd.bos.olapServer.storages.ICubeDataObserverContext;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.InputRowList;
import kd.bos.olapServer.storages.MarkDimensionKeys;
import kd.bos.olapServer.storages.PartitionCubeWorkspace;
import kd.bos.olapServer.storages.RowIndexUtil;
import kd.bos.olapServer.storages.UnMarkDimensionKeys;
import kd.bos.olapServer.storages.plugins.InputRowWriterCreatingEventArgs;
import kd.bos.olapServer.transactions.ITransaction;
import kd.bos.olapServer.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B3\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ$\u0010?\u001a\u00020@2\n\u0010A\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0018\u0010?\u001a\u00020@2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0005H\u0016J\u001c\u0010D\u001a\u00060Ej\u0002`F2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0005H\u0016J\b\u0010H\u001a\u00020@H\u0016J\b\u0010I\u001a\u00020@H\u0016J\u0014\u0010J\u001a\u00020\u001c2\n\u0010K\u001a\u00060\u0011j\u0002`\u0012H\u0002J\u0010\u0010J\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020\u0004H\u0002J$\u0010L\u001a\u00020@2\n\u0010M\u001a\u00060\u0011j\u0002`N2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0005H\u0016J$\u0010O\u001a\u00020@2\n\u0010P\u001a\u00060\u0011j\u0002`N2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0005H\u0016J\u001e\u0010Q\u001a\u00020\u000e2\n\u0010K\u001a\u00060\u0011j\u0002`\u00122\b\u0010R\u001a\u0004\u0018\u00010\u001cH\u0002J(\u0010S\u001a\u00020@2\n\u0010A\u001a\u00060\u0011j\u0002`\u00122\n\u0010T\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010C\u001a\u00020\u0005H\u0016J\u001c\u0010S\u001a\u00020@2\n\u0010T\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010C\u001a\u00020\u0005H\u0016R\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00060\u0011j\u0002`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001aR\u0014\u0010+\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0015\u0010.\u001a\u00020/8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0018\u00102\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001aR\u000e\u00104\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00107R\u0018\u00108\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010(R\u0018\u0010:\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010(R\u000e\u0010<\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010=\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010(\u00a8\u0006U"}, d2={"Lkd/bos/olapServer/storages/PartitionInputRowWriter;", "Lkd/bos/olapServer/storages/IInputRowWriter;", "Lkd/bos/olapServer/storages/ICubeDataObserverContext;", "Lkd/bos/olapServer/collections/IMutableDictionaryObserver;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "_tran", "Lkd/bos/olapServer/transactions/ITransaction;", "strategy", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "subCubeWorkspaces", "", "Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "(Lkd/bos/olapServer/storages/CubeWorkspace;Lkd/bos/olapServer/transactions/ITransaction;Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;)V", "_index", "", "Lkd/bos/olapServer/common/int;", "_lockTime", "", "Lkd/bos/olapServer/common/long;", "creatingEventArgs", "Lkd/bos/olapServer/storages/plugins/InputRowWriterCreatingEventArgs;", "cubeId", "getCubeId", "()I", "currentInputRowList", "Lkd/bos/olapServer/storages/InputRowList;", "currentLock", "Ljava/io/Closeable;", "currentMarkKey", "Lkd/bos/olapServer/storages/MarkDimensionKeys;", "currentObserver", "Lkd/bos/olapServer/storages/ICubeDataObserver;", "currentPartitionItem", "Lkd/bos/olapServer/metadata/IPartitionItem;", "currentPartitionPosition", "globalIndex", "getGlobalIndex", "()J", "index", "getIndex", "keyInPartition", "getKeyInPartition", "()Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "metadata", "Lkd/bos/olapServer/metadata/Cube;", "getMetadata", "()Lkd/bos/olapServer/metadata/Cube;", "partitionId", "getPartitionId", "partitionWriteCount", "getStrategy", "()Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "tid", "getTid", "transactionId", "getTransactionId", "writeCount", "writeLockTime", "getWriteLockTime", "add", "", "partionId", "key", "values", "addOrUpdate", "", "Lkd/bos/olapServer/common/bool;", "value", "close", "force", "getSubInputRowList", "partitionPosition", "onAdded", "addIndex", "Lkd/bos/olapServer/common/idx;", "onUpdated", "updateIndex", "switchLock", "inputRowList", "update", "rowIndex", "bos-olap-core"})
public final class PartitionInputRowWriter
implements IInputRowWriter,
ICubeDataObserverContext,
IMutableDictionaryObserver<IDimensionKeys, IMeasureValues> {
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final ITransaction _tran;
    @Nullable
    private final IAddOrUpdateStrategy<IMeasureValues> strategy;
    @NotNull
    private final PartitionCubeWorkspace[] subCubeWorkspaces;
    @NotNull
    private final InputRowWriterCreatingEventArgs creatingEventArgs;
    private long _lockTime;
    @Nullable
    private Closeable currentLock;
    @Nullable
    private InputRowList currentInputRowList;
    private int currentPartitionPosition;
    @NotNull
    private IPartitionItem currentPartitionItem;
    @Nullable
    private ICubeDataObserver currentObserver;
    @NotNull
    private MarkDimensionKeys currentMarkKey;
    private int partitionWriteCount;
    private long writeCount;
    private int _index;

    public PartitionInputRowWriter(@NotNull CubeWorkspace cubeWorkspace, @NotNull ITransaction _tran, @Nullable IAddOrUpdateStrategy<IMeasureValues> strategy, @NotNull PartitionCubeWorkspace[] subCubeWorkspaces) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)_tran, (String)"_tran");
        Intrinsics.checkNotNullParameter((Object)subCubeWorkspaces, (String)"subCubeWorkspaces");
        this.cubeWorkspace = cubeWorkspace;
        this._tran = _tran;
        this.strategy = strategy;
        this.subCubeWorkspaces = subCubeWorkspaces;
        this.creatingEventArgs = new InputRowWriterCreatingEventArgs(this);
        this.currentPartitionPosition = -1;
        this.currentPartitionItem = EmptyPartitionItem.INSTANCE;
        PartitionInputRowWriter this_$iv = this;
        boolean $i$f$getMetadata = false;
        this.currentMarkKey = new MarkDimensionKeys(this_$iv.cubeWorkspace.getMetadata(), EmptyDimensionKeys.INSTANCE);
        this.cubeWorkspace.getInputRowWriterCreating().invoke(this.cubeWorkspace.getPlugins().getContext(), this.creatingEventArgs);
        this.currentObserver = this.creatingEventArgs.createCubeDataObserver$bos_olap_core();
        this._index = -1;
    }

    @Override
    @Nullable
    public IAddOrUpdateStrategy<IMeasureValues> getStrategy() {
        return this.strategy;
    }

    private final Cube getMetadata() {
        boolean $i$f$getMetadata = false;
        return this.cubeWorkspace.getMetadata();
    }

    private final InputRowList getSubInputRowList(IDimensionKeys key) {
        PartitionInputRowWriter this_$iv = this;
        boolean $i$f$getMetadata = false;
        int partitionPosition = this_$iv.cubeWorkspace.getMetadata().getPartition().getPartitionPosition(key);
        InputRowList inputRowList = this.getSubInputRowList(partitionPosition);
        boolean bl = false;
        boolean bl2 = false;
        InputRowList it = inputRowList;
        boolean bl3 = false;
        this.currentMarkKey.setBaseKeys(key);
        return inputRowList;
    }

    private final InputRowList getSubInputRowList(int partitionPosition) {
        InputRowList result;
        InputRowList inputRowList;
        InputRowList inputRowList2 = this.currentInputRowList;
        if (partitionPosition == this.currentPartitionPosition && inputRowList2 != null) {
            inputRowList = inputRowList2;
        } else {
            PartitionCubeWorkspace newSubCubeWorkspace = this.switchLock(partitionPosition, inputRowList2);
            this.currentPartitionPosition = partitionPosition;
            this.currentMarkKey = new MarkDimensionKeys(newSubCubeWorkspace.getMetadata(), EmptyDimensionKeys.INSTANCE);
            this.currentPartitionItem = newSubCubeWorkspace.getPartitionItem();
            InputRowList inputRowList3 = newSubCubeWorkspace.getInputRowList();
            boolean bl = false;
            boolean bl2 = false;
            InputRowList it = inputRowList3;
            boolean bl3 = false;
            this.currentInputRowList = it;
            inputRowList = result = inputRowList3;
        }
        if (this.partitionWriteCount >= 500000) {
            this.switchLock(partitionPosition, result);
        }
        return result;
    }

    private final PartitionCubeWorkspace switchLock(int partitionPosition, InputRowList inputRowList) {
        Object object = this;
        ((PartitionInputRowWriter)object).writeCount += (long)this.partitionWriteCount;
        object = inputRowList;
        if (object != null) {
            ((InputRowList)object).force();
        }
        if (this.currentPartitionPosition >= 0 && this.partitionWriteCount > 0) {
            object = this.currentObserver;
            if (object != null) {
                object.onForcePartition();
            }
            this.partitionWriteCount = 0;
        }
        if ((object = this.currentLock) != null) {
            object.close();
        }
        PartitionCubeWorkspace newSubCubeWorkspace = this.subCubeWorkspaces[partitionPosition];
        PartitionInputRowWriter partitionInputRowWriter = this;
        boolean $i$f$measureNanoTime = false;
        boolean bl = false;
        long start$iv = System.nanoTime();
        long l = partitionInputRowWriter._lockTime;
        PartitionInputRowWriter partitionInputRowWriter2 = partitionInputRowWriter;
        boolean bl2 = false;
        this.currentLock = newSubCubeWorkspace.getDataLock().getWriteLock();
        Unit unit = Unit.INSTANCE;
        partitionInputRowWriter2._lockTime = l + (System.nanoTime() - start$iv);
        return newSubCubeWorkspace;
    }

    @Override
    public boolean addOrUpdate(@NotNull IDimensionKeys key, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        PartitionInputRowWriter observer = this.currentObserver == null ? null : this;
        return this.getSubInputRowList(key).addOrUpdate(this.currentMarkKey, value2, this.getStrategy(), (IMutableDictionaryObserver<IDimensionKeys, IMeasureValues>)observer) < 0;
    }

    @Override
    public void add(@NotNull IDimensionKeys key, @NotNull IMeasureValues values) {
        int n;
        int canAdd;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Object object = this.getStrategy();
        int n2 = canAdd = object == null ? 1 : (n = object.canAdd());
        if (canAdd != 0) {
            this._index = this.getSubInputRowList(key).add$bos_olap_core(this.currentMarkKey, values);
            object = this;
            n = ((PartitionInputRowWriter)object).partitionWriteCount;
            ((PartitionInputRowWriter)object).partitionWriteCount = n + 1;
            object = this.currentObserver;
            if (object != null) {
                object.onAdded(key, values);
            }
        }
    }

    @Override
    public void update(long rowIndex, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int index2 = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex);
        InputRowList inputRowList = this.getSubInputRowList(RowIndexUtil.INSTANCE.getPartitionPosition(rowIndex));
        IMeasureValues newValues = this.getStrategy() != null && this.getStrategy().getSupportModifiedValue() ? this.getStrategy().modifiedValue(inputRowList.getMeasureValues(index2), values) : values;
        IDimensionKeys key = inputRowList.update$bos_olap_core(index2, newValues);
        ICubeDataObserver iCubeDataObserver = this.currentObserver;
        if (iCubeDataObserver != null) {
            ICubeDataObserver iCubeDataObserver2 = iCubeDataObserver;
            boolean bl = false;
            boolean bl2 = false;
            ICubeDataObserver $this$update_u24lambda_u2d3 = iCubeDataObserver2;
            boolean bl3 = false;
            if (!IMeasureValuesKt.allValuesIsUndefined(newValues)) {
                this._index = index2;
                this.currentMarkKey.setBaseKeys(new UnMarkDimensionKeys(this.cubeWorkspace.getMetadata(), this.currentPartitionItem, key));
                PartitionInputRowWriter partitionInputRowWriter = this;
                int n = partitionInputRowWriter.partitionWriteCount;
                partitionInputRowWriter.partitionWriteCount = n + 1;
                $this$update_u24lambda_u2d3.onUpdated(this.currentMarkKey.getBaseKeys(), newValues);
            }
        }
    }

    @Override
    public void add(int partionId, @NotNull IDimensionKeys key, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.getSubInputRowList(partionId).add$bos_olap_core(key, values);
    }

    @Override
    public void update(int partionId, int rowIndex, @NotNull IMeasureValues values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.getSubInputRowList(partionId).update$bos_olap_core(rowIndex, values);
    }

    @Override
    public void onAdded(int addIndex, @NotNull IDimensionKeys key, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ICubeDataObserver iCubeDataObserver = this.currentObserver;
        if (iCubeDataObserver != null) {
            ICubeDataObserver iCubeDataObserver2 = iCubeDataObserver;
            boolean bl = false;
            boolean bl2 = false;
            ICubeDataObserver $this$onAdded_u24lambda_u2d4 = iCubeDataObserver2;
            boolean bl3 = false;
            this._index = addIndex;
            PartitionInputRowWriter partitionInputRowWriter = this;
            int n = partitionInputRowWriter.partitionWriteCount;
            partitionInputRowWriter.partitionWriteCount = n + 1;
            $this$onAdded_u24lambda_u2d4.onAdded(this.currentMarkKey.getBaseKeys(), value2);
        }
    }

    @Override
    public void onUpdated(int updateIndex, @NotNull IDimensionKeys key, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ICubeDataObserver iCubeDataObserver = this.currentObserver;
        if (iCubeDataObserver != null) {
            ICubeDataObserver iCubeDataObserver2 = iCubeDataObserver;
            boolean bl = false;
            boolean bl2 = false;
            ICubeDataObserver $this$onUpdated_u24lambda_u2d5 = iCubeDataObserver2;
            boolean bl3 = false;
            if (!IMeasureValuesKt.allValuesIsUndefined(value2)) {
                this._index = updateIndex;
                PartitionInputRowWriter partitionInputRowWriter = this;
                int n = partitionInputRowWriter.partitionWriteCount;
                partitionInputRowWriter.partitionWriteCount = n + 1;
                $this$onUpdated_u24lambda_u2d5.onUpdated(this.currentMarkKey.getBaseKeys(), value2);
            }
        }
    }

    @Override
    public int getCubeId() {
        return this.cubeWorkspace.getCubeId();
    }

    @Override
    public long getTid() {
        return this._tran.getVersion().getId();
    }

    @Override
    public int getPartitionId() {
        return this.currentPartitionPosition;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public long getGlobalIndex() {
        return RowIndexUtil.INSTANCE.getRowIndex(this.currentPartitionPosition, this._index);
    }

    @Override
    @NotNull
    public IDimensionKeys getKeyInPartition() {
        return this.currentMarkKey;
    }

    @Override
    public void force() {
        Object object = this.currentInputRowList;
        if (object != null) {
            ((InputRowList)object).force();
        }
        object = this.currentObserver;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$force_u24lambda_u2d6 = object2;
            boolean bl3 = false;
            PartitionInputRowWriter partitionInputRowWriter = this;
            partitionInputRowWriter.writeCount += (long)this.partitionWriteCount;
            if (this.writeCount > 0L) {
                if (this.partitionWriteCount > 0) {
                    $this$force_u24lambda_u2d6.onForcePartition();
                    this.partitionWriteCount = 0;
                }
                $this$force_u24lambda_u2d6.onForce();
            }
        }
        this._tran.commit();
    }

    @Override
    public void close() {
        Closeable closeable = this.currentLock;
        if (closeable != null) {
            closeable.close();
        }
        if (this._tran.getState() == TransactionStatus.Active) {
            this._tran.rollback();
        }
    }

    @Override
    public long getWriteLockTime() {
        return this._lockTime;
    }

    @Override
    public long getTransactionId() {
        return this._tran.getVersion().getId();
    }

    @Override
    public boolean addOrUpdate(@NotNull IInputRow row) {
        return IInputRowWriter.DefaultImpls.addOrUpdate(this, row);
    }
}

