/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.Closeable;
import java.util.Arrays;
import java.util.UUID;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IMutableList;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.storages.IMutableFixedNumberMap;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\r2\n\u0010\u0017\u001a\u00060\nj\u0002`\u0018H\u0002J\u0018\u0010\u0019\u001a\u00060\nj\u0002`\u00182\n\u0010\u001a\u001a\u00060\nj\u0002`\u0018H\u0016J\u0018\u0010\u001b\u001a\u00060\nj\u0002`\u00182\n\u0010\u0017\u001a\u00060\nj\u0002`\u0018H\u0016J\u0018\u0010\u001c\u001a\u00060\nj\u0002`\u00182\n\u0010\u001a\u001a\u00060\nj\u0002`\u0018H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer/storages/Position2NumberMap;", "Lkd/bos/olapServer/storages/IMutableFixedNumberMap;", "Lkd/bos/olapServer/collections/IDataContainer;", "uuidSeq", "Lkd/bos/olapServer/collections/IMutableList;", "Ljava/util/UUID;", "members", "Lkd/bos/olapServer/metadata/MemberCollection;", "(Lkd/bos/olapServer/collections/IMutableList;Lkd/bos/olapServer/metadata/MemberCollection;)V", "fix2PosMapSize", "", "number2PosMap", "", "Lkd/bos/olapServer/metadata/Member;", "[Lkd/bos/olapServer/metadata/Member;", "pos2FixMap", "", "add", "", "memberUUID", "close", "force", "getMemberByFixedNumber", "fixedNumber", "Lkd/bos/olapServer/common/int;", "getOrCreateFixedNumber", "position", "getPositionByFixedNumber", "tryGetFixedNumberByPosition", "bos-olap-core"})
public final class Position2NumberMap
implements IMutableFixedNumberMap,
IDataContainer {
    @NotNull
    private final IMutableList<UUID> uuidSeq;
    @NotNull
    private final MemberCollection members;
    @NotNull
    private Member[] number2PosMap;
    private int fix2PosMapSize;
    @NotNull
    private final int[] pos2FixMap;

    public Position2NumberMap(@NotNull IMutableList<UUID> uuidSeq, @NotNull MemberCollection members2) {
        Intrinsics.checkNotNullParameter(uuidSeq, (String)"uuidSeq");
        Intrinsics.checkNotNullParameter((Object)members2, (String)"members");
        this.uuidSeq = uuidSeq;
        this.members = members2;
        this.number2PosMap = new Member[0];
        int n = 0;
        int n2 = this.members.getCount();
        int[] nArray = new int[n2];
        Position2NumberMap position2NumberMap = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = -1;
        }
        position2NumberMap.pos2FixMap = nArray;
        this.number2PosMap = new Member[this.uuidSeq.getCount() + 1];
        this.add(Member.Companion.getNull_ID());
        n = 0;
        n2 = this.uuidSeq.getCount();
        if (n < n2) {
            do {
                int i = n++;
                UUID id = (UUID)this.uuidSeq.get(i);
                if (Intrinsics.areEqual((Object)Member.Companion.getNull_ID(), (Object)id)) continue;
                this.add(id);
            } while (n < n2);
        }
    }

    private final void add(UUID memberUUID) {
        int n;
        Object object;
        Member member = this.members.tryGet(memberUUID);
        if (member != null) {
            if (this.pos2FixMap[member.getPosition$bos_olap_core()] == -1) {
                this.pos2FixMap[member.getPosition$bos_olap_core()] = this.fix2PosMapSize;
            } else {
                Object[] objectArray = Res.INSTANCE.getPosition2NumberMapException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.Position2NumberMapException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{memberUUID};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
        }
        if (this.fix2PosMapSize >= this.number2PosMap.length) {
            object = this.number2PosMap;
            n = this.fix2PosMapSize + 16;
            boolean bl = false;
            Member[] memberArray = Arrays.copyOf(object, n);
            Intrinsics.checkNotNullExpressionValue((Object)memberArray, (String)"java.util.Arrays.copyOf(this, newSize)");
            this.number2PosMap = memberArray;
        }
        object = this;
        n = object.fix2PosMapSize;
        object.fix2PosMapSize = n + 1;
        this.number2PosMap[n] = member;
    }

    private final Member getMemberByFixedNumber(int fixedNumber) {
        boolean bl = 0 <= fixedNumber ? fixedNumber < this.fix2PosMapSize : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "fixedNumber=" + fixedNumber + ",number2PosMap.size=" + this.fix2PosMapSize;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.number2PosMap[fixedNumber];
    }

    @Override
    public int getPositionByFixedNumber(int fixedNumber) {
        int n;
        Member member = this.getMemberByFixedNumber(fixedNumber);
        return member == null ? -1 : (n = member.getPosition$bos_olap_core());
    }

    @Override
    public int getOrCreateFixedNumber(int position) {
        int n;
        int fixedNumber = this.pos2FixMap[position];
        if (fixedNumber < 0) {
            Member member = (Member)this.members.get(position);
            this.uuidSeq.add(member.getID());
            this.add(member.getID());
            n = this.pos2FixMap[position];
        } else {
            n = fixedNumber;
        }
        return n;
    }

    @Override
    public int tryGetFixedNumberByPosition(int position) {
        return (0 <= position ? position < this.pos2FixMap.length : false) ? this.pos2FixMap[position] : -1;
    }

    @Override
    public void force() {
        IDataContainer iDataContainer;
        IMutableList<UUID> iMutableList = this.uuidSeq;
        IDataContainer iDataContainer2 = iDataContainer = iMutableList instanceof IDataContainer ? (IDataContainer)((Object)iMutableList) : null;
        if (iDataContainer != null) {
            iDataContainer.force();
        }
    }

    @Override
    public void close() {
        Closeable closeable;
        IMutableList<UUID> iMutableList = this.uuidSeq;
        Closeable closeable2 = closeable = iMutableList instanceof Closeable ? (Closeable)((Object)iMutableList) : null;
        if (closeable != null) {
            closeable.close();
        }
    }
}

