/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.olapServer.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer.collections.NumberToElementMap;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.common.OlapContext;
import kd.bos.olapServer.common.ParallelTaskManager;
import kd.bos.olapServer.computingEngine.AggShieldRuleFilterBuilder;
import kd.bos.olapServer.computingEngine.AlwaysTrueDimensionKeysFilter;
import kd.bos.olapServer.computingEngine.IDimensionKeysFilter;
import kd.bos.olapServer.computingEngine.StoredFilter;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.dataEntities.InputRow;
import kd.bos.olapServer.dataSources.ArrayJsonReader;
import kd.bos.olapServer.dataSources.FixedDimension;
import kd.bos.olapServer.dataSources.IntStringPair;
import kd.bos.olapServer.dataSources.SaveCommandInfo;
import kd.bos.olapServer.dataSources.SaveCommandInfoV1;
import kd.bos.olapServer.dataSources.SaveCommandInfoV2;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.DimensionCollection;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.MeasureCollection;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.OlapDataTypes;
import kd.bos.olapServer.performanceStatistics.CommandContext;
import kd.bos.olapServer.performanceStatistics.CommandExecuteState;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.tools.Res;
import kd.olap.fel.common.OperateUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 -2\u00020\u0001:\u0006-./012B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020!0 2\n\u0010*\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0006\u0010+\u001a\u00020,R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 \u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkd/bos/olapServer/storages/SaveCommandExecutor;", "", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "saveCommandInfo", "Lkd/bos/olapServer/dataSources/SaveCommandInfo;", "reader", "Ljava/io/BufferedReader;", "(Lkd/bos/olapServer/storages/CubeWorkspace;Lkd/bos/olapServer/dataSources/SaveCommandInfo;Ljava/io/BufferedReader;)V", "dataValuesList", "", "", "(Lkd/bos/olapServer/storages/CubeWorkspace;Lkd/bos/olapServer/dataSources/SaveCommandInfo;Ljava/util/Iterator;)V", "_resultCount", "", "commandContext", "Lkd/bos/olapServer/performanceStatistics/CommandContext;", "dimArray", "Lkd/bos/olapServer/metadata/Dimension;", "[Lkd/bos/olapServer/metadata/Dimension;", "dimSize", "", "Lkd/bos/olapServer/common/int;", "dims", "Lkd/bos/olapServer/metadata/DimensionCollection;", "meaArray", "Lkd/bos/olapServer/metadata/Measure;", "[Lkd/bos/olapServer/metadata/Measure;", "meas", "Lkd/bos/olapServer/metadata/MeasureCollection;", "measureSize", "numberToMemberMaps", "Lkd/bos/olapServer/collections/NumberToElementMap;", "Lkd/bos/olapServer/metadata/Member;", "[Lkd/bos/olapServer/collections/NumberToElementMap;", "row", "Lkd/bos/olapServer/dataEntities/InputRow;", "storedFilter", "Lkd/bos/olapServer/computingEngine/StoredFilter;", "validFilter", "Lkd/bos/olapServer/computingEngine/IDimensionKeysFilter;", "getNumberToMemberMap", "dimIndex", "write", "", "Companion", "DataValuesIteratorV1", "DataValuesIteratorV2", "DataValuesIteratorV3", "IncrementStrategy", "SaveStrategy", "bos-olap-core"})
public final class SaveCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final SaveCommandInfo saveCommandInfo;
    @NotNull
    private final Iterator<Object[]> dataValuesList;
    @NotNull
    private final InputRow row;
    private final int dimSize;
    @NotNull
    private final DimensionCollection dims;
    @NotNull
    private final Dimension[] dimArray;
    private final int measureSize;
    @NotNull
    private final MeasureCollection meas;
    @NotNull
    private final Measure[] meaArray;
    @Nullable
    private final StoredFilter storedFilter;
    @NotNull
    private final IDimensionKeysFilter validFilter;
    @Nullable
    private NumberToElementMap<Member>[] numberToMemberMaps;
    @Nullable
    private CommandContext commandContext;
    private long _resultCount;

    public SaveCommandExecutor(@NotNull CubeWorkspace cubeWorkspace, @NotNull SaveCommandInfo saveCommandInfo, @NotNull Iterator<Object[]> dataValuesList) {
        int n;
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)saveCommandInfo, (String)"saveCommandInfo");
        Intrinsics.checkNotNullParameter(dataValuesList, (String)"dataValuesList");
        this.cubeWorkspace = cubeWorkspace;
        this.saveCommandInfo = saveCommandInfo;
        this.dataValuesList = dataValuesList;
        this.commandContext = OlapContext.Companion.tryGetContext(CommandContext.class);
        Cube metadata = this.cubeWorkspace.getMetadata();
        this.row = new InputRow(metadata);
        this.dimSize = this.saveCommandInfo.getDimensions().size();
        this.dims = metadata.getDimensions();
        int allDimSize = metadata.getDimensions().getCount();
        int n2 = 0;
        int n3 = this.dimSize;
        Object object = new Dimension[n3];
        SaveCommandExecutor saveCommandExecutor = this;
        while (n2 < n3) {
            n = n2++;
            object[n] = (Dimension)this.dims.get(this.saveCommandInfo.getDimensions().get(n));
        }
        saveCommandExecutor.dimArray = object;
        this.measureSize = this.saveCommandInfo.getMeasures().size();
        if (this.measureSize <= 0) {
            String string = Res.INSTANCE.getSaveCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.SaveCommandExecutorException_1");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        this.meas = this.cubeWorkspace.getMetadata().getMeasures();
        n2 = 0;
        n3 = this.measureSize;
        object = new Measure[n3];
        saveCommandExecutor = this;
        while (n2 < n3) {
            n = n2++;
            object[n] = (Measure)this.meas.get(this.saveCommandInfo.getMeasures().get(n));
        }
        saveCommandExecutor.meaArray = object;
        HashSet<Object> dimSet = new HashSet<Object>();
        AggShieldRuleFilterBuilder builder = new AggShieldRuleFilterBuilder(this.cubeWorkspace.getMetadata());
        for (FixedDimension fixDim : this.saveCommandInfo.getFixedDimensions()) {
            String name2 = fixDim.getName();
            Dimension dimension = (Dimension)this.dims.get(name2);
            Member member = (Member)dimension.getMembers().get(fixDim.getValue());
            if (!dimSet.add(dimension)) {
                Object[] objectArray = Res.INSTANCE.getSaveCommandExecutorException_2();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.SaveCommandExecutorException_2");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{name2};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
            builder.scanForSave(dimension, member);
            this.row.setDimensionValue(name2, fixDim.getValue());
        }
        for (String dim : this.saveCommandInfo.getDimensions()) {
            if (dimSet.add(this.dims.get(dim))) continue;
            Object[] objectArray = Res.INSTANCE.getSaveCommandExecutorException_3();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.SaveCommandExecutorException_3");
            Object[] objectArray3 = objectArray;
            objectArray = new Object[]{dim};
            throw Res.INSTANCE.getRuntimeException((String)objectArray3, objectArray);
        }
        if (dimSet.size() != allDimSize) {
            object = Res.INSTANCE.getSaveCommandExecutorException_4();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Res.SaveCommandExecutorException_4");
            Object object2 = object;
            object = new Object[]{allDimSize};
            throw Res.INSTANCE.getRuntimeException((String)object2, (Object[])object);
        }
        this.storedFilter = CommonTypesKt.getDynamicCalcEnabled() ? builder.getStoredFilter() : null;
        this.validFilter = this.cubeWorkspace.getMetadata().getValidDataRules().getValidFilter();
    }

    public SaveCommandExecutor(@NotNull CubeWorkspace cubeWorkspace, @NotNull SaveCommandInfo saveCommandInfo, @NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)saveCommandInfo, (String)"saveCommandInfo");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this(cubeWorkspace, saveCommandInfo, SaveCommandExecutor.Companion.createDataValuesIterator(cubeWorkspace.getMetadata(), saveCommandInfo, reader));
    }

    private final NumberToElementMap<Member> getNumberToMemberMap(int dimIndex) {
        NumberToElementMap<Member>[] maps = this.numberToMemberMaps;
        if (maps == null) {
            int n = 0;
            int n2 = this.dimSize;
            NumberToElementMap[] numberToElementMapArray = new NumberToElementMap[n2];
            while (n < n2) {
                int n3 = n++;
                Dimension dim = this.dimArray[n3];
                numberToElementMapArray[n3] = new NumberToElementMap((Function1)new Function1<String, Member>(dim){
                    final /* synthetic */ Dimension $dim;
                    {
                        this.$dim = $dim;
                        super(1);
                    }

                    @NotNull
                    public final Member invoke(@NotNull String memberName) {
                        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
                        return (Member)this.$dim.getMembers().get(memberName);
                    }
                });
            }
            this.numberToMemberMaps = maps = numberToElementMapArray;
        }
        return maps[dimIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write() {
        CommandContext commandContext = this.commandContext;
        if (commandContext != null) {
            commandContext.setState(CommandExecuteState.Companion.getSelectCount(), 0L);
        }
        long exitQueryLockTime = System.nanoTime();
        CommandContext commandContext2 = this.commandContext;
        if (commandContext2 != null) {
            commandContext2.setTimeState(CommandExecuteState.Companion.getExitQueryLock(), exitQueryLockTime);
        }
        IAddOrUpdateStrategy saveStrategy = this.saveCommandInfo.isIncrement() ? (IAddOrUpdateStrategy)new IncrementStrategy(this.row, this.meaArray, this.meas.getCount()) : (IAddOrUpdateStrategy)new SaveStrategy(this.row, this.meaArray);
        Closeable closeable = this.cubeWorkspace.createWriter(saveStrategy);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Unit unit;
            int n;
            Object values;
            int n2;
            IInputRowWriter writer = (IInputRowWriter)closeable;
            boolean bl3 = false;
            try {
                Unit unit2;
                IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
                Iterator<Object[]> iterator = this.dataValuesList;
                n2 = 0;
                Object object = iterator;
                while (object.hasNext()) {
                    boolean validFilterMatch;
                    values = object.next();
                    if (!continueToken.canContinue()) break;
                    if (this.dimSize + this.measureSize != ((Object[])values).length) {
                        Object[] objectArray = Res.INSTANCE.getSaveCommandExecutorException_5();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.SaveCommandExecutorException_5");
                        Object[] objectArray2 = objectArray;
                        objectArray = new Object[]{this.dimSize, this.measureSize, ((Object[])values).length};
                        throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                    }
                    n2 = 0;
                    n = this.measureSize;
                    if (n2 < n) {
                        do {
                            int it = n2++;
                            this.row.setMeasureValue(this.meaArray[it], values[it]);
                        } while (n2 < n);
                    }
                    if ((n2 = 0) < (n = this.dimSize)) {
                        do {
                            int i = n2++;
                            Dimension dim = this.dimArray[i];
                            Object value2 = values[this.measureSize + i];
                            Object object2 = value2;
                            if (object2 instanceof Integer) {
                                this.row.setDimensionValue(dim, this.getNumberToMemberMap(i).map(((Number)value2).intValue()));
                                continue;
                            }
                            if (object2 instanceof IntStringPair) {
                                this.row.setDimensionValue(dim, this.getNumberToMemberMap(i).map(((IntStringPair)value2).getNumber(), ((IntStringPair)value2).getValue()));
                                continue;
                            }
                            if (object2 instanceof String) {
                                this.row.setDimensionValue(dim, (Member)dim.getMembers().get((String)value2));
                                continue;
                            }
                            if (object2 instanceof Member) {
                                this.row.setDimensionValue(dim, (Member)value2);
                                continue;
                            }
                            throw new NotSupportedException();
                        } while (n2 < n);
                    }
                    boolean storedMatch = this.storedFilter == null || this.storedFilter.match(this.row.getKeys());
                    boolean bl4 = validFilterMatch = this.validFilter == AlwaysTrueDimensionKeysFilter.INSTANCE || this.validFilter.match(this.row.getKeys());
                    if (storedMatch) {
                        if (validFilterMatch) {
                            writer.addOrUpdate(this.row.getKeys(), this.row.getValues());
                            SaveCommandExecutor i = this;
                            long l = i._resultCount;
                            i._resultCount = l + 1L;
                            continue;
                        }
                        if (!this.saveCommandInfo.getDisallowInvalidData()) continue;
                        Object[] i = Res.INSTANCE.getSaveCommandExecutorException_9();
                        Intrinsics.checkNotNullExpressionValue((Object)i, (String)"Res.SaveCommandExecutorException_9");
                        Object[] objectArray = i;
                        i = new Object[]{this.row};
                        throw Res.INSTANCE.getRuntimeException((String)objectArray, i);
                    }
                    if (this.saveCommandInfo.getDisallowDynamicData()) {
                        Object[] i = Res.INSTANCE.getSaveCommandExecutorException_8();
                        Intrinsics.checkNotNullExpressionValue((Object)i, (String)"Res.SaveCommandExecutorException_8");
                        Object[] objectArray = i;
                        i = new Object[]{this.row};
                        throw Res.INSTANCE.getRuntimeException((String)objectArray, i);
                    }
                    if (validFilterMatch || !this.saveCommandInfo.getDisallowInvalidData()) continue;
                    Object[] i = Res.INSTANCE.getSaveCommandExecutorException_9();
                    Intrinsics.checkNotNullExpressionValue((Object)i, (String)"Res.SaveCommandExecutorException_9");
                    Object[] objectArray = i;
                    i = new Object[]{this.row};
                    throw Res.INSTANCE.getRuntimeException((String)objectArray, i);
                }
                if ((object = this.commandContext) != null) {
                    ((CommandContext)object).setTimeState(CommandExecuteState.Companion.getEnterWriteLock(), exitQueryLockTime + writer.getWriteLockTime());
                }
                object = this.commandContext;
                if (object != null) {
                    ((CommandContext)object).setState(CommandExecuteState.Companion.getResultCount(), this._resultCount);
                }
                object = this.commandContext;
                if (object == null) {
                    unit2 = null;
                } else {
                    ((CommandContext)object).setTimeState(CommandExecuteState.Companion.getExitWriteLock());
                    unit2 = Unit.INSTANCE;
                }
                unit = unit2;
            }
            finally {
                ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                values = ptm;
                n2 = 0;
                n = 0;
                Throwable throwable2 = null;
                try {
                    ParallelTaskManager it = (ParallelTaskManager)values;
                    boolean bl5 = false;
                    writer.force();
                    Unit unit3 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)values, (Throwable)throwable2);
                }
                values = this.commandContext;
                if (values != null) {
                    ((CommandContext)values).updateTransactionVersion(writer.getTransactionId());
                }
            }
            Unit unit4 = unit;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/storages/SaveCommandExecutor$Companion;", "", "()V", "createDataValuesIterator", "", "", "cube", "Lkd/bos/olapServer/metadata/Cube;", "saveCommandInfo", "Lkd/bos/olapServer/dataSources/SaveCommandInfo;", "reader", "Ljava/io/BufferedReader;", "getDataTypes", "Lkd/bos/olapServer/metadata/OlapDataTypes;", "cmd", "(Lkd/bos/olapServer/dataSources/SaveCommandInfo;Lkd/bos/olapServer/metadata/Cube;)[Lkd/bos/olapServer/metadata/OlapDataTypes;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final OlapDataTypes[] getDataTypes(SaveCommandInfo cmd, Cube cube) {
            MeasureCollection meas = cube.getMeasures();
            int measureSize = cmd.getMeasures().size();
            int n = measureSize + cmd.getDimensions().size();
            OlapDataTypes[] olapDataTypesArray = new OlapDataTypes[n];
            for (int i = 0; i < n; ++i) {
                OlapDataTypes olapDataTypes;
                int n2;
                int n3 = n2 = i;
                OlapDataTypes[] olapDataTypesArray2 = olapDataTypesArray;
                if (n2 < measureSize) {
                    Measure mea = (Measure)meas.get(cmd.getMeasures().get(n2));
                    olapDataTypes = mea.getDataType();
                } else {
                    olapDataTypes = OlapDataTypes.string;
                }
                olapDataTypesArray2[n3] = olapDataTypes;
            }
            return olapDataTypesArray;
        }

        private final Iterator<Object[]> createDataValuesIterator(Cube cube, SaveCommandInfo saveCommandInfo, BufferedReader reader) {
            OlapDataTypes[] types = this.getDataTypes(saveCommandInfo, cube);
            SaveCommandInfo saveCommandInfo2 = saveCommandInfo;
            return saveCommandInfo2 instanceof SaveCommandInfoV1 ? (Iterator)new DataValuesIteratorV1(reader, types) : (saveCommandInfo2 instanceof SaveCommandInfoV2 ? (Iterator)new DataValuesIteratorV2(reader, types) : (Iterator)new DataValuesIteratorV3(reader, types));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\f\u0010\u000f\u001a\u00060\u000bj\u0002`\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00060\u000bj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/storages/SaveCommandExecutor$SaveStrategy;", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "row", "Lkd/bos/olapServer/dataEntities/InputRow;", "meaArray", "", "Lkd/bos/olapServer/metadata/Measure;", "(Lkd/bos/olapServer/dataEntities/InputRow;[Lkd/bos/olapServer/metadata/Measure;)V", "[Lkd/bos/olapServer/metadata/Measure;", "supportModifiedValue", "", "Lkd/bos/olapServer/common/bool;", "getSupportModifiedValue", "()Z", "canAdd", "modifiedValue", "current", "newValue", "bos-olap-core"})
    private static final class SaveStrategy
    implements IAddOrUpdateStrategy<IMeasureValues> {
        @NotNull
        private final InputRow row;
        @NotNull
        private final Measure[] meaArray;

        public SaveStrategy(@NotNull InputRow row, @NotNull Measure[] meaArray) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            Intrinsics.checkNotNullParameter((Object)meaArray, (String)"meaArray");
            this.row = row;
            this.meaArray = meaArray;
        }

        @Override
        public boolean canAdd() {
            for (Measure measure : this.meaArray) {
                Object value2 = this.row.getValues().get(measure.getPosition$bos_olap_core());
                if (value2 == CommonTypesKt.getUndefined() || value2 == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean getSupportModifiedValue() {
            return true;
        }

        @Override
        @NotNull
        public IMeasureValues modifiedValue(@NotNull IMeasureValues current, @NotNull IMeasureValues newValue) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            for (Measure measure : this.meaArray) {
                Object oldMeasure;
                int i = measure.getPosition$bos_olap_core();
                Object newMeasure = newValue.get(i);
                if (newMeasure == CommonTypesKt.getUndefined() || !OperateUtils.valueEquals((Object)newMeasure, (Object)(oldMeasure = current.get(i)))) continue;
                this.row.setMeasureValue(i, CommonTypesKt.getUndefined());
            }
            return newValue;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u0012\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/storages/SaveCommandExecutor$IncrementStrategy;", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "row", "Lkd/bos/olapServer/dataEntities/InputRow;", "meaArray", "", "Lkd/bos/olapServer/metadata/Measure;", "measureCount", "", "Lkd/bos/olapServer/common/int;", "(Lkd/bos/olapServer/dataEntities/InputRow;[Lkd/bos/olapServer/metadata/Measure;I)V", "[Lkd/bos/olapServer/metadata/Measure;", "supportModifiedValue", "", "Lkd/bos/olapServer/common/bool;", "getSupportModifiedValue", "()Z", "canAdd", "modifiedValue", "current", "newValue", "bos-olap-core"})
    private static final class IncrementStrategy
    implements IAddOrUpdateStrategy<IMeasureValues> {
        @NotNull
        private final InputRow row;
        @NotNull
        private final Measure[] meaArray;

        public IncrementStrategy(@NotNull InputRow row, @NotNull Measure[] meaArray, int measureCount) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            Intrinsics.checkNotNullParameter((Object)meaArray, (String)"meaArray");
            this.row = row;
            this.meaArray = meaArray;
        }

        @Override
        public boolean canAdd() {
            for (Measure measure : this.meaArray) {
                Object value2 = this.row.getValues().get(measure.getPosition$bos_olap_core());
                if (OperateUtils.isDefaultValue((Object)value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean getSupportModifiedValue() {
            return true;
        }

        @Override
        @NotNull
        public IMeasureValues modifiedValue(@NotNull IMeasureValues current, @NotNull IMeasureValues newValue) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            for (Measure measure : this.meaArray) {
                int measurePosition = measure.getPosition$bos_olap_core();
                Object newMeasure = newValue.get(measurePosition);
                Object result = newMeasure == CommonTypesKt.getUndefined() || OperateUtils.isDefaultValue((Object)newMeasure) ? CommonTypesKt.getUndefined() : OperateUtils.add((Object)current.get(measurePosition), (Object)newMeasure);
                this.row.setMeasureValue(measurePosition, result);
            }
            return this.row.getValues();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/storages/SaveCommandExecutor$DataValuesIteratorV1;", "", "", "", "br", "Ljava/io/BufferedReader;", "valueTypes", "Lkd/bos/olapServer/metadata/OlapDataTypes;", "(Ljava/io/BufferedReader;[Lkd/bos/olapServer/metadata/OlapDataTypes;)V", "line", "", "[Lkd/bos/olapServer/metadata/OlapDataTypes;", "values", "[Ljava/lang/Object;", "hasNext", "", "next", "()[Ljava/lang/Object;", "bos-olap-core"})
    private static final class DataValuesIteratorV1
    implements Iterator<Object[]>,
    KMappedMarker {
        @NotNull
        private final BufferedReader br;
        @NotNull
        private final OlapDataTypes[] valueTypes;
        @NotNull
        private final Object[] values;
        @Nullable
        private String line;

        public DataValuesIteratorV1(@NotNull BufferedReader br, @NotNull OlapDataTypes[] valueTypes) {
            Intrinsics.checkNotNullParameter((Object)br, (String)"br");
            Intrinsics.checkNotNullParameter((Object)valueTypes, (String)"valueTypes");
            this.br = br;
            this.valueTypes = valueTypes;
            this.values = new Object[this.valueTypes.length];
        }

        @Override
        public boolean hasNext() {
            this.line = this.br.readLine();
            return this.line != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Object[] next() {
            String line2 = this.line;
            try {
                int p1;
                StringReader sr = new StringReader(line2);
                if (line2 != null && (p1 = StringsKt.indexOf$default((CharSequence)line2, (String)"{\"dataValues\":", (int)0, (boolean)false, (int)6, null)) >= 0) {
                    sr.skip(p1 + 14);
                }
                Closeable closeable = sr;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    StringReader it = (StringReader)closeable;
                    boolean bl3 = false;
                    ArrayJsonReader reader = new ArrayJsonReader(this.valueTypes, sr, 1);
                    if (reader.next()) {
                        reader.read(this.values);
                    }
                    Object[] objectArray = this.values;
                    return objectArray;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                Object[] objectArray = Res.INSTANCE.getSaveCommandExecutorException_6();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.SaveCommandExecutorException_6");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{line2, e.getMessage()};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, e, objectArray);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/storages/SaveCommandExecutor$DataValuesIteratorV2;", "", "", "", "br", "Ljava/io/Reader;", "valueTypes", "Lkd/bos/olapServer/metadata/OlapDataTypes;", "(Ljava/io/Reader;[Lkd/bos/olapServer/metadata/OlapDataTypes;)V", "lineCount", "", "reader", "Lkd/bos/olapServer/dataSources/ArrayJsonReader;", "values", "[Ljava/lang/Object;", "hasNext", "", "next", "()[Ljava/lang/Object;", "bos-olap-core"})
    private static final class DataValuesIteratorV2
    implements Iterator<Object[]>,
    KMappedMarker {
        @NotNull
        private final ArrayJsonReader reader;
        @NotNull
        private final Object[] values;
        private int lineCount;

        public DataValuesIteratorV2(@NotNull Reader br, @NotNull OlapDataTypes[] valueTypes) {
            Intrinsics.checkNotNullParameter((Object)br, (String)"br");
            Intrinsics.checkNotNullParameter((Object)valueTypes, (String)"valueTypes");
            this.reader = new ArrayJsonReader(valueTypes, br, 1);
            this.values = new Object[valueTypes.length];
        }

        @Override
        public boolean hasNext() {
            try {
                DataValuesIteratorV2 dataValuesIteratorV2 = this;
                int n = dataValuesIteratorV2.lineCount;
                dataValuesIteratorV2.lineCount = n + 1;
                return this.reader.next() ? this.reader.read(this.values) : false;
            }
            catch (Exception e) {
                Object[] objectArray = Res.INSTANCE.getSaveCommandExecutorException_6();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.SaveCommandExecutorException_6");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.lineCount - 1, e.getMessage()};
                throw new RuntimeException(Res.INSTANCE.format((String)objectArray2, objectArray), e);
            }
        }

        @Override
        @NotNull
        public Object[] next() {
            return this.values;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/storages/SaveCommandExecutor$DataValuesIteratorV3;", "", "", "", "br", "Ljava/io/Reader;", "valueTypes", "Lkd/bos/olapServer/metadata/OlapDataTypes;", "(Ljava/io/Reader;[Lkd/bos/olapServer/metadata/OlapDataTypes;)V", "lineCount", "", "reader", "Lkd/bos/olapServer/dataSources/ArrayJsonReader;", "values", "[Ljava/lang/Object;", "hasNext", "", "next", "()[Ljava/lang/Object;", "bos-olap-core"})
    private static final class DataValuesIteratorV3
    implements Iterator<Object[]>,
    KMappedMarker {
        @NotNull
        private final ArrayJsonReader reader;
        @NotNull
        private final Object[] values;
        private int lineCount;

        public DataValuesIteratorV3(@NotNull Reader br, @NotNull OlapDataTypes[] valueTypes) {
            Intrinsics.checkNotNullParameter((Object)br, (String)"br");
            Intrinsics.checkNotNullParameter((Object)valueTypes, (String)"valueTypes");
            this.reader = new ArrayJsonReader(valueTypes, br, 0, 4, null);
            this.values = new Object[valueTypes.length];
        }

        @Override
        public boolean hasNext() {
            try {
                DataValuesIteratorV3 dataValuesIteratorV3 = this;
                int n = dataValuesIteratorV3.lineCount;
                dataValuesIteratorV3.lineCount = n + 1;
                return this.reader.next() ? this.reader.read(this.values) : false;
            }
            catch (Exception e) {
                Object[] objectArray = Res.INSTANCE.getSaveCommandExecutorException_6();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.SaveCommandExecutorException_6");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.lineCount - 1, e.getMessage()};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, e, objectArray);
            }
        }

        @Override
        @NotNull
        public Object[] next() {
            return this.values;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

