/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages.pools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.olapServer.collections.LockFreeStack;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.ByteBufferResourcePool;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000  *\u0006\b\u0000\u0010\u0001 \u0000*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0015\u001a\u00020\rJ\u0015\u0010\u0016\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0018\u001a\u00020\r2%\u0010\u0019\u001a!\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001aH\u0004R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lkd/bos/olapServer/storages/pools/ObjectPool;", "K", "V", "", "()V", "_itemsDict", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkd/bos/olapServer/collections/LockFreeStack;", "maxObjectCount", "", "getMaxObjectCount", "()I", "closeObj", "", "key", "obj", "(Ljava/lang/Object;Ljava/lang/Object;)V", "createObject", "(Ljava/lang/Object;)Ljava/lang/Object;", "get", "release", "removeAll", "reuse", "value", "scan", "removeFun", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "v", "", "Lkd/bos/olapServer/common/bool;", "Companion", "bos-olap-core"})
public abstract class ObjectPool<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<K, LockFreeStack<V>> _itemsDict = new ConcurrentHashMap();
    private static int ResourceTimeout = ByteBufferResourcePool.Companion.getResourceTimeout();

    public V get(K key) {
        V result;
        LockFreeStack<V> stack = this._itemsDict.get(key);
        if (stack != null && (result = stack.tryPop()) != null) {
            return this.reuse(result);
        }
        return this.createObject(key);
    }

    protected abstract V createObject(K var1);

    protected V reuse(V value2) {
        return value2;
    }

    protected int getMaxObjectCount() {
        return CommonTypesKt.getAvailableProcessors() * 99;
    }

    public void release(K key, V obj) {
        LockFreeStack stack;
        ConcurrentMap $this$getOrPut$iv = this._itemsDict;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key);
        if (object == null) {
            boolean bl = false;
            LockFreeStack lockFreeStack = new LockFreeStack();
            boolean bl2 = false;
            boolean bl3 = false;
            LockFreeStack default$iv = lockFreeStack;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((stack = (LockFreeStack)object).getSize() < this.getMaxObjectCount()) {
            stack.push(obj);
        } else {
            this.closeObj(key, obj);
        }
    }

    protected abstract void closeObj(K var1, V var2);

    public final void removeAll() {
        Object object = this._itemsDict;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            Object key = object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            LockFreeStack stack = (LockFreeStack)object3.getValue();
            Object item = stack.tryPop();
            while (item != null) {
                this.closeObj(key, item);
                item = stack.tryPop();
            }
        }
    }

    protected final void scan(@NotNull Function1<? super V, Boolean> removeFun) {
        LockFreeStack stack;
        Intrinsics.checkNotNullParameter(removeFun, (String)"removeFun");
        boolean bl = false;
        List removeKeys = new ArrayList();
        Object object = this._itemsDict;
        boolean bl2 = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl3 = false;
            Object key = object2.getKey();
            Object object3 = object;
            boolean bl4 = false;
            stack = (LockFreeStack)object3.getValue();
            stack.gc(removeFun, (Function1)new Function1<V, Unit>(this, key){
                final /* synthetic */ ObjectPool<K, V> this$0;
                final /* synthetic */ K $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(1);
                }

                public final void invoke(V it) {
                    this.this$0.closeObj(this.$key, it);
                }
            });
            if (!stack.isEmpty()) continue;
            removeKeys.add(key);
        }
        for (Map.Entry key : removeKeys) {
            LockFreeStack<V> removedItems = this._itemsDict.remove(key);
            if (removedItems == null || removedItems.isEmpty()) continue;
            ConcurrentMap $this$getOrPut$iv = this._itemsDict;
            boolean $i$f$getOrPut = false;
            Object object4 = $this$getOrPut$iv.get(key);
            if (object4 == null) {
                boolean bl5 = false;
                LockFreeStack lockFreeStack = new LockFreeStack();
                boolean bl6 = false;
                boolean bl7 = false;
                LockFreeStack default$iv = lockFreeStack;
                boolean bl8 = false;
                object4 = $this$getOrPut$iv.putIfAbsent(key, default$iv);
                if (object4 == null) {
                    object4 = default$iv;
                }
            }
            stack = (LockFreeStack)object4;
            V item = removedItems.tryPop();
            while (item != null) {
                stack.push(item);
                item = removedItems.tryPop();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer/storages/pools/ObjectPool$Companion;", "", "()V", "ResourceTimeout", "", "getResourceTimeout", "()I", "setResourceTimeout", "(I)V", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getResourceTimeout() {
            return ResourceTimeout;
        }

        public final void setResourceTimeout(int n) {
            ResourceTimeout = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

