/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages.pools;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer.collections.IImmutableList;
import kd.bos.olapServer.collections.IImmutableListInt;
import kd.bos.olapServer.collections.IQueryBitmap;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.DimensionMemberKey;
import kd.bos.olapServer.storages.CubeResourcePool;
import kd.bos.olapServer.storages.pools.DimensionEntry;
import kd.bos.olapServer.storages.pools.InvalidDataQueryBitmapEntry;
import kd.bos.olapServer.storages.pools.MeasureEntry;
import kd.bos.olapServer.storages.pools.PoolEntry;
import kd.bos.olapServer.storages.pools.PoolWithVersion;
import kd.bos.olapServer.storages.pools.QueryBitmapEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0007J\u0012\u0010\u001d\u001a\u00020\r2\n\u0010\u001e\u001a\u00060\u000bj\u0002`\fJ\u0016\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010 \u001a\u00020\u0012J\u0016\u0010!\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u001c\u0012\u0004\u0012\u00020\u0012\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013\u0012\u0004\u0012\u00020\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00180\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "Ljava/io/Closeable;", "parentPool", "Lkd/bos/olapServer/storages/CubeResourcePool;", "(Lkd/bos/olapServer/storages/CubeResourcePool;)V", "_dimensionLists", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer$ResourceContainer;", "Lkd/bos/olapServer/metadata/Dimension;", "Lkd/bos/olapServer/collections/IImmutableListInt;", "Lkd/bos/olapServer/storages/pools/DimensionEntry;", "_invalidDataQueryBitmaps", "", "Lkd/bos/olapServer/common/int;", "Lkd/bos/olapServer/collections/IQueryBitmap;", "Lkd/bos/olapServer/storages/pools/InvalidDataQueryBitmapEntry;", "_isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_measureLists", "Lkd/bos/olapServer/metadata/Measure;", "Lkd/bos/olapServer/collections/IImmutableList;", "", "Lkd/bos/olapServer/storages/pools/MeasureEntry;", "_queryBitmaps", "Lkd/bos/olapServer/query/DimensionMemberKey;", "Lkd/bos/olapServer/storages/pools/QueryBitmapEntry;", "close", "", "getDimensionList", "dimension", "getInvalidDataQueryBitmaps", "memberId", "getMeasureList", "measure", "getQueryBitmap", "member", "Lkd/bos/olapServer/metadata/Member;", "ResourceContainer", "bos-olap-core"})
public class TaskResourceContainer
implements Closeable {
    @NotNull
    private final ResourceContainer<Dimension, IImmutableListInt, DimensionEntry> _dimensionLists;
    @NotNull
    private final ResourceContainer<Measure, IImmutableList<Object>, MeasureEntry> _measureLists;
    @NotNull
    private final ResourceContainer<DimensionMemberKey, IQueryBitmap, QueryBitmapEntry> _queryBitmaps;
    @NotNull
    private final ResourceContainer<Integer, IQueryBitmap, InvalidDataQueryBitmapEntry> _invalidDataQueryBitmaps;
    @NotNull
    private final AtomicBoolean _isClosed;

    public TaskResourceContainer(@NotNull CubeResourcePool parentPool) {
        Intrinsics.checkNotNullParameter((Object)parentPool, (String)"parentPool");
        this._dimensionLists = new ResourceContainer<Dimension, IImmutableListInt, DimensionEntry>(parentPool.getDimensionPool());
        this._measureLists = new ResourceContainer<Measure, IImmutableList<Object>, MeasureEntry>(parentPool.getMeasurePool());
        this._queryBitmaps = new ResourceContainer(parentPool.getQueryBitmapPool());
        this._invalidDataQueryBitmaps = new ResourceContainer(parentPool.getInvalidDataQueryBitmapPool());
        this._isClosed = new AtomicBoolean();
    }

    @NotNull
    public final IImmutableListInt getDimensionList(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this._dimensionLists.getResource(dimension);
    }

    @NotNull
    public final IImmutableList<Object> getMeasureList(@NotNull Measure measure) {
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        return this._measureLists.getResource(measure);
    }

    @NotNull
    public final IQueryBitmap getQueryBitmap(@NotNull Dimension dimension, @NotNull Member member) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        return this._queryBitmaps.getResource(new DimensionMemberKey(dimension, member));
    }

    @NotNull
    public final IQueryBitmap getInvalidDataQueryBitmaps(int memberId) {
        return this._invalidDataQueryBitmaps.getResource(memberId);
    }

    @Override
    public void close() {
        if (this._isClosed.compareAndSet(false, true)) {
            this._queryBitmaps.close();
            this._invalidDataQueryBitmaps.close();
            this._dimensionLists.close();
            this._measureLists.close();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0006\b\u0001\u0010\u0002 \u0001*\u0016\b\u0002\u0010\u0003 \u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00042\u00020\u0005B\u001f\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010R.\u0010\t\u001a\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010\nj\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u0001`\u000bX\u0088\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/storages/pools/TaskResourceContainer$ResourceContainer;", "K", "V", "EntryV", "Lkd/bos/olapServer/storages/pools/PoolEntry;", "Ljava/io/Closeable;", "parentPool", "Lkd/bos/olapServer/storages/pools/PoolWithVersion;", "(Lkd/bos/olapServer/storages/pools/PoolWithVersion;)V", "_resources", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "close", "", "getResource", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "bos-olap-core"})
    protected static final class ResourceContainer<K, V, EntryV extends PoolEntry<? extends K, ? extends V>>
    implements Closeable {
        @NotNull
        private final PoolWithVersion<K, V, EntryV> parentPool;
        @Nullable
        private HashMap<K, EntryV> _resources;

        public ResourceContainer(@NotNull PoolWithVersion<K, V, EntryV> parentPool) {
            Intrinsics.checkNotNullParameter(parentPool, (String)"parentPool");
            this.parentPool = parentPool;
        }

        public final V getResource(K key) {
            PoolEntry result;
            PoolEntry poolEntry;
            HashMap<K, Object> resources = this._resources;
            if (resources == null) {
                boolean bl = false;
                resources = new HashMap();
                this._resources = resources;
                poolEntry = null;
            } else {
                poolEntry = result = (PoolEntry)resources.get(key);
            }
            if (result == null) {
                result = (PoolEntry)this.parentPool.get(key);
                Map map = resources;
                boolean bl = false;
                map.put(key, result);
            }
            return (V)result.getValue();
        }

        @Override
        public void close() {
            HashMap<K, EntryV> resources = this._resources;
            if (resources != null) {
                for (PoolEntry entry : resources.values()) {
                    Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                    this.parentPool.release(entry);
                }
                resources.clear();
            }
        }
    }
}

