/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages.selectors;

import kd.bos.olapServer.collections.IMutableList;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.builds.MemberBuilder;
import kd.bos.olapServer.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer.metadata.events.CreateMemberEvent;
import kd.bos.olapServer.metadata.events.DropMemberEvent;
import kd.bos.olapServer.metadata.events.MetadataEvent;
import kd.bos.olapServer.storages.selectors.DimensionIndexSelector;
import kd.bos.olapServer.storages.selectors.MinV2DimensionIndexSelector;
import kd.bos.olapServer.storages.selectors.MinV3DimensionIndexSelector;
import kd.bos.olapServer.storages.selectors.SelectorBase;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer/storages/selectors/DimensionIndexSelector;", "Lkd/bos/olapServer/storages/selectors/SelectorBase;", "bufferProvider", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "ctx", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;Lkd/bos/olapServer/storages/selectors/SelectorContext;)V", "m2Selector", "Lkd/bos/olapServer/storages/selectors/MinV2DimensionIndexSelector;", "getM2Selector", "()Lkd/bos/olapServer/storages/selectors/MinV2DimensionIndexSelector;", "m3Selector", "Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector;", "getM3Selector", "()Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector;", "bind", "", "event", "Lkd/bos/olapServer/metadata/events/MetadataEvent;", "getOrCreate", "Lkd/bos/olapServer/collections/IMutableList;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "onMemberChangeBind", "indexFormat", "", "Lkd/bos/olapServer/common/string;", "bos-olap-core"})
public final class DimensionIndexSelector
extends SelectorBase {
    public DimensionIndexSelector(@NotNull IByteBufferProvider bufferProvider, @NotNull SelectorContext ctx) {
        Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(bufferProvider, ctx);
    }

    public /* synthetic */ DimensionIndexSelector(IByteBufferProvider iByteBufferProvider, SelectorContext selectorContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            selectorContext = new SelectorContext(null, 1, null);
        }
        this(iByteBufferProvider, selectorContext);
    }

    private final MinV2DimensionIndexSelector getM2Selector() {
        return (MinV2DimensionIndexSelector)this.create(m2Selector.1.INSTANCE);
    }

    private final MinV3DimensionIndexSelector getM3Selector() {
        return (MinV3DimensionIndexSelector)this.create(m3Selector.1.INSTANCE);
    }

    @NotNull
    public final IMutableList<IDimensionKeys> getOrCreate(@NotNull Cube cube) {
        IMutableList<IDimensionKeys> iMutableList;
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Dimension firstDim = cube.getDimensions().getCount() == 0 ? null : (Dimension)cube.getDimensions().get(0);
        Object object = firstDim;
        String indexFormat = object == null ? null : ((Dimension)object).getIndexFormat();
        object = indexFormat;
        if (Intrinsics.areEqual((Object)object, (Object)"mv3")) {
            iMutableList = this.getM3Selector().create(cube);
        } else if (Intrinsics.areEqual((Object)object, (Object)"mv2")) {
            iMutableList = this.getM2Selector().create(cube);
        } else if (object == null) {
            iMutableList = this.getM3Selector().create(cube);
        } else {
            Object[] objectArray = Res.INSTANCE.getCommonException_8();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_8");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{indexFormat};
            throw Res.INSTANCE.getNotSupportedException((String)objectArray2, objectArray);
        }
        return iMutableList;
    }

    public final void bind(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof CreateDimensionEvent) {
            String string = ((CreateDimensionEvent)event).getDimBuilder().getIndexFormat();
            if (Intrinsics.areEqual((Object)string, (Object)"") ? true : Intrinsics.areEqual((Object)string, (Object)"mv3")) {
                this.getM3Selector().bind(event);
            } else {
                String string2;
                MemberBuilder memberBuilder;
                MemberBuilder member = (MemberBuilder)((CreateDimensionEvent)event).getDimBuilder().getMembers().get(0);
                boolean isDefault = Intrinsics.areEqual((Object)member.getName(), (Object)((memberBuilder = ((CreateDimensionEvent)event).getDefaultMemberBuilder()) == null ? "" : ((string2 = memberBuilder.getName()) == null ? "" : string2)));
                CreateMemberEvent memberEvent = new CreateMemberEvent(((CreateDimensionEvent)event).getDimBuilder(), member, ((CreateDimensionEvent)event).getRowCount(), isDefault);
                this.onMemberChangeBind(memberEvent, ((CreateDimensionEvent)event).getDimBuilder().getIndexFormat());
            }
        } else if (metadataEvent instanceof CreateMemberEvent) {
            this.onMemberChangeBind(event, ((CreateMemberEvent)event).getDimBuilder().getIndexFormat());
        } else if (metadataEvent instanceof DropMemberEvent) {
            this.onMemberChangeBind(event, ((DropMemberEvent)event).getDimension().getIndexFormat());
        }
    }

    private final void onMemberChangeBind(MetadataEvent event, String indexFormat) {
        switch (indexFormat) {
            case "": 
            case "mv3": {
                this.getM3Selector().bind(event);
                break;
            }
            case "mv2": {
                this.getM2Selector().bind(event);
                break;
            }
            default: {
                Object[] objectArray = Res.INSTANCE.getCommonException_8();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_8");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{indexFormat};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray2, objectArray);
            }
        }
    }
}

