/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages.selectors;

import java.io.Closeable;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IImmutableListInt;
import kd.bos.olapServer.collections.IMutableListInt;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.builds.DimensionBuilder;
import kd.bos.olapServer.metadata.builds.MemberBuilder;
import kd.bos.olapServer.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer.metadata.events.MetadataEvent;
import kd.bos.olapServer.storages.selectors.DKListIntSelector;
import kd.bos.olapServer.storages.selectors.ListIntSelector;
import kd.bos.olapServer.storages.selectors.RK2ListIntSelector;
import kd.bos.olapServer.storages.selectors.RKListIntSelector;
import kd.bos.olapServer.storages.selectors.SelectorBase;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\"\u001a\u00060#j\u0002`$H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lkd/bos/olapServer/storages/selectors/ListIntSelector;", "Lkd/bos/olapServer/storages/selectors/SelectorBase;", "bufferProvider", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "ctx", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;Lkd/bos/olapServer/storages/selectors/SelectorContext;)V", "dkSelector", "Lkd/bos/olapServer/storages/selectors/DKListIntSelector;", "getDkSelector", "()Lkd/bos/olapServer/storages/selectors/DKListIntSelector;", "rk2Selector", "Lkd/bos/olapServer/storages/selectors/RK2ListIntSelector;", "getRk2Selector", "()Lkd/bos/olapServer/storages/selectors/RK2ListIntSelector;", "rkSelector", "Lkd/bos/olapServer/storages/selectors/RKListIntSelector;", "getRkSelector", "()Lkd/bos/olapServer/storages/selectors/RKListIntSelector;", "bind", "", "event", "Lkd/bos/olapServer/metadata/events/MetadataEvent;", "getOrCreateImmutableListInt", "Lkd/bos/olapServer/collections/IImmutableListInt;", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "getOrCreateMutableListInt", "Lkd/bos/olapServer/collections/IMutableListInt;", "onDimensionCreate", "dimBuilder", "Lkd/bos/olapServer/metadata/builds/DimensionBuilder;", "defaultMemberBuilder", "Lkd/bos/olapServer/metadata/builds/MemberBuilder;", "rowCount", "", "Lkd/bos/olapServer/common/long;", "bos-olap-core"})
public final class ListIntSelector
extends SelectorBase {
    public ListIntSelector(@NotNull IByteBufferProvider bufferProvider, @NotNull SelectorContext ctx) {
        Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(bufferProvider, ctx);
    }

    public /* synthetic */ ListIntSelector(IByteBufferProvider iByteBufferProvider, SelectorContext selectorContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            selectorContext = new SelectorContext(null, 1, null);
        }
        this(iByteBufferProvider, selectorContext);
    }

    private final RK2ListIntSelector getRk2Selector() {
        return (RK2ListIntSelector)this.create(rk2Selector.1.INSTANCE);
    }

    private final RKListIntSelector getRkSelector() {
        return (RKListIntSelector)this.create(rkSelector.1.INSTANCE);
    }

    private final DKListIntSelector getDkSelector() {
        return (DKListIntSelector)this.create(dkSelector.1.INSTANCE);
    }

    @NotNull
    public final IImmutableListInt getOrCreateImmutableListInt(@NotNull Dimension dimension) {
        IImmutableListInt iImmutableListInt;
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        switch (dimension.getDataFormat()) {
            case "rk2": {
                iImmutableListInt = this.getRk2Selector().getOrCreateImmutableListInt(dimension);
                break;
            }
            case "rk": {
                iImmutableListInt = this.getRkSelector().getOrCreateImmutableListInt(dimension);
                break;
            }
            case "dk": {
                iImmutableListInt = this.getDkSelector().getOrCreateImmutableListInt(dimension);
                break;
            }
            default: {
                Object[] objectArray = Res.INSTANCE.getCommonException_8();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_8");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{dimension.getDataFormat()};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray2, objectArray);
            }
        }
        return iImmutableListInt;
    }

    @NotNull
    public final IMutableListInt getOrCreateMutableListInt(@NotNull Dimension dimension) {
        IMutableListInt iMutableListInt;
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.getBufferProvider().createFolder(dimension.getName());
        switch (dimension.getDataFormat()) {
            case "rk2": {
                iMutableListInt = this.getRk2Selector().getOrCreateMutableListInt(dimension);
                break;
            }
            case "rk": {
                iMutableListInt = this.getRkSelector().getOrCreateMutableListInt(dimension);
                break;
            }
            case "dk": {
                iMutableListInt = this.getDkSelector().getOrCreateMutableListInt(dimension);
                break;
            }
            default: {
                Object[] objectArray = Res.INSTANCE.getCommonException_8();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_8");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{dimension.getDataFormat()};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray2, objectArray);
            }
        }
        return iMutableListInt;
    }

    public final void bind(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof CreateDimensionEvent) {
            long rowCount = ((CreateDimensionEvent)event).getRowCount();
            event.core((Function0<Unit>)((Function0)new Function0<Unit>(this, event, rowCount){
                final /* synthetic */ ListIntSelector this$0;
                final /* synthetic */ MetadataEvent $event;
                final /* synthetic */ long $rowCount;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    this.$rowCount = $rowCount;
                    super(0);
                }

                public final void invoke() {
                    ListIntSelector.access$onDimensionCreate(this.this$0, ((CreateDimensionEvent)this.$event).getDimBuilder(), ((CreateDimensionEvent)this.$event).getDefaultMemberBuilder(), this.$rowCount);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onDimensionCreate(DimensionBuilder dimBuilder, MemberBuilder defaultMemberBuilder, long rowCount) {
        this.getBufferProvider().createFolder(dimBuilder.getName());
        if (rowCount > 0L && defaultMemberBuilder != null) {
            Closeable closeable;
            IMutableListInt dimList;
            block7: {
                Dimension dim = dimBuilder.tempBuild(0);
                this.getBufferProvider().createFolder(dim.getName());
                int pos = ((Member)dim.getMembers().get(defaultMemberBuilder.getName())).getPosition$bos_olap_core();
                dimList = this.getOrCreateMutableListInt(dim);
                try {
                    long l = 0L;
                    if (l < rowCount) {
                        do {
                            long it = l++;
                            dimList.add(pos);
                        } while (l < rowCount);
                    }
                    Closeable closeable2 = closeable = dimList instanceof IDataContainer ? (IDataContainer)((Object)dimList) : null;
                    if (closeable == null) break block7;
                    closeable.force();
                }
                catch (Throwable throwable) {
                    Closeable closeable3;
                    Closeable closeable4 = closeable3 = dimList instanceof Closeable ? (Closeable)((Object)dimList) : null;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                    throw throwable;
                }
            }
            Closeable closeable5 = closeable = dimList instanceof Closeable ? (Closeable)((Object)dimList) : null;
            if (closeable != null) {
                closeable.close();
            }
        }
    }

    public static final /* synthetic */ void access$onDimensionCreate(ListIntSelector $this, DimensionBuilder dimBuilder, MemberBuilder defaultMemberBuilder, long rowCount) {
        $this.onDimensionCreate(dimBuilder, defaultMemberBuilder, rowCount);
    }
}

