/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages.selectors;

import java.io.Closeable;
import java.util.Iterator;
import kd.bos.olapServer.collections.IMutableList;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinMutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinDimensionKeysList;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.builds.DimensionBuilder;
import kd.bos.olapServer.metadata.builds.MemberBuilder;
import kd.bos.olapServer.metadata.events.CreateMemberEvent;
import kd.bos.olapServer.metadata.events.DropMemberEvent;
import kd.bos.olapServer.metadata.events.MetadataEvent;
import kd.bos.olapServer.storages.selectors.DimensionIndexSelectorBase;
import kd.bos.olapServer.storages.selectors.ExtensionTypes;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J0\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010'\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\u0010(\u001a\u00060)j\u0002`*2\n\u0010+\u001a\u00060\u001fj\u0002` H\u0016J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006-"}, d2={"Lkd/bos/olapServer/storages/selectors/MinV2DimensionIndexSelector;", "Lkd/bos/olapServer/storages/selectors/DimensionIndexSelectorBase;", "bufferProvider", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "ctx", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;Lkd/bos/olapServer/storages/selectors/SelectorContext;)V", "DataExtension", "", "Lkd/bos/olapServer/common/string;", "getDataExtension", "()Ljava/lang/String;", "SegmentExtension", "getSegmentExtension", "bind", "", "event", "Lkd/bos/olapServer/metadata/events/MetadataEvent;", "create", "Lkd/bos/olapServer/collections/IMutableList;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "createMetadata", "Lkotlin/Pair;", "Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "member", "Lkd/bos/olapServer/metadata/Member;", "isReadOnly", "", "Lkd/bos/olapServer/common/bool;", "dimBuilder", "Lkd/bos/olapServer/metadata/builds/DimensionBuilder;", "memberBuilder", "Lkd/bos/olapServer/metadata/builds/MemberBuilder;", "createMutableBitmap", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmap;", "onMemberCreate", "rowCount", "", "Lkd/bos/olapServer/common/long;", "isDefaultMember", "onMemberDrop", "bos-olap-core"})
public final class MinV2DimensionIndexSelector
extends DimensionIndexSelectorBase {
    public MinV2DimensionIndexSelector(@NotNull IByteBufferProvider bufferProvider, @NotNull SelectorContext ctx) {
        Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(bufferProvider, ctx);
    }

    public /* synthetic */ MinV2DimensionIndexSelector(IByteBufferProvider iByteBufferProvider, SelectorContext selectorContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            selectorContext = new SelectorContext(null, 1, null);
        }
        this(iByteBufferProvider, selectorContext);
    }

    @NotNull
    public final String getSegmentExtension() {
        return ExtensionTypes.INSTANCE.getMinV2SegType();
    }

    @Override
    @NotNull
    public String getDataExtension() {
        return ExtensionTypes.INSTANCE.getMinV2DataType();
    }

    @Override
    @NotNull
    public IMutableList<IDimensionKeys> create(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        int count = this.getCtx().getRowCount();
        boolean bl = count >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"RowCount = ", (Object)count);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new MinDimensionKeysList(cube, count, (Function2<? super Dimension, ? super Member, ? extends IMinMutableBitmap>)((Function2)new Function2<Dimension, Member, MinBitmap>(this){

            @NotNull
            public final MinBitmap invoke(@NotNull Dimension p0, @NotNull Member p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return MinV2DimensionIndexSelector.access$createMutableBitmap((MinV2DimensionIndexSelector)this.receiver, p0, p1);
            }
        }));
    }

    private final MinBitmap createMutableBitmap(Dimension dimension, Member member) {
        Pair<ListMetadata, ListMetadata> pair = this.createMetadata(dimension, member, false);
        ListMetadata indexMetadata = (ListMetadata)pair.component1();
        ListMetadata dataMetadata = (ListMetadata)pair.component2();
        return new MinBitmap(indexMetadata, dataMetadata);
    }

    private final Pair<ListMetadata, ListMetadata> createMetadata(DimensionBuilder dimBuilder, MemberBuilder memberBuilder, boolean isReadOnly) {
        Dimension dimension = dimBuilder.tempBuild(0);
        Member member = memberBuilder.tempBuild(1, dimension);
        return this.createMetadata(dimension, member, isReadOnly);
    }

    private final Pair<ListMetadata, ListMetadata> createMetadata(Dimension dimension, Member member, boolean isReadOnly) {
        String indexPath = this.getPath(dimension, member, this.getSegmentExtension());
        String dataPath = this.getPath(dimension, member, this.getDataExtension());
        ListMetadata indexMetadata = new ListMetadata(this.getBufferProvider().getOrCreate(indexPath, isReadOnly), null, 2, null);
        ListMetadata dataMetadata = new ListMetadata(this.getBufferProvider().getOrCreate(dataPath, isReadOnly), null, 2, null);
        return new Pair((Object)indexMetadata, (Object)dataMetadata);
    }

    public final void bind(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof CreateMemberEvent) {
            event.core((Function0<Unit>)((Function0)new Function0<Unit>(event, this){
                final /* synthetic */ MetadataEvent $event;
                final /* synthetic */ MinV2DimensionIndexSelector this$0;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    MemberBuilder[] memberBuilderArray = ((CreateMemberEvent)this.$event).getMemberBuilders();
                    MinV2DimensionIndexSelector minV2DimensionIndexSelector = this.this$0;
                    MetadataEvent metadataEvent = this.$event;
                    boolean $i$f$forEach = false;
                    void var5_5 = $this$forEach$iv;
                    int n = ((void)var5_5).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var5_5[i];
                        boolean bl = false;
                        minV2DimensionIndexSelector.onMemberCreate(((CreateMemberEvent)metadataEvent).getDimBuilder(), (MemberBuilder)it, ((CreateMemberEvent)metadataEvent).getRowCount(), ((CreateMemberEvent)metadataEvent).isDefault());
                    }
                }
            }));
        } else if (metadataEvent instanceof DropMemberEvent) {
            event.core((Function0<Unit>)((Function0)new Function0<Unit>(event, this){
                final /* synthetic */ MetadataEvent $event;
                final /* synthetic */ MinV2DimensionIndexSelector this$0;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Dimension dimension = ((DropMemberEvent)this.$event).getDimension();
                    Member[] memberArray = ((DropMemberEvent)this.$event).getDropMembers();
                    MinV2DimensionIndexSelector minV2DimensionIndexSelector = this.this$0;
                    boolean $i$f$forEach = false;
                    void var5_5 = $this$forEach$iv;
                    int n = ((void)var5_5).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var5_5[i];
                        boolean bl = false;
                        minV2DimensionIndexSelector.onMemberDrop(dimension, (Member)it);
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMemberCreate(@NotNull DimensionBuilder dimBuilder, @NotNull MemberBuilder memberBuilder, long rowCount, boolean isDefaultMember) {
        Intrinsics.checkNotNullParameter((Object)dimBuilder, (String)"dimBuilder");
        Intrinsics.checkNotNullParameter((Object)memberBuilder, (String)"memberBuilder");
        if (rowCount > 0L && isDefaultMember) {
            Pair<ListMetadata, ListMetadata> pair = this.createMetadata(dimBuilder, memberBuilder, false);
            ListMetadata indexMetadata = (ListMetadata)pair.component1();
            ListMetadata dataMetadata = (ListMetadata)pair.component2();
            MinBitmap bitmap = new MinBitmap(indexMetadata, dataMetadata);
            Closeable closeable = bitmap;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                MinBitmap it = (MinBitmap)closeable;
                boolean bl3 = false;
                int longCount = (int)(rowCount / (long)64);
                int bitRemCount = (int)(rowCount % (long)64);
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)longCount);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl4 = false;
                    bitmap.update(i, -1L);
                }
                long lastValue = 0L;
                if (bitRemCount > 0) {
                    Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)bitRemCount);
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv2.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int i = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl5 = false;
                        lastValue = CommonTypesKt.setTrue(lastValue, i);
                    }
                    bitmap.update(longCount, lastValue);
                }
                bitmap.force();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Override
    public void onMemberDrop(@NotNull Dimension dimension, @NotNull Member member) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        String indexFilePath = this.getPath(dimension, member, this.getSegmentExtension());
        String bitMapFilePath = this.getPath(dimension, member, this.getDataExtension());
        if (this.getBufferProvider().exist(indexFilePath)) {
            this.getBufferProvider().delete(indexFilePath);
        }
        if (this.getBufferProvider().exist(bitMapFilePath)) {
            this.getBufferProvider().delete(bitMapFilePath);
        }
    }

    public static final /* synthetic */ MinBitmap access$createMutableBitmap(MinV2DimensionIndexSelector $this, Dimension dimension, Member member) {
        return $this.createMutableBitmap(dimension, member);
    }
}

