/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages.selectors;

import kd.bos.olapServer.collections.IQueryBitmap;
import kd.bos.olapServer.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinQueryBitmap;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.EmptyQueryBitmap;
import kd.bos.olapServer.storages.selectors.ExtensionTypes;
import kd.bos.olapServer.storages.selectors.QueryBitmapSelectorBase;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer/storages/selectors/MinV2QueryBitmapSelector;", "Lkd/bos/olapServer/storages/selectors/QueryBitmapSelectorBase;", "bufferProvider", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "ctx", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;Lkd/bos/olapServer/storages/selectors/SelectorContext;)V", "DataExtension", "", "Lkd/bos/olapServer/common/string;", "getDataExtension", "()Ljava/lang/String;", "SegmentExtension", "getSegmentExtension", "create", "Lkd/bos/olapServer/collections/IQueryBitmap;", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "member", "Lkd/bos/olapServer/metadata/Member;", "createMetadata", "Lkotlin/Pair;", "Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;", "isReadonly", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
public final class MinV2QueryBitmapSelector
extends QueryBitmapSelectorBase {
    public MinV2QueryBitmapSelector(@NotNull IByteBufferProvider bufferProvider, @NotNull SelectorContext ctx) {
        Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(bufferProvider, ctx);
    }

    public /* synthetic */ MinV2QueryBitmapSelector(IByteBufferProvider iByteBufferProvider, SelectorContext selectorContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            selectorContext = new SelectorContext(null, 1, null);
        }
        this(iByteBufferProvider, selectorContext);
    }

    @Override
    @NotNull
    public String getDataExtension() {
        return ExtensionTypes.INSTANCE.getMinV2DataType();
    }

    @NotNull
    public final String getSegmentExtension() {
        return ExtensionTypes.INSTANCE.getMinV2SegType();
    }

    @Override
    @NotNull
    public IQueryBitmap create(@NotNull Dimension dimension, @NotNull Member member) {
        IQueryBitmap iQueryBitmap;
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        String bitMapFilePath = this.getPath(dimension, member, this.getDataExtension());
        if (!this.getBufferProvider().exist(bitMapFilePath)) {
            iQueryBitmap = EmptyQueryBitmap.Companion.getDefault();
        } else {
            Pair<ListMetadata, ListMetadata> pair = this.createMetadata(dimension, member, true);
            ListMetadata indexMetadata = (ListMetadata)pair.component1();
            ListMetadata dataMetadata = (ListMetadata)pair.component2();
            iQueryBitmap = new MinQueryBitmap(indexMetadata, dataMetadata);
        }
        return iQueryBitmap;
    }

    private final Pair<ListMetadata, ListMetadata> createMetadata(Dimension dimension, Member member, boolean isReadonly) {
        this.getBufferProvider().createFolder(dimension.getName());
        String indexFilePath = this.getPath(dimension, member, this.getSegmentExtension());
        String bitMapFilePath = this.getPath(dimension, member, this.getDataExtension());
        ListMetadata indexMetadata = new ListMetadata(this.getBufferProvider().getOrCreate(indexFilePath, isReadonly), null, 2, null);
        ListMetadata dataMetadata = new ListMetadata(this.getBufferProvider().getOrCreate(bitMapFilePath, isReadonly), null, 2, null);
        return new Pair((Object)indexMetadata, (Object)dataMetadata);
    }
}

