/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.storages.selectors;

import java.io.Closeable;
import java.util.Iterator;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IMutableList;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.memoryMappedFiles.ArrayMetadata;
import kd.bos.olapServer.memoryMappedFiles.MutableArrayLong;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBufferProvider;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinMutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinDimensionKeysList;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.BigPageListProvider;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.LastDataMetadata;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MainDataMetadata;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinBitmapData;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinMutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinMutableListSegmentFacade;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinMutableListSegmentInfo;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinMutableVirtualListPage;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.DimensionCollection;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.builds.DimensionBuilder;
import kd.bos.olapServer.metadata.builds.MemberBuilder;
import kd.bos.olapServer.metadata.events.CreateDimensionEvent;
import kd.bos.olapServer.metadata.events.CreateMemberEvent;
import kd.bos.olapServer.metadata.events.DropMemberEvent;
import kd.bos.olapServer.metadata.events.MetadataEvent;
import kd.bos.olapServer.storages.CubeResourcePool;
import kd.bos.olapServer.storages.IMutableFixedNumberMap;
import kd.bos.olapServer.storages.selectors.ExtensionTypes;
import kd.bos.olapServer.storages.selectors.SelectorBase;
import kd.bos.olapServer.storages.selectors.SelectorContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 -2\u00020\u0001:\u0004-./0B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010#\u001a\u00060\u0014j\u0002`\u00152\n\u0010$\u001a\u00060%j\u0002`&J.\u0010'\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010$\u001a\u00060%j\u0002`&2\n\u0010(\u001a\u00060\u001ej\u0002`\u001fJ\u0016\u0010)\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u00061"}, d2={"Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector;", "Lkd/bos/olapServer/storages/selectors/SelectorBase;", "bufferProvider", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "ctx", "Lkd/bos/olapServer/storages/selectors/SelectorContext;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;Lkd/bos/olapServer/storages/selectors/SelectorContext;)V", "bind", "", "event", "Lkd/bos/olapServer/metadata/events/MetadataEvent;", "create", "Lkd/bos/olapServer/collections/IMutableList;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "createMinMutableBitmap", "", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableBitmap;", "dimensionName", "", "Lkd/bos/olapServer/common/string;", "memberIds", "", "(Ljava/lang/String;[I)[Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableBitmap;", "dimBuilder", "Lkd/bos/olapServer/metadata/builds/DimensionBuilder;", "memberBuilder", "Lkd/bos/olapServer/metadata/builds/MemberBuilder;", "exist", "", "Lkd/bos/olapServer/common/bool;", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "onDimensionCreate", "defaultMemberBuilderName", "rowCount", "", "Lkd/bos/olapServer/common/long;", "onMemberCreate", "isDefault", "onMemberDrop", "member", "Lkd/bos/olapServer/metadata/Member;", "tryGet", "Companion", "SharedMinDimensionMetadata", "SharedMinDimensionMetadataBase", "SharedMinMetadata", "bos-olap-core"})
public final class MinV3DimensionIndexSelector
extends SelectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MainPrefix = "main";
    @NotNull
    public static final String LastPrefix = "last";
    @NotNull
    public static final String MemberIndexesPrefix = "memberIndexes";
    @NotNull
    public static final String PagesPrefix = "pages";

    public MinV3DimensionIndexSelector(@NotNull IByteBufferProvider bufferProvider, @NotNull SelectorContext ctx) {
        Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(bufferProvider, ctx);
    }

    public /* synthetic */ MinV3DimensionIndexSelector(IByteBufferProvider iByteBufferProvider, SelectorContext selectorContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            selectorContext = new SelectorContext(null, 1, null);
        }
        this(iByteBufferProvider, selectorContext);
    }

    public final boolean exist(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        if (cube.getDimensions().getCount() == 0) {
            return false;
        }
        Dimension firstDim = (Dimension)cube.getDimensions().get(0);
        return this.exist(firstDim);
    }

    public final boolean exist(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        String path = MinV3DimensionIndexSelector.Companion.getPath(dimension.getName(), MainPrefix, MinV3DimensionIndexSelector.Companion.getMinV3Extension());
        return this.getBufferProvider().exist(path);
    }

    @Nullable
    public final IMutableList<IDimensionKeys> tryGet(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        return this.exist(cube) ? this.create(cube) : (IMutableList<IDimensionKeys>)null;
    }

    @NotNull
    public final IMutableList<IDimensionKeys> create(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        int count = this.getCtx().getRowCount();
        boolean bl = count >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"RowCount = ", (Object)count);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new MinDimensionKeysList(cube, count, (Function2<? super Dimension, ? super Member, ? extends IMinMutableBitmap>)((Function2)new Function2<Dimension, Member, MinMutableBitmap>(new SharedMinMetadata(cube)){

            @NotNull
            public final MinMutableBitmap invoke(@NotNull Dimension p0, @NotNull Member p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((SharedMinMetadata)this.receiver).createMinMutableBitmap(p0, p1);
            }
        }));
    }

    @NotNull
    public final MinMutableBitmap[] createMinMutableBitmap(@NotNull String dimensionName, @NotNull int[] memberIds) {
        Intrinsics.checkNotNullParameter((Object)dimensionName, (String)"dimensionName");
        Intrinsics.checkNotNullParameter((Object)memberIds, (String)"memberIds");
        SharedMinDimensionMetadataBase metadata = new SharedMinDimensionMetadataBase(this.getBufferProvider(), dimensionName);
        int n = 0;
        int n2 = memberIds.length;
        MinMutableBitmap[] minMutableBitmapArray = new MinMutableBitmap[n2];
        while (n < n2) {
            int n3 = n++;
            minMutableBitmapArray[n3] = metadata.createMinMutableBitmap(memberIds[n3]);
        }
        return minMutableBitmapArray;
    }

    private final MinMutableBitmap createMinMutableBitmap(DimensionBuilder dimBuilder, MemberBuilder memberBuilder) {
        IDataContainer iDataContainer;
        CubeResourcePool cubeResourcePool = this.getCtx().getCubeResourcePool();
        Intrinsics.checkNotNull((Object)cubeResourcePool);
        CubeResourcePool pool = cubeResourcePool;
        Dimension dim = dimBuilder.tempBuild(0);
        Member member = (Member)dim.getMembers().get(memberBuilder.getName());
        IMutableFixedNumberMap fixedNumberMap = pool.getMutableFixedNumberMap(dim);
        int memberId = fixedNumberMap.getOrCreateFixedNumber(member.getPosition$bos_olap_core());
        IDataContainer iDataContainer2 = iDataContainer = fixedNumberMap instanceof IDataContainer ? (IDataContainer)((Object)fixedNumberMap) : null;
        if (iDataContainer != null) {
            iDataContainer.force();
        }
        return new SharedMinDimensionMetadata(this.getBufferProvider(), fixedNumberMap, dim.getName()).createMinMutableBitmap(memberId);
    }

    public final void bind(@NotNull MetadataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MetadataEvent metadataEvent = event;
        if (metadataEvent instanceof CreateDimensionEvent) {
            long rowCount = ((CreateDimensionEvent)event).getRowCount();
            event.core((Function0<Unit>)((Function0)new Function0<Unit>(this, event, rowCount){
                final /* synthetic */ MinV3DimensionIndexSelector this$0;
                final /* synthetic */ MetadataEvent $event;
                final /* synthetic */ long $rowCount;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    this.$rowCount = $rowCount;
                    super(0);
                }

                public final void invoke() {
                    String string;
                    MemberBuilder memberBuilder;
                    this.this$0.onDimensionCreate(((CreateDimensionEvent)this.$event).getDimBuilder(), (memberBuilder = ((CreateDimensionEvent)this.$event).getDefaultMemberBuilder()) == null ? "" : ((string = memberBuilder.getName()) == null ? "" : string), this.$rowCount);
                }
            }));
        } else if (metadataEvent instanceof CreateMemberEvent) {
            event.core((Function0<Unit>)((Function0)new Function0<Unit>(event, this){
                final /* synthetic */ MetadataEvent $event;
                final /* synthetic */ MinV3DimensionIndexSelector this$0;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    MemberBuilder[] memberBuilderArray = ((CreateMemberEvent)this.$event).getMemberBuilders();
                    MinV3DimensionIndexSelector minV3DimensionIndexSelector = this.this$0;
                    MetadataEvent metadataEvent = this.$event;
                    boolean $i$f$forEach = false;
                    void var5_5 = $this$forEach$iv;
                    int n = ((void)var5_5).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var5_5[i];
                        boolean bl = false;
                        minV3DimensionIndexSelector.onMemberCreate(((CreateMemberEvent)metadataEvent).getDimBuilder(), (MemberBuilder)it, ((CreateMemberEvent)metadataEvent).getRowCount(), ((CreateMemberEvent)metadataEvent).isDefault());
                    }
                }
            }));
        } else if (metadataEvent instanceof DropMemberEvent) {
            event.core((Function0<Unit>)((Function0)new Function0<Unit>(event, this){
                final /* synthetic */ MetadataEvent $event;
                final /* synthetic */ MinV3DimensionIndexSelector this$0;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Dimension dimension = ((DropMemberEvent)this.$event).getDimension();
                    Member[] memberArray = ((DropMemberEvent)this.$event).getDropMembers();
                    MinV3DimensionIndexSelector minV3DimensionIndexSelector = this.this$0;
                    boolean $i$f$forEach = false;
                    void var5_5 = $this$forEach$iv;
                    int n = ((void)var5_5).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var5_5[i];
                        boolean bl = false;
                        minV3DimensionIndexSelector.onMemberDrop(dimension, (Member)it);
                    }
                }
            }));
        }
    }

    public final void onDimensionCreate(@NotNull DimensionBuilder dimBuilder, @NotNull String defaultMemberBuilderName, long rowCount) {
        Intrinsics.checkNotNullParameter((Object)dimBuilder, (String)"dimBuilder");
        Intrinsics.checkNotNullParameter((Object)defaultMemberBuilderName, (String)"defaultMemberBuilderName");
        for (MemberBuilder member : dimBuilder.getMembers()) {
            this.onMemberCreate(dimBuilder, member, rowCount, Intrinsics.areEqual((Object)member.getName(), (Object)defaultMemberBuilderName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMemberCreate(@NotNull DimensionBuilder dimBuilder, @NotNull MemberBuilder memberBuilder, long rowCount, boolean isDefault) {
        Intrinsics.checkNotNullParameter((Object)dimBuilder, (String)"dimBuilder");
        Intrinsics.checkNotNullParameter((Object)memberBuilder, (String)"memberBuilder");
        if (rowCount > 0L && isDefault) {
            MinMutableBitmap minMutableBitmap = this.createMinMutableBitmap(dimBuilder, memberBuilder);
            Closeable closeable = minMutableBitmap;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                MinMutableBitmap it = (MinMutableBitmap)closeable;
                boolean bl3 = false;
                int longCount = (int)(rowCount / (long)64);
                int bitRemCount = (int)(rowCount % (long)64);
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)longCount);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl4 = false;
                    minMutableBitmap.update(i, -1L);
                }
                long lastValue = 0L;
                if (bitRemCount > 0) {
                    Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)bitRemCount);
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv2.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int i = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl5 = false;
                        lastValue = CommonTypesKt.setTrue(lastValue, i);
                    }
                    minMutableBitmap.update(longCount, lastValue);
                }
                minMutableBitmap.force();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public final void onMemberDrop(@NotNull Dimension dimension, @NotNull Member member) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector$SharedMinMetadata;", "", "cube", "Lkd/bos/olapServer/metadata/Cube;", "(Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector;Lkd/bos/olapServer/metadata/Cube;)V", "dims", "", "Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector$SharedMinDimensionMetadata;", "[Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector$SharedMinDimensionMetadata;", "fixedNumberMaps", "Lkd/bos/olapServer/storages/IMutableFixedNumberMap;", "[Lkd/bos/olapServer/storages/IMutableFixedNumberMap;", "createMinMutableBitmap", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableBitmap;", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "member", "Lkd/bos/olapServer/metadata/Member;", "bos-olap-core"})
    private final class SharedMinMetadata {
        @NotNull
        private final SharedMinDimensionMetadata[] dims;
        @NotNull
        private final IMutableFixedNumberMap[] fixedNumberMaps;

        public SharedMinMetadata(Cube cube) {
            Intrinsics.checkNotNullParameter((Object)MinV3DimensionIndexSelector.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            DimensionCollection tmp = cube.getDimensions();
            CubeResourcePool cubeResourcePool = MinV3DimensionIndexSelector.this.getCtx().getCubeResourcePool();
            Intrinsics.checkNotNull((Object)cubeResourcePool);
            CubeResourcePool pool = cubeResourcePool;
            int n = 0;
            int n2 = tmp.getCount();
            IMutableFixedNumberMap[] iMutableFixedNumberMapArray = new IMutableFixedNumberMap[n2];
            SharedMinMetadata sharedMinMetadata = this;
            while (n < n2) {
                int n3 = n++;
                Dimension dim = (Dimension)tmp.get(n3);
                iMutableFixedNumberMapArray[n3] = pool.getMutableFixedNumberMap(dim);
            }
            sharedMinMetadata.fixedNumberMaps = iMutableFixedNumberMapArray;
            this.dims = new SharedMinDimensionMetadata[tmp.getCount()];
        }

        @NotNull
        public final MinMutableBitmap createMinMutableBitmap(@NotNull Dimension dimension, @NotNull Member member) {
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            int dimPos = dimension.getPosition();
            SharedMinDimensionMetadata item = this.dims[dimPos];
            if (item == null) {
                IMutableFixedNumberMap fixedNumberMap = this.fixedNumberMaps[dimPos];
                this.dims[dimPos] = item = new SharedMinDimensionMetadata(MinV3DimensionIndexSelector.this.getBufferProvider(), fixedNumberMap, dimension.getName());
            }
            return item.createMinMutableBitmap(member);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010+\u001a\u00020,2\n\u0010-\u001a\u00060.j\u0002`/R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00060"}, d2={"Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector$SharedMinDimensionMetadataBase;", "", "bufferProvider", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "dimensionName", "", "Lkd/bos/olapServer/common/string;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;Ljava/lang/String;)V", "arrayMetadata", "Lkd/bos/olapServer/memoryMappedFiles/ArrayMetadata;", "getArrayMetadata", "()Lkd/bos/olapServer/memoryMappedFiles/ArrayMetadata;", "lastData", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/LastDataMetadata;", "getLastData", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/LastDataMetadata;", "lastDataPath", "getLastDataPath", "()Ljava/lang/String;", "mainData", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MainDataMetadata;", "getMainData", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MainDataMetadata;", "mainDataPath", "getMainDataPath", "memberIndexes", "Lkd/bos/olapServer/memoryMappedFiles/MutableArrayLong;", "getMemberIndexes", "()Lkd/bos/olapServer/memoryMappedFiles/MutableArrayLong;", "memberIndexesPath", "getMemberIndexesPath", "minBitmapData", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;", "getMinBitmapData", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;", "pages", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableVirtualListPage;", "getPages", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableVirtualListPage;", "provider", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/BigPageListProvider;", "getProvider", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/BigPageListProvider;", "createMinMutableBitmap", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableBitmap;", "memberId", "", "Lkd/bos/olapServer/common/int;", "bos-olap-core"})
    private static class SharedMinDimensionMetadataBase {
        @NotNull
        private final String mainDataPath;
        @NotNull
        private final MainDataMetadata mainData;
        @NotNull
        private final String lastDataPath;
        @NotNull
        private final LastDataMetadata lastData;
        @NotNull
        private final MinBitmapData minBitmapData;
        @NotNull
        private final String memberIndexesPath;
        @NotNull
        private final ArrayMetadata arrayMetadata;
        @NotNull
        private final MutableArrayLong memberIndexes;
        @NotNull
        private final BigPageListProvider provider;
        @NotNull
        private final MinMutableVirtualListPage pages;

        public SharedMinDimensionMetadataBase(@NotNull IByteBufferProvider bufferProvider, @NotNull String dimensionName) {
            Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)"dimensionName");
            this.mainDataPath = Companion.getPath(dimensionName, MinV3DimensionIndexSelector.MainPrefix, Companion.getMinV3Extension());
            this.mainData = new MainDataMetadata(bufferProvider.getOrCreate(this.mainDataPath, false), null, 2, null);
            this.lastDataPath = Companion.getPath(dimensionName, MinV3DimensionIndexSelector.LastPrefix, Companion.getMinV3Extension());
            this.lastData = new LastDataMetadata(bufferProvider.getOrCreate(this.lastDataPath, false), null, 2, null);
            this.minBitmapData = new MinBitmapData(this.mainData, this.lastData);
            this.memberIndexesPath = Companion.getPath(dimensionName, MinV3DimensionIndexSelector.MemberIndexesPrefix, Companion.getMinV3Extension());
            this.arrayMetadata = new ArrayMetadata(bufferProvider.getOrCreate(this.memberIndexesPath, false), null, 2, null);
            this.memberIndexes = new MutableArrayLong(this.arrayMetadata);
            this.provider = new BigPageListProvider(bufferProvider, dimensionName, false);
            this.pages = new MinMutableVirtualListPage(this.provider);
        }

        @NotNull
        public final String getMainDataPath() {
            return this.mainDataPath;
        }

        @NotNull
        public final MainDataMetadata getMainData() {
            return this.mainData;
        }

        @NotNull
        public final String getLastDataPath() {
            return this.lastDataPath;
        }

        @NotNull
        public final LastDataMetadata getLastData() {
            return this.lastData;
        }

        @NotNull
        public final MinBitmapData getMinBitmapData() {
            return this.minBitmapData;
        }

        @NotNull
        public final String getMemberIndexesPath() {
            return this.memberIndexesPath;
        }

        @NotNull
        public final ArrayMetadata getArrayMetadata() {
            return this.arrayMetadata;
        }

        @NotNull
        public final MutableArrayLong getMemberIndexes() {
            return this.memberIndexes;
        }

        @NotNull
        public final BigPageListProvider getProvider() {
            return this.provider;
        }

        @NotNull
        public final MinMutableVirtualListPage getPages() {
            return this.pages;
        }

        @NotNull
        public final MinMutableBitmap createMinMutableBitmap(int memberId) {
            MinMutableListSegmentInfo list = new MinMutableListSegmentInfo(memberId, this.memberIndexes, this.pages);
            MinMutableListSegmentFacade indexes = new MinMutableListSegmentFacade(list);
            return new MinMutableBitmap(memberId, this.minBitmapData, indexes);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector$SharedMinDimensionMetadata;", "Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector$SharedMinDimensionMetadataBase;", "bufferProvider", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;", "fixedNumberMap", "Lkd/bos/olapServer/storages/IMutableFixedNumberMap;", "dimensionName", "", "Lkd/bos/olapServer/common/string;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferProvider;Lkd/bos/olapServer/storages/IMutableFixedNumberMap;Ljava/lang/String;)V", "createMinMutableBitmap", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableBitmap;", "member", "Lkd/bos/olapServer/metadata/Member;", "bos-olap-core"})
    private static final class SharedMinDimensionMetadata
    extends SharedMinDimensionMetadataBase {
        @NotNull
        private final IMutableFixedNumberMap fixedNumberMap;

        public SharedMinDimensionMetadata(@NotNull IByteBufferProvider bufferProvider, @NotNull IMutableFixedNumberMap fixedNumberMap, @NotNull String dimensionName) {
            Intrinsics.checkNotNullParameter((Object)bufferProvider, (String)"bufferProvider");
            Intrinsics.checkNotNullParameter((Object)fixedNumberMap, (String)"fixedNumberMap");
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)"dimensionName");
            super(bufferProvider, dimensionName);
            this.fixedNumberMap = fixedNumberMap;
        }

        @NotNull
        public final MinMutableBitmap createMinMutableBitmap(@NotNull Member member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            int memberId = this.fixedNumberMap.getOrCreateFixedNumber(member.getPosition$bos_olap_core());
            return this.createMinMutableBitmap(memberId);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u00020\u00042\n\u0010\r\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0004j\u0002`\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\u0004j\u0002`\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/storages/selectors/MinV3DimensionIndexSelector$Companion;", "", "()V", "LastPrefix", "", "Lkd/bos/olapServer/common/string;", "MainPrefix", "MemberIndexesPrefix", "MinV3Extension", "getMinV3Extension", "()Ljava/lang/String;", "PagesPrefix", "getPath", "dimensionName", "prefix", "extension", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMinV3Extension() {
            return ExtensionTypes.INSTANCE.getMinV3Type();
        }

        private final String getPath(String dimensionName, String prefix, String extension) {
            String[] stringArray = new String[]{prefix + '.' + extension};
            return ((Object)Paths.INSTANCE.get(dimensionName, stringArray)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

