/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.tools;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.tools.JsonHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.nio.cs.StreamEncoder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u001a\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0018\u001a\u00060\u0006j\u0002`\u0007R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lkd/bos/olapServer/tools/RecycledByteArrayOutputStream;", "Ljava/io/OutputStream;", "buf", "", "onFlush", "Lkotlin/Function2;", "", "Lkd/bos/olapServer/common/int;", "", "([BLkotlin/jvm/functions/Function2;)V", "_size", "array", "getArray", "()[B", "size", "getSize", "()I", "ensureCapacity", "minCapacity", "flush", "grow", "write", "b", "off", "len", "writeFrom", "inputStream", "Ljava/io/InputStream;", "Companion", "bos-olap-core"})
public final class RecycledByteArrayOutputStream
extends OutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] buf;
    @Nullable
    private final Function2<byte[], Integer, Unit> onFlush;
    private int _size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public RecycledByteArrayOutputStream(@NotNull byte[] buf, @Nullable Function2<? super byte[], ? super Integer, Unit> onFlush) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.buf = buf;
        this.onFlush = onFlush;
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private final void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = RecycledByteArrayOutputStream.Companion.hugeCapacity(minCapacity);
        }
        byte[] byArray = this.buf;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, newCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        this.buf = byArray2;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this._size + 1);
        this.buf[this._size] = (byte)b;
        RecycledByteArrayOutputStream recycledByteArrayOutputStream = this;
        ++recycledByteArrayOutputStream._size;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this._size + len);
        System.arraycopy(b, off, this.buf, this._size, len);
        RecycledByteArrayOutputStream recycledByteArrayOutputStream = this;
        recycledByteArrayOutputStream._size += len;
    }

    public final void writeFrom(@NotNull InputStream inputStream, int len) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len > 0) {
            this.ensureCapacity(this._size + len);
            int readSize = CommonTypesKt.readByteArray(inputStream, this.buf, this._size, len);
            if (readSize > 0) {
                RecycledByteArrayOutputStream recycledByteArrayOutputStream = this;
                recycledByteArrayOutputStream._size += readSize;
            }
        }
    }

    @Override
    public void flush() {
        Function2<byte[], Integer, Unit> function2 = this.onFlush;
        if (function2 != null) {
            function2.invoke((Object)this.buf, (Object)this._size);
        }
    }

    @NotNull
    public final byte[] getArray() {
        return this.buf;
    }

    public final int getSize() {
        return this._size;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u001f\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u000bJ#\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\n\u0010\n\u001a\u00060\rj\u0002`\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ/\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/tools/RecycledByteArrayOutputStream$Companion;", "", "()V", "MAX_ARRAY_SIZE", "", "hugeCapacity", "minCapacity", "writeJson", "Ljava/nio/ByteBuffer;", "cache", "value", "writeJson$bos_olap_core", "writeString", "", "Lkd/bos/olapServer/common/string;", "writeString$bos_olap_core", "writeTo", "write", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "", "writeTo$bos_olap_core", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int hugeCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }

        @NotNull
        public final ByteBuffer writeJson$bos_olap_core(@Nullable ByteBuffer cache, @NotNull Object value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Companion this_$iv = this;
            boolean $i$f$writeTo$bos_olap_core = false;
            byte[] bytes$iv = cache == null || cache.capacity() > 16384 ? new byte[4096] : cache.array();
            Intrinsics.checkNotNullExpressionValue((Object)bytes$iv, (String)"bytes");
            RecycledByteArrayOutputStream stream$iv = new RecycledByteArrayOutputStream(bytes$iv, null);
            OutputStream stream = stream$iv;
            boolean bl = false;
            JsonHelper.INSTANCE.getMapper().writeValue(stream, value2);
            stream$iv.flush();
            ByteBuffer byteBuffer = ByteBuffer.wrap(stream$iv.getArray(), 0, stream$iv.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(stream.array,0,stream.size)");
            return byteBuffer;
        }

        @NotNull
        public final ByteBuffer writeString$bos_olap_core(@Nullable ByteBuffer cache, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Companion this_$iv = this;
            boolean $i$f$writeTo$bos_olap_core = false;
            byte[] bytes$iv = cache == null || cache.capacity() > 16384 ? new byte[4096] : cache.array();
            Intrinsics.checkNotNullExpressionValue((Object)bytes$iv, (String)"bytes");
            RecycledByteArrayOutputStream stream$iv = new RecycledByteArrayOutputStream(bytes$iv, null);
            OutputStream stream = stream$iv;
            boolean bl = false;
            StreamEncoder e = StreamEncoder.forOutputStreamWriter(stream, (Object)stream, Charsets.UTF_8);
            e.write(value2);
            e.flush();
            stream$iv.flush();
            ByteBuffer byteBuffer = ByteBuffer.wrap(stream$iv.getArray(), 0, stream$iv.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(stream.array,0,stream.size)");
            return byteBuffer;
        }

        @NotNull
        public final ByteBuffer writeTo$bos_olap_core(@Nullable ByteBuffer cache, @NotNull Function1<? super OutputStream, Unit> write2) {
            Intrinsics.checkNotNullParameter(write2, (String)"write");
            boolean $i$f$writeTo$bos_olap_core = false;
            byte[] bytes = cache == null || cache.capacity() > 16384 ? new byte[4096] : cache.array();
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            RecycledByteArrayOutputStream stream = new RecycledByteArrayOutputStream(bytes, null);
            write2.invoke((Object)stream);
            stream.flush();
            ByteBuffer byteBuffer = ByteBuffer.wrap(stream.getArray(), 0, stream.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(stream.array,0,stream.size)");
            return byteBuffer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

