/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.tools;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.olapServer.replication.IDDLRecord;
import kd.bos.olapServer.replication.IRedoRecord;
import kd.bos.olapServer.replication.ReadedRedoFile;
import kd.bos.olapServer.replication.ReadedRedoPage;
import kd.bos.olapServer.replication.SlaveLSNContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R2\u0010\u000b\u001a&\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\fj\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer/tools/RedoParser;", "", "startLSN", "", "Lkd/bos/olapServer/common/long;", "endLSN", "redoPath", "", "Lkd/bos/olapServer/common/string;", "parseFilePath", "(JJLjava/lang/String;Ljava/lang/String;)V", "UnCompleteDdlRecords", "Ljava/util/HashMap;", "", "Lkd/bos/olapServer/common/int;", "Lkd/bos/olapServer/replication/IRedoRecord;", "Lkotlin/collections/HashMap;", "parse", "", "parseDDLRecord", "lineHead", "record", "Lkd/bos/olapServer/replication/IDDLRecord;", "writer", "Ljava/io/Writer;", "bos-olap-core"})
public final class RedoParser {
    private final long startLSN;
    private final long endLSN;
    @NotNull
    private final String redoPath;
    @NotNull
    private final String parseFilePath;
    @NotNull
    private HashMap<Integer, IRedoRecord> UnCompleteDdlRecords;

    public RedoParser(long startLSN, long endLSN, @NotNull String redoPath, @NotNull String parseFilePath) {
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)parseFilePath, (String)"parseFilePath");
        this.startLSN = startLSN;
        this.endLSN = endLSN;
        this.redoPath = redoPath;
        this.parseFilePath = parseFilePath;
        this.UnCompleteDdlRecords = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse() {
        SlaveLSNContext slaveLSNContext = new SlaveLSNContext(this.startLSN, this.endLSN);
        ReadedRedoFile redoFile = new ReadedRedoFile(this.redoPath, slaveLSNContext);
        File parseFile = new File(this.parseFilePath);
        if (parseFile.isDirectory()) {
            throw new RuntimeException(Intrinsics.stringPlus((String)this.parseFilePath, (Object)" is a directory, but required a file."));
        }
        Closeable closeable = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(parseFile)));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl3 = false;
            while (redoFile.hasNext()) {
                ReadedRedoPage page = redoFile.next();
                long lsn = page.getLSN();
                byte version = page.getVersion();
                SimpleDateFormat sdf = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
                sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
                String timestamp = sdf.format(page.getTimestamp());
                String lineHead = "" + '[' + lsn + ' ' + version + ' ' + timestamp + "] ";
                while (page.hasNext()) {
                    IRedoRecord record2 = page.next();
                    IRedoRecord iRedoRecord = record2;
                    if (iRedoRecord instanceof IDDLRecord) {
                        this.parseDDLRecord(lineHead, (IDDLRecord)record2, writer);
                        continue;
                    }
                    writer.append(Intrinsics.stringPlus((String)lineHead, (Object)record2));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void parseDDLRecord(String lineHead, IDDLRecord record2, Writer writer) {
        IRedoRecord ddlRecord = this.UnCompleteDdlRecords.get(record2.getCubeId());
        if (ddlRecord == null) {
            if (record2.isEofDDL()) {
                writer.append(Intrinsics.stringPlus((String)lineHead, (Object)record2));
            } else {
                Map map = this.UnCompleteDdlRecords;
                Integer n = record2.getCubeId();
                boolean bl = false;
                map.put(n, record2);
            }
        } else {
            IDDLRecord conRecord = record2.consolidate(ddlRecord);
            Map map = this.UnCompleteDdlRecords;
            Integer n = record2.getCubeId();
            boolean bl = false;
            map.put(n, conRecord);
            if (!record2.isEofDDL()) {
                return;
            }
            writer.append(Intrinsics.stringPlus((String)lineHead, (Object)conRecord));
            this.UnCompleteDdlRecords.remove(record2.getCubeId());
        }
    }
}

