/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.tools;

import java.io.File;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.metadata.OlapMetadata;
import kd.bos.olapServer.replication.ControlConfig;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.RedoParser;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bJ(\u0010\r\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0018\u00010\u000e2\n\u0010\u000f\u001a\u00060\nj\u0002`\u000bJ\u001e\u0010\u0010\u001a\u00020\u00042\n\u0010\u0011\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0012\u001a\u00060\nj\u0002`\u000bJ\u001e\u0010\u0013\u001a\u00020\u00042\n\u0010\u0012\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0011\u001a\u00060\nj\u0002`\u000bJ*\u0010\u0014\u001a\u00020\u00042\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0015\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0016\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer/tools/ReplicationTool;", "", "()V", "parseRedo", "", "startLSN", "", "Lkd/bos/olapServer/common/long;", "endLSN", "redoPath", "", "Lkd/bos/olapServer/common/string;", "parseFilePath", "readLSNControl", "Lkotlin/Pair;", "controlFilePath", "totalBackup", "databasePath", "backupPath", "totalRecovery", "updateLSNControl", "recoveryStartLSN", "recoveryEndLSN", "bos-olap-core"})
public final class ReplicationTool {
    @Nullable
    public final Pair<Long, Long> readLSNControl(@NotNull String controlFilePath) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)controlFilePath, (String)"controlFilePath");
        if (new File(controlFilePath).exists()) {
            ControlConfig controlConfig = ControlConfig.Companion.readControlConfig(controlFilePath);
            pair = new Pair((Object)controlConfig.getRecoveryStartLSN(), (Object)controlConfig.getRecoveryEndLSN());
        } else {
            pair = null;
        }
        return pair;
    }

    public final void updateLSNControl(@NotNull String controlFilePath, long recoveryStartLSN, long recoveryEndLSN) {
        Intrinsics.checkNotNullParameter((Object)controlFilePath, (String)"controlFilePath");
        new ControlConfig(recoveryStartLSN, recoveryEndLSN).save(controlFilePath);
    }

    public final void parseRedo(long startLSN, long endLSN, @NotNull String redoPath, @NotNull String parseFilePath) {
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)parseFilePath, (String)"parseFilePath");
        new RedoParser(startLSN, endLSN, redoPath, parseFilePath).parse();
    }

    public final void totalBackup(@NotNull String databasePath, @NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        OlapMetadata olapMetadata = OlapMetadata.Companion.ReadFrom(databasePath);
        OlapWorkspace olapWorkspace = new OlapWorkspace(olapMetadata, databasePath);
        File backupDir = new File(backupPath);
        if (backupDir.isFile()) {
            throw new RuntimeException(Intrinsics.stringPlus((String)backupPath, (Object)" is a file, but required a directory."));
        }
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        olapWorkspace.backupOlap(backupPath);
        Object object = new String[]{"index.json"};
        File indexJsonFile = Paths.INSTANCE.get(databasePath, (String)object).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)indexJsonFile, (String)"indexJsonFile");
        String[] stringArray = new String[1];
        String string = indexJsonFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indexJsonFile.name");
        stringArray[0] = string;
        object = Paths.INSTANCE.get(backupPath, stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Paths.get(backupPath, indexJsonFile.name).toFile()");
        FilesKt.copyTo$default((File)indexJsonFile, (File)object, (boolean)false, (int)0, (int)6, null);
    }

    public final void totalRecovery(@NotNull String backupPath, @NotNull String databasePath) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        OlapMetadata olapMetadata = OlapMetadata.Companion.ReadFrom(databasePath);
        OlapWorkspace olapWorkspace = new OlapWorkspace(olapMetadata, databasePath);
        olapWorkspace.recoveryOlap(backupPath);
    }
}

