/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.transactions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.olapServer.backup.sequenceLog.SeqLogSetting;
import kd.bos.olapServer.tools.Res;
import kd.bos.olapServer.transactions.ITransaction;
import kd.bos.olapServer.transactions.ITransactionVersion;
import kd.bos.olapServer.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0013\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/transactions/TransactionManager;", "", "lastTransactionId", "", "Lkd/bos/olapServer/common/long;", "(J)V", "_lastTransactionId", "Ljava/util/concurrent/atomic/AtomicLong;", "lastCommittedTransactionId", "getLastCommittedTransactionId", "()J", "beginTransaction", "Lkd/bos/olapServer/transactions/ITransaction;", "updateVersion", "", "newVersion", "Companion", "Transaction", "bos-olap-core"})
public final class TransactionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicLong _lastTransactionId;

    public TransactionManager(long lastTransactionId) {
        this._lastTransactionId = new AtomicLong(lastTransactionId);
    }

    public /* synthetic */ TransactionManager(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        this(l);
    }

    public final void updateVersion(long newVersion) {
        this._lastTransactionId.set(newVersion);
    }

    @NotNull
    public final ITransaction beginTransaction() {
        return new Transaction();
    }

    public final long getLastCommittedTransactionId() {
        return this._lastTransactionId.get();
    }

    public TransactionManager() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/transactions/TransactionManager$Companion;", "", "()V", "createTransactionManager", "Lkd/bos/olapServer/transactions/TransactionManager;", "rootPath", "", "Lkd/bos/olapServer/common/string;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final TransactionManager createTransactionManager(@NotNull String rootPath) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
                lastVersion = 0L;
                files = new File(rootPath).listFiles();
                if (files == null) break block5;
                $this$filter$iv = files;
                $i$f$filter = false;
                var8_7 /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var11_11 = $this$filterTo$iv$iv;
                var12_12 = ((void)var11_11).length;
                for (var13_13 = 0; var13_13 < var12_12; ++var13_13) {
                    it = element$iv$iv = var11_11[var13_13];
                    $i$a$-filter-TransactionManager$Companion$createTransactionManager$1 = false;
                    var17_17 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)var17_17, (String)"it.name");
                    if (!StringsKt.startsWith$default((String)var17_17, (String)"commands", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    var17_17 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)var17_17, (String)"it.name");
                    if (StringsKt.endsWith$default((String)var17_17, (String)".log", (boolean)false, (int)2, null)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (File file : (List)destination$iv$iv) {
                    var8_7 /* !! */  = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)var8_7 /* !! */ , (String)"file.name");
                    versions = SeqLogSetting.Companion.getStartAndEnd((String)var8_7 /* !! */ , "commands".length());
                    if (((Number)versions.getFirst()).longValue() < ((Number)versions.getSecond()).longValue()) {
                        var8_8 = ((Number)versions.getSecond()).longValue();
                        var10_10 = false;
                        lastVersion = Math.max(lastVersion, var8_8);
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    lastVersion = SeqLogSetting.Companion.getLastId(file, ((Number)versions.getSecond()).longValue());
                    break;
                }
            }
            return new TransactionManager(lastVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n0\u000bR\u00060\u0000R\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer/transactions/TransactionManager$Transaction;", "Lkd/bos/olapServer/transactions/ITransaction;", "(Lkd/bos/olapServer/transactions/TransactionManager;)V", "_id", "", "Lkd/bos/olapServer/common/long;", "_isClosed", "", "_state", "Lkd/bos/olapServer/transactions/TransactionStatus;", "_version", "Lkd/bos/olapServer/transactions/TransactionManager$Transaction$MutableTransactionVersion;", "Lkd/bos/olapServer/transactions/TransactionManager;", "state", "getState", "()Lkd/bos/olapServer/transactions/TransactionStatus;", "version", "Lkd/bos/olapServer/transactions/ITransactionVersion;", "getVersion", "()Lkd/bos/olapServer/transactions/ITransactionVersion;", "close", "", "commit", "rollback", "MutableTransactionVersion", "bos-olap-core"})
    private final class Transaction
    implements ITransaction {
        private long _id;
        @NotNull
        private final MutableTransactionVersion _version;
        @NotNull
        private TransactionStatus _state;
        private boolean _isClosed;

        public Transaction() {
            Intrinsics.checkNotNullParameter((Object)TransactionManager.this, (String)"this$0");
            this._id = TransactionManager.this._lastTransactionId.incrementAndGet();
            this._version = new MutableTransactionVersion();
            this._state = TransactionStatus.Active;
        }

        @Override
        public void commit() {
            if (this._isClosed) {
                String string = Res.INSTANCE.getTransactionManagerException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.TransactionManagerException_1");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            if (this._state != TransactionStatus.Active) {
                String string = Res.INSTANCE.getTransactionManagerException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.TransactionManagerException_2");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            this._state = TransactionStatus.Committed;
        }

        @Override
        public void rollback() {
            if (this._isClosed) {
                String string = Res.INSTANCE.getTransactionManagerException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.TransactionManagerException_1");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            if (this._state != TransactionStatus.Active) {
                String string = Res.INSTANCE.getTransactionManagerException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.TransactionManagerException_2");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            this._state = TransactionStatus.Aborted;
        }

        @Override
        @NotNull
        public ITransactionVersion getVersion() {
            return this._version;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this._state;
        }

        @Override
        public void close() {
            if (!this._isClosed) {
                if (this._state == TransactionStatus.Active) {
                    this.rollback();
                }
                this._isClosed = true;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/transactions/TransactionManager$Transaction$MutableTransactionVersion;", "Lkd/bos/olapServer/transactions/ITransactionVersion;", "(Lkd/bos/olapServer/transactions/TransactionManager$Transaction;)V", "id", "", "Lkd/bos/olapServer/common/long;", "getId", "()J", "isClosed", "", "Lkd/bos/olapServer/common/bool;", "()Z", "bos-olap-core"})
        private final class MutableTransactionVersion
        implements ITransactionVersion {
            public MutableTransactionVersion() {
                Intrinsics.checkNotNullParameter((Object)Transaction.this, (String)"this$0");
            }

            @Override
            public long getId() {
                return Transaction.this._id;
            }

            @Override
            public boolean isClosed() {
                return Transaction.this._isClosed;
            }
        }
    }
}

