/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import SevenZip.Compression.LZMA.Encoder;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.OutputStream;
import kd.bos.olapServer2.backup.BackupConstant;
import kd.bos.olapServer2.backup.BackupContext;
import kd.bos.olapServer2.backup.DistributedBackup;
import kd.bos.olapServer2.backup.IBackupItem;
import kd.bos.olapServer2.backup.KeysBackup;
import kd.bos.olapServer2.backup.MeasuresBackup;
import kd.bos.olapServer2.backup.MetadataBackup;
import kd.bos.olapServer2.backup.RowValidBitmapBackup;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.partitions.CachePartitionItem;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.ICubeDataLock;
import kd.bos.olapServer2.storages.PartitionCubeWorkspace;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\u001e\u001a\u00060\bj\u0002`\tH\u0002J\u001c\u0010\u001f\u001a\u00020\u001a2\n\u0010 \u001a\u00060\u0017j\u0002`\u00182\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/backup/CubeBackup;", "Ljava/io/Closeable;", "workspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "outputStream", "Ljava/io/OutputStream;", "metadataReadLock", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/storages/CubeWorkspace;Ljava/io/OutputStream;Ljava/io/Closeable;Ljava/lang/String;)V", "_fileVersion", "_stream", "Ljava/io/DataOutputStream;", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "fileVersion", "getFileVersion", "()Ljava/lang/String;", "items", "Lkd/bos/olapServer2/backup/DistributedBackup;", "Lkd/bos/olapServer2/backup/IBackupItem;", "backup", "", "Lkd/bos/olapServer2/common/long;", "close", "", "upgradeFileVersion", "basicWorkspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "cubeName", "write", "version", "ctx", "Lkd/bos/olapServer2/backup/BackupContext;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nCubeBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeBackup.kt\nkd/bos/olapServer2/backup/CubeBackup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CancellableToken.kt\nkd/bos/olapServer2/common/CancellableToken\n*L\n1#1,182:1\n1855#2,2:183\n106#3,13:185\n*S KotlinDebug\n*F\n+ 1 CubeBackup.kt\nkd/bos/olapServer2/backup/CubeBackup\n*L\n57#1:183,2\n140#1:185,13\n*E\n"})
public final class CubeBackup
implements Closeable {
    @NotNull
    private final CubeWorkspace workspace;
    @Nullable
    private Closeable metadataReadLock;
    @NotNull
    private final DistributedBackup<IBackupItem> items;
    @NotNull
    private final Cube cube;
    @NotNull
    private final DataOutputStream _stream;
    @NotNull
    private String _fileVersion;

    public CubeBackup(@NotNull CubeWorkspace workspace, @NotNull OutputStream outputStream, @Nullable Closeable metadataReadLock, @NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.workspace = workspace;
        this.metadataReadLock = metadataReadLock;
        this.items = new DistributedBackup();
        this.cube = this.workspace.getMetadata();
        this._stream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this._fileVersion = BackupConstant.INSTANCE.getBackupFileHeader_v5();
        String cubeName = this.cube.getName();
        this.items.registerProxy(new MetadataBackup(this.workspace, rootPath));
        if (this.cube.getEnabledPartition()) {
            Iterable $this$forEach$iv = this.workspace.getPartitionWorkspaces();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractCubeWorkspace subWorkspace = (AbstractCubeWorkspace)element$iv;
                boolean bl = false;
                if (!(subWorkspace instanceof PartitionCubeWorkspace)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (StringsKt.contains$default((CharSequence)((PartitionCubeWorkspace)subWorkspace).getPartitionItem().getKey(), (CharSequence)CachePartitionItem.INSTANCE.getKey(), (boolean)false, (int)2, null) || subWorkspace.getRowCount() <= 0L) continue;
                ICubeDataLock dataLock = subWorkspace.getDataLock();
                RowValidBitmapBackup rowValidBitmapItem = new RowValidBitmapBackup(subWorkspace, rootPath);
                KeysBackup keyItem = new KeysBackup(subWorkspace, dataLock);
                MeasuresBackup measureItem = new MeasuresBackup(dataLock, keyItem, subWorkspace, rootPath);
                this.items.registerProxy(rowValidBitmapItem);
                this.items.registerProxy(keyItem);
                this.items.registerProxy(measureItem);
                this.upgradeFileVersion(subWorkspace, rootPath, cubeName);
            }
        } else {
            AbstractCubeWorkspace basicWorkspace = (AbstractCubeWorkspace)CollectionsKt.first((Iterable)this.workspace.getPartitionWorkspaces());
            if (basicWorkspace.getRowCount() > 0L) {
                ICubeDataLock dataLock = basicWorkspace.getDataLock();
                RowValidBitmapBackup rowValidBitmapItem = new RowValidBitmapBackup(basicWorkspace, rootPath);
                KeysBackup keyItem = new KeysBackup(basicWorkspace, dataLock);
                MeasuresBackup measureItem = new MeasuresBackup(dataLock, keyItem, basicWorkspace, rootPath);
                this.items.registerProxy(rowValidBitmapItem);
                this.items.registerProxy(keyItem);
                this.items.registerProxy(measureItem);
                this.upgradeFileVersion(basicWorkspace, rootPath, cubeName);
            }
        }
    }

    private final String getFileVersion() {
        return this._fileVersion;
    }

    private final void upgradeFileVersion(AbstractCubeWorkspace basicWorkspace, String rootPath, String cubeName) {
        if (Intrinsics.areEqual((Object)this._fileVersion, (Object)BackupConstant.INSTANCE.getLatestBackupFileHeader())) {
            return;
        }
        String partitionKey = BackupConstant.INSTANCE.getPartitionKey(basicWorkspace);
        String[] stringArray = new String[]{cubeName, partitionKey};
        String path = ((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString();
        if (RowValidBitmapBackup.Companion.requireBackupFile(path)) {
            this._fileVersion = BackupConstant.INSTANCE.getLatestBackupFileHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long backup() {
        long version = this.workspace.getTransactionManager().getLastCommittedTransactionId();
        CancellableToken this_$iv = CancellableToken.INSTANCE;
        boolean $i$f$withCancellable = false;
        ICancellable ct$iv = OlapContext.Companion.tryGetContext(ICancellable.class);
        if (ct$iv == null) {
            ICancellable myCt$iv = this_$iv.createCancellable();
            OlapContext.Companion.push(myCt$iv);
            try {
                boolean bl = false;
                Closeable closeable = new BackupContext(this.workspace.getMetadata().getName(), this._stream);
                Throwable throwable = null;
                try {
                    BackupContext ctx = (BackupContext)closeable;
                    boolean bl2 = false;
                    this.items.init(ctx);
                    ctx.getDependencyTasks().submitAndWaitTasks();
                    Closeable readLock = this.metadataReadLock;
                    if (readLock != null) {
                        readLock.close();
                        this.metadataReadLock = null;
                    }
                    this.write(version, ctx);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                OlapContext.Companion.pop(myCt$iv);
            }
        }
        boolean bl = false;
        Closeable closeable = new BackupContext(this.workspace.getMetadata().getName(), this._stream);
        Throwable throwable = null;
        try {
            BackupContext ctx = (BackupContext)closeable;
            boolean bl3 = false;
            this.items.init(ctx);
            ctx.getDependencyTasks().submitAndWaitTasks();
            Closeable readLock = this.metadataReadLock;
            if (readLock != null) {
                readLock.close();
                this.metadataReadLock = null;
            }
            this.write(version, ctx);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return version;
    }

    private final void write(long version, BackupContext ctx) {
        byte[] byArray = this.getFileVersion().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this._stream.write(byArray);
        this._stream.writeLong(version);
        this._stream.writeInt(this.items.getFileCount());
        this.items.writeManifest(this._stream);
        Encoder encoder = ctx.createEncoder();
        encoder.WriteCoderProperties((OutputStream)this._stream);
        ctx.getZipQueue().startOutput();
        ctx.getZipQueue().waitTasks();
        this._stream.flush();
    }

    @Override
    public void close() {
        this.items.close();
    }
}

