/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import SevenZip.Compression.LZMA.Decoder;
import java.io.Closeable;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olapServer2.backup.BackupConstant;
import kd.bos.olapServer2.backup.FileRecovery;
import kd.bos.olapServer2.backup.IRecoveryItem;
import kd.bos.olapServer2.backup.KeyFileRecovery;
import kd.bos.olapServer2.backup.KeysRecoveryV5;
import kd.bos.olapServer2.backup.RecoveryContext;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.ParallelTaskManager;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.metadata.PropertyValueItem;
import kd.bos.olapServer2.metadata.builds.CubeBuilder;
import kd.bos.olapServer2.metadata.builds.CubeEntry;
import kd.bos.olapServer2.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer2.metadata.builds.OlapMetadataBuilder;
import kd.bos.olapServer2.storages.OlapLockManager;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.tools.CubeFactoryCreator;
import kd.bos.olapServer2.tools.FileTools;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u001aJ\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/backup/CubeRecovery;", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "rootPath", "inputStream", "Ljava/io/DataInputStream;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Ljava/lang/String;Ljava/lang/String;Ljava/io/DataInputStream;I)V", "_transactionId", "", "context", "Lkd/bos/olapServer2/backup/RecoveryContext;", "cubePath", "fileVersion", "transactionId", "getTransactionId", "()J", "createDecoder", "LSevenZip/Compression/LZMA/Decoder;", "innerRecovery", "", "readRecoveryList", "Ljava/util/ArrayList;", "Lkd/bos/olapServer2/backup/IRecoveryItem;", "Lkotlin/collections/ArrayList;", "recovery", "renameCube", "updateOlapMetadata", "validateHeader", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nCubeRecovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeRecovery.kt\nkd/bos/olapServer2/backup/CubeRecovery\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n372#2,3:265\n375#2,4:269\n1#3:268\n1855#4,2:273\n*S KotlinDebug\n*F\n+ 1 CubeRecovery.kt\nkd/bos/olapServer2/backup/CubeRecovery\n*L\n169#1:265,3\n169#1:269,4\n186#1:273,2\n*E\n"})
public final class CubeRecovery {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final String cubeName;
    @NotNull
    private final String rootPath;
    @NotNull
    private final DataInputStream inputStream;
    private final int cubeId;
    @NotNull
    private final String cubePath;
    private int fileVersion;
    @NotNull
    private final RecoveryContext context;
    private long _transactionId;

    public CubeRecovery(@NotNull OlapWorkspace olapWorkspace, @NotNull String cubeName, @NotNull String rootPath, @NotNull DataInputStream inputStream, int cubeId) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.olapWorkspace = olapWorkspace;
        this.cubeName = cubeName;
        this.rootPath = rootPath;
        this.inputStream = inputStream;
        this.cubeId = cubeId;
        this.fileVersion = 1;
        try {
            StringValidator.INSTANCE.validate(this.cubeName);
            String[] stringArray = new String[]{this.cubeName};
            this.cubePath = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
            this.context = new RecoveryContext(this.cubePath, this.cubeName);
        }
        catch (Throwable ex) {
            throw new RuntimeException(this.cubeName + ',' + ex.getMessage(), ex);
        }
        this._transactionId = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recovery() {
        try {
            OlapLockManager.CubeLock lock = this.olapWorkspace.getLockManager().lock(this.cubeName);
            Closeable closeable = lock;
            Throwable throwable = null;
            try {
                OlapLockManager.CubeLock it = (OlapLockManager.CubeLock)closeable;
                boolean bl = false;
                if (FileTools.INSTANCE.isExist(this.cubePath)) {
                    FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(this.cubePath));
                    this.innerRecovery();
                } else {
                    this.innerRecovery();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(this.cubeName + ',' + ex.getMessage(), ex);
        }
    }

    public final long getTransactionId() {
        return this._transactionId;
    }

    private final void innerRecovery() {
        long version;
        this.validateHeader();
        this._transactionId = version = this.fileVersion == 3 || this.fileVersion == 4 || this.fileVersion == 5 || this.fileVersion == 6 ? this.inputStream.readLong() : 0L;
        CancellableToken.INSTANCE.withCancellable((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeRecovery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                if (CubeRecovery.access$getFileVersion$p(this.this$0) < 5) {
                    CubeFactoryCreator.INSTANCE.create().recovery(CubeRecovery.access$getFileVersion$p(this.this$0), CubeRecovery.access$getCubeName$p(this.this$0), CubeRecovery.access$getRootPath$p(this.this$0), CubeRecovery.access$getInputStream$p(this.this$0));
                } else {
                    FileTools.INSTANCE.createFile(CubeRecovery.access$getCubePath$p(this.this$0), false);
                    ArrayList fileList = CubeRecovery.access$readRecoveryList(this.this$0);
                    Decoder decoder = CubeRecovery.access$createDecoder(this.this$0);
                    ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                    Closeable closeable = ptm;
                    CubeRecovery cubeRecovery = this.this$0;
                    Throwable throwable = null;
                    try {
                        ParallelTaskManager it = (ParallelTaskManager)closeable;
                        boolean bl = false;
                        IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
                        for (IRecoveryItem file : fileList) {
                            if (!continueToken.canContinue()) continue;
                            file.recovery(decoder);
                        }
                        CubeRecovery.access$getContext$p(cubeRecovery).waitTasks();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                CubeRecovery.access$renameCube(this.this$0);
            }
        }, (Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ CubeRecovery this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CubeRecovery.access$getContext$p(this.this$0).close();
                if (FileTools.INSTANCE.isExist(CubeRecovery.access$getCubePath$p(this.this$0))) {
                    FileTools.INSTANCE.deleteDir(PathsKt.fileSafeConstructor(CubeRecovery.access$getCubePath$p(this.this$0)));
                }
            }
        }, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeRecovery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CubeRecovery.access$getContext$p(this.this$0).close();
            }
        }));
        this.updateOlapMetadata();
    }

    private final void validateHeader() {
        int n;
        byte[] headerByte = new byte[23];
        int len = CommonTypesKt.readByteArray(this.inputStream, headerByte);
        if (len != 23) {
            String string2 = Res.INSTANCE.getCubeRecoveryException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-CubeRecoveryException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        String currentFileHeader = new String(headerByte, Charsets.UTF_8);
        String string3 = currentFileHeader;
        if (Intrinsics.areEqual((Object)string3, (Object)"Kingdee Shrek backup v1")) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)string3, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v2())) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)string3, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v3())) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)string3, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v4())) {
            n = 4;
        } else if (Intrinsics.areEqual((Object)string3, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v5())) {
            n = 5;
        } else if (Intrinsics.areEqual((Object)string3, (Object)BackupConstant.INSTANCE.getBackupFileHeader_v6())) {
            n = 6;
        } else {
            if (StringsKt.startsWith$default((String)currentFileHeader, (String)"Kingdee Shrek backup v", (boolean)false, (int)2, null)) {
                String string4 = Res.INSTANCE.getCubeRecoveryException_8();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-CubeRecoveryException_8>(...)");
                throw Res.INSTANCE.getRuntimeException(string4, new Object[0]);
            }
            String string5 = Res.INSTANCE.getCubeRecoveryException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-CubeRecoveryException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string5, new Object[0]);
        }
        this.fileVersion = n;
    }

    private final ArrayList<IRecoveryItem> readRecoveryList() {
        int fileCount = this.inputStream.readInt();
        ArrayList<IRecoveryItem> fileList = new ArrayList<IRecoveryItem>();
        HashMap keysRecoveryMap = new HashMap();
        KeysRecoveryV5 keyReader5 = null;
        block4: for (int index2 = 0; index2 < fileCount; ++index2) {
            int ordinal = this.inputStream.read();
            switch (ordinal) {
                case 1: {
                    Object object2;
                    if (!(this.fileVersion == 5 || this.fileVersion == 6)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    KeyFileRecovery keyFile = new KeyFileRecovery(this.inputStream, this.fileVersion);
                    String partitionName = keyFile.getPartitionName();
                    if (((CharSequence)partitionName).length() == 0) {
                        if (keyReader5 == null) {
                            keyReader5 = new KeysRecoveryV5(partitionName, this.context);
                            fileList.add(keyReader5);
                        }
                        keyReader5.addDimensionFile(keyFile);
                        continue block4;
                    }
                    Map $this$getOrPut$iv = keysRecoveryMap;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(partitionName);
                    if (value$iv == null) {
                        KeysRecoveryV5 keysRecoveryV5;
                        boolean bl = false;
                        KeysRecoveryV5 it = keysRecoveryV5 = new KeysRecoveryV5(partitionName, this.context);
                        boolean bl2 = false;
                        fileList.add(it);
                        KeysRecoveryV5 answer$iv = keysRecoveryV5;
                        $this$getOrPut$iv.put(partitionName, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    KeysRecoveryV5 keyRecovery = (KeysRecoveryV5)object2;
                    keyRecovery.addDimensionFile(keyFile);
                    continue block4;
                }
                case 0: 
                case 2: 
                case 3: {
                    fileList.add(new FileRecovery(this.inputStream, this.cubePath, this.fileVersion));
                    continue block4;
                }
                default: {
                    String string3 = Res.INSTANCE.getCubeRecoveryException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-CubeRecoveryException_3>(...)");
                    Object[] objectArray = new Object[]{ordinal};
                    throw Res.INSTANCE.getRuntimeException(string3, objectArray);
                }
            }
        }
        return fileList;
    }

    private final void updateOlapMetadata() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Iterable $this$forEach$iv = this.context.getCubeWorkspace().getMetadata().getProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyValueItem it = (PropertyValueItem)element$iv;
            boolean bl = false;
            ((Map)propertyMap).put(it.getName(), it.getValue());
        }
        this.olapWorkspace.getLockManager().enterWrite((Function0)new Function0<Unit>(this, propertyMap){
            final /* synthetic */ CubeRecovery this$0;
            final /* synthetic */ HashMap<String, String> $propertyMap;
            {
                this.this$0 = $receiver;
                this.$propertyMap = $propertyMap;
                super(0);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                block4: {
                    builder = OlapMetadataBuilder.Companion.readFrom(CubeRecovery.access$getRootPath$p(this.this$0));
                    builder.setMaxId(CubeRecovery.access$getCubeId$p(this.this$0));
                    if (CubeRecovery.access$getCubeId$p(this.this$0) <= 0) ** GOTO lbl-1000
                    var2_2 = builder.getCubes();
                    var3_5 = this.this$0;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (CubeEntry)element$iv;
                        $i$a$-firstOrNull-CubeRecovery$updateOlapMetadata$2$1 = false;
                        if (!(it.getId() == CubeRecovery.access$getCubeId$p(var3_5))) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                if (v0 == null) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                $this$firstOrNull$iv = v1;
                var3_5 = this.this$0;
                if (!$this$firstOrNull$iv) {
                    $i$a$-require-CubeRecovery$updateOlapMetadata$2$2 = false;
                    var4_7 = "recovery " + CubeRecovery.access$getCubeName$p(var3_5) + " error,cubeId[" + CubeRecovery.access$getCubeId$p(var3_5) + "] is exist";
                    throw new IllegalArgumentException(var4_7.toString());
                }
                cubeEntry = new CubeEntry(CubeRecovery.access$getCubeId$p(this.this$0), CubeRecovery.access$getCubeName$p(this.this$0), this.$propertyMap);
                builder.getCubes().add(cubeEntry);
                builder.save();
            }
        });
        this.olapWorkspace.updateMetadata(CommandTypes.create, this.cubeName);
    }

    private final Decoder createDecoder() {
        Decoder decoder = new Decoder();
        int propertiesSize = 5;
        byte[] properties2 = new byte[propertiesSize];
        if (CommonTypesKt.readByteArray(this.inputStream, properties2, 0, propertiesSize) != propertiesSize) {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_4());
        }
        if (!decoder.SetDecoderProperties(properties2)) {
            throw new RuntimeException(Res.INSTANCE.getCubeRecoveryException_5());
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void renameCube() {
        if (((CharSequence)this.cubeName).length() > 0 && !Intrinsics.areEqual((Object)this.cubeName, (Object)this.context.getCubeWorkspace().getMetadata().getName())) {
            Closeable closeable = this.context.getCubeWorkspace().getMetadataStorage().createWriterContext();
            Throwable throwable = null;
            try {
                IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
                boolean bl = false;
                CubeBuilder cubeBuilder = writerContext.getCubeBuilder();
                cubeBuilder.setName(this.cubeName);
                writerContext.save();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public static final /* synthetic */ int access$getFileVersion$p(CubeRecovery $this) {
        return $this.fileVersion;
    }

    public static final /* synthetic */ String access$getCubeName$p(CubeRecovery $this) {
        return $this.cubeName;
    }

    public static final /* synthetic */ String access$getRootPath$p(CubeRecovery $this) {
        return $this.rootPath;
    }

    public static final /* synthetic */ DataInputStream access$getInputStream$p(CubeRecovery $this) {
        return $this.inputStream;
    }

    public static final /* synthetic */ String access$getCubePath$p(CubeRecovery $this) {
        return $this.cubePath;
    }

    public static final /* synthetic */ ArrayList access$readRecoveryList(CubeRecovery $this) {
        return $this.readRecoveryList();
    }

    public static final /* synthetic */ Decoder access$createDecoder(CubeRecovery $this) {
        return $this.createDecoder();
    }

    public static final /* synthetic */ void access$renameCube(CubeRecovery $this) {
        $this.renameCube();
    }

    public static final /* synthetic */ RecoveryContext access$getContext$p(CubeRecovery $this) {
        return $this.context;
    }

    public static final /* synthetic */ int access$getCubeId$p(CubeRecovery $this) {
        return $this.cubeId;
    }
}

