/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import kd.bos.olapServer2.backup.BackupContext;
import kd.bos.olapServer2.backup.BackupFileType;
import kd.bos.olapServer2.backup.IBackupItem;
import kd.bos.olapServer2.backup.ZipFileStreamQueue;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B3\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\u0012\n\u0010\n\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0016J\u0006\u0010\"\u001a\u00020\u001fJ\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020\u001fJ\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00060\rj\u0002`\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00060\u0017j\u0002`\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\u00060\u0017j\u0002`\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0012\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkd/bos/olapServer2/backup/FileBackup;", "Lkd/bos/olapServer2/backup/IBackupItem;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "rootPath", "relativePath", "fileType", "Lkd/bos/olapServer2/backup/BackupFileType;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkd/bos/olapServer2/backup/BackupFileType;)V", "sourcePath", "(Ljava/lang/String;Lkd/bos/olapServer2/backup/BackupFileType;Ljava/lang/String;)V", "_contentLength", "", "_tmpFile", "Ljava/io/File;", "_zipFileEntry", "Lkd/bos/olapServer2/backup/ZipFileStreamQueue$IZipFileEntry;", "contentLength", "Lkd/bos/olapServer2/common/long;", "getContentLength", "()J", "fileCount", "", "Lkd/bos/olapServer2/common/int;", "getFileCount", "()I", "pathLength", "getPathLength", "sourceFile", "channelCopy", "", "targetFile", "close", "copyToTempFolder", "init", "ctx", "Lkd/bos/olapServer2/backup/BackupContext;", "submitZipSource", "writeManifest", "stream", "Ljava/io/DataOutputStream;", "bos-olap-core2"})
public class FileBackup
implements IBackupItem {
    @NotNull
    private final BackupFileType fileType;
    @NotNull
    private final String relativePath;
    @NotNull
    private final File sourceFile;
    private long _contentLength;
    @Nullable
    private File _tmpFile;
    @Nullable
    private ZipFileStreamQueue.IZipFileEntry _zipFileEntry;

    public FileBackup(@NotNull String sourcePath, @NotNull BackupFileType fileType, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this.fileType = fileType;
        this.relativePath = relativePath;
        this.sourceFile = PathsKt.fileSafeConstructor(sourcePath);
        this._contentLength = -1L;
    }

    public FileBackup(@NotNull String cubeName, @NotNull String rootPath, @NotNull String relativePath, @NotNull BackupFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        String[] stringArray = new String[]{cubeName, relativePath};
        this(((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString(), fileType, relativePath);
    }

    private final int getPathLength() {
        byte[] byArray = this.relativePath.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray.length;
    }

    private final long getContentLength() {
        return this._contentLength;
    }

    @Override
    public int getFileCount() {
        return 1;
    }

    @Override
    public void init(@NotNull BackupContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this._zipFileEntry = ctx.getZipQueue().register();
    }

    public final void submitZipSource() {
        block0: {
            this._contentLength = this.sourceFile.length();
            ZipFileStreamQueue.IZipFileEntry iZipFileEntry = this._zipFileEntry;
            if (iZipFileEntry == null) break block0;
            iZipFileEntry.zipFile(this.sourceFile);
        }
    }

    public final void copyToTempFolder() {
        block0: {
            File tmpFile;
            this._contentLength = this.sourceFile.length();
            this._tmpFile = tmpFile = ITempFolder.Companion.createTempFile("backupFile", ".tmp");
            this.channelCopy(this.sourceFile, tmpFile);
            ZipFileStreamQueue.IZipFileEntry iZipFileEntry = this._zipFileEntry;
            if (iZipFileEntry == null) break block0;
            iZipFileEntry.zipFile(tmpFile);
        }
    }

    @Override
    public void writeManifest(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        DataOutputStream $this$writeManifest_u24lambda_u240 = stream;
        boolean bl = false;
        $this$writeManifest_u24lambda_u240.writeByte(this.fileType.getValue());
        if (!(this.getContentLength() >= 0L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        $this$writeManifest_u24lambda_u240.writeLong(this.getContentLength());
        $this$writeManifest_u24lambda_u240.writeInt(this.getPathLength());
        byte[] byArray = this.relativePath.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        $this$writeManifest_u24lambda_u240.write(byArray);
    }

    @Override
    public void close() {
        block1: {
            File file = this._tmpFile;
            if (file != null) {
                file.delete();
            }
            ZipFileStreamQueue.IZipFileEntry iZipFileEntry = this._zipFileEntry;
            if (iZipFileEntry == null) break block1;
            iZipFileEntry.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void channelCopy(File sourceFile, File targetFile) {
        Object object2 = new OpenOption[]{StandardOpenOption.READ};
        object2 = FileChannel.open(sourceFile.toPath(), object2);
        Throwable throwable = null;
        try {
            long l;
            FileChannel source2 = (FileChannel)object2;
            boolean bl = false;
            Object object3 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            object3 = FileChannel.open(targetFile.toPath(), object3);
            Throwable throwable2 = null;
            try {
                FileChannel target = (FileChannel)object3;
                boolean bl2 = false;
                l = target.transferFrom(source2, 0L, source2.size());
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }
}

