/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import SevenZip.Compression.LZMA.Decoder;
import java.io.DataInputStream;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.backup.BaseRecovery;
import kd.bos.olapServer2.backup.IRecoveryItem;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J#\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00112\n\u0010\u0012\u001a\u00060\u0006j\u0002`\u0007H\u0002\u00a2\u0006\u0002\u0010\u0013R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/backup/FileRecovery;", "Lkd/bos/olapServer2/backup/BaseRecovery;", "Lkd/bos/olapServer2/backup/IRecoveryItem;", "inputStream", "Ljava/io/DataInputStream;", "cubePath", "", "Lkd/bos/olapServer2/common/string;", "fileVersion", "", "Lkd/bos/olapServer2/common/int;", "(Ljava/io/DataInputStream;Ljava/lang/String;I)V", "recovery", "", "decoder", "LSevenZip/Compression/LZMA/Decoder;", "splitPath", "", "path", "(Ljava/lang/String;)[Ljava/lang/String;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nFileRecovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileRecovery.kt\nkd/bos/olapServer2/backup/FileRecovery\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,58:1\n37#2,2:59\n*S KotlinDebug\n*F\n+ 1 FileRecovery.kt\nkd/bos/olapServer2/backup/FileRecovery\n*L\n56#1:59,2\n*E\n"})
public final class FileRecovery
extends BaseRecovery
implements IRecoveryItem {
    @NotNull
    private final String cubePath;

    public FileRecovery(@NotNull DataInputStream inputStream, @NotNull String cubePath, int fileVersion) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)cubePath, (String)"cubePath");
        super(inputStream, fileVersion);
        this.cubePath = cubePath;
    }

    @Override
    public void recovery(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        String[] nodes = this.splitPath(this.getRelativePath());
        Path current = Paths.INSTANCE.get(this.cubePath, new String[0]);
        int n = nodes.length - 1;
        for (int i = 0; i < n; ++i) {
            String node = nodes[i];
            String[] stringArray = new String[]{node};
            File dir = Paths.INSTANCE.toFile(((Object)(current = Paths.INSTANCE.get(((Object)current).toString(), stringArray)).toAbsolutePath()).toString());
            if (dir.exists()) continue;
            dir.mkdir();
        }
        File file = Paths.INSTANCE.toFile(((Object)current).toString(), nodes[nodes.length - 1]);
        this.writeToFile(decoder, file);
    }

    private final String[] splitPath(String path) {
        List nodes = new ArrayList();
        int start = 0;
        int n = path.length();
        for (int index2 = 0; index2 < n; ++index2) {
            String node;
            char c = path.charAt(index2);
            if (c != '/' && c != '\\' || index2 <= start) continue;
            Intrinsics.checkNotNullExpressionValue((Object)path.substring(start, index2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            nodes.add(node);
            start = index2 + 1;
        }
        if (path.length() > start) {
            String string2 = path.substring(start, path.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            nodes.add(string2);
        }
        Collection $this$toTypedArray$iv = nodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }
}

