/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.backup.BackupConstant;
import kd.bos.olapServer2.backup.BackupContext;
import kd.bos.olapServer2.backup.BackupFileType;
import kd.bos.olapServer2.backup.DistributedBackup;
import kd.bos.olapServer2.backup.FileBackup;
import kd.bos.olapServer2.backup.IBackupItem;
import kd.bos.olapServer2.backup.SafeFile;
import kd.bos.olapServer2.backup.bigFile.RunLengthIntListWriter;
import kd.bos.olapServer2.collections.IImmutableListInt;
import kd.bos.olapServer2.common.DependencyTaskCollection;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.ManagedResourceList;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeDataStorage;
import kd.bos.olapServer2.storages.ICubeDataLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019J\u001e\u0010\u001b\u001a\u0018\u0012\b\u0012\u00060\rj\u0002`\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\t0\u001cH\u0002J\u0006\u0010\u001f\u001a\u00020\u0019J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0016J'\u0010#\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\t2\n\u0010%\u001a\u00060\rj\u0002`&H\u0002\u00a2\u0006\u0002\u0010'R\u001a\u0010\b\u001a\f\u0012\b\u0012\u00060\nR\u00020\u00000\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006)"}, d2={"Lkd/bos/olapServer2/backup/KeysBackup;", "Lkd/bos/olapServer2/backup/DistributedBackup;", "Lkd/bos/olapServer2/backup/FileBackup;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "dataLock", "Lkd/bos/olapServer2/storages/ICubeDataLock;", "(Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;Lkd/bos/olapServer2/storages/ICubeDataLock;)V", "_copyTasks", "", "Lkd/bos/olapServer2/backup/KeysBackup$CopyTask;", "[Lkd/bos/olapServer2/backup/KeysBackup$CopyTask;", "_keyLastCount", "", "_partitionKey", "", "Lkd/bos/olapServer2/common/string;", "_queryLockInstance", "Ljava/io/Closeable;", "getDataLock", "()Lkd/bos/olapServer2/storages/ICubeDataLock;", "writers", "Lkd/bos/olapServer2/backup/bigFile/RunLengthIntListWriter;", "[Lkd/bos/olapServer2/backup/bigFile/RunLengthIntListWriter;", "close", "", "copyRowsToTempFile", "createKeysList", "Lkotlin/Pair;", "Lkd/bos/olapServer2/common/long;", "Lkd/bos/olapServer2/collections/IImmutableListInt;", "flush", "init", "ctx", "Lkd/bos/olapServer2/backup/BackupContext;", "zipInt", "keysList", "rowCount", "Lkd/bos/olapServer2/common/rowIdx;", "([Lkd/bos/olapServer2/collections/IImmutableListInt;J)V", "CopyTask", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nKeysBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeysBackup.kt\nkd/bos/olapServer2/backup/KeysBackup\n+ 2 ResourceCreator.kt\nkd/bos/olapServer2/common/ResourceCreatorKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,196:1\n13#2,17:197\n11065#3:214\n11400#3,3:215\n13309#3,2:220\n37#4,2:218\n26#5:222\n*S KotlinDebug\n*F\n+ 1 KeysBackup.kt\nkd/bos/olapServer2/backup/KeysBackup\n*L\n30#1:197,17\n34#1:214\n34#1:215,3\n107#1:220,2\n34#1:218,2\n145#1:222\n*E\n"})
public final class KeysBackup
extends DistributedBackup<FileBackup> {
    @NotNull
    private final AbstractCubeWorkspace cubeWorkspace;
    @NotNull
    private final ICubeDataLock dataLock;
    private long _keyLastCount;
    @NotNull
    private final RunLengthIntListWriter[] writers;
    @NotNull
    private final String _partitionKey;
    @NotNull
    private CopyTask[] _copyTasks;
    @Nullable
    private Closeable _queryLockInstance;

    /*
     * WARNING - void declaration
     */
    public KeysBackup(@NotNull AbstractCubeWorkspace cubeWorkspace, @NotNull ICubeDataLock dataLock) {
        void $this$toTypedArray$iv;
        Iterable iterable;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        SafeFile[] safeFileArray;
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)dataLock, (String)"dataLock");
        this.cubeWorkspace = cubeWorkspace;
        this.dataLock = dataLock;
        this._partitionKey = BackupConstant.INSTANCE.getPartitionKey(this.cubeWorkspace);
        DimensionCollection dimensions2 = this.cubeWorkspace.getMetadata().getDimensions();
        boolean $i$f$createManagedResource22 = false;
        List list$iv = new ArrayList();
        ManagedResourceList resources$iv = new ManagedResourceList(list$iv);
        try {
            ManagedResourceList $this$_init__u24lambda_u240 = resources$iv;
            boolean bl = false;
            int n = 0;
            int n2 = dimensions2.getCount();
            SafeFile[] safeFileArray2 = new SafeFile[n2];
            while (n < n2) {
                int n3 = n++;
                safeFileArray2[n3] = $this$_init__u24lambda_u240.put(new SafeFile(ITempFolder.Companion.createTempFile("dim_" + ((Dimension)dimensions2.get(n3)).getName(), ".tmp")));
            }
            safeFileArray = safeFileArray2;
        }
        catch (Throwable ex$iv) {
            for (AutoCloseable res$iv : list$iv) {
                try {
                    res$iv.close();
                }
                catch (Throwable throwable) {}
            }
            throw ex$iv;
        }
        Object[] $i$f$createManagedResource22 = safeFileArray;
        boolean $i$f$map = false;
        resources$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SafeFile safeFile = (SafeFile)item$iv$iv;
            iterable = destination$iv$iv2;
            boolean bl = false;
            iterable.add(it.getFile());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        RunLengthIntListWriter[] thisCollection$iv = $this$toTypedArray$iv;
        File[] files = thisCollection$iv.toArray(new File[0]);
        int n = 0;
        int n4 = files.length;
        thisCollection$iv = new RunLengthIntListWriter[n4];
        iterable = this;
        while (n < n4) {
            int destination$iv$iv2 = n++;
            thisCollection$iv[destination$iv$iv2] = new RunLengthIntListWriter(new BufferedOutputStream(PathsKt.safeOutputStream(files[destination$iv$iv2])));
        }
        ((KeysBackup)iterable).writers = thisCollection$iv;
        n4 = files.length;
        for (n = 0; n < n4; ++n) {
            int i = n;
            File file = files[n];
            String string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            String[] stringArray = new String[]{((Dimension)dimensions2.get(i)).getName() + ".keys"};
            this.registerProxy((IBackupItem)new FileBackup(string2, BackupFileType.Keys, ((Object)Paths.INSTANCE.get(this._partitionKey, stringArray)).toString()));
        }
        n = 0;
        n4 = files.length;
        CopyTask[] copyTaskArray = new CopyTask[n4];
        iterable = this;
        while (n < n4) {
            int n5 = n++;
            copyTaskArray[n5] = new CopyTask(this.writers[n5]);
        }
        ((KeysBackup)iterable)._copyTasks = copyTaskArray;
    }

    @NotNull
    public final ICubeDataLock getDataLock() {
        return this.dataLock;
    }

    @Override
    public void init(@NotNull BackupContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super.init(ctx);
        Function0[] function0Array = new Function0[]{new Function0<Unit>(this){
            final /* synthetic */ KeysBackup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                KeysBackup.access$set_queryLockInstance$p(this.this$0, this.this$0.getDataLock().getReadLock());
                Pair pair = KeysBackup.access$createKeysList(this.this$0);
                long rowCount = ((Number)pair.component1()).longValue();
                IImmutableListInt[] keysList = (IImmutableListInt[])pair.component2();
                if (rowCount > 0L) {
                    int n = keysList.length;
                    for (int i = 0; i < n; ++i) {
                        CopyTask copyTask = KeysBackup.access$get_copyTasks$p(this.this$0)[i];
                        copyTask.setRowCount(rowCount);
                        copyTask.setKeyList(keysList[i]);
                    }
                }
                KeysBackup.access$set_keyLastCount$p(this.this$0, rowCount);
            }
        }};
        DependencyTaskCollection.addTaskGroup$default(ctx.getDependencyTasks(), "GetPartitionQueryLock_" + this._partitionKey, function0Array, null, 4, null);
        int n = 0;
        int n2 = this.writers.length;
        Function0[] function0Array2 = new Function0[n2];
        String string2 = "CopyPartitionKeys_" + this._partitionKey;
        DependencyTaskCollection dependencyTaskCollection = ctx.getDependencyTasks();
        while (n < n2) {
            int n3 = n++;
            function0Array2[n3] = new Function0<Unit>((Object)this._copyTasks[n3]){

                public final void invoke() {
                    ((CopyTask)this.receiver).run();
                }
            };
        }
        String[] stringArray = new String[]{"GetPartitionQueryLock_" + this._partitionKey};
        dependencyTaskCollection.addTaskGroup(string2, function0Array2, stringArray);
        stringArray = new Function0[]{new Function0<Unit>(this){
            final /* synthetic */ KeysBackup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Closeable closeable = KeysBackup.access$get_queryLockInstance$p(this.this$0);
                if (closeable != null) {
                    closeable.close();
                }
                KeysBackup.access$set_queryLockInstance$p(this.this$0, null);
            }
        }};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{"CopyPartitionKeys_" + this._partitionKey};
        ctx.getDependencyTasks().addTaskGroup("ReleasePartitionQueryLock_" + this._partitionKey, (Function0<Unit>[])stringArray2, stringArray);
    }

    @Override
    public void close() {
        RunLengthIntListWriter[] $this$forEach$iv = this.writers;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            RunLengthIntListWriter element$iv;
            RunLengthIntListWriter it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.close();
        }
        Closeable closeable = this._queryLockInstance;
        if (closeable != null) {
            closeable.close();
        }
        this._queryLockInstance = null;
        super.close();
    }

    public final void copyRowsToTempFile() {
        Pair<Long, IImmutableListInt[]> pair = this.createKeysList();
        long rowCount = ((Number)pair.component1()).longValue();
        IImmutableListInt[] keysList = (IImmutableListInt[])pair.component2();
        if (this._keyLastCount < rowCount) {
            this.zipInt(keysList, rowCount);
        }
    }

    private final Pair<Long, IImmutableListInt[]> createKeysList() {
        Pair pair;
        CubeDataStorage dataStorage = this.cubeWorkspace.getDataStorage();
        DimensionCollection dimensions2 = this.cubeWorkspace.getMetadata().getDimensions();
        long splitCount = this.cubeWorkspace.getResourcePool().getSplitCount();
        long rowCount = this.cubeWorkspace.getResourcePool().getRowCount();
        if (this._keyLastCount < rowCount) {
            int n = 0;
            int n2 = dimensions2.getCount();
            IImmutableListInt[] iImmutableListIntArray = new IImmutableListInt[n2];
            Long l = rowCount;
            while (n < n2) {
                int n3 = n++;
                iImmutableListIntArray[n3] = dataStorage.createImmutableListInt((Dimension)dimensions2.get(n3), splitCount, rowCount);
            }
            IImmutableListInt[] iImmutableListIntArray2 = iImmutableListIntArray;
            Long l2 = l;
            pair = new Pair((Object)l2, (Object)iImmutableListIntArray2);
        } else {
            boolean $i$f$emptyArray = false;
            pair = new Pair((Object)rowCount, (Object)new IImmutableListInt[0]);
        }
        return pair;
    }

    private final void zipInt(IImmutableListInt[] keysList, long rowCount) {
        if (!(keysList.length == this.writers.length)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this._keyLastCount < rowCount) {
            int n = keysList.length;
            for (int i = 0; i < n; ++i) {
                IImmutableListInt data = keysList[i];
                RunLengthIntListWriter writer = this.writers[i];
                for (long j = this._keyLastCount; j < rowCount; ++j) {
                    writer.write(data.get(j));
                }
            }
            this._keyLastCount = rowCount;
        }
    }

    public final void flush() {
        for (RunLengthIntListWriter writer : this.writers) {
            writer.flush();
            writer.close();
        }
        for (FileBackup item : this.getProxyItems()) {
            item.submitZipSource();
        }
    }

    public static final /* synthetic */ void access$set_queryLockInstance$p(KeysBackup $this, Closeable closeable) {
        $this._queryLockInstance = closeable;
    }

    public static final /* synthetic */ Pair access$createKeysList(KeysBackup $this) {
        return $this.createKeysList();
    }

    public static final /* synthetic */ CopyTask[] access$get_copyTasks$p(KeysBackup $this) {
        return $this._copyTasks;
    }

    public static final /* synthetic */ void access$set_keyLastCount$p(KeysBackup $this, long l) {
        $this._keyLastCount = l;
    }

    public static final /* synthetic */ Closeable access$get_queryLockInstance$p(KeysBackup $this) {
        return $this._queryLockInstance;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/backup/KeysBackup$CopyTask;", "", "writer", "Lkd/bos/olapServer2/backup/bigFile/RunLengthIntListWriter;", "(Lkd/bos/olapServer2/backup/KeysBackup;Lkd/bos/olapServer2/backup/bigFile/RunLengthIntListWriter;)V", "keyList", "Lkd/bos/olapServer2/collections/IImmutableListInt;", "getKeyList", "()Lkd/bos/olapServer2/collections/IImmutableListInt;", "setKeyList", "(Lkd/bos/olapServer2/collections/IImmutableListInt;)V", "rowCount", "", "getRowCount", "()J", "setRowCount", "(J)V", "getWriter", "()Lkd/bos/olapServer2/backup/bigFile/RunLengthIntListWriter;", "run", "", "bos-olap-core2"})
    private final class CopyTask {
        @NotNull
        private final RunLengthIntListWriter writer;
        private long rowCount;
        @Nullable
        private IImmutableListInt keyList;

        public CopyTask(RunLengthIntListWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            this.writer = writer;
        }

        @NotNull
        public final RunLengthIntListWriter getWriter() {
            return this.writer;
        }

        public final long getRowCount() {
            return this.rowCount;
        }

        public final void setRowCount(long l) {
            this.rowCount = l;
        }

        @Nullable
        public final IImmutableListInt getKeyList() {
            return this.keyList;
        }

        public final void setKeyList(@Nullable IImmutableListInt iImmutableListInt) {
            this.keyList = iImmutableListInt;
        }

        public final void run() {
            if (this.rowCount > 0L) {
                IImmutableListInt iImmutableListInt = this.keyList;
                Intrinsics.checkNotNull((Object)iImmutableListInt);
                IImmutableListInt k = iImmutableListInt;
                long l = this.rowCount;
                for (long i = 0L; i < l; ++i) {
                    this.writer.write(k.get(i));
                }
                this.keyList = null;
            }
        }
    }
}

