/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.olapServer2.backup.BackupConstant;
import kd.bos.olapServer2.backup.BackupContext;
import kd.bos.olapServer2.backup.DistributedBackup;
import kd.bos.olapServer2.backup.FileBackup;
import kd.bos.olapServer2.backup.IBackupItem;
import kd.bos.olapServer2.backup.KeysBackup;
import kd.bos.olapServer2.backup.MeasureObjectBackup;
import kd.bos.olapServer2.backup.MeasureSparseObjectBackup;
import kd.bos.olapServer2.common.NotSupportedException;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.MeasureCollection;
import kd.bos.olapServer2.metadata.OlapDataFormats;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.ICubeDataLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/backup/MeasuresBackup;", "Lkd/bos/olapServer2/backup/DistributedBackup;", "Lkd/bos/olapServer2/backup/IBackupItem;", "dataLock", "Lkd/bos/olapServer2/storages/ICubeDataLock;", "keysItem", "Lkd/bos/olapServer2/backup/KeysBackup;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/storages/ICubeDataLock;Lkd/bos/olapServer2/backup/KeysBackup;Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;Ljava/lang/String;)V", "partitionKey", "collectCopyTask", "", "tasks", "", "Lkd/bos/olapServer2/backup/FileBackup;", "items", "init", "ctx", "Lkd/bos/olapServer2/backup/BackupContext;", "bos-olap-core2"})
public final class MeasuresBackup
extends DistributedBackup<IBackupItem> {
    @NotNull
    private final ICubeDataLock dataLock;
    @NotNull
    private final KeysBackup keysItem;
    @NotNull
    private final String partitionKey;

    public MeasuresBackup(@NotNull ICubeDataLock dataLock, @NotNull KeysBackup keysItem, @NotNull AbstractCubeWorkspace cubeWorkspace, @NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)dataLock, (String)"dataLock");
        Intrinsics.checkNotNullParameter((Object)keysItem, (String)"keysItem");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.dataLock = dataLock;
        this.keysItem = keysItem;
        this.partitionKey = BackupConstant.INSTANCE.getPartitionKey(cubeWorkspace);
        MeasureCollection measures2 = cubeWorkspace.getMetadata().getMeasures();
        for (Measure measure : measures2.getStoredMeasures()) {
            if (measure.getDataFormat() == OlapDataFormats.MeasureFormat_Decimal) {
                throw new NotSupportedException("decimal \u7c7b\u578b\u5ea6\u91cf\u503c\u4e0d\u652f\u6301\u5907\u4efd\uff01");
            }
            if (measure.getDataFormat().isSparse()) {
                this.registerProxy((IBackupItem)new MeasureSparseObjectBackup(cubeWorkspace, rootPath, measure));
                continue;
            }
            this.registerProxy((IBackupItem)new MeasureObjectBackup(cubeWorkspace, rootPath, measure));
        }
    }

    @Override
    public void init(@NotNull BackupContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List copyTasks = new ArrayList();
        this.collectCopyTask(copyTasks, this);
        Object[] objectArray = new Function0[]{new Function0<Unit>(this, (List<FileBackup>)copyTasks){
            final /* synthetic */ MeasuresBackup this$0;
            final /* synthetic */ List<FileBackup> $copyTasks;
            {
                this.this$0 = $receiver;
                this.$copyTasks = $copyTasks;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Closeable closeable = MeasuresBackup.access$getDataLock$p(this.this$0).getWriteLock(1800L, TimeUnit.SECONDS);
                MeasuresBackup measuresBackup = this.this$0;
                List<FileBackup> list2 = this.$copyTasks;
                Throwable throwable = null;
                try {
                    Closeable it = closeable;
                    boolean bl = false;
                    MeasuresBackup.access$getKeysItem$p(measuresBackup).copyRowsToTempFile();
                    MeasuresBackup.access$getKeysItem$p(measuresBackup).flush();
                    for (FileBackup task : list2) {
                        task.copyToTempFolder();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }};
        Function0[] function0Array = objectArray;
        objectArray = new String[]{"ReleasePartitionQueryLock_" + this.partitionKey};
        ctx.getDependencyTasks().addTaskGroup("CopyPartitionMeasures_" + this.partitionKey, function0Array, (String[])objectArray);
        super.init(ctx);
    }

    private final void collectCopyTask(List<FileBackup> tasks, DistributedBackup<?> items2) {
        for (IBackupItem item : items2) {
            if (item instanceof FileBackup) {
                tasks.add((FileBackup)item);
                continue;
            }
            if (!(item instanceof DistributedBackup)) continue;
            this.collectCopyTask(tasks, (DistributedBackup)item);
        }
    }

    public static final /* synthetic */ ICubeDataLock access$getDataLock$p(MeasuresBackup $this) {
        return $this.dataLock;
    }

    public static final /* synthetic */ KeysBackup access$getKeysItem$p(MeasuresBackup $this) {
        return $this.keysItem;
    }
}

