/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.InputStream;
import kd.bos.olapServer2.backup.CubeRecovery;
import kd.bos.olapServer2.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer2.metadata.MetadataUpdatedEventArgs;
import kd.bos.olapServer2.server.ReplicationWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.OlapWorkspace;
import kd.bos.olapServer2.transactions.ITransaction;
import kd.bos.olapServer2.transactions.TransactionManager;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u0012\u0010\b\u0002\u0010\u000f\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/backup/RecoveryCommandExecutor;", "", "olapWorkspace", "Lkd/bos/olapServer2/storages/OlapWorkspace;", "commandInfo", "Lkd/bos/olapServer2/dataSources/RecoveryCommandInfo;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "rootPath", "webInputStream", "Ljava/io/InputStream;", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "recoveryFileName", "replicationWorkspace", "Lkd/bos/olapServer2/server/ReplicationWorkspace;", "(Lkd/bos/olapServer2/storages/OlapWorkspace;Lkd/bos/olapServer2/dataSources/RecoveryCommandInfo;Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;ILjava/lang/String;Lkd/bos/olapServer2/server/ReplicationWorkspace;)V", "run", "", "bos-olap-core2"})
public final class RecoveryCommandExecutor {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final RecoveryCommandInfo commandInfo;
    @NotNull
    private final String cubeName;
    @NotNull
    private final String rootPath;
    @NotNull
    private final InputStream webInputStream;
    private final int cubeId;
    @Nullable
    private final String recoveryFileName;
    @Nullable
    private final ReplicationWorkspace replicationWorkspace;

    public RecoveryCommandExecutor(@NotNull OlapWorkspace olapWorkspace, @NotNull RecoveryCommandInfo commandInfo, @NotNull String cubeName, @NotNull String rootPath, @NotNull InputStream webInputStream, int cubeId, @Nullable String recoveryFileName, @Nullable ReplicationWorkspace replicationWorkspace) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)commandInfo, (String)"commandInfo");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)webInputStream, (String)"webInputStream");
        this.olapWorkspace = olapWorkspace;
        this.commandInfo = commandInfo;
        this.cubeName = cubeName;
        this.rootPath = rootPath;
        this.webInputStream = webInputStream;
        this.cubeId = cubeId;
        this.recoveryFileName = recoveryFileName;
        this.replicationWorkspace = replicationWorkspace;
        if (!(!StringsKt.isBlank((CharSequence)this.cubeName))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(this.cubeId > 0)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    public /* synthetic */ RecoveryCommandExecutor(OlapWorkspace olapWorkspace, RecoveryCommandInfo recoveryCommandInfo, String string2, String string3, InputStream inputStream, int n, String string4, ReplicationWorkspace replicationWorkspace, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            string4 = null;
        }
        if ((n2 & 0x80) != 0) {
            replicationWorkspace = null;
        }
        this(olapWorkspace, recoveryCommandInfo, string2, string3, inputStream, n, string4, replicationWorkspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        DataInputStream inputStream = new DataInputStream(new BufferedInputStream(this.webInputStream));
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            DataInputStream it22 = (DataInputStream)closeable;
            boolean bl = false;
            CubeRecovery cubeRecovery = new CubeRecovery(this.olapWorkspace, this.cubeName, this.rootPath, inputStream, this.cubeId);
            cubeRecovery.recovery();
            long it22 = cubeRecovery.getTransactionId();
        }
        catch (Throwable it22) {
            throwable = it22;
            throw it22;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long transactionId = it22;
        CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(this.cubeName);
        ITransaction tran = this.replicationWorkspace != null ? cubeWorkspace.getTransactionManager().beginTransaction(TransactionTypes.MetadataTransaction, this.replicationWorkspace.getCurrentNode().getValue()) : TransactionManager.beginTransaction$default(cubeWorkspace.getTransactionManager(), TransactionTypes.MetadataTransaction, null, 2, null);
        try {
            cubeWorkspace.getTransactionManager().updateVersion(transactionId);
            cubeWorkspace.getMetadataUpdated().invoke(cubeWorkspace.getPlugins().getContext(), new MetadataUpdatedEventArgs(transactionId, this.commandInfo, this.recoveryFileName));
            tran.commit();
        }
        catch (Throwable t2) {
            tran.rollback();
            throw t2;
        }
    }
}

