/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import kd.bos.olapServer2.backup.AbstractTaskContext;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0003j\u0002`\u0004J\f\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00060\u0003j\u0002`\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer2/backup/RecoveryContext;", "Lkd/bos/olapServer2/backup/AbstractTaskContext;", "cubePath", "", "Lkd/bos/olapServer2/common/string;", "cubeName", "(Ljava/lang/String;Ljava/lang/String;)V", "_cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "contextTaskName", "getContextTaskName", "()Ljava/lang/String;", "getCubeName", "getCubePath", "cubeWorkspace", "getCubeWorkspace", "()Lkd/bos/olapServer2/storages/CubeWorkspace;", "close", "", "getRealWorkspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "partitionName", "getThreadSize", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-core2"})
public final class RecoveryContext
extends AbstractTaskContext {
    @NotNull
    private final String cubePath;
    @NotNull
    private final String cubeName;
    @Nullable
    private CubeWorkspace _cubeWorkspace;

    public RecoveryContext(@NotNull String cubePath, @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubePath, (String)"cubePath");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        super(null);
        this.cubePath = cubePath;
        this.cubeName = cubeName;
    }

    @NotNull
    public final String getCubePath() {
        return this.cubePath;
    }

    @NotNull
    public final String getCubeName() {
        return this.cubeName;
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspace() {
        CubeWorkspace cubeWorkspace = this._cubeWorkspace;
        if (cubeWorkspace == null) {
            CubeWorkspace cubeWorkspace2;
            CubeWorkspace it = cubeWorkspace2 = new CubeWorkspace(this.cubePath);
            boolean bl = false;
            this._cubeWorkspace = it;
            cubeWorkspace = cubeWorkspace2;
        }
        return cubeWorkspace;
    }

    @NotNull
    public final AbstractCubeWorkspace getRealWorkspace(@NotNull String partitionName) {
        Intrinsics.checkNotNullParameter((Object)partitionName, (String)"partitionName");
        return this.getCubeWorkspace().getPartitionWorkspaces().getOrCreate(partitionName);
    }

    @Override
    protected int getThreadSize() {
        Object object2 = this._cubeWorkspace;
        int partitionSize = object2 != null && (object2 = ((CubeWorkspace)object2).getPartitionWorkspaces()) != null ? object2.getMaxPartitionSize() : -1;
        return partitionSize > 0 ? Math.min(partitionSize, CommonTypesKt.getAvailableProcessors()) : Math.min(CommonTypesKt.getAvailableProcessors(), 8);
    }

    @Override
    @NotNull
    protected String getContextTaskName() {
        return "RecoveryThread_" + this.cubeName;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            CubeWorkspace cubeWorkspace = this._cubeWorkspace;
            if (cubeWorkspace != null) {
                cubeWorkspace.close();
            }
        }
        super.close();
    }
}

