/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer2.backup.BackupConstant;
import kd.bos.olapServer2.backup.BackupContext;
import kd.bos.olapServer2.backup.BackupFileType;
import kd.bos.olapServer2.backup.DistributedBackup;
import kd.bos.olapServer2.backup.FileBackup;
import kd.bos.olapServer2.backup.IBackupItem;
import kd.bos.olapServer2.common.DependencyTaskCollection;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.storages.AbstractCubeWorkspace;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J@\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\n\u0010\u0010\u001a\u00060\u0006j\u0002`\u00072\n\u0010\t\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0011\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0012\u001a\u00060\u0006j\u0002`\u0007H\u0002R\u0012\u0010\t\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/backup/RowValidBitmapBackup;", "Lkd/bos/olapServer2/backup/DistributedBackup;", "Lkd/bos/olapServer2/backup/FileBackup;", "workspace", "Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/storages/AbstractCubeWorkspace;Ljava/lang/String;)V", "partitionKey", "init", "", "ctx", "Lkd/bos/olapServer2/backup/BackupContext;", "registerFileItem", "path", "cubeName", "prefix", "extension", "Companion", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nRowValidBitmapBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RowValidBitmapBackup.kt\nkd/bos/olapServer2/backup/RowValidBitmapBackup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n*S KotlinDebug\n*F\n+ 1 RowValidBitmapBackup.kt\nkd/bos/olapServer2/backup/RowValidBitmapBackup\n*L\n71#1:99,2\n*E\n"})
public final class RowValidBitmapBackup
extends DistributedBackup<FileBackup> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootPath;
    @NotNull
    private final String partitionKey;

    public RowValidBitmapBackup(@NotNull AbstractCubeWorkspace workspace, @NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.rootPath = rootPath;
        this.partitionKey = BackupConstant.INSTANCE.getPartitionKey(workspace);
        String cubeName = workspace.getMetadata().getName();
        String[] stringArray = new String[]{cubeName, this.partitionKey};
        String path = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
        if (Companion.requireBackupFile(path)) {
            this.registerFileItem(path, cubeName, this.partitionKey, "rowValid", "key");
            this.registerFileItem(path, cubeName, this.partitionKey, "rowValid", "dat");
        }
    }

    @Override
    public void init(@NotNull BackupContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List items2 = this.getProxyItems();
        int n = 0;
        int n2 = items2.size();
        Function0[] function0Array = new Function0[n2];
        String string2 = "CopyPartitionRowValidBitmap_" + this.partitionKey;
        DependencyTaskCollection dependencyTaskCollection = ctx.getDependencyTasks();
        while (n < n2) {
            int n3 = n++;
            FileBackup item = (FileBackup)items2.get(n3);
            function0Array[n3] = new Function0<Unit>(item){
                final /* synthetic */ FileBackup $item;
                {
                    this.$item = $item;
                    super(0);
                }

                public final void invoke() {
                    this.$item.copyToTempFolder();
                }
            };
        }
        DependencyTaskCollection.addTaskGroup$default(dependencyTaskCollection, string2, function0Array, null, 4, null);
        super.init(ctx);
    }

    private final void registerFileItem(String path, String cubeName, String partitionKey, String prefix, String extension) {
        int bitArrayIndexCount = BackupConstant.INSTANCE.getFileCount(path, prefix, extension);
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)bitArrayIndexCount);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            String[] stringArray = new String[]{prefix + (it != 0 ? String.valueOf(it) : "") + '.' + extension};
            FileBackup rowValidBitmapIndex = new FileBackup(cubeName, this.rootPath, ((Object)Paths.INSTANCE.get(partitionKey, stringArray)).toString(), BackupFileType.OtherFile);
            this.registerProxy((IBackupItem)rowValidBitmapIndex);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer2/backup/RowValidBitmapBackup$Companion;", "", "()V", "requireBackupFile", "", "Lkd/bos/olapServer2/common/bool;", "path", "", "Lkd/bos/olapServer2/common/string;", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean requireBackupFile(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String rowValidDataFilePath = "rowValid.dat";
            String[] stringArray = new String[]{rowValidDataFilePath};
            Path rowValidDataFile = Paths.INSTANCE.get(path, stringArray);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(rowValidDataFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

