/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import java.io.Closeable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kd.bos.olapServer2.backup.IRedoTraceInfoIterable;
import kd.bos.olapServer2.backup.IRedoTraceInfoIterator;
import kd.bos.olapServer2.backup.RedoTraceInfo;
import kd.bos.olapServer2.backup.RedoTraceIterableWrapper;
import kd.bos.olapServer2.backup.TransactionTraceQueryExecutor;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataEntities.InputRow;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.Cube;
import kd.bos.olapServer2.metadata.Dimension;
import kd.bos.olapServer2.metadata.DimensionCollection;
import kd.bos.olapServer2.metadata.Measure;
import kd.bos.olapServer2.metadata.Member;
import kd.bos.olapServer2.metadata.MemberStorageTypes;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.query.QueryBuilder;
import kd.bos.olapServer2.replication.AbstractDMLRecord;
import kd.bos.olapServer2.replication.DDLRecord;
import kd.bos.olapServer2.replication.DDLRecordV0;
import kd.bos.olapServer2.replication.DDLRecordV3;
import kd.bos.olapServer2.replication.DMLRecord;
import kd.bos.olapServer2.replication.DMLRecordV2;
import kd.bos.olapServer2.replication.DMLRecordV3;
import kd.bos.olapServer2.replication.IDDLRecord;
import kd.bos.olapServer2.replication.IDMLRecord;
import kd.bos.olapServer2.replication.IRedoRecord;
import kd.bos.olapServer2.replication.RedoPageInfo;
import kd.bos.olapServer2.replication.RedoRecordWithPage;
import kd.bos.olapServer2.replication.RedoType;
import kd.bos.olapServer2.replication.ReplicationMaster;
import kd.bos.olapServer2.selects.IQueryReader;
import kd.bos.olapServer2.selects.IQuerySession;
import kd.bos.olapServer2.selects.IRowIndexSelectField;
import kd.bos.olapServer2.selects.Query;
import kd.bos.olapServer2.storages.CubeWorkspace;
import kd.bos.olapServer2.storages.RowIndexUtil;
import kd.bos.olapServer2.tools.JsonHelper;
import kd.bos.olapServer2.tools.Res;
import kd.bos.olapServer2.transactions.MasterTransactionContext;
import kd.bos.olapServer2.transactions.UndoRecordReader;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001f !\"BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\u0006\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\u0007\u0012\n\u0010\n\u001a\u00060\bj\u0002`\t\u0012\u000e\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J>\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u0015\u001a\u00060\bj\u0002`\t2\n\u0010\u0016\u001a\u00060\bj\u0002`\t2\n\u0010\u0017\u001a\u00060\fj\u0002`\r2\n\u0010\u0018\u001a\u00060\fj\u0002`\rH\u0002J9\u0010\u0019\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u001a\u0010\u0006\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\u0007H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eR\"\u0010\u0006\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor;", "", "master", "Lkd/bos/olapServer2/replication/ReplicationMaster;", "cubeWorkspace", "Lkd/bos/olapServer2/storages/CubeWorkspace;", "cellKey", "", "", "Lkd/bos/olapServer2/common/string;", "measureName", "token", "", "Lkd/bos/olapServer2/common/long;", "deadlineTime", "Ljava/time/LocalDateTime;", "(Lkd/bos/olapServer2/replication/ReplicationMaster;Lkd/bos/olapServer2/storages/CubeWorkspace;Ljava/util/Map;Ljava/lang/String;Ljava/lang/Long;Ljava/time/LocalDateTime;)V", "Ljava/lang/Long;", "getRedoIterator", "", "Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$RedoRecordWrapper;", "redoPath", "backupPath", "maxLsn", "endTimeLong", "queryRowIndex", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "(Lkd/bos/olapServer2/metadata/Cube;Ljava/util/Map;)Ljava/lang/Long;", "run", "Lkd/bos/olapServer2/backup/RedoTraceIterableWrapper;", "Companion", "EmptyIterable", "RedoRecordWrapper", "RedoTraceIterable", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nTransactionTarceQueryExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionTarceQueryExecutor.kt\nkd/bos/olapServer2/backup/TransactionTraceQueryExecutor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,437:1\n215#2,2:438\n*S KotlinDebug\n*F\n+ 1 TransactionTarceQueryExecutor.kt\nkd/bos/olapServer2/backup/TransactionTraceQueryExecutor\n*L\n50#1:438,2\n*E\n"})
public final class TransactionTraceQueryExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationMaster master;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final Map<String, String> cellKey;
    @NotNull
    private final String measureName;
    @Nullable
    private final Long token;
    @NotNull
    private final LocalDateTime deadlineTime;
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public TransactionTraceQueryExecutor(@NotNull ReplicationMaster master, @NotNull CubeWorkspace cubeWorkspace, @NotNull Map<String, String> cellKey, @NotNull String measureName, @Nullable Long token, @NotNull LocalDateTime deadlineTime) {
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
        Intrinsics.checkNotNullParameter((Object)measureName, (String)"measureName");
        Intrinsics.checkNotNullParameter((Object)deadlineTime, (String)"deadlineTime");
        this.master = master;
        this.cubeWorkspace = cubeWorkspace;
        this.cellKey = cellKey;
        this.measureName = measureName;
        this.token = token;
        this.deadlineTime = deadlineTime;
    }

    @NotNull
    public final RedoTraceIterableWrapper run() {
        int n;
        Cube cube = this.cubeWorkspace.getMetadata();
        int measurePosition = ((Measure)cube.getMeasures().get(this.measureName)).getPosition();
        int[] rowKey = new int[cube.getDimensions().getCount()];
        boolean dynamicCalcAndStored = false;
        boolean dynamicCalc = false;
        String currentStorage = "Stored";
        Map<String, String> $this$forEach$iv = this.cellKey;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            int memberIndex;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            Dimension dim = (Dimension)cube.getDimensions().get(entry.getKey());
            int dimIndex = dim.getPosition();
            Member member = dim.getMembers().get(entry.getValue());
            if (member.getStorageType() == MemberStorageTypes.DynamicCalcAndStored) {
                dynamicCalcAndStored = true;
            }
            if (member.getStorageType() == MemberStorageTypes.DynamicCalc) {
                dynamicCalc = true;
            }
            rowKey[dimIndex] = memberIndex = member.getPosition();
        }
        if (dynamicCalc) {
            currentStorage = "DynamicCalc";
        } else if (dynamicCalcAndStored) {
            currentStorage = "DynamicCalcAndStored";
        }
        Long l = this.queryRowIndex(cube, this.cellKey);
        if (l == null) {
            return new RedoTraceIterableWrapper(new EmptyIterable(), currentStorage);
        }
        long rowIndex = l;
        Cube realCube = null;
        realCube = cube;
        if (cube.getEnabledPartition()) {
            int entry;
            int it = entry = RowIndexUtil.INSTANCE.getPartitionPosition(rowIndex);
            boolean bl = false;
            realCube = this.cubeWorkspace.getMetadata().getPartitionCubeMetadata(this.cubeWorkspace.getMetadata().getPartitionItems().get(it));
            n = entry;
        } else {
            n = -1;
        }
        int partitionId = n;
        long partitionRowIndex = RowIndexUtil.INSTANCE.getPartitionRowIndex(rowIndex);
        MasterTransactionContext masterTransactionContext = this.master.getTransactionContext$bos_olap_core2();
        long endTimeLong = this.deadlineTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        Iterator<RedoRecordWrapper> iterator3 = this.getRedoIterator(masterTransactionContext.getRedoPath(), masterTransactionContext.getBackupPath(), masterTransactionContext.getCurrentLsn(), endTimeLong);
        return new RedoTraceIterableWrapper(new RedoTraceIterable(iterator3, realCube, rowKey, measurePosition, partitionId, partitionRowIndex), currentStorage);
    }

    private final Iterator<RedoRecordWrapper> getRedoIterator(String redoPath, String backupPath, long maxLsn, long endTimeLong) {
        Long l = this.token;
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)new UndoRecordReader(redoPath, backupPath, 0L, Long.min(maxLsn, l != null ? l : maxLsn), this.cubeWorkspace.getCubeId()), (Function1)((Function1)new Function1<RedoRecordWithPage, Boolean>(endTimeLong){
            final /* synthetic */ long $endTimeLong;
            {
                this.$endTimeLong = $endTimeLong;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RedoRecordWithPage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RedoPageInfo page = it.getStartPage();
                return page.getTimestamp() >= this.$endTimeLong;
            }
        })), (Function1)getRedoIterator.2.INSTANCE), (Function1)getRedoIterator.3.INSTANCE).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Long queryRowIndex(Cube cube, Map<String, String> cellKey) {
        Map.Entry<String, String> entry2;
        QueryBuilder queryBuilder;
        DimensionCollection dims = cube.getDimensions();
        if (cellKey.keySet().size() != dims.getCount()) {
            String string2 = Res.INSTANCE.getTransactionTraceQueryExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TransactionTraceQue\u2026ExecutorException_1>(...)");
            Object[] objectArray = new Object[]{cellKey};
            throw Res.INSTANCE.getIllegalArgumentException(string2, objectArray);
        }
        QueryBuilder $this$queryRowIndex_u24lambda_u242 = queryBuilder = new QueryBuilder(cube);
        boolean bl = false;
        for (Map.Entry<String, String> entry2 : cellKey.entrySet()) {
            String dim = entry2.getKey();
            String member = entry2.getValue();
            $this$queryRowIndex_u24lambda_u242.addFilter(dim, CollectionsKt.listOf((Object)member));
        }
        $this$queryRowIndex_u24lambda_u242.getQuery().setIncludeRowIndexField(true);
        $this$queryRowIndex_u24lambda_u242.getQuery().setTop(1L);
        $this$queryRowIndex_u24lambda_u242.getQuery().setExcludeDynamicCalcResult(true);
        Query query2 = queryBuilder.getQuery();
        IQuerySession session = this.cubeWorkspace.createQuerySession(query2, false);
        IQueryReader reader = session.createReader();
        Closeable closeable = reader;
        Object object2 = null;
        try {
            Long l;
            IQueryReader it = (IQueryReader)closeable;
            boolean bl2 = false;
            if (it.next()) {
                Object TValue = it.getSelectFields().get("__rowIndex__");
                Intrinsics.checkNotNull(TValue, (String)"null cannot be cast to non-null type kd.bos.olapServer2.selects.IRowIndexSelectField");
                IRowIndexSelectField rowIndexField = (IRowIndexSelectField)TValue;
                l = rowIndexField.getCurrent();
            } else {
                l = null;
            }
            entry2 = l;
        }
        catch (Throwable throwable) {
            try {
                object2 = throwable;
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)closeable, object2);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        return entry2;
    }

    public static final /* synthetic */ DateTimeFormatter access$getDateFormat$cp() {
        return dateFormat;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$Companion;", "", "()V", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0007H\u0096\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$EmptyIterable;", "Lkd/bos/olapServer2/backup/IRedoTraceInfoIterable;", "()V", "iterator", "kd/bos/olapServer2/backup/TransactionTraceQueryExecutor$EmptyIterable$iterator$1", "getIterator", "()Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$EmptyIterable$iterator$1;", "Lkd/bos/olapServer2/backup/IRedoTraceInfoIterator;", "bos-olap-core2"})
    private static final class EmptyIterable
    implements IRedoTraceInfoIterable {
        private final iterator.1 getIterator() {
            return new IRedoTraceInfoIterator(){
                @Nullable
                private final Long currentDeadlineTime;

                @Nullable
                public Long getCurrentDeadlineTime() {
                    return this.currentDeadlineTime;
                }

                public boolean hasNext() {
                    return false;
                }

                @NotNull
                public RedoTraceInfo next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public IRedoTraceInfoIterator iterator() {
            return this.getIterator();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0016\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00060\u0004j\u0002`\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0015\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014\u00a8\u0006\""}, d2={"Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$RedoRecordWrapper;", "Lkd/bos/olapServer2/replication/IRedoRecord;", "realRecord", "lsn", "", "Lkd/bos/olapServer2/common/long;", "time", "measureValue", "", "(Lkd/bos/olapServer2/replication/IRedoRecord;JJLjava/lang/Object;)V", "cubeId", "", "Lkd/bos/olapServer2/common/int;", "getCubeId", "()I", "isOlapLevel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "getLsn", "()J", "getMeasureValue", "()Ljava/lang/Object;", "setMeasureValue", "(Ljava/lang/Object;)V", "getRealRecord", "()Lkd/bos/olapServer2/replication/IRedoRecord;", "redoType", "Lkd/bos/olapServer2/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer2/replication/RedoType;", "tid", "getTid", "getTime", "bos-olap-core2"})
    private static final class RedoRecordWrapper
    implements IRedoRecord {
        @NotNull
        private final IRedoRecord realRecord;
        private final long lsn;
        private final long time;
        @Nullable
        private Object measureValue;

        public RedoRecordWrapper(@NotNull IRedoRecord realRecord, long lsn, long time2, @Nullable Object measureValue) {
            Intrinsics.checkNotNullParameter((Object)realRecord, (String)"realRecord");
            this.realRecord = realRecord;
            this.lsn = lsn;
            this.time = time2;
            this.measureValue = measureValue;
        }

        public /* synthetic */ RedoRecordWrapper(IRedoRecord iRedoRecord, long l, long l2, Object object2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                object2 = null;
            }
            this(iRedoRecord, l, l2, object2);
        }

        @NotNull
        public final IRedoRecord getRealRecord() {
            return this.realRecord;
        }

        public final long getLsn() {
            return this.lsn;
        }

        public final long getTime() {
            return this.time;
        }

        @Nullable
        public final Object getMeasureValue() {
            return this.measureValue;
        }

        public final void setMeasureValue(@Nullable Object object2) {
            this.measureValue = object2;
        }

        @Override
        public int getCubeId() {
            return this.realRecord.getCubeId();
        }

        @Override
        public boolean isOlapLevel() {
            return this.realRecord.isOlapLevel();
        }

        @Override
        @NotNull
        public RedoType getRedoType() {
            return this.realRecord.getRedoType();
        }

        @Override
        public long getTid() {
            return this.realRecord.getTid();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0012\b\u0002\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\n\u0010\f\u001a\u00060\nj\u0002`\u000b\u0012\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0011\u001a\u00020\u0015H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$RedoTraceIterable;", "Lkd/bos/olapServer2/backup/IRedoTraceInfoIterable;", "unIterator", "", "Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$RedoRecordWrapper;", "cube", "Lkd/bos/olapServer2/metadata/Cube;", "rowKey", "", "measurePosition", "", "Lkd/bos/olapServer2/common/int;", "partitionId", "rowIndex", "", "Lkd/bos/olapServer2/common/long;", "(Ljava/util/Iterator;Lkd/bos/olapServer2/metadata/Cube;[IIIJ)V", "iterator", "kd/bos/olapServer2/backup/TransactionTraceQueryExecutor$RedoTraceIterable$iterator$1", "getIterator", "()Lkd/bos/olapServer2/backup/TransactionTraceQueryExecutor$RedoTraceIterable$iterator$1;", "Lkd/bos/olapServer2/backup/IRedoTraceInfoIterator;", "bos-olap-core2"})
    private static final class RedoTraceIterable
    implements IRedoTraceInfoIterable {
        @NotNull
        private final Iterator<RedoRecordWrapper> unIterator;
        @NotNull
        private final Cube cube;
        @NotNull
        private final int[] rowKey;
        private final int measurePosition;
        private final int partitionId;
        private final long rowIndex;

        public RedoTraceIterable(@NotNull Iterator<RedoRecordWrapper> unIterator, @NotNull Cube cube, @NotNull int[] rowKey, int measurePosition, int partitionId, long rowIndex) {
            Intrinsics.checkNotNullParameter(unIterator, (String)"unIterator");
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            Intrinsics.checkNotNullParameter((Object)rowKey, (String)"rowKey");
            this.unIterator = unIterator;
            this.cube = cube;
            this.rowKey = rowKey;
            this.measurePosition = measurePosition;
            this.partitionId = partitionId;
            this.rowIndex = rowIndex;
        }

        private final iterator.1 getIterator() {
            return new IRedoTraceInfoIterator(this){
                @Nullable
                private Long _currentDeadlineTime;
                private boolean canContinue;
                @Nullable
                private RedoRecordWrapper Current;
                @NotNull
                private final StringBuilder ddlCommandStr;
                @NotNull
                private final InputRow row;
                final /* synthetic */ RedoTraceIterable this$0;
                {
                    this.this$0 = $receiver;
                    this.canContinue = true;
                    this.ddlCommandStr = new StringBuilder();
                    this.row = new InputRow(RedoTraceIterable.access$getCube$p($receiver));
                }

                @Nullable
                public Long getCurrentDeadlineTime() {
                    return this._currentDeadlineTime;
                }

                public boolean hasNext() {
                    boolean hasNext = false;
                    while (this.canContinue && RedoTraceIterable.access$getUnIterator$p(this.this$0).hasNext()) {
                        boolean bl;
                        RedoRecordWrapper current = (RedoRecordWrapper)RedoTraceIterable.access$getUnIterator$p(this.this$0).next();
                        this._currentDeadlineTime = current.getTime();
                        IRedoRecord record = current.getRealRecord();
                        switch (iterator.WhenMappings.$EnumSwitchMapping$0[record.getRedoType().ordinal()]) {
                            case 1: {
                                bl = false;
                                break;
                            }
                            case 2: {
                                iterator.1.dealPrevDDLCommand$default(this, false, 1, null);
                                if (this.canContinue) {
                                    bl = this.execInsert(record, current);
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case 3: 
                            case 4: {
                                iterator.1.dealPrevDDLCommand$default(this, false, 1, null);
                                if (this.canContinue) {
                                    boolean flag;
                                    Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDMLRecord");
                                    IDMLRecord dmlRecord = (IDMLRecord)record;
                                    boolean bl2 = flag = dmlRecord.getPartitionId() == RedoTraceIterable.access$getPartitionId$p(this.this$0) && dmlRecord.getRowIndex() == RedoTraceIterable.access$getRowIndex$p(this.this$0);
                                    if (flag) {
                                        dmlRecord.getMeasures(this.row);
                                        Object measureValue = this.row.getValues().getMeasureValue(RedoTraceIterable.access$getMeasurePosition$p(this.this$0));
                                        if (!Intrinsics.areEqual((Object)measureValue, (Object)CommonTypesKt.getIgnoreValue())) {
                                            current.setMeasureValue(measureValue);
                                            bl = true;
                                            break;
                                        }
                                        bl = false;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case 5: {
                                this.canContinue = false;
                                bl = false;
                                break;
                            }
                            case 6: {
                                Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type kd.bos.olapServer2.replication.IDDLRecord");
                                IDDLRecord ddlRecord = (IDDLRecord)record;
                                String commandStr = ddlRecord.getDDLCommand();
                                IDDLRecord iDDLRecord = ddlRecord;
                                if (iDDLRecord instanceof DDLRecord ? true : iDDLRecord instanceof DDLRecordV0) {
                                    if (ddlRecord.isEofDDL()) {
                                        iterator.1.dealPrevDDLCommand$default(this, false, 1, null);
                                    }
                                    this.ddlCommandStr.insert(0, commandStr);
                                } else if (iDDLRecord instanceof DDLRecordV3) {
                                    this.ddlCommandStr.insert(0, commandStr);
                                    this.dealPrevDDLCommand(true);
                                } else {
                                    throw Res.INSTANCE.getNotSupportedException("not support record type", new Object[0]);
                                }
                                bl = false;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        if (!(hasNext = bl)) continue;
                        this.Current = current;
                        break;
                    }
                    return hasNext;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private final boolean execInsert(IRedoRecord record, RedoRecordWrapper current) {
                    if (!(record instanceof AbstractDMLRecord)) return false;
                    IRedoRecord iRedoRecord = record;
                    if (iRedoRecord instanceof DMLRecord) {
                        ((AbstractDMLRecord)record).getRow(this.row, RedoTraceIterable.access$getCube$p(this.this$0).getDimensions().getCount());
                        if (!Arrays.equals(this.row.getKeys().getArray(), RedoTraceIterable.access$getRowKey$p(this.this$0))) return false;
                        this.canContinue = false;
                        Object measureValue = this.row.getValues().getMeasureValue(RedoTraceIterable.access$getMeasurePosition$p(this.this$0));
                        if (Intrinsics.areEqual((Object)measureValue, (Object)CommonTypesKt.getIgnoreValue())) return false;
                        current.setMeasureValue(measureValue);
                        return true;
                    }
                    if (!(iRedoRecord instanceof DMLRecordV2 ? true : iRedoRecord instanceof DMLRecordV3)) throw Res.INSTANCE.getNotSupportedException("not support record type", new Object[0]);
                    if (((AbstractDMLRecord)record).getPartitionId() != RedoTraceIterable.access$getPartitionId$p(this.this$0)) return false;
                    if (((AbstractDMLRecord)record).getRowIndex() != RedoTraceIterable.access$getRowIndex$p(this.this$0)) return false;
                    this.canContinue = false;
                    ((AbstractDMLRecord)record).getRow(this.row, RedoTraceIterable.access$getCube$p(this.this$0).getDimensions().getCount());
                    Object measureValue = this.row.getValues().getMeasureValue(RedoTraceIterable.access$getMeasurePosition$p(this.this$0));
                    if (Intrinsics.areEqual((Object)measureValue, (Object)CommonTypesKt.getIgnoreValue())) return false;
                    current.setMeasureValue(measureValue);
                    return true;
                }

                private final void dealPrevDDLCommand(boolean ignoreMember) {
                    if (((CharSequence)this.ddlCommandStr).length() > 0) {
                        String string2 = this.ddlCommandStr.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        String commandStr = string2;
                        MetadataCommandInfo metaCmdInfo = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(commandStr, MetadataCommandInfo.class);
                        this.canContinue = !(metaCmdInfo.getMetadataType() == MetadataTypes.Member && metaCmdInfo.getAction() == CommandTypes.drop && !ignoreMember || metaCmdInfo.getMetadataType() == MetadataTypes.Dimension && (metaCmdInfo.getAction() == CommandTypes.drop || metaCmdInfo.getAction() == CommandTypes.create) || metaCmdInfo.getMetadataType() == MetadataTypes.Cube && metaCmdInfo.getAction() == CommandTypes.repair || metaCmdInfo.getMetadataType() == MetadataTypes.Partition && metaCmdInfo.getAction() == CommandTypes.repair);
                        StringsKt.clear((StringBuilder)this.ddlCommandStr);
                    }
                }

                static /* synthetic */ void dealPrevDDLCommand$default(iterator.1 var0, boolean bl, int n, Object object2) {
                    if ((n & 1) != 0) {
                        bl = false;
                    }
                    var0.dealPrevDDLCommand(bl);
                }

                @NotNull
                public RedoTraceInfo next() {
                    RedoRecordWrapper currentValue = this.Current;
                    if (currentValue != null) {
                        String timeStr = Instant.ofEpochSecond(currentValue.getTime() / (long)1000).atZone(ZoneId.systemDefault()).toLocalDateTime().format(TransactionTraceQueryExecutor.access$getDateFormat$cp());
                        IRedoRecord realRecord = currentValue.getRealRecord();
                        if (!(realRecord instanceof IDMLRecord)) {
                            String string2 = "Failed requirement.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        Object measureValue = currentValue.getMeasureValue();
                        Object value2 = !Intrinsics.areEqual((Object)measureValue, (Object)CommonTypesKt.getUndefined()) ? measureValue : null;
                        long l = currentValue.getTid();
                        long l2 = currentValue.getLsn();
                        Intrinsics.checkNotNull((Object)timeStr);
                        RedoTraceInfo redoTraceInfo = new RedoTraceInfo(l, l2, value2, timeStr);
                        this.Current = null;
                        this.row.reset();
                        return redoTraceInfo;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public IRedoTraceInfoIterator iterator() {
            return this.getIterator();
        }

        public static final /* synthetic */ Cube access$getCube$p(RedoTraceIterable $this) {
            return $this.cube;
        }

        public static final /* synthetic */ Iterator access$getUnIterator$p(RedoTraceIterable $this) {
            return $this.unIterator;
        }

        public static final /* synthetic */ int access$getPartitionId$p(RedoTraceIterable $this) {
            return $this.partitionId;
        }

        public static final /* synthetic */ long access$getRowIndex$p(RedoTraceIterable $this) {
            return $this.rowIndex;
        }

        public static final /* synthetic */ int access$getMeasurePosition$p(RedoTraceIterable $this) {
            return $this.measurePosition;
        }

        public static final /* synthetic */ int[] access$getRowKey$p(RedoTraceIterable $this) {
            return $this.rowKey;
        }
    }
}

