/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup;

import SevenZip.Compression.LZMA.Encoder;
import SevenZip.ICodeProgress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olapServer2.backup.BackupContext;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.PathsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\b\u0018\u00010\u0010R\u00020\u0000H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0006\u0010\u001b\u001a\u00020\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer2/backup/ZipFileStreamQueue;", "", "target", "Ljava/io/DataOutputStream;", "ctx", "Lkd/bos/olapServer2/backup/BackupContext;", "(Ljava/io/DataOutputStream;Lkd/bos/olapServer2/backup/BackupContext;)V", "_buffer", "", "_cachedRes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkd/bos/olapServer2/common/long;", "LSevenZip/Compression/LZMA/Encoder;", "_files", "", "Lkd/bos/olapServer2/backup/ZipFileStreamQueue$ZipFileEntry;", "_latch", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_waitingOutputEntryIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "register", "Lkd/bos/olapServer2/backup/ZipFileStreamQueue$IZipFileEntry;", "startOutput", "", "tryGetOutputEntry", "trySaveToTarget", "waitTasks", "IZipFileEntry", "ProgressWithCancel", "ZipFileEntry", "bos-olap-core2"})
public final class ZipFileStreamQueue {
    @NotNull
    private final DataOutputStream target;
    @NotNull
    private final BackupContext ctx;
    @NotNull
    private final List<ZipFileEntry> _files;
    @NotNull
    private final AtomicBoolean _latch;
    @NotNull
    private final AtomicInteger _waitingOutputEntryIndex;
    @NotNull
    private final byte[] _buffer;
    @NotNull
    private final ConcurrentHashMap<Long, Encoder> _cachedRes;

    public ZipFileStreamQueue(@NotNull DataOutputStream target, @NotNull BackupContext ctx) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.target = target;
        this.ctx = ctx;
        this._files = new ArrayList();
        this._latch = new AtomicBoolean();
        this._waitingOutputEntryIndex = new AtomicInteger(-1);
        this._buffer = new byte[8192];
        this._cachedRes = new ConcurrentHashMap();
    }

    @NotNull
    public final IZipFileEntry register() {
        ZipFileEntry entry = new ZipFileEntry();
        this._files.add(entry);
        return entry;
    }

    public final void startOutput() {
        if (!this._waitingOutputEntryIndex.compareAndSet(-1, 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.trySaveToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void trySaveToTarget() {
        if (this._latch.compareAndSet(false, true)) {
            try {
                ZipFileEntry outputEntry = this.tryGetOutputEntry();
                while (outputEntry != null) {
                    outputEntry.saveToTarget();
                    this._waitingOutputEntryIndex.incrementAndGet();
                    outputEntry = this.tryGetOutputEntry();
                }
            }
            finally {
                this._latch.set(false);
            }
        }
    }

    private final ZipFileEntry tryGetOutputEntry() {
        ZipFileEntry waitingOutputEntry;
        int waitingOutputEntryIndex = this._waitingOutputEntryIndex.get();
        boolean bl = 0 <= waitingOutputEntryIndex ? waitingOutputEntryIndex < this._files.size() : false;
        if (bl && (waitingOutputEntry = this._files.get(waitingOutputEntryIndex)).getZipFinished()) {
            return waitingOutputEntry;
        }
        return null;
    }

    public final void waitTasks() {
        this.ctx.waitTasks();
        this.trySaveToTarget();
        this._cachedRes.clear();
        if (!(this._waitingOutputEntryIndex.get() == this._files.size())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0001\u0006\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer2/backup/ZipFileStreamQueue$IZipFileEntry;", "Ljava/io/Closeable;", "zipFile", "", "sourceFile", "Ljava/io/File;", "Lkd/bos/olapServer2/backup/ZipFileStreamQueue$ZipFileEntry;", "bos-olap-core2"})
    public static interface IZipFileEntry
    extends Closeable {
        public void zipFile(@NotNull File var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer2/backup/ZipFileStreamQueue$ProgressWithCancel;", "LSevenZip/ICodeProgress;", "()V", "token", "Lkd/bos/olapServer2/common/IContinueToken;", "(Lkd/bos/olapServer2/common/IContinueToken;)V", "SetProgress", "", "p0", "", "p1", "bos-olap-core2"})
    private static final class ProgressWithCancel
    implements ICodeProgress {
        @NotNull
        private final IContinueToken token;

        public ProgressWithCancel(@NotNull IContinueToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.token = token;
        }

        public ProgressWithCancel() {
            this(CancellableToken.INSTANCE.getContinueToken());
        }

        public void SetProgress(long p0, long p1) {
            this.token.canContinue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\tj\u0002`\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/backup/ZipFileStreamQueue$ZipFileEntry;", "Lkd/bos/olapServer2/backup/ZipFileStreamQueue$IZipFileEntry;", "(Lkd/bos/olapServer2/backup/ZipFileStreamQueue;)V", "_sourceFile", "Ljava/io/File;", "_state", "", "_zipFile", "zipFinished", "", "Lkd/bos/olapServer2/common/bool;", "getZipFinished", "()Z", "close", "", "saveToTarget", "zip", "zipFile", "sourceFile", "bos-olap-core2"})
    @SourceDebugExtension(value={"SMAP\nZipFileStreamQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFileStreamQueue.kt\nkd/bos/olapServer2/backup/ZipFileStreamQueue$ZipFileEntry\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n72#2,2:171\n1#3:173\n*S KotlinDebug\n*F\n+ 1 ZipFileStreamQueue.kt\nkd/bos/olapServer2/backup/ZipFileStreamQueue$ZipFileEntry\n*L\n117#1:171,2\n117#1:173\n*E\n"})
    private final class ZipFileEntry
    implements IZipFileEntry {
        private int _state;
        @Nullable
        private File _sourceFile;
        @Nullable
        private File _zipFile;

        public final boolean getZipFinished() {
            return this._state > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zipFile(@NotNull File sourceFile) {
            File tmpFile;
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            if (!(this._state == 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            this._sourceFile = sourceFile;
            this._zipFile = tmpFile = ITempFolder.Companion.createTempFile("backupZipFile", ".tmp");
            BackupContext backupContext = ZipFileStreamQueue.this.ctx;
            ZipFileStreamQueue zipFileStreamQueue = ZipFileStreamQueue.this;
            BackupContext backupContext2 = backupContext;
            synchronized (backupContext2) {
                boolean bl = false;
                zipFileStreamQueue.ctx.submitTask((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                    public final void invoke() {
                        ((ZipFileEntry)this.receiver).zip();
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void zip() {
            void key$iv;
            void $this$getOrPut$iv;
            if (!(this._state == 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            File file = this._sourceFile;
            Intrinsics.checkNotNull((Object)file);
            File sourceFile = file;
            File file2 = this._zipFile;
            Intrinsics.checkNotNull((Object)file2);
            File zipFile2 = file2;
            Object object2 = ZipFileStreamQueue.this._cachedRes;
            Serializable serializable = Thread.currentThread().getId();
            ZipFileStreamQueue zipFileStreamQueue = ZipFileStreamQueue.this;
            boolean $i$f$getOrPut = false;
            Object object3 = $this$getOrPut$iv.get(key$iv);
            if (object3 == null) {
                boolean bl = false;
                Encoder default$iv = zipFileStreamQueue.ctx.createEncoder();
                boolean bl2 = false;
                object3 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object3 == null) {
                    object3 = default$iv;
                }
            }
            Encoder encoder = (Encoder)object3;
            object2 = PathsKt.safeInputStream(sourceFile);
            serializable = null;
            try {
                FileInputStream inputStream = (FileInputStream)object2;
                boolean bl = false;
                Closeable closeable = new BufferedOutputStream(PathsKt.safeOutputStream(zipFile2));
                Throwable throwable = null;
                try {
                    BufferedOutputStream outputStream = (BufferedOutputStream)closeable;
                    boolean bl3 = false;
                    encoder.Code((InputStream)inputStream, (OutputStream)outputStream, -1L, -1L, (ICodeProgress)new ProgressWithCancel());
                    outputStream.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                zipFileStreamQueue = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)serializable);
            }
            this._state = 1;
            ZipFileStreamQueue.this.trySaveToTarget();
            sourceFile.delete();
            this._sourceFile = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void saveToTarget() {
            if (!(this._state == 1)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            File file = this._zipFile;
            Intrinsics.checkNotNull((Object)file);
            File zipFile2 = file;
            byte[] buffer = ZipFileStreamQueue.this._buffer;
            Closeable closeable = new BufferedInputStream(PathsKt.safeInputStream(zipFile2));
            ZipFileStreamQueue zipFileStreamQueue = ZipFileStreamQueue.this;
            Throwable throwable = null;
            try {
                BufferedInputStream inputStream = (BufferedInputStream)closeable;
                boolean bl = false;
                int size = inputStream.read(buffer);
                while (size >= 0) {
                    zipFileStreamQueue.target.write(buffer, 0, size);
                    size = inputStream.read(buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this._state = 2;
            zipFile2.delete();
            this._zipFile = null;
        }

        @Override
        public void close() {
            block3: {
                if (this._state >= 2) break block3;
                File file = this._zipFile;
                if (file != null) {
                    file.delete();
                }
                if (this._state < 1) {
                    File file2 = this._sourceFile;
                    if (file2 != null) {
                        file2.delete();
                    }
                }
            }
        }
    }
}

