/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kd.bos.olapServer2.collections.LockFreeQueue;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.OlapConfigItem;
import kd.bos.olapServer2.common.PathsKt;
import kd.bos.olapServer2.tools.RecycledByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u0004\u0018\u00010\u0004J\b\u0010\r\u001a\u0004\u0018\u00010\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/BigStreamCache;", "Ljava/io/Closeable;", "()V", "_inMemoryByteBuffer", "Ljava/nio/ByteBuffer;", "_tempFile", "Ljava/io/File;", "close", "", "copy", "Ljava/io/InputStream;", "inputStream", "tryGetInMemoryByteBuffer", "tryGetTempFile", "Companion", "InMemoryCache", "bos-olap-core2"})
public final class BigStreamCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private File _tempFile;
    @Nullable
    private ByteBuffer _inMemoryByteBuffer;
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem threadByteBufferInitSizeConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_Stream_threadByteBufferInitSize", 4, 1, 131072, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem threadByteBufferMaxReleaseSizeConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_Stream_threadByteBufferMaxReleaseSize", 16, 1, 131072, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem sharedByteBufferInitSizeConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_Stream_sharedByteBufferInitSize", 8192, 1, 262144, null, false, false, null, 240, null);
    @NotNull
    private static final OlapConfigItem.OlapConfigIntTypeItem sharedByteBufferMaxObjectCountConfigItem = new OlapConfigItem.OlapConfigIntTypeItem("BytePool_Stream_sharedByteBufferMaxObjectCount", 4, 1, 1024, null, false, false, null, 240, null);
    @NotNull
    private static final ThreadLocal<byte[]> byteBufferCache = new ThreadLocal();
    @NotNull
    private static final LockFreeQueue<byte[]> bigByteBufferCache = new LockFreeQueue(kd.bos.olapServer2.backup.sequenceLog.BigStreamCache$Companion.access$getSharedByteBufferMaxObjectCount(Companion), true);

    @Nullable
    public final ByteBuffer tryGetInMemoryByteBuffer() {
        return this._inMemoryByteBuffer;
    }

    @Nullable
    public final File tryGetTempFile() {
        return this._tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final InputStream copy(@NotNull InputStream inputStream) {
        File tempFile;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InMemoryCache smallCache = new InMemoryCache(Companion.getOrCreateByteBuffer());
        this._inMemoryByteBuffer = smallCache.write(inputStream);
        if (this._inMemoryByteBuffer != null) {
            return smallCache.createStream();
        }
        InMemoryCache bigCache = new InMemoryCache(Companion.getOrCreateBigByteBuffer());
        bigCache.getInMemoryStream().write(smallCache.getByteArray());
        Companion.release(smallCache.getByteBuffer());
        this._inMemoryByteBuffer = bigCache.write(inputStream);
        if (this._inMemoryByteBuffer != null) {
            return bigCache.createStream();
        }
        this._tempFile = tempFile = ITempFolder.Companion.createTempFile("KDMDD", "Cache");
        Closeable closeable = PathsKt.safeOutputStream(tempFile);
        Throwable throwable = null;
        try {
            FileOutputStream tempStream = (FileOutputStream)closeable;
            boolean bl = false;
            tempStream.write(bigCache.getByteArray());
            Companion.release(bigCache.getByteBuffer());
            this._inMemoryByteBuffer = null;
            long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempStream, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return PathsKt.safeInputStream(tempFile);
    }

    @Override
    public void close() {
        ByteBuffer byteBuffer = this._inMemoryByteBuffer;
        if (byteBuffer != null) {
            ByteBuffer it = byteBuffer;
            boolean bl = false;
            Companion.release(it);
        }
        File file = this._tempFile;
        if (file != null) {
            file.delete();
        }
        this._inMemoryByteBuffer = null;
        this._tempFile = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00060\tj\u0002`\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0018\u0010\u0015\u001a\u00060\tj\u0002`\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0017\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0018\u0010\u0019\u001a\u00060\tj\u0002`\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u0014\u0010\u001b\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010\u00a8\u0006#"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/BigStreamCache$Companion;", "", "()V", "bigByteBufferCache", "Lkd/bos/olapServer2/collections/LockFreeQueue;", "", "byteBufferCache", "Ljava/lang/ThreadLocal;", "sharedByteBufferInitSize", "", "Lkd/bos/olapServer2/common/int;", "getSharedByteBufferInitSize", "()I", "sharedByteBufferInitSizeConfigItem", "Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigIntTypeItem;", "getSharedByteBufferInitSizeConfigItem$bos_olap_core2", "()Lkd/bos/olapServer2/common/OlapConfigItem$OlapConfigIntTypeItem;", "sharedByteBufferMaxObjectCount", "getSharedByteBufferMaxObjectCount", "sharedByteBufferMaxObjectCountConfigItem", "getSharedByteBufferMaxObjectCountConfigItem$bos_olap_core2", "threadByteBufferInitSize", "getThreadByteBufferInitSize", "threadByteBufferInitSizeConfigItem", "getThreadByteBufferInitSizeConfigItem$bos_olap_core2", "threadByteBufferMaxReleaseSize", "getThreadByteBufferMaxReleaseSize", "threadByteBufferMaxReleaseSizeConfigItem", "getThreadByteBufferMaxReleaseSizeConfigItem$bos_olap_core2", "getOrCreateBigByteBuffer", "Ljava/nio/ByteBuffer;", "getOrCreateByteBuffer", "release", "", "value", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getThreadByteBufferInitSizeConfigItem$bos_olap_core2() {
            return threadByteBufferInitSizeConfigItem;
        }

        private final int getThreadByteBufferInitSize() {
            return this.getThreadByteBufferInitSizeConfigItem$bos_olap_core2().getValue() * 1024;
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getThreadByteBufferMaxReleaseSizeConfigItem$bos_olap_core2() {
            return threadByteBufferMaxReleaseSizeConfigItem;
        }

        private final int getThreadByteBufferMaxReleaseSize() {
            return Math.max(this.getThreadByteBufferInitSizeConfigItem$bos_olap_core2().getValue(), this.getThreadByteBufferMaxReleaseSizeConfigItem$bos_olap_core2().getValue()) * 1024;
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getSharedByteBufferInitSizeConfigItem$bos_olap_core2() {
            return sharedByteBufferInitSizeConfigItem;
        }

        private final int getSharedByteBufferInitSize() {
            int tv;
            int v = this.getSharedByteBufferInitSizeConfigItem$bos_olap_core2().getValue();
            return (v <= (tv = this.getThreadByteBufferInitSizeConfigItem$bos_olap_core2().getValue()) ? tv * 2 : v) * 1024;
        }

        @NotNull
        public final OlapConfigItem.OlapConfigIntTypeItem getSharedByteBufferMaxObjectCountConfigItem$bos_olap_core2() {
            return sharedByteBufferMaxObjectCountConfigItem;
        }

        private final int getSharedByteBufferMaxObjectCount() {
            return this.getSharedByteBufferMaxObjectCountConfigItem$bos_olap_core2().getValue();
        }

        @NotNull
        public final ByteBuffer getOrCreateByteBuffer() {
            byte[] cache = (byte[])byteBufferCache.get();
            if (cache == null) {
                cache = new byte[this.getThreadByteBufferInitSize()];
            } else {
                byteBufferCache.set(null);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(cache);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            return byteBuffer;
        }

        public final void release(@Nullable ByteBuffer value2) {
            byte[] old = (byte[])byteBufferCache.get();
            if (value2 != null) {
                value2.limit(0);
                if (value2.capacity() == this.getSharedByteBufferInitSize()) {
                    LockFreeQueue lockFreeQueue = bigByteBufferCache;
                    byte[] byArray = value2.array();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                    lockFreeQueue.push(byArray);
                } else if (value2.capacity() <= this.getThreadByteBufferMaxReleaseSize() && (old == null || old.length < value2.capacity())) {
                    byteBufferCache.set(value2.array());
                }
            }
        }

        @NotNull
        public final ByteBuffer getOrCreateBigByteBuffer() {
            byte[] byArray = (byte[])bigByteBufferCache.tryPop();
            if (byArray == null) {
                byArray = new byte[this.getSharedByteBufferInitSize()];
            }
            byte[] cache = byArray;
            ByteBuffer byteBuffer = ByteBuffer.wrap(cache);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            return byteBuffer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ int access$getSharedByteBufferMaxObjectCount(Companion $this) {
            return $this.getSharedByteBufferMaxObjectCount();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/BigStreamCache$InMemoryCache;", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "byteArray", "", "getByteArray", "()[B", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "inMemoryStream", "Lkd/bos/olapServer2/tools/RecycledByteArrayOutputStream;", "getInMemoryStream", "()Lkd/bos/olapServer2/tools/RecycledByteArrayOutputStream;", "createStream", "Ljava/io/InputStream;", "write", "inputStream", "bos-olap-core2"})
    private static final class InMemoryCache {
        @NotNull
        private final ByteBuffer byteBuffer;
        @NotNull
        private final byte[] byteArray;
        @NotNull
        private final RecycledByteArrayOutputStream inMemoryStream;

        public InMemoryCache(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            this.byteBuffer = byteBuffer;
            byte[] byArray = this.byteBuffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            this.byteArray = byArray;
            this.inMemoryStream = new RecycledByteArrayOutputStream(this.byteArray, null);
        }

        @NotNull
        public final ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        @NotNull
        public final byte[] getByteArray() {
            return this.byteArray;
        }

        @NotNull
        public final RecycledByteArrayOutputStream getInMemoryStream() {
            return this.inMemoryStream;
        }

        @Nullable
        public final ByteBuffer write(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.inMemoryStream.writeFrom(inputStream, this.byteArray.length - this.inMemoryStream.getSize());
            int size = this.inMemoryStream.getSize();
            return size < this.byteArray.length ? ByteBuffer.wrap(this.byteArray, 0, size) : null;
        }

        @NotNull
        public final InputStream createStream() {
            return new ByteArrayInputStream(this.byteArray, 0, this.inMemoryStream.getSize());
        }
    }
}

