/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogFilter;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogRecord;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0010\u001a\u00060\rj\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0019\u0010\u0014\u001a\u00060\rj\u0002`\u00112\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/EndTimeFilter;", "T", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecord;", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogFilter;", "endTime", "Ljava/time/LocalDateTime;", "(Ljava/time/LocalDateTime;)V", "_endDate", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "_endTimeLong", "", "_hasNotMatch", "", "getEndTime", "()Ljava/time/LocalDateTime;", "matchEntry", "Lkd/bos/olapServer2/common/bool;", "entry", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "matchRecord", "record", "(Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecord;)Z", "bos-olap-core2"})
public final class EndTimeFilter<T extends ISeqLogRecord>
implements ISeqLogFilter<T> {
    @NotNull
    private final LocalDateTime endTime;
    private boolean _hasNotMatch;
    private final long _endTimeLong;
    private final LocalDate _endDate;

    public EndTimeFilter(@NotNull LocalDateTime endTime) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.endTime = endTime;
        this._endTimeLong = this.endTime.atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
        this._endDate = this.endTime.toLocalDate();
    }

    @NotNull
    public final LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean matchEntry(@NotNull SeqLogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        LocalDate localDate = entry.getStartTime();
        return !(localDate != null ? localDate.isAfter(this._endDate) : false);
    }

    @Override
    public boolean matchRecord(@NotNull T record) {
        long beginTime;
        Intrinsics.checkNotNullParameter(record, (String)"record");
        if (this._hasNotMatch) {
            return false;
        }
        Long l = record.getTime();
        long l2 = beginTime = l != null ? l : Long.MIN_VALUE;
        if (beginTime == Long.MIN_VALUE) {
            return true;
        }
        if (beginTime > this._endTimeLong) {
            this._hasNotMatch = true;
            return false;
        }
        return true;
    }
}

