/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import kd.bos.olapServer2.backup.sequenceLog.ISeqLogFilter;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogRecord;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogEntry;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\u00060\nj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0019\u0010\u0011\u001a\u00060\nj\u0002`\u000e2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/MoreVersionFilter;", "T", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecord;", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogFilter;", "versions", "", "", "Lkd/bos/olapServer2/common/long;", "([Ljava/lang/Long;)V", "_hasMatchEnd", "", "_versions", "[Ljava/lang/Long;", "matchEntry", "Lkd/bos/olapServer2/common/bool;", "entry", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "matchRecord", "record", "(Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecord;)Z", "bos-olap-core2"})
public final class MoreVersionFilter<T extends ISeqLogRecord>
implements ISeqLogFilter<T> {
    @NotNull
    private final Long[] _versions;
    private boolean _hasMatchEnd;

    public MoreVersionFilter(@NotNull Long[] versions) {
        Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
        this._versions = (Long[])ArraysKt.sortedArray((Comparable[])versions);
    }

    @Override
    public boolean matchEntry(@NotNull SeqLogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (this._versions.length == 0) {
            return false;
        }
        return ((Number)ArraysKt.first((Object[])this._versions)).longValue() <= entry.getEnd() && entry.getStart() <= ((Number)ArraysKt.last((Object[])this._versions)).longValue();
    }

    @Override
    public boolean matchRecord(@NotNull T record) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        if (this._versions.length == 0 || this._hasMatchEnd) {
            return false;
        }
        long id = record.getId();
        if (ArraysKt.contains((Object[])this._versions, (Object)id)) {
            if (id == ((Number)ArraysKt.last((Object[])this._versions)).longValue()) {
                this._hasMatchEnd = true;
            }
            return true;
        }
        return false;
    }
}

