/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.olapServer2.backup.sequenceLog.ISeqLogRecord;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogField;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogRowParser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0005\u00a2\u0006\u0002\u00105R\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0015\u0010\u000f\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0015\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0015\u0010\u0018\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0015\u0010\u001a\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0011\u0010\u001c\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0018\u0010\u001e\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR\u0015\u0010 \u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\fR\u0015\u0010\"\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\fR\u0015\u0010$\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\fR\u0015\u0010&\u001a\u00060\u0012j\u0002`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0015R\u0018\u0010(\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0015\u0010+\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\fR\u0015\u0010-\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\fR\u0015\u0010/\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\fR\u0015\u00101\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\f\u00a8\u00067"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/ProfileLogData;", "Lkd/bos/olapServer2/backup/sequenceLog/ISeqLogRecord;", "parser", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser;", "fields", "", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;", "(Lkd/bos/olapServer2/backup/sequenceLog/SeqLogRowParser;[Lkd/bos/olapServer2/backup/sequenceLog/SeqLogField;)V", "begin", "", "Lkd/bos/olapServer2/common/long;", "getBegin", "()J", "calculating", "getCalculating", "commandId", "getCommandId", "commandType", "", "Lkd/bos/olapServer2/common/string;", "getCommandType", "()Ljava/lang/String;", "dataLockTimeSpan", "getDataLockTimeSpan", "end", "getEnd", "finishing", "getFinishing", "hashcode", "getHashcode", "id", "getId", "metadataLockTimeSpan", "getMetadataLockTimeSpan", "selectCount", "getSelectCount", "selectOutputCount", "getSelectOutputCount", "threadName", "getThreadName", "time", "getTime", "()Ljava/lang/Long;", "traceId", "getTraceId", "waitingMetadataLock", "getWaitingMetadataLock", "writeCount", "getWriteCount", "writing", "getWriting", "getExportTableArray", "", "()[Ljava/lang/Object;", "Companion", "bos-olap-core2"})
public final class ProfileLogData
implements ISeqLogRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long commandId;
    private final long begin;
    private final long traceId;
    @NotNull
    private final String threadName;
    @NotNull
    private final String commandType;
    @NotNull
    private final String hashcode;
    private final long waitingMetadataLock;
    private final long calculating;
    private final long writing;
    private final long finishing;
    private final long end;
    private final long selectCount;
    private final long writeCount;
    private final long metadataLockTimeSpan;
    private final long dataLockTimeSpan;
    private final long selectOutputCount;
    @NotNull
    private static DecimalFormat df = new DecimalFormat("#.000");
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public ProfileLogData(@NotNull SeqLogRowParser parser2, @NotNull SeqLogField[] fields2) {
        Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)fields2, (String)"fields");
        this.commandId = parser2.getLongValue(fields2[0]);
        this.begin = parser2.getLongValue(fields2[1]);
        this.traceId = parser2.getLongValue(fields2[2]);
        this.threadName = parser2.getStringValue(fields2[3]);
        this.commandType = parser2.getStringValue(fields2[4]);
        this.hashcode = parser2.getStringValue(fields2[5]);
        this.waitingMetadataLock = parser2.getLongValue(fields2[6]);
        this.calculating = parser2.getLongValue(fields2[7]);
        this.writing = parser2.getLongValue(fields2[8]);
        this.finishing = parser2.getLongValue(fields2[9]);
        this.end = parser2.getLongValue(fields2[10]);
        this.selectCount = parser2.getLongValue(fields2[11]);
        this.writeCount = parser2.getLongValue(fields2[12]);
        this.metadataLockTimeSpan = parser2.getLongValue(fields2[13]);
        this.dataLockTimeSpan = parser2.getLongValue(fields2[14]);
        this.selectOutputCount = parser2.getLongValue(fields2[15]);
    }

    public final long getCommandId() {
        return this.commandId;
    }

    public final long getBegin() {
        return this.begin;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    @NotNull
    public final String getThreadName() {
        return this.threadName;
    }

    @NotNull
    public final String getCommandType() {
        return this.commandType;
    }

    @NotNull
    public final String getHashcode() {
        return this.hashcode;
    }

    public final long getWaitingMetadataLock() {
        return this.waitingMetadataLock;
    }

    public final long getCalculating() {
        return this.calculating;
    }

    public final long getWriting() {
        return this.writing;
    }

    public final long getFinishing() {
        return this.finishing;
    }

    public final long getEnd() {
        return this.end;
    }

    public final long getSelectCount() {
        return this.selectCount;
    }

    public final long getWriteCount() {
        return this.writeCount;
    }

    public final long getMetadataLockTimeSpan() {
        return this.metadataLockTimeSpan;
    }

    public final long getDataLockTimeSpan() {
        return this.dataLockTimeSpan;
    }

    public final long getSelectOutputCount() {
        return this.selectOutputCount;
    }

    @Override
    public long getId() {
        return this.commandId;
    }

    @Override
    @NotNull
    public Long getTime() {
        return this.begin;
    }

    @NotNull
    public final Object[] getExportTableArray() {
        Object[] objectArray = new Object[]{this.threadName, this.commandType, this.commandId, ProfileLogData.Companion.dealNum(this.traceId), ProfileLogData.Companion.dealTimeToDate(this.begin), ProfileLogData.Companion.dealTimeToMs(this.waitingMetadataLock), ProfileLogData.Companion.dealTimeToMs(this.calculating), ProfileLogData.Companion.dealTimeToMs(this.writing), ProfileLogData.Companion.dealTimeToMs(this.finishing), ProfileLogData.Companion.dealTimeToMs(this.end), ProfileLogData.Companion.dealNum(this.selectCount), ProfileLogData.Companion.dealNum(this.writeCount), ProfileLogData.Companion.dealTimeToMs(this.metadataLockTimeSpan), ProfileLogData.Companion.dealTimeToMs(this.dataLockTimeSpan), ProfileLogData.Companion.dealNum(this.selectOutputCount)};
        return objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0018\u0010\u000e\u001a\u00060\tj\u0002`\n2\n\u0010\u000f\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u0010\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/ProfileLogData$Companion;", "", "()V", "df", "Ljava/text/DecimalFormat;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "dealNum", "", "Lkd/bos/olapServer2/common/string;", "num", "", "Lkd/bos/olapServer2/common/long;", "dealTimeToDate", "time", "dealTimeToMs", "bos-olap-core2"})
    public static final class Companion {
        private Companion() {
        }

        private final String dealNum(long num) {
            return num == -1L ? "" : String.valueOf(num);
        }

        private final String dealTimeToMs(long time2) {
            if (time2 == -1L) {
                return "";
            }
            String string2 = df.format((double)time2 / 1000000.0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        private final String dealTimeToDate(long time2) {
            return '\t' + formatter.format(LocalDateTime.ofInstant(new Date(time2).toInstant(), ZoneId.systemDefault()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

