/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.olapServer2.backup.sequenceLog.AbstractCompression;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.OlapRuntimeException;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.tools.Res;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/QatZipCompression;", "Lkd/bos/olapServer2/backup/sequenceLog/AbstractCompression;", "()V", "compress", "Ljava/io/File;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "target", "source", "", "token", "Lkd/bos/olapServer2/common/IContinueToken;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/io/File;Lkd/bos/olapServer2/common/IContinueToken;)Ljava/io/File;", "isWindows", "", "Lkd/bos/olapServer2/common/bool;", "TempLogFile", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nQatZipCompression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QatZipCompression.kt\nkd/bos/olapServer2/backup/sequenceLog/QatZipCompression\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n11065#2:111\n11400#2,3:112\n1855#3,2:115\n1#4:117\n*S KotlinDebug\n*F\n+ 1 QatZipCompression.kt\nkd/bos/olapServer2/backup/sequenceLog/QatZipCompression\n*L\n34#1:111\n34#1:112,3\n42#1:115,2\n*E\n"})
public final class QatZipCompression
extends AbstractCompression {
    private final boolean isWindows() {
        String string2 = System.getProperty("os.name");
        return string2 != null ? StringsKt.contains((CharSequence)string2, (CharSequence)"windows", (boolean)true) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public File compress(@NotNull String rootPath, @NotNull String target, @NotNull File[] source2, @NotNull IContinueToken token) {
        void $this$mapTo$iv$iv;
        Iterator $this$map$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        File targetFile = Paths.INSTANCE.toFile(rootPath, target);
        String command = "qzip";
        List $this$compress_u24lambda_u241 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$compress_u24lambda_u241.add("-O");
        $this$compress_u24lambda_u241.add("7z");
        File[] fileArray = source2;
        List list3 = $this$compress_u24lambda_u241;
        boolean $i$f$map = false;
        void var14_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var20_32 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getAbsolutePath());
        }
        list3.addAll((List)destination$iv$iv);
        $this$compress_u24lambda_u241.add("-L");
        $this$compress_u24lambda_u241.add(String.valueOf(AbstractCompression.Companion.getQatCompressionRatio()));
        $this$compress_u24lambda_u241.add("-o");
        String string2 = targetFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        $this$compress_u24lambda_u241.add(string2);
        List arguments = list2;
        String cmd = null;
        cmd = command;
        Iterable $this$forEach$iv = arguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            cmd = cmd + ' ' + it;
        }
        String tempFolderPath = ITempFolder.Companion.getTempFolder().getAbsolutePath();
        Intrinsics.checkNotNull((Object)tempFolderPath);
        TempLogFile infoResult = new TempLogFile("CompressCmdInfo.log", tempFolderPath);
        TempLogFile errorResult = new TempLogFile("CompressCmdError.log", tempFolderPath);
        try {
            if (this.isWindows()) {
                throw Res.INSTANCE.getNotSupportedException("only run in linux!", new Object[0]);
            }
            String[] it = new String[]{"/bin/sh", "-c", cmd};
            ProcessBuilder proBuilder = new ProcessBuilder(it);
            proBuilder.redirectOutput(infoResult.getFile());
            proBuilder.redirectError(errorResult.getFile());
            Process pro = proBuilder.start();
            boolean finished = pro.waitFor(20L, TimeUnit.MINUTES);
            if (!finished) {
                throw new TimeoutException("Process timed out");
            }
            int exitValue = pro.exitValue();
            if (exitValue != 0) {
                String errorText = errorResult.getText();
                StringBuilder stringBuilder = new StringBuilder().append("do ");
                String string3 = Arrays.toString(source2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this)");
                OlapRuntimeException ex = new OlapRuntimeException(stringBuilder.append(string3).append(" zip to ").append(target).append(" failed. ").append(errorText).toString(), null, new RuntimeException("Process exited with non-zero value: " + exitValue + '\n' + errorText));
                throw ex;
            }
            File tmpFile = Paths.INSTANCE.toFile(rootPath, target + ".7z");
            boolean success = tmpFile.renameTo(targetFile);
            if (!success) {
                boolean bl4 = false;
                String[] stringArray = new String[]{target};
                String string4 = tmpFile + " rename to " + Paths.INSTANCE.get(rootPath, stringArray) + " failed.";
                throw new IllegalArgumentException(string4.toString());
            }
            File file = targetFile;
            return file;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            errorResult.close();
            infoResult.close();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/QatZipCompression$TempLogFile;", "Ljava/io/Closeable;", "name", "", "Lkd/bos/olapServer2/common/string;", "tempFolderPath", "(Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "close", "", "getText", "bos-olap-core2"})
    private static final class TempLogFile
    implements Closeable {
        @NotNull
        private final File file;

        public TempLogFile(@NotNull String name2, @NotNull String tempFolderPath) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)tempFolderPath, (String)"tempFolderPath");
            String[] stringArray = new String[]{name2};
            File file = Paths.INSTANCE.get(tempFolderPath, stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.file = file;
            if (this.file.exists()) {
                this.file.delete();
            }
            this.file.createNewFile();
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String getText() {
            return FilesKt.readText((File)this.file, (Charset)Charsets.UTF_8);
        }

        @Override
        public void close() {
            this.file.delete();
        }
    }
}

