/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.Closeable;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.backup.sequenceLog.SeqLog7zItemEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogContainerEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u0004\u0018\u00010\rJ\f\u0010\u000e\u001a\u00060\tj\u0002`\u000fH\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqLog7zEntry;", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogContainerEntry;", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLog7zItemEntry;", "strategy", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;", "file", "Ljava/io/File;", "(Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;Ljava/io/File;)V", "_exists", "", "getFile", "()Ljava/io/File;", "createSevenZFile", "Lorg/apache/commons/compress/archivers/sevenz/SevenZFile;", "exists", "Lkd/bos/olapServer2/common/bool;", "getEntriesCore", "", "()[Lkd/bos/olapServer2/backup/sequenceLog/SeqLog7zItemEntry;", "toString", "", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSeqLog7zEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeqLog7zEntry.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLog7zEntry\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,44:1\n37#2,2:45\n*S KotlinDebug\n*F\n+ 1 SeqLog7zEntry.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLog7zEntry\n*L\n26#1:45,2\n*E\n"})
public final class SeqLog7zEntry
extends SeqLogContainerEntry<SeqLog7zItemEntry> {
    @NotNull
    private final File file;
    private boolean _exists;

    public SeqLog7zEntry(@NotNull SeqLogNameStrategy strategy, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(strategy, file.getName());
        this.file = file;
        this._exists = true;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected SeqLog7zItemEntry[] getEntriesCore() {
        List result2 = new ArrayList();
        Closeable closeable = (Closeable)new SevenZFile(this.file);
        Throwable throwable = null;
        try {
            SevenZFile it = (SevenZFile)closeable;
            boolean bl = false;
            for (SevenZArchiveEntry elem : it.getEntries()) {
                SeqLogNameStrategy seqLogNameStrategy = this.getStrategy();
                String string2 = elem.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                result2.add(new SeqLog7zItemEntry(seqLogNameStrategy, this, string2));
            }
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SeqLog7zItemEntry[0]);
    }

    @Override
    public boolean exists() {
        return this._exists;
    }

    @Nullable
    public final SevenZFile createSevenZFile() {
        SevenZFile sevenZFile;
        try {
            sevenZFile = new SevenZFile(this.file);
        }
        catch (NoSuchFileException e) {
            this._exists = false;
            sevenZFile = null;
        }
        return sevenZFile;
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.getStart() + ',' + this.getEnd() + ']' + this.file.getName();
    }
}

