/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer2.backup.sequenceLog;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer2.backup.sequenceLog.SeqLog7zEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogContainerEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogV1FileEntry;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogV2FileEntry;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\u00060\tj\u0002`\u001aH\u0016J\u0017\u0010\u001b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0014\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00060\u000bj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00060\u000bj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006 "}, d2={"Lkd/bos/olapServer2/backup/sequenceLog/SeqLogDirectoryEntry;", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogContainerEntry;", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "strategy", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;", "rootPath", "Ljava/io/File;", "(Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;Ljava/io/File;)V", "_exists", "", "end", "", "Lkd/bos/olapServer2/common/long;", "getEnd", "()J", "endTime", "Ljava/time/LocalDate;", "getEndTime", "()Ljava/time/LocalDate;", "start", "getStart", "startTime", "getStartTime", "autoMkdir", "", "exists", "Lkd/bos/olapServer2/common/bool;", "files", "", "()[Ljava/io/File;", "getEntriesCore", "()[Lkd/bos/olapServer2/backup/sequenceLog/SeqLogEntry;", "bos-olap-core2"})
@SourceDebugExtension(value={"SMAP\nSeqLogDirectoryEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeqLogDirectoryEntry.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogDirectoryEntry\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,68:1\n13309#2,2:69\n37#3,2:71\n*S KotlinDebug\n*F\n+ 1 SeqLogDirectoryEntry.kt\nkd/bos/olapServer2/backup/sequenceLog/SeqLogDirectoryEntry\n*L\n34#1:69,2\n52#1:71,2\n*E\n"})
public final class SeqLogDirectoryEntry
extends SeqLogContainerEntry<SeqLogEntry> {
    @NotNull
    private final File rootPath;
    private boolean _exists;

    public SeqLogDirectoryEntry(@NotNull SeqLogNameStrategy strategy, @NotNull File rootPath) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        super(strategy, null);
        this.rootPath = rootPath;
        this._exists = true;
    }

    @Override
    public long getStart() {
        SeqLogEntry seqLogEntry = (SeqLogEntry)ArraysKt.firstOrNull((Object[])this.getEntries());
        return seqLogEntry != null ? seqLogEntry.getStart() : 0L;
    }

    @Override
    public long getEnd() {
        SeqLogEntry seqLogEntry = (SeqLogEntry)ArraysKt.lastOrNull((Object[])this.getEntries());
        return seqLogEntry != null ? seqLogEntry.getEnd() : 0L;
    }

    @Override
    @Nullable
    public LocalDate getStartTime() {
        SeqLogEntry seqLogEntry = (SeqLogEntry)ArraysKt.firstOrNull((Object[])this.getEntries());
        return seqLogEntry != null ? seqLogEntry.getStartTime() : null;
    }

    @Override
    @Nullable
    public LocalDate getEndTime() {
        SeqLogEntry seqLogEntry = (SeqLogEntry)ArraysKt.lastOrNull((Object[])this.getEntries());
        return seqLogEntry != null ? seqLogEntry.getEndTime() : null;
    }

    @Override
    public boolean exists() {
        return this._exists;
    }

    @NotNull
    protected SeqLogEntry[] getEntriesCore() {
        List result2 = new ArrayList();
        File[] fileArray = this.files();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)this.getStrategy().getPrefix(), (boolean)false, (int)2, null)) continue;
                String string3 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string3, (String)this.getStrategy().getZipSuffix(), (boolean)false, (int)2, null)) {
                    result2.add(new SeqLog7zEntry(this.getStrategy(), file));
                    continue;
                }
                String string4 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string4, (String)this.getStrategy().getFileSuffix(), (boolean)false, (int)2, null)) {
                    result2.add(new SeqLogV1FileEntry(this.getStrategy(), file));
                    continue;
                }
                String string5 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string5, (String)this.getStrategy().getFileSuffix2(), (boolean)false, (int)2, null)) continue;
                result2.add(new SeqLogV2FileEntry(this.getStrategy(), file));
            }
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SeqLogEntry[0]);
    }

    private final File[] files() {
        File[] files = this.rootPath.listFiles();
        if (files == null) {
            this._exists = false;
        }
        return files;
    }

    public final void autoMkdir() {
        if (!this.rootPath.exists()) {
            this.rootPath.mkdirs();
        }
    }
}

